/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.Entity2VirtualSupersetTypeRelationship;
import jp.sourceforge.tmdmaker.model.IVisitor;
import jp.sourceforge.tmdmaker.model.RelatedRelationship;
import jp.sourceforge.tmdmaker.model.ReusedIdentifier;
import jp.sourceforge.tmdmaker.model.VirtualSupersetType;

public class VirtualSuperset
extends AbstractEntityModel {
    @Override
    public ReusedIdentifier createReusedIdentifier() {
        return null;
    }

    @Override
    public boolean isDeletable() {
        return this.getModelSourceConnections().size() == 0;
    }

    @Override
    public boolean isEntityTypeEditable() {
        return false;
    }

    public List<AbstractEntityModel> getVirtualSubsetList() {
        VirtualSupersetType type = this.getVirtualSupersetType();
        if (type == null) {
            return new ArrayList<AbstractEntityModel>();
        }
        return type.getSubsetList();
    }

    public List<AbstractConnectionModel> getVirtualSubsetRelationshipList() {
        ArrayList<AbstractConnectionModel> results = new ArrayList<AbstractConnectionModel>();
        results.addAll(this.getVirtualSupersetType().getModelTargetConnections());
        return results;
    }

    public VirtualSupersetType getVirtualSupersetType() {
        if (this.getModelTargetConnections().size() != 0) {
            return (VirtualSupersetType)this.getModelTargetConnections().get(0).getSource();
        }
        return null;
    }

    @Override
    public VirtualSuperset getCopy() {
        VirtualSuperset copy = new VirtualSuperset();
        this.copyTo(copy);
        return copy;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    private boolean isTypeConnected() {
        return this.getModelTargetConnections().size() != 0;
    }

    public void connectSubset(AbstractEntityModel subset) {
        if (!this.isTypeConnected()) {
            this.addVirtualSupersetType();
        }
        VirtualSupersetType type = this.getVirtualSupersetType();
        new Entity2VirtualSupersetTypeRelationship(subset, (ConnectableElement)type).connect();
    }

    public void disconnectSubset(AbstractEntityModel subset) {
        VirtualSupersetType type = this.getVirtualSupersetType();
        if (type == null) {
            return;
        }
        for (AbstractConnectionModel c : type.getModelTargetConnections()) {
            if (!c.getSource().equals(subset)) continue;
            c.disconnect();
            break;
        }
        if (type.getModelTargetConnections().size() == 0) {
            this.removeVirtualSupersetType();
        }
    }

    private void removeVirtualSupersetType() {
        AbstractConnectionModel r = this.getModelTargetConnections().get(0);
        VirtualSupersetType type = this.getVirtualSupersetType();
        r.disconnect();
        this.getDiagram().removeChild(type);
    }

    private void addVirtualSupersetType() {
        VirtualSupersetType type = new VirtualSupersetType();
        this.getDiagram().addChild(type);
        RelatedRelationship r = new RelatedRelationship(type, this);
        r.connect();
    }

    public boolean hasSubset() {
        return this.getVirtualSupersetType() != null;
    }

    @Override
    public boolean canCreateSubset() {
        return false;
    }

    @Override
    public boolean canCreateMultivalueOr() {
        return false;
    }

    @Override
    public boolean canCreateVirtualEntity() {
        return false;
    }
}

