/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog.component;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ModelSelectPanel
extends Composite {
    private List<AbstractEntityModel> selectModels = null;
    private List<AbstractEntityModel> notSelectModels = null;
    private org.eclipse.swt.widgets.List selectedList = null;
    private org.eclipse.swt.widgets.List candidateList = null;
    private Label selectedLabel = null;
    private Label candidateLabel = null;
    private Composite buttonsComposite = null;
    private Button selectButton = null;
    private Button removeButton = null;
    private Button selectAllButton = null;
    private Button removeAllButton = null;

    public ModelSelectPanel(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridData gridData1 = new GridData();
        gridData1.verticalSpan = 4;
        gridData1.verticalAlignment = 4;
        gridData1.widthHint = 150;
        gridData1.grabExcessVerticalSpace = false;
        gridData1.heightHint = 100;
        gridData1.horizontalAlignment = 1;
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 150;
        gridData.heightHint = 100;
        gridData.verticalSpan = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.selectedLabel = new Label((Composite)this, 0);
        this.selectedLabel.setText(Messages.Select);
        Label filler = new Label((Composite)this, 0);
        filler.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.candidateLabel = new Label((Composite)this, 0);
        this.candidateLabel.setText(Messages.Unselect);
        this.selectedList = new org.eclipse.swt.widgets.List((Composite)this, 2818);
        this.selectedList.setLayoutData((Object)gridData);
        this.selectedList.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ModelSelectPanel.this.selectButton.setEnabled(false);
                ModelSelectPanel.this.removeButton.setEnabled(true);
                ModelSelectPanel.this.selectAllButton.setEnabled(false);
                ModelSelectPanel.this.removeAllButton.setEnabled(true);
                ModelSelectPanel.this.candidateList.setSelection(new int[0]);
            }
        });
        this.createButtonsComposite();
        this.candidateList = new org.eclipse.swt.widgets.List((Composite)this, 2818);
        this.candidateList.setLayoutData((Object)gridData1);
        this.candidateList.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ModelSelectPanel.this.selectButton.setEnabled(true);
                ModelSelectPanel.this.removeButton.setEnabled(false);
                ModelSelectPanel.this.selectAllButton.setEnabled(true);
                ModelSelectPanel.this.removeAllButton.setEnabled(false);
                ModelSelectPanel.this.selectedList.setSelection(new int[0]);
            }
        });
        this.setLayout((Layout)gridLayout);
        this.setSize(new Point(409, 159));
    }

    public void initializeValue(List<AbstractEntityModel> selectModels, List<AbstractEntityModel> notSelectModels) {
        this.selectModels = selectModels;
        this.notSelectModels = notSelectModels;
        this.updateList();
    }

    private void updateList() {
        this.selectedList.removeAll();
        this.candidateList.removeAll();
        for (AbstractEntityModel m : this.selectModels) {
            this.selectedList.add(m.getName());
        }
        for (AbstractEntityModel m : this.notSelectModels) {
            this.candidateList.add(m.getName());
        }
    }

    public List<AbstractEntityModel> getSelectModels() {
        return this.selectModels;
    }

    public List<AbstractEntityModel> getNotSelectModels() {
        return this.notSelectModels;
    }

    private void createButtonsComposite() {
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        rowLayout.justify = false;
        rowLayout.spacing = 3;
        rowLayout.fill = true;
        GridData gridData6 = new GridData();
        gridData6.horizontalAlignment = 4;
        gridData6.verticalSpan = 4;
        gridData6.verticalAlignment = 4;
        this.buttonsComposite = new Composite((Composite)this, 0);
        this.buttonsComposite.setLayoutData((Object)gridData6);
        this.buttonsComposite.setLayout((Layout)rowLayout);
        this.selectButton = new Button(this.buttonsComposite, 0);
        this.selectButton.setText("<");
        this.selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] selectedIndices = ModelSelectPanel.this.candidateList.getSelectionIndices();
                if (selectedIndices.length == 0) {
                    return;
                }
                ArrayList<AbstractEntityModel> selectedModels = new ArrayList<AbstractEntityModel>();
                int[] nArray = selectedIndices;
                int n = selectedIndices.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    selectedModels.add((AbstractEntityModel)ModelSelectPanel.this.notSelectModels.get(i));
                    ++n2;
                }
                ModelSelectPanel.this.notSelectModels.removeAll(selectedModels);
                ModelSelectPanel.this.selectModels.addAll(selectedModels);
                ModelSelectPanel.this.updateList();
            }
        });
        this.removeButton = new Button(this.buttonsComposite, 0);
        this.removeButton.setText(">");
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] selectedIndices = ModelSelectPanel.this.selectedList.getSelectionIndices();
                if (selectedIndices.length == 0) {
                    return;
                }
                ArrayList<AbstractEntityModel> selectedModels = new ArrayList<AbstractEntityModel>();
                int[] nArray = selectedIndices;
                int n = selectedIndices.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    selectedModels.add((AbstractEntityModel)ModelSelectPanel.this.selectModels.get(i));
                    ++n2;
                }
                ModelSelectPanel.this.selectModels.removeAll(selectedModels);
                ModelSelectPanel.this.notSelectModels.addAll(selectedModels);
                ModelSelectPanel.this.updateList();
            }
        });
        this.selectAllButton = new Button(this.buttonsComposite, 0);
        this.selectAllButton.setText("<<");
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelSelectPanel.this.selectModels.addAll(ModelSelectPanel.this.notSelectModels);
                ModelSelectPanel.this.notSelectModels.clear();
                ModelSelectPanel.this.updateList();
            }
        });
        this.removeAllButton = new Button(this.buttonsComposite, 0);
        this.removeAllButton.setText(">>");
        this.removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelSelectPanel.this.notSelectModels.addAll(ModelSelectPanel.this.selectModels);
                ModelSelectPanel.this.selectModels.clear();
                ModelSelectPanel.this.updateList();
            }
        });
    }
}

