/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.dialog.model;

import jp.sourceforge.tmdmaker.dialog.model.EditAttribute;
import jp.sourceforge.tmdmaker.dialog.model.EditTable;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Detail;
import jp.sourceforge.tmdmaker.model.Entity;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.IAttribute;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.model.Laputa;
import jp.sourceforge.tmdmaker.model.rule.EntityTypeRule;

public class EditEntity
extends EditTable {
    public static final String PROPERTY_IDENTIFIER = "_edit_property_identifier";
    public static final String PROPERTY_UP_IDENTIFIER = "_edit_property_up_identifier";
    protected EditAttribute editIdentifier;
    private boolean latuta;
    private boolean detail;

    public EditEntity(Entity entity) {
        super((AbstractEntityModel)entity);
        this.editIdentifier = new EditAttribute((IAttribute)entity.getIdentifier());
    }

    public EditEntity(Detail entity) {
        super((AbstractEntityModel)entity);
        this.editIdentifier = new EditAttribute((IAttribute)entity.getDetailIdentifier());
        this.detail = true;
    }

    public EditEntity(Laputa entity) {
        super((AbstractEntityModel)entity);
        this.editIdentifier = new EditAttribute((IAttribute)entity.getIdentifier());
        this.latuta = true;
    }

    @Override
    public void uptoIdentifier(int index) {
        EditAttribute toIdentifier = (EditAttribute)this.attributes.get(index);
        EditAttribute tempIdentifier = new EditAttribute();
        this.editIdentifier.copyTo(tempIdentifier);
        toIdentifier.copyTo(this.editIdentifier);
        tempIdentifier.copyTo(toIdentifier);
        this.firePropertyChange(PROPERTY_UP_IDENTIFIER, tempIdentifier, toIdentifier);
    }

    public EditAttribute getEditIdentifier() {
        return this.editIdentifier;
    }

    public void updateEditIdentifier(EditAttribute identifier) {
        String oldIndentifierName = this.editIdentifier.getName();
        identifier.copyTo(this.editIdentifier);
        this.firePropertyChange(PROPERTY_IDENTIFIER, oldIndentifierName, this.editIdentifier);
    }

    public void setIdentifierName(String name) {
        String oldIndentifierName = this.editIdentifier.getName();
        this.editIdentifier.setName(name);
        this.firePropertyChange(PROPERTY_IDENTIFIER, oldIndentifierName, this.editIdentifier);
    }

    @Override
    public boolean canUpToIdentifier() {
        return true;
    }

    protected void setEditIdentifier(EditAttribute editIdentifier) {
        this.editIdentifier = editIdentifier;
    }

    public boolean isLatuta() {
        return this.latuta;
    }

    public boolean isDetail() {
        return this.detail;
    }

    public boolean isEntity() {
        return !this.latuta && !this.detail;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.getEditIdentifier().getName().length() > 0;
    }

    @Override
    protected void copySpecialTo(AbstractEntityModel to) {
        Identifier newIdentifier;
        Entity edited;
        if (this.isEntity()) {
            edited = (Entity)to;
            newIdentifier = new Identifier();
            this.getEditIdentifier().copyTo((IAttribute)newIdentifier);
            edited.setIdentifier(newIdentifier);
        }
        if (this.isDetail()) {
            edited = (Detail)to;
            newIdentifier = new Identifier();
            this.getEditIdentifier().copyTo((IAttribute)newIdentifier);
            edited.setDetailIdentifier(newIdentifier);
            edited.setEntityType(this.getType());
        }
    }

    private EditAttribute findAttributeByName(String attributeName) {
        if (attributeName == null || attributeName.length() == 0) {
            return null;
        }
        for (EditAttribute ea : this.getAttributes()) {
            if (!attributeName.equals(ea.getName())) continue;
            return ea;
        }
        return null;
    }

    public void updateTypeAttribute(String oldEntityName, String newEntityName) {
        String oldAttributeName = null;
        String newAttribteName = null;
        if (this.getType().equals((Object)EntityType.EVENT)) {
            oldAttributeName = EntityTypeRule.createEventAttributeName((String)oldEntityName);
            newAttribteName = EntityTypeRule.createEventAttributeName((String)newEntityName);
        } else {
            oldAttributeName = EntityTypeRule.createResourceAttributeName((String)oldEntityName);
            newAttribteName = EntityTypeRule.createResourceAttributeName((String)newEntityName);
        }
        EditAttribute ea = this.findAttributeByName(oldAttributeName);
        if (ea != null) {
            ea.setName(newAttribteName);
            this.firePropertyChange("_edit_property_attributes", null, ea);
        }
    }
}

