/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.tmdmaker.TMDEditor;
import jp.sourceforge.tmdmaker.editpart.AbstractTMDEditPart;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.ModelElement;
import jp.sourceforge.tmdmaker.model.other.Memo;
import jp.sourceforge.tmdmaker.model.other.TurboFile;
import jp.sourceforge.tmdmaker.property.DiagramPropertySource;
import jp.sourceforge.tmdmaker.property.IPropertyAvailable;
import jp.sourceforge.tmdmaker.ui.command.EntityModelAddCommand;
import jp.sourceforge.tmdmaker.ui.command.MemoAddCommand;
import jp.sourceforge.tmdmaker.ui.command.MemoChangeCommand;
import jp.sourceforge.tmdmaker.ui.command.ModelConstraintChangeCommand;
import jp.sourceforge.tmdmaker.util.ConstraintConverter;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.ui.views.properties.IPropertySource;

public class DiagramEditPart
extends AbstractTMDEditPart<Diagram>
implements IPropertyAvailable {
    public DiagramEditPart(Diagram diagram) {
        this.setModel(diagram);
    }

    protected IFigure createFigure() {
        FreeformLayer figure = new FreeformLayer();
        figure.setLayoutManager((LayoutManager)new FreeformLayout());
        return figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new DiagramEditPolicy());
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SnapFeedbackPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_property_children")) {
            this.refreshChildren();
        }
    }

    protected List<ModelElement> getModelChildren() {
        return ((Diagram)this.getModel()).getChildren();
    }

    @Override
    protected void onDoubleClicked() {
    }

    public Object getAdapter(Class key) {
        if (key == SnapToHelper.class) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean val = (Boolean)this.getViewer().getProperty("SnapToGeometry.isEnabled");
            if (val != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGrid.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.size() == 0) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return snapStrategies.get(0);
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            ss = snapStrategies.toArray(ss);
            return new CompoundSnapToHelper(ss);
        }
        return super.getAdapter(key);
    }

    @Override
    public IPropertySource getPropertySource(TMDEditor editor) {
        return new DiagramPropertySource(editor, (Diagram)this.getModel());
    }

    private class DiagramEditPolicy
    extends XYLayoutEditPolicy {
        private DiagramEditPolicy() {
        }

        protected EditPolicy createChildEditPolicy(EditPart child) {
            logger.debug(((Object)((Object)this)).getClass() + "#createChildEditPolicy()");
            return new ResizableEditPolicy();
        }

        protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
            logger.debug(((Object)((Object)this)).getClass() + "#createChangeConstraintCommand()");
            ModelConstraintChangeCommand command = new ModelConstraintChangeCommand((ModelElement)child.getModel(), ConstraintConverter.toConstraint((Rectangle)constraint));
            return command;
        }

        protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
            logger.debug("resizedirection:" + request.getResizeDirection());
            logger.debug("NORTH_SOUTH/EAST_WEST:5/24");
            return super.createChangeConstraintCommand(request, child, constraint);
        }

        protected Command getCreateCommand(CreateRequest request) {
            logger.debug(((Object)((Object)this)).getClass() + "#getCreateCommand()" + request.getNewObjectType());
            Rectangle constraint = (Rectangle)this.getConstraintFor(request);
            ConnectableElement model = (ConnectableElement)request.getNewObject();
            model.setConstraint(ConstraintConverter.toConstraintWithoutHeightWidth(constraint));
            logger.debug(model.getConstraint().toString());
            if (model instanceof TurboFile) {
                return this.createTurboFileCommand(constraint, model);
            }
            if (model instanceof AbstractEntityModel) {
                return new EntityModelAddCommand((Diagram)DiagramEditPart.this.getModel(), constraint.x, constraint.y);
            }
            if (model instanceof Memo) {
                return this.createMemoCommand(constraint, model);
            }
            return null;
        }

        private EntityModelAddCommand createTurboFileCommand(Rectangle constraint, ConnectableElement model) {
            TurboFile turbo = (TurboFile)model;
            turbo.setName("\u30bf\u30fc\u30dc\u30d5\u30a1\u30a4\u30eb");
            return new EntityModelAddCommand((Diagram)DiagramEditPart.this.getModel(), (AbstractEntityModel)turbo, constraint.x, constraint.y);
        }

        private Command createMemoCommand(Rectangle constraint, ConnectableElement model) {
            Memo memo = (Memo)model;
            CompoundCommand command = new CompoundCommand();
            command.add((Command)new MemoAddCommand((Diagram)DiagramEditPart.this.getModel(), memo, constraint.x, constraint.y));
            command.add((Command)new MemoChangeCommand(memo, "Memo"));
            return command;
        }
    }
}

