/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.HeapStatus;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.progress.ProgressRegion;
import org.eclipse.ui.internal.util.PrefUtil;

public class StandardTrim {
    @Inject
    EModelService modelService;
    private StatusLineManager manager;

    @PostConstruct
    void createWidget(Composite parent, MToolControl toolControl) {
        if (toolControl.getElementId().equals("org.eclipse.ui.StatusLine")) {
            this.createStatusLine(parent, toolControl);
        } else if (toolControl.getElementId().equals("org.eclipse.ui.HeapStatus")) {
            this.createHeapStatus(parent, toolControl);
        } else if (toolControl.getElementId().equals("org.eclipse.ui.ProgressBar")) {
            this.createProgressBar(parent, toolControl);
        }
    }

    @PreDestroy
    void destroy() {
        if (this.manager != null) {
            this.manager.dispose();
            this.manager = null;
        }
    }

    private void createProgressBar(Composite parent, MToolControl toolControl) {
        ProgressRegion progressRegion = new ProgressRegion();
        IEclipseContext context = this.modelService.getContainingContext((MUIElement)toolControl);
        WorkbenchWindow wbw = (WorkbenchWindow)context.get(IWorkbenchWindow.class);
        progressRegion.createContents(parent, wbw);
    }

    private void createHeapStatus(Composite parent, MToolControl toolControl) {
        new HeapStatus(parent, PrefUtil.getInternalPreferenceStore());
    }

    private void createStatusLine(Composite parent, MToolControl toolControl) {
        Workbench wb;
        IEclipseContext context = this.modelService.getContainingContext((MUIElement)toolControl);
        WorkbenchWindow wbw = (WorkbenchWindow)context.get(IWorkbenchWindow.class);
        if (wbw == null) {
            wb = (Workbench)PlatformUI.getWorkbench();
            wb.createWorkbenchWindow(wb.getDefaultPageInput(), null, this.modelService.getTopLevelWindowFor((MUIElement)toolControl), false);
            wbw = (WorkbenchWindow)context.get(IWorkbenchWindow.class);
        }
        if (wbw != null) {
            wb = (Workbench)PlatformUI.getWorkbench();
            wb.createWorkbenchWindow(wb.getDefaultPageInput(), null, this.modelService.getTopLevelWindowFor((MUIElement)toolControl), false);
            wbw = (WorkbenchWindow)context.get(IWorkbenchWindow.class);
            this.manager = wbw.getStatusLineManager();
            this.manager.createControl(parent);
        }
    }
}

