/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.dialogs.IPromptCondition;
import org.eclipse.team.internal.ui.dialogs.PromptingDialog;

public class UIProjectSetSerializationContext
extends ProjectSetSerializationContext {
    private final Shell shell;

    public UIProjectSetSerializationContext(Shell shell, String filename) {
        super(filename);
        Assert.isNotNull((Object)shell);
        this.shell = shell;
    }

    public Object getShell() {
        return this.shell;
    }

    public IProject[] confirmOverwrite(IProject[] projects) throws TeamException {
        IResource[] resourcesToOverwrite;
        IPromptCondition prompt = new IPromptCondition(projects){
            List resources;
            {
                this.resources = Arrays.asList(iProjectArray);
            }

            public boolean needsPrompt(IResource resource) {
                if (resource instanceof IProject) {
                    IProject project = (IProject)resource;
                    return (project.exists() || this.getTargetFile(project).exists()) && this.resources.contains(resource);
                }
                return false;
            }

            public String promptMessage(IResource resource) {
                if (resource.exists()) {
                    return NLS.bind((String)TeamUIMessages.UIProjectSetSerializationContext_0, (Object[])new String[]{resource.getName()});
                }
                return NLS.bind((String)TeamUIMessages.UIProjectSetSerializationContext_2, (Object[])new String[]{resource.getName(), this.getTargetFile((IProject)resource).getAbsolutePath()});
            }

            public File getTargetFile(IProject project) {
                return new File(project.getParent().getLocation().toFile(), project.getName());
            }
        };
        PromptingDialog dialog = new PromptingDialog((Shell)this.getShell(), (IResource[])projects, prompt, TeamUIMessages.UIProjectSetSerializationContext_1);
        try {
            resourcesToOverwrite = dialog.promptForMultiple();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        IProject[] projectsToOverwrite = new IProject[resourcesToOverwrite.length];
        System.arraycopy(resourcesToOverwrite, 0, projectsToOverwrite, 0, resourcesToOverwrite.length);
        return projectsToOverwrite;
    }
}

