/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.AbstractRelationship;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.IVisitor;
import jp.sourceforge.tmdmaker.model.RecursiveTable;
import jp.sourceforge.tmdmaker.model.rule.RelationshipRule;

public class RecursiveRelationship
extends AbstractRelationship {
    private RecursiveTable table;
    private Diagram diagram;

    public RecursiveRelationship(AbstractEntityModel source) {
        this.setSource(source);
        this.diagram = this.getSource().getDiagram();
        this.table = RelationshipRule.createRecursiveTable(source);
        this.table.setConstraint(source.getConstraint().getTranslated(100, 0));
        this.setTarget(this.table);
    }

    @Override
    public void connect() {
        this.diagram.addChild(this.table);
        AbstractEntityModel sourceEntity = this.getSource();
        if (!sourceEntity.getModelSourceConnections().contains(this)) {
            sourceEntity.addSourceConnection(this);
        }
        this.table.addTargetConnection(this);
        this.attachSource();
        this.attachTarget();
    }

    @Override
    public void disconnect() {
        this.getSource().removeSourceConnection(this);
        this.table.removeTargetConnection(this);
        this.diagram.removeChild(this.table);
    }

    @Override
    public boolean isDeletable() {
        return this.table.isDeletable();
    }

    @Override
    public String getTargetName() {
        return this.getSourceName();
    }

    @Override
    public void identifierChanged() {
        this.table.fireIdentifierChanged(this);
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }
}

