/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.ide.undo.AbstractCopyOrMoveResourcesOperation;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public class CopyResourcesOperation
extends AbstractCopyOrMoveResourcesOperation {
    IResource[] originalResources;
    ResourceDescription[] snapshotResourceDescriptions;

    public CopyResourcesOperation(IResource resource, IPath newPath, String label) {
        super(new IResource[]{resource}, new IPath[]{newPath}, label);
        this.setOriginalResources(new IResource[]{resource});
    }

    public CopyResourcesOperation(IResource[] resources, IPath destinationPath, String label) {
        super(resources, destinationPath, label);
        this.setOriginalResources(this.resources);
    }

    public CopyResourcesOperation(IResource[] resources, IPath[] destinationPaths, String label) {
        super(resources, destinationPaths, label);
        this.setOriginalResources(this.resources);
    }

    @Override
    protected void doExecute(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        this.copy(monitor, uiInfo);
    }

    protected void copy(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        monitor.beginTask("", 2000);
        monitor.setTaskName(UndoMessages.AbstractResourcesOperation_CopyingResourcesProgress);
        ArrayList resourcesAtDestination = new ArrayList();
        ArrayList<ResourceDescription> overwrittenResources = new ArrayList<ResourceDescription>();
        int i = 0;
        while (i < this.resources.length) {
            ResourceDescription[] overwrites = WorkspaceUndoUtil.copy(new IResource[]{this.resources[i]}, this.getDestinationPath(this.resources[i], i), resourcesAtDestination, (IProgressMonitor)new SubProgressMonitor(monitor, 1000 / this.resources.length), uiInfo, true, this.fCreateGroups, this.fCreateLinks, this.fRelativeToVariable);
            int j = 0;
            while (j < overwrites.length) {
                overwrittenResources.add(overwrites[j]);
                ++j;
            }
            ++i;
        }
        if (this.resourceDescriptions != null) {
            i = 0;
            while (i < this.resourceDescriptions.length) {
                if (this.resourceDescriptions[i] != null) {
                    this.resourceDescriptions[i].createResource((IProgressMonitor)new SubProgressMonitor(monitor, 1000 / this.resourceDescriptions.length));
                }
                ++i;
            }
        }
        this.setResourceDescriptions(overwrittenResources.toArray(new ResourceDescription[overwrittenResources.size()]));
        this.setTargetResources(resourcesAtDestination.toArray(new IResource[resourcesAtDestination.size()]));
        monitor.done();
    }

    @Override
    protected void doUndo(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        monitor.beginTask("", 2);
        monitor.setTaskName(UndoMessages.AbstractResourcesOperation_CopyingResourcesProgress);
        WorkspaceUndoUtil.delete(this.resources, (IProgressMonitor)new SubProgressMonitor(monitor, 1), uiInfo, true);
        WorkspaceUndoUtil.recreate(this.resourceDescriptions, (IProgressMonitor)new SubProgressMonitor(monitor, 1), uiInfo);
        this.setResourceDescriptions(new ResourceDescription[0]);
        this.setTargetResources(this.originalResources);
        monitor.done();
    }

    @Override
    protected boolean updateResourceChangeDescriptionFactory(IResourceChangeDescriptionFactory factory, int operation) {
        boolean update = false;
        if (operation == UNDO) {
            IResource resource;
            int i = 0;
            while (i < this.resources.length) {
                update = true;
                resource = this.resources[i];
                factory.delete(resource);
                ++i;
            }
            i = 0;
            while (i < this.resourceDescriptions.length) {
                if (this.resourceDescriptions[i] != null) {
                    update = true;
                    resource = this.resourceDescriptions[i].createResourceHandle();
                    factory.create(resource);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.resources.length) {
                update = true;
                IResource resource = this.resources[i];
                factory.copy(resource, this.getDestinationPath(resource, i));
                ++i;
            }
        }
        return update;
    }

    @Override
    public IStatus computeUndoableStatus(IProgressMonitor monitor) {
        IStatus status = super.computeUndoableStatus(monitor);
        if (!status.isOK()) {
            return status;
        }
        if (this.originalResources == null) {
            this.markInvalid();
            return this.getErrorStatus(UndoMessages.CopyResourcesOperation_NotAllowedDueToDataLoss);
        }
        int i = 0;
        while (i < this.snapshotResourceDescriptions.length) {
            if (!this.snapshotResourceDescriptions[i].verifyExistence(true)) {
                this.markInvalid();
                return this.getErrorStatus(UndoMessages.CopyResourcesOperation_NotAllowedDueToDataLoss);
            }
            ++i;
        }
        if (status.isOK()) {
            status = this.computeDeleteStatus();
        }
        if (status.isOK() && this.resourceDescriptions != null && this.resourceDescriptions.length > 0) {
            status = this.computeCreateStatus(true);
        }
        return status;
    }

    private void setOriginalResources(IResource[] originals) {
        this.originalResources = originals;
        this.snapshotResourceDescriptions = new ResourceDescription[originals.length];
        int i = 0;
        while (i < originals.length) {
            this.snapshotResourceDescriptions[i] = ResourceDescription.fromResource(originals[i]);
            ++i;
        }
    }
}

