/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.compare.internal.DocLineComparator;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.team.internal.core.subscribers.AbstractContentComparator;

public abstract class RangeDifferenceComparator
extends AbstractContentComparator {
    public RangeDifferenceComparator(boolean ignoreWhitespace) {
        super(ignoreWhitespace);
    }

    protected abstract boolean compareRangeDifferences(RangeDifference[] var1, IDocument var2, IDocument var3);

    protected boolean contentsEqual(IProgressMonitor monitor, InputStream is1, InputStream is2, boolean ignoreWhitespace) {
        try {
            String left = Utilities.readString((InputStream)is1, (String)ResourcesPlugin.getEncoding());
            String right = Utilities.readString((InputStream)is2, (String)ResourcesPlugin.getEncoding());
            return this.compareStrings(left, right, monitor);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private boolean compareStrings(String left, String right, IProgressMonitor monitor) {
        Document lDoc = new Document(left);
        Document rDoc = new Document(right);
        DocLineComparator sleft = new DocLineComparator((IDocument)lDoc, (IRegion)new Region(0, lDoc.getLength()), this.shouldIgnoreWhitespace());
        DocLineComparator sright = new DocLineComparator((IDocument)rDoc, (IRegion)new Region(0, rDoc.getLength()), this.shouldIgnoreWhitespace());
        DocLineComparator sl = sleft;
        DocLineComparator sr = sright;
        RangeDifference[] ranges = RangeDifferencer.findRanges((IProgressMonitor)monitor, (IRangeComparator)sl, (IRangeComparator)sr);
        return this.compareRangeDifferences(ranges, (IDocument)lDoc, (IDocument)rDoc);
    }
}

