/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.action;

import java.util.List;
import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.action.AbstractMultipleSelectionAction;
import jp.sourceforge.tmdmaker.dialog.VirtualSupersetCreateDialog;
import jp.sourceforge.tmdmaker.editpart.AbstractEntityModelEditPart;
import jp.sourceforge.tmdmaker.editpart.AbstractModelEditPart;
import jp.sourceforge.tmdmaker.editpart.DiagramEditPart;
import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.Constraint;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.model.VirtualSuperset;
import jp.sourceforge.tmdmaker.model.VirtualSupersetType;
import jp.sourceforge.tmdmaker.ui.command.ModelEditCommand;
import jp.sourceforge.tmdmaker.ui.command.VirtualSubsetAddCommand;
import jp.sourceforge.tmdmaker.ui.command.VirtualSubsetDisconnectCommand;
import jp.sourceforge.tmdmaker.ui.command.VirtualSupersetTypeChangeCommand;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;

public class VirtualSupersetCreateAction
extends AbstractMultipleSelectionAction {
    public static final String ID = "_VS";

    public VirtualSupersetCreateAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.EditVirtualSuperset);
        this.setId(ID);
    }

    public void run() {
        Point pos = this.getControlCursorLocation();
        List<AbstractEntityModel> selectedModels = this.getSelectedModelList();
        Diagram diagram = null;
        VirtualSuperset original = null;
        VirtualSupersetType aggregator = null;
        if (selectedModels.size() == 0) {
            diagram = this.getDiagram();
        } else {
            diagram = selectedModels.get(0).getDiagram();
            original = this.getVirtualSuperset();
            if (original != null) {
                selectedModels.remove(original);
                aggregator = original.getVirtualSupersetType();
            }
        }
        VirtualSupersetCreateDialog dialog = new VirtualSupersetCreateDialog(this.getControl().getShell(), diagram, original, selectedModels);
        if (dialog.open() == 0) {
            CompoundCommand ccommand = new CompoundCommand();
            VirtualSuperset edited = dialog.getEditedValue();
            aggregator = dialog.getEditedAggregator();
            if (original == null) {
                List<AbstractEntityModel> selection = dialog.getSelection();
                if (selection.size() == 0) {
                    return;
                }
                ccommand.add((Command)new VirtualSupersetCreateCommand(diagram, edited.getName(), aggregator.isApplyAttribute(), selection, pos.x, pos.y));
            } else {
                ccommand.add((Command)new ModelEditCommand((AbstractEntityModel)original, (AbstractEntityModel)edited));
                ccommand.add((Command)new VirtualSupersetTypeChangeCommand(original.getVirtualSupersetType(), dialog.getEditedAggregator().isApplyAttribute()));
                List<AbstractEntityModel> notSelection = dialog.getNotSelection();
                List<AbstractEntityModel> selection = dialog.getSelection();
                List selectedList = original.getVirtualSubsetList();
                for (AbstractEntityModel s : selection) {
                    if (selectedList.contains(s)) continue;
                    ccommand.add((Command)new VirtualSubsetAddCommand(original, s));
                }
                for (AbstractEntityModel m : original.getVirtualSubsetList()) {
                    if (!notSelection.contains(m)) continue;
                    ccommand.add((Command)new VirtualSubsetDisconnectCommand(original, m));
                }
            }
            this.execute((Command)ccommand);
        }
    }

    private Control getControl() {
        return ((AbstractEditPart)this.getSelectedObjects().get(0)).getViewer().getControl();
    }

    private Point getControlCursorLocation() {
        Control control = this.getControl();
        Point pos = control.getDisplay().getCursorLocation();
        System.out.println(pos);
        pos = control.toControl(pos);
        System.out.println(pos);
        pos.x -= 200;
        pos.y -= 100;
        return pos;
    }

    private Diagram getDiagram() {
        for (Object o : this.getSelectedObjects()) {
            if (o instanceof DiagramEditPart) {
                return (Diagram)((DiagramEditPart)o).getModel();
            }
            if (!(o instanceof AbstractModelEditPart)) continue;
            return (Diagram)((AbstractModelEditPart)o).getParent().getModel();
        }
        return null;
    }

    private VirtualSuperset getVirtualSuperset() {
        List<AbstractEntityModel> list = this.getSelectedModelList();
        for (AbstractEntityModel o : list) {
            if (!(o instanceof VirtualSuperset)) continue;
            return (VirtualSuperset)o;
        }
        for (AbstractEntityModel o : list) {
            VirtualSupersetType type = o.findVirtualSupersetType();
            if (type == null) continue;
            return type.getSuperset();
        }
        return null;
    }

    @Override
    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() >= 1 && this.hasEntityModel()) {
            return true;
        }
        return this.isDiagramSelected();
    }

    private boolean hasEntityModel() {
        for (Object o : this.getSelectedObjects()) {
            if (!(o instanceof AbstractEntityModelEditPart)) continue;
            return true;
        }
        return false;
    }

    private boolean isDiagramSelected() {
        return this.getSelectedObjects().size() == 1 && this.getSelectedObjects().get(0) instanceof DiagramEditPart;
    }

    private static class VirtualSupersetCreateCommand
    extends Command {
        private Diagram diagram;
        private String virtualSupersetName;
        private boolean applyAttribute;
        private List<AbstractEntityModel> subsets;
        private VirtualSuperset model;
        private int x;
        private int y;
        private Constraint typeConstraint;

        public VirtualSupersetCreateCommand(Diagram diagram, String virtualSupersetName, boolean applyAttribute, List<AbstractEntityModel> subsets, int x, int y) {
            this.diagram = diagram;
            this.virtualSupersetName = virtualSupersetName;
            this.applyAttribute = applyAttribute;
            this.subsets = subsets;
            this.x = x;
            this.y = y;
            Constraint supersetConstraint = new Constraint(x, y, -1, -1);
            this.typeConstraint = supersetConstraint.getTranslated(0, 50);
        }

        public void execute() {
            this.model = this.diagram.createVirtualSuperset(this.virtualSupersetName, this.subsets);
            this.model.move(this.x, this.y);
            VirtualSupersetType type = this.model.getVirtualSupersetType();
            type.setConstraint(this.typeConstraint);
            type.setApplyAttribute(this.applyAttribute);
        }

        public void undo() {
            for (AbstractEntityModel m : this.subsets) {
                this.model.disconnectSubset(m);
            }
            this.diagram.removeChild((AbstractEntityModel)this.model);
        }
    }
}

