/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model;

import jp.sourceforge.tmdmaker.model.ConnectableElement;
import jp.sourceforge.tmdmaker.model.constraint.AnchorConstraint;

public abstract class AbstractConnectionModel
extends ConnectableElement {
    protected ConnectableElement source;
    protected ConnectableElement target;
    protected AnchorConstraint sourceAnchorConstraint = new AnchorConstraint();
    protected AnchorConstraint targetAnchorConstraint = new AnchorConstraint();
    @Deprecated
    public int sourceXp = -1;
    @Deprecated
    public int sourceYp = -1;
    @Deprecated
    public int targetXp = -1;
    @Deprecated
    public int targetYp = -1;
    public static final String PROPERTY_SOURCE_CARDINALITY = "_property_source_cardinality";
    public static final String PROPERTY_TARGET_CARDINALITY = "_property_target_cardinality";
    public static final String PROPERTY_CONNECTION = "_property_connection";

    public void connect() {
        this.attachSource();
        this.attachTarget();
    }

    public void disconnect() {
        this.detachSource();
        this.detachTarget();
    }

    public void attachSource() {
        if (!this.source.getModelSourceConnections().contains(this)) {
            this.source.addSourceConnection(this);
        }
    }

    public void attachTarget() {
        if (!this.target.getModelTargetConnections().contains(this)) {
            this.target.addTargetConnection(this);
        }
    }

    public void detachSource() {
        if (this.source != null) {
            this.source.removeSourceConnection(this);
        }
    }

    public void detachTarget() {
        if (this.target != null) {
            this.target.removeTargetConnection(this);
        }
    }

    public ConnectableElement getSource() {
        return this.source;
    }

    public void setSource(ConnectableElement source) {
        this.source = source;
    }

    public ConnectableElement getTarget() {
        return this.target;
    }

    public void setTarget(ConnectableElement target) {
        this.target = target;
    }

    public void fireParentMoved() {
        this.firePropertyChange(PROPERTY_CONNECTION, null, null);
    }

    public abstract boolean isDeletable();

    public abstract String getSourceName();

    public abstract String getTargetName();

    public void setSourceAnchorConstraint(AnchorConstraint sourceAnchorConstraint) {
        AnchorConstraint oldSourceAnchorConstraint = this.sourceAnchorConstraint;
        this.sourceAnchorConstraint = sourceAnchorConstraint;
        this.firePropertyChange(PROPERTY_CONNECTION, oldSourceAnchorConstraint, this.sourceAnchorConstraint);
    }

    public AnchorConstraint getSourceAnchorConstraint() {
        return this.sourceAnchorConstraint;
    }

    public void setTargetAnchorConstraint(AnchorConstraint targetAnchorConstraint) {
        AnchorConstraint oldTargetAnchorConstraint = this.targetAnchorConstraint;
        this.targetAnchorConstraint = targetAnchorConstraint;
        this.firePropertyChange(PROPERTY_CONNECTION, oldTargetAnchorConstraint, this.targetAnchorConstraint);
    }

    public AnchorConstraint getTargetAnchorConstraint() {
        return this.targetAnchorConstraint;
    }

    public boolean isConnected() {
        return this.source != null && this.source.getModelSourceConnections().contains(this) && this.target != null && this.target.getModelTargetConnections().contains(this);
    }
}

