/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.editor.draw2d;

import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.tmdmaker.model.AbstractConnectionModel;
import jp.sourceforge.tmdmaker.model.AbstractRelationship;
import jp.sourceforge.tmdmaker.model.Event2EventRelationship;
import jp.sourceforge.tmdmaker.model.RecursiveRelationship;
import jp.sourceforge.tmdmaker.model.Resource2ResourceRelationship;
import jp.sourceforge.tmdmaker.ui.editor.draw2d.ConstraintAdjuster;
import jp.sourceforge.tmdmaker.ui.editor.draw2d.adjuster.CombinationTableAdjuster;
import jp.sourceforge.tmdmaker.ui.editor.draw2d.adjuster.MappingListAdjuster;
import jp.sourceforge.tmdmaker.ui.editor.draw2d.adjuster.NullConstraintAdjuster;
import jp.sourceforge.tmdmaker.ui.editor.draw2d.adjuster.RecursiveTableAdjuster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintAdjusterFactory {
    protected static Logger logger = LoggerFactory.getLogger(ConstraintAdjusterFactory.class);
    private static Map<Class<? extends AbstractRelationship>, Class<? extends ConstraintAdjuster>> adjusterMap = new HashMap<Class<? extends AbstractRelationship>, Class<? extends ConstraintAdjuster>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(RecursiveRelationship.class, RecursiveTableAdjuster.class);
            this.put(Event2EventRelationship.class, MappingListAdjuster.class);
            this.put(Resource2ResourceRelationship.class, CombinationTableAdjuster.class);
        }
    };

    public static ConstraintAdjuster getAdjuster(AbstractConnectionModel relationship) {
        Class<? extends ConstraintAdjuster> adjuster = adjusterMap.get(relationship.getClass());
        if (adjuster == null) {
            return new NullConstraintAdjuster();
        }
        try {
            return adjuster.getConstructor(relationship.getClass()).newInstance(relationship);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
            return new NullConstraintAdjuster();
        }
    }
}

