/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.editor.gef3.treeeditparts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jp.sourceforge.tmdmaker.TMDEditor;
import jp.sourceforge.tmdmaker.TMDPlugin;
import jp.sourceforge.tmdmaker.model.Identifier;
import jp.sourceforge.tmdmaker.ui.views.properties.IPropertyAvailable;
import jp.sourceforge.tmdmaker.ui.views.properties.IdentifierPropertySource;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifierTreeEditPart
extends AbstractTreeEditPart
implements PropertyChangeListener,
IPropertyAvailable {
    private static Logger logger = LoggerFactory.getLogger(IdentifierTreeEditPart.class);

    public IdentifierTreeEditPart(Identifier identifier) {
        this.setModel(identifier);
    }

    public Identifier getModel() {
        return (Identifier)super.getModel();
    }

    protected String getText() {
        Identifier model = this.getModel();
        if (model.getName() == null) {
            return "";
        }
        return model.getName();
    }

    protected Image getImage() {
        return TMDPlugin.getImage("icons/outline/identifier.png");
    }

    public void activate() {
        super.activate();
        this.getModel().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void deactivate() {
        this.getModel().removePropertyChangeListener((PropertyChangeListener)this);
        super.deactivate();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        logger.debug(this.getClass() + "." + evt.getPropertyName());
        if (evt.getPropertyName().equals("_property_name")) {
            this.refreshVisuals();
        } else {
            logger.warn("Not Handle Event Occured.");
        }
    }

    @Override
    public IPropertySource getPropertySource(TMDEditor editor) {
        return new IdentifierPropertySource(editor, this.getModel());
    }
}

