/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.ui.views.properties;

import jp.sourceforge.tmdmaker.Messages;
import jp.sourceforge.tmdmaker.TMDEditor;
import jp.sourceforge.tmdmaker.extension.DialectProviderFactory;
import jp.sourceforge.tmdmaker.model.Diagram;
import jp.sourceforge.tmdmaker.ui.views.properties.AbstractPropertySource;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class DiagramPropertySource
extends AbstractPropertySource {
    private static final String NAME = "Name";
    private static final String DATABASE_NAME = "DatabaseName";
    private static final String DESCRIPTION = "Description";
    Diagram diagram;
    CommandStack stack;
    private String[] dataBaseList;

    public DiagramPropertySource(TMDEditor editor, Diagram diagram) {
        super(editor);
        this.stack = editor.getViewer().getEditDomain().getCommandStack();
        this.diagram = diagram;
        this.dataBaseList = DialectProviderFactory.getDialectProvider().getDatabaseList().toArray(new String[0]);
    }

    public Object getEditableValue() {
        return this.diagram;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)NAME, Messages.ModelName), new ComboBoxPropertyDescriptor((Object)DATABASE_NAME, Messages.DatabaseName, this.dataBaseList), new TextPropertyDescriptor((Object)DESCRIPTION, Messages.Description)};
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(NAME)) {
            return this.diagram.getName() != null ? this.diagram.getName() : "";
        }
        if (id.equals(DATABASE_NAME)) {
            return ArrayUtils.indexOf((Object[])this.dataBaseList, (Object)this.diagram.getDatabaseName());
        }
        if (id.equals(DESCRIPTION)) {
            return this.diagram.getDescription() != null ? this.diagram.getDescription() : "";
        }
        return null;
    }

    @Override
    public boolean isPropertySet(Object id) {
        return id.equals(NAME) || id.equals(DATABASE_NAME) || id.equals(DESCRIPTION);
    }

    @Override
    public void resetPropertyValue(Object id) {
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        this.stack.execute(this.createSetPropertyCommand(id, value));
    }

    @Override
    protected Command createSetPropertyCommand(Object id, Object value) {
        return new DiagramPropertyChangeCommand(this.diagram, id, value);
    }

    private static class DiagramPropertyChangeCommand
    extends Command {
        private Diagram diagram;
        private Object newValue;
        private Object oldValue;
        private Object id;
        private String[] dataBaseList;

        public DiagramPropertyChangeCommand(Diagram diagram, Object id, Object newValue) {
            this.id = id;
            this.diagram = diagram;
            this.newValue = newValue;
            this.dataBaseList = DialectProviderFactory.getDialectProvider().getDatabaseList().toArray(new String[0]);
            if (id.equals(DiagramPropertySource.NAME)) {
                this.oldValue = diagram.getName();
            }
            if (id.equals(DiagramPropertySource.DESCRIPTION)) {
                this.oldValue = diagram.getDescription();
            }
            if (id.equals(DiagramPropertySource.DATABASE_NAME)) {
                this.oldValue = diagram.getDatabaseName();
            }
        }

        public void execute() {
            if (this.id.equals(DiagramPropertySource.NAME)) {
                this.diagram.setName((String)this.newValue);
            }
            if (this.id.equals(DiagramPropertySource.DESCRIPTION)) {
                this.diagram.setDescription((String)this.newValue);
            }
            if (this.id.equals(DiagramPropertySource.DATABASE_NAME)) {
                String db_name = this.dataBaseList[(Integer)this.newValue];
                this.diagram.setDatabaseName(db_name);
            }
        }

        public void undo() {
            if (this.id.equals(DiagramPropertySource.NAME)) {
                this.diagram.setName((String)this.oldValue);
            }
            if (this.id.equals(DiagramPropertySource.DESCRIPTION)) {
                this.diagram.setDescription((String)this.oldValue);
            }
            if (this.id.equals(DiagramPropertySource.DATABASE_NAME)) {
                this.diagram.setDatabaseName((String)this.oldValue);
            }
        }
    }
}

