/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tmdmaker.model.rule;

import jp.sourceforge.tmdmaker.model.AbstractEntityModel;
import jp.sourceforge.tmdmaker.model.AbstractRelationship;
import jp.sourceforge.tmdmaker.model.CombinationTable;
import jp.sourceforge.tmdmaker.model.EntityType;
import jp.sourceforge.tmdmaker.model.Event2EventRelationship;
import jp.sourceforge.tmdmaker.model.MappingList;
import jp.sourceforge.tmdmaker.model.RecursiveRelationship;
import jp.sourceforge.tmdmaker.model.RecursiveTable;
import jp.sourceforge.tmdmaker.model.Resource2ResourceRelationship;
import jp.sourceforge.tmdmaker.model.SubsetEntity;
import jp.sourceforge.tmdmaker.model.TransfarReuseKeysToTargetRelationship;
import jp.sourceforge.tmdmaker.model.TurboFileRelationship;
import jp.sourceforge.tmdmaker.model.other.TurboFile;
import jp.sourceforge.tmdmaker.model.rule.EntityTypeRule;
import jp.sourceforge.tmdmaker.model.rule.ImplementRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationshipRule {
    private static Logger logger = LoggerFactory.getLogger(RelationshipRule.class);

    public static AbstractRelationship createRelationship(AbstractEntityModel source, AbstractEntityModel target) {
        AbstractRelationship relationship = null;
        if (RelationshipRule.isRecursive(source, target)) {
            logger.debug("Recursive");
            relationship = new RecursiveRelationship(source);
        } else if (RelationshipRule.isR2E(source, target)) {
            logger.debug("RESOURCE:EVENT");
            relationship = new TransfarReuseKeysToTargetRelationship(source, target);
        } else if (RelationshipRule.isR2R(source, target) && !RelationshipRule.isSameOriginal(source, target)) {
            logger.debug("RESOURCE:RESOURCE");
            relationship = new Resource2ResourceRelationship(source, target);
        } else if (RelationshipRule.isE2E(source, target) && !RelationshipRule.isSameOriginal(source, target)) {
            logger.debug("EVENT:EVENT");
            relationship = new Event2EventRelationship(source, target);
        } else {
            logger.debug("Not TM Relationship Rule");
            if (RelationshipRule.isTurboFile(source, target)) {
                relationship = new TurboFileRelationship(source, target);
            }
        }
        return relationship;
    }

    private static boolean isRecursive(AbstractEntityModel source, AbstractEntityModel target) {
        return source == target;
    }

    private static boolean isR2R(AbstractEntityModel source, AbstractEntityModel target) {
        return EntityTypeRule.isResource(source) && EntityTypeRule.isResource(target);
    }

    private static boolean isSameOriginal(AbstractEntityModel source, AbstractEntityModel target) {
        if (source instanceof SubsetEntity && target instanceof SubsetEntity) {
            SubsetEntity sourceSubset = (SubsetEntity)source;
            SubsetEntity targetSubset = (SubsetEntity)target;
            return sourceSubset.getSuperset().equals(targetSubset.getSuperset());
        }
        return false;
    }

    private static boolean isR2E(AbstractEntityModel source, AbstractEntityModel target) {
        return EntityTypeRule.isEvent(source) && EntityTypeRule.isResource(target) || EntityTypeRule.isResource(source) && EntityTypeRule.isEvent(target);
    }

    private static boolean isE2E(AbstractEntityModel source, AbstractEntityModel target) {
        return EntityTypeRule.isEvent(source) && EntityTypeRule.isEvent(target);
    }

    public static CombinationTable createCombinationTable(AbstractEntityModel source, AbstractEntityModel target) {
        CombinationTable table = new CombinationTable();
        table.setEntityType(EntityType.RESOURCE);
        table.setName(RelationshipRule.createCombinationTableName(source, target));
        ImplementRule.setModelDefaultValue(table);
        return table;
    }

    private static String createCombinationTableName(AbstractEntityModel source, AbstractEntityModel target) {
        return String.valueOf(source.getName().replace(".\u5bfe\u7167\u8868", "")) + "." + target.getName().replace(".\u5bfe\u7167\u8868", "") + ".\u5bfe\u7167\u8868";
    }

    public static MappingList createMappingList(AbstractEntityModel source, AbstractEntityModel target) {
        MappingList table = new MappingList();
        table.setName(RelationshipRule.createMappingListName(source, target));
        ImplementRule.setModelDefaultValue(table);
        return table;
    }

    private static String createMappingListName(AbstractEntityModel source, AbstractEntityModel target) {
        return String.valueOf(source.getName()) + "." + target.getName() + "." + "\u5bfe\u5fdc\u8868";
    }

    public static RecursiveTable createRecursiveTable(AbstractEntityModel model) {
        RecursiveTable table = new RecursiveTable();
        table.setEntityType(model.getEntityType());
        table.setName(RelationshipRule.createRecursiveTableName(model));
        ImplementRule.setModelDefaultValue(table);
        table.addCreationIdentifier(model);
        return table;
    }

    private static String createRecursiveTableName(AbstractEntityModel model) {
        String name = model.getName();
        return String.valueOf(name) + "." + name + "." + "\u518d\u5e30\u8868";
    }

    private static boolean isTurboFile(AbstractEntityModel source, AbstractEntityModel target) {
        return source instanceof TurboFile || target instanceof TurboFile;
    }
}

