/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.generate.html.attributelist;

import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.Entity;
import org.tmdmaker.core.model.IAttribute;
import org.tmdmaker.core.model.generate.attributelist.AttributeListModelBuilder;
import org.tmdmaker.core.model.generate.attributelist.EntityAttributePair;
import org.tmdmaker.generate.html.Messages;
import org.tmdmaker.generate.html.internal.HtmlGeneratorUtils;
import org.tmdmaker.model.generate.Generator;
import org.tmdmaker.model.generate.GeneratorRuntimeException;

public class AttributeListHtmlGenerator
implements Generator {
    private static Logger logger = LoggerFactory.getLogger(AttributeListHtmlGenerator.class);

    public String getGeneratorName() {
        return Messages.AttributeListHtmlGenerator_GeneratorName;
    }

    public String getGroupName() {
        return "HTML";
    }

    public void execute(String rootDir, List<AbstractEntityModel> models) {
        logger.info("generate");
        VelocityContext context = HtmlGeneratorUtils.getVecityContext();
        try {
            HtmlGeneratorUtils.outputCSS(rootDir);
            HtmlGeneratorUtils.copyStream(AttributeListHtmlGenerator.class.getResourceAsStream("index.html"), new FileOutputStream(new File(rootDir, "attributes_index.html")));
            Map attributes = new AttributeListModelBuilder().build(models);
            context.put("entities", models);
            HtmlGeneratorUtils.applyTemplate("summary.html", this.getClass(), new File(rootDir, "summary.html"), context);
            context.put("attributes", attributes.entrySet());
            HtmlGeneratorUtils.applyTemplate("attribute_list.html", this.getClass(), new File(rootDir, "attribute_list.html"), context);
            File attributesDir = new File(rootDir, "attributes");
            attributesDir.mkdir();
            for (Map.Entry entry : attributes.entrySet()) {
                IAttribute attribute = ((EntityAttributePair)entry.getValue()).getAttribute();
                AbstractEntityModel entity = ((EntityAttributePair)entry.getValue()).getModel();
                context.put("attribute", (Object)attribute);
                context.put("entity", (Object)entity);
                if (entity instanceof Entity) {
                    context.put("entityType", (Object)((Entity)entity).getEntityType().getTypeName());
                } else {
                    context.remove((Object)"entityType");
                }
                HtmlGeneratorUtils.applyTemplate("attribute.html", this.getClass(), new File(attributesDir, String.valueOf(((EntityAttributePair)entry.getValue()).createAttributeFileKey()) + ".html"), context);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new GeneratorRuntimeException((Throwable)e);
        }
    }

    public boolean isImplementModelOnly() {
        return false;
    }
}

