/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.editor.gef3.editparts.node;

import java.beans.PropertyChangeEvent;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.ui.views.properties.IPropertySource;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.Attribute;
import org.tmdmaker.core.model.IAttribute;
import org.tmdmaker.ui.editor.gef3.editparts.IAttributeEditPart;
import org.tmdmaker.ui.editor.gef3.editparts.node.AbstractTMDEditPart;
import org.tmdmaker.ui.editor.gef3.editpolicies.AttributeComponentEditPolicy;
import org.tmdmaker.ui.views.properties.IPropertyAvailable;
import org.tmdmaker.ui.views.properties.gef3.IAttributePropertySource;

public class AttributeEditPart
extends AbstractTMDEditPart<Attribute>
implements IPropertyAvailable,
IAttributeEditPart {
    public AttributeEditPart(Attribute attribute) {
        this.setModel(attribute);
    }

    protected IFigure createFigure() {
        Label label = new Label();
        label.setText(this.createAttributeName((Attribute)this.getModel()));
        label.setBorder((Border)new MarginBorder(2, 2, 2, 2));
        label.setLabelAlignment(1);
        return label;
    }

    private String createAttributeName(Attribute attribute) {
        StringBuilder name = new StringBuilder(attribute.getName());
        if (attribute.isDerivation()) {
            name.append("(D)");
        }
        return name.toString();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new AttributeComponentEditPolicy());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_property_name")) {
            this.logger.debug("Handle Name Event.");
            this.handleNameChange(evt);
        } else {
            this.logger.warn("Not Handle Event Occured.");
        }
    }

    protected void refreshVisuals() {
        Label f = (Label)this.getFigure();
        f.setText(this.createAttributeName((Attribute)this.getModel()));
        this.getParent().refresh();
    }

    protected void handleNameChange(PropertyChangeEvent evt) {
        this.refreshVisuals();
    }

    @Override
    public IPropertySource getPropertySource(CommandStack commandStack) {
        return new IAttributePropertySource(commandStack, (IAttribute)this.getModel());
    }

    @Override
    public AbstractEntityModel getParentModel() {
        return (AbstractEntityModel)this.getParent().getModel();
    }
}

