/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.core.model;

import java.io.Serializable;
import org.tmdmaker.core.model.StandardSQLDataType;

public class DataTypeDeclaration
implements Serializable {
    private StandardSQLDataType logicalType;
    private Integer size;
    private Integer scale;
    private Boolean autoIncrement;
    private String defaultValue;

    public DataTypeDeclaration(StandardSQLDataType logicalType, Integer size, Integer scale) {
        this(logicalType, size, scale, null, null);
    }

    public DataTypeDeclaration(StandardSQLDataType logicalType, Integer size, Integer scale, Boolean autoIncrement, String defaultValue) {
        this.logicalType = logicalType;
        this.size = size;
        this.scale = scale;
        this.autoIncrement = autoIncrement;
        this.defaultValue = defaultValue;
    }

    public StandardSQLDataType getLogicalType() {
        return this.logicalType;
    }

    public Integer getSize() {
        return this.size;
    }

    public Integer getScale() {
        return this.scale;
    }

    public Boolean getAutoIncrement() {
        return this.autoIncrement;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public DataTypeDeclaration getCopy() {
        return new DataTypeDeclaration(this.logicalType, this.size, this.scale, this.autoIncrement, this.defaultValue);
    }

    public DataTypeDeclaration newLogicalType(StandardSQLDataType newType) {
        DataTypeDeclaration newValue = this.getCopy();
        newValue.logicalType = newType;
        if (!newType.isSupportSize()) {
            newValue.size = null;
        }
        if (!newType.isSupportScale()) {
            newValue.scale = null;
        }
        return newValue;
    }

    public DataTypeDeclaration newSize(Integer newSize) {
        DataTypeDeclaration newValue = this.getCopy();
        newValue.size = newSize;
        return newValue;
    }

    public DataTypeDeclaration newScale(Integer newScale) {
        DataTypeDeclaration newValue = this.getCopy();
        newValue.scale = newScale;
        return newValue;
    }
}

