/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.core.model.relationship;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.AbstractRelationship;
import org.tmdmaker.core.model.Event2EventRelationship;
import org.tmdmaker.core.model.RecursiveRelationship;
import org.tmdmaker.core.model.Resource2ResourceRelationship;
import org.tmdmaker.core.model.SubsetEntity;
import org.tmdmaker.core.model.TransfarReuseKeysToTargetRelationship;
import org.tmdmaker.core.model.TurboFileRelationship;
import org.tmdmaker.core.model.other.TurboFile;

public class Relationship {
    private static Logger logger = LoggerFactory.getLogger(Relationship.class);
    private AbstractEntityModel fromEntity;
    private AbstractEntityModel toEntity;

    protected Relationship(AbstractEntityModel fromEntity, AbstractEntityModel toEntity) {
        this.fromEntity = fromEntity;
        this.toEntity = toEntity;
    }

    public static AbstractRelationship of(AbstractEntityModel from, AbstractEntityModel to) {
        return new Relationship(from, to).build();
    }

    private AbstractRelationship build() {
        AbstractRelationship relationship = null;
        if (Relationship.isRecursive(this.fromEntity, this.toEntity)) {
            logger.debug("Recursive");
            relationship = new RecursiveRelationship(this.fromEntity);
        } else if (Relationship.isR2E(this.fromEntity, this.toEntity)) {
            logger.debug("RESOURCE:EVENT");
            relationship = new TransfarReuseKeysToTargetRelationship(this.fromEntity, this.toEntity);
        } else if (Relationship.isR2R(this.fromEntity, this.toEntity) && !Relationship.isSameOriginal(this.fromEntity, this.toEntity)) {
            logger.debug("RESOURCE:RESOURCE");
            relationship = new Resource2ResourceRelationship(this.fromEntity, this.toEntity);
        } else if (Relationship.isE2E(this.fromEntity, this.toEntity) && !Relationship.isSameOriginal(this.fromEntity, this.toEntity)) {
            logger.debug("EVENT:EVENT");
            relationship = new Event2EventRelationship(this.fromEntity, this.toEntity);
        } else {
            logger.debug("Not TM Relationship Rule");
            if (Relationship.isTurboFile(this.fromEntity, this.toEntity)) {
                relationship = new TurboFileRelationship(this.fromEntity, this.toEntity);
            }
        }
        return relationship;
    }

    private static boolean isR2E(AbstractEntityModel source, AbstractEntityModel target) {
        return source.isEvent() && target.isResource() || source.isResource() && target.isEvent();
    }

    private static boolean isR2R(AbstractEntityModel source, AbstractEntityModel target) {
        return source.isResource() && target.isResource();
    }

    private static boolean isRecursive(AbstractEntityModel source, AbstractEntityModel target) {
        return source == target;
    }

    private static boolean isE2E(AbstractEntityModel source, AbstractEntityModel target) {
        return source.isEvent() && target.isEvent();
    }

    private static boolean isSameOriginal(AbstractEntityModel source, AbstractEntityModel target) {
        if (source instanceof SubsetEntity && target instanceof SubsetEntity) {
            SubsetEntity sourceSubset = (SubsetEntity)source;
            SubsetEntity targetSubset = (SubsetEntity)target;
            return sourceSubset.getSuperset().equals(targetSubset.getSuperset());
        }
        return false;
    }

    private static boolean isTurboFile(AbstractEntityModel source, AbstractEntityModel target) {
        return source instanceof TurboFile || target instanceof TurboFile;
    }
}

