/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.progress.WorkbenchJob;

public class FilteredTree
extends Composite {
    protected Text filterText;
    protected ToolBarManager filterToolBar;
    protected Control clearButtonControl;
    protected TreeViewer treeViewer;
    protected Composite filterComposite;
    private PatternFilter patternFilter;
    protected String initialText = "";
    private Job refreshJob;
    protected Composite parent;
    protected boolean showFilterControls;
    protected Composite treeComposite;
    private boolean quickSelectionMode = false;
    private static final long SOFT_MAX_EXPAND_TIME = 200L;
    private String previousFilterText;
    private boolean narrowingDown;

    public FilteredTree(Composite parent, boolean useNewLook, boolean useFastHashLookup) {
        super(parent, 0);
        this.parent = parent;
        if (this.treeViewer != null) {
            this.treeViewer.setUseHashlookup(useFastHashLookup);
        }
    }

    public FilteredTree(Composite parent, int treeStyle, PatternFilter filter, boolean useNewLook, boolean useFastHashLookup) {
        super(parent, 0);
        this.parent = parent;
        this.init(treeStyle, filter);
        if (this.treeViewer != null) {
            this.treeViewer.setUseHashlookup(useFastHashLookup);
        }
    }

    @Deprecated
    protected FilteredTree(Composite parent) {
        super(parent, 0);
        this.parent = parent;
    }

    @Deprecated
    protected FilteredTree(Composite parent, boolean useNewLook) {
        super(parent, 0);
        this.parent = parent;
    }

    @Deprecated
    public FilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
        super(parent, 0);
        this.parent = parent;
        this.init(treeStyle, filter);
    }

    @Deprecated
    public FilteredTree(Composite parent, int treeStyle, PatternFilter filter, boolean useNewLook) {
        super(parent, 0);
        this.parent = parent;
        this.init(treeStyle, filter);
    }

    protected void init(int treeStyle, PatternFilter filter) {
        this.patternFilter = filter;
        this.showFilterControls = PlatformUI.getPreferenceStore().getBoolean("SHOW_FILTERED_TEXTS");
        this.createControl(this.parent, treeStyle);
        this.createRefreshJob();
        this.setInitialText(WorkbenchMessages.FilteredTree_FilterMessage);
        this.setFont(this.parent.getFont());
    }

    protected void createControl(Composite parent, int treeStyle) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        if (parent.getLayout() instanceof GridLayout) {
            this.setLayoutData(new GridData(4, 4, true, true));
        }
        if (this.showFilterControls) {
            this.filterComposite = new Composite((Composite)this, 0);
            GridLayout filterLayout = new GridLayout();
            filterLayout.marginHeight = 0;
            filterLayout.marginWidth = 0;
            this.filterComposite.setLayout((Layout)filterLayout);
            this.filterComposite.setFont(parent.getFont());
            this.createFilterControls(this.filterComposite);
            this.filterComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        }
        this.treeComposite = new Composite((Composite)this, 0);
        GridLayout treeCompositeLayout = new GridLayout();
        treeCompositeLayout.marginHeight = 0;
        treeCompositeLayout.marginWidth = 0;
        this.treeComposite.setLayout((Layout)treeCompositeLayout);
        GridData data = new GridData(4, 4, true, true);
        this.treeComposite.setLayoutData((Object)data);
        this.createTreeControl(this.treeComposite, treeStyle);
    }

    protected Composite createFilterControls(Composite parent) {
        this.createFilterText(parent);
        return parent;
    }

    protected Control createTreeControl(Composite parent, int style) {
        this.treeViewer = this.doCreateTreeViewer(parent, style);
        GridData data = new GridData(4, 4, true, true);
        this.treeViewer.getControl().setLayoutData((Object)data);
        this.treeViewer.getControl().addDisposeListener(e -> {
            boolean bl = this.refreshJob.cancel();
        });
        if (this.treeViewer instanceof NotifyingTreeViewer) {
            this.patternFilter.setUseCache(true);
        }
        this.treeViewer.addFilter((ViewerFilter)this.patternFilter);
        return this.treeViewer.getControl();
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new NotifyingTreeViewer(parent, style);
    }

    private TreeItem getFirstMatchingItem(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (this.patternFilter.isLeafMatch((Viewer)this.treeViewer, item.getData()) && this.patternFilter.isElementSelectable(item.getData())) {
                return item;
            }
            TreeItem treeItem = this.getFirstMatchingItem(item.getItems());
            if (treeItem != null) {
                return treeItem;
            }
            ++n2;
        }
        return null;
    }

    private void createRefreshJob() {
        this.refreshJob = this.doCreateRefreshJob();
        this.refreshJob.setSystem(true);
    }

    protected WorkbenchJob doCreateRefreshJob() {
        return new WorkbenchJob("Refresh Filter"){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                boolean initial;
                if (FilteredTree.this.treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                String text = FilteredTree.this.getFilterString();
                if (text == null) {
                    return Status.OK_STATUS;
                }
                boolean bl = initial = FilteredTree.this.initialText != null && FilteredTree.this.initialText.equals(text);
                if (initial) {
                    FilteredTree.this.patternFilter.setPattern(null);
                } else if (text != null) {
                    FilteredTree.this.patternFilter.setPattern(text);
                }
                Composite redrawFalseControl = FilteredTree.this.treeComposite != null ? FilteredTree.this.treeComposite : FilteredTree.this.treeViewer.getControl();
                try {
                    redrawFalseControl.setRedraw(false);
                    if (!FilteredTree.this.narrowingDown) {
                        TreeItem[] is;
                        TreeItem[] treeItemArray = is = FilteredTree.this.treeViewer.getTree().getItems();
                        int n = is.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem item = treeItemArray[n2];
                            if (item.getExpanded()) {
                                FilteredTree.this.treeViewer.setExpandedState(item.getData(), false);
                            }
                            ++n2;
                        }
                    }
                    FilteredTree.this.treeViewer.refresh(true);
                    if (text.length() > 0 && !initial) {
                        TreeItem[] items = FilteredTree.this.getViewer().getTree().getItems();
                        int treeHeight = FilteredTree.this.getViewer().getTree().getBounds().height;
                        int numVisibleItems = treeHeight / FilteredTree.this.getViewer().getTree().getItemHeight();
                        long stopTime = 200L + System.currentTimeMillis();
                        if (items.length > 0 && this.recursiveExpand(items, monitor, stopTime, new int[]{numVisibleItems})) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                    }
                }
                finally {
                    TreeItem[] items = FilteredTree.this.getViewer().getTree().getItems();
                    if (items.length > 0 && FilteredTree.this.getViewer().getTree().getSelectionCount() == 0) {
                        FilteredTree.this.treeViewer.getTree().setTopItem(items[0]);
                    }
                    if (FilteredTree.this.quickSelectionMode) {
                        FilteredTree.this.updateTreeSelection(false);
                    }
                    redrawFalseControl.setRedraw(true);
                }
                return Status.OK_STATUS;
            }

            private boolean recursiveExpand(TreeItem[] items, IProgressMonitor monitor, long cancelTime, int[] numItemsLeft) {
                boolean canceled = false;
                int i = 0;
                while (!canceled && i < items.length) {
                    boolean visible;
                    TreeItem item = items[i];
                    int n = numItemsLeft[0];
                    numItemsLeft[0] = n - 1;
                    boolean bl = visible = n >= 0;
                    if (monitor.isCanceled() || !visible && System.currentTimeMillis() > cancelTime) {
                        canceled = true;
                    } else {
                        Object itemData = item.getData();
                        if (itemData != null) {
                            if (!item.getExpanded()) {
                                FilteredTree.this.treeViewer.setExpandedState(itemData, true);
                            }
                            TreeItem[] children = item.getItems();
                            if (items.length > 0) {
                                canceled = this.recursiveExpand(children, monitor, cancelTime, numItemsLeft);
                            }
                        }
                    }
                    ++i;
                }
                return canceled;
            }
        };
    }

    protected void updateToolbar(boolean visible) {
    }

    protected void createFilterText(Composite parent) {
        this.filterText = this.doCreateFilterText(parent);
        this.filterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String filterTextString = FilteredTree.this.filterText.getText();
                e.result = filterTextString.length() == 0 || filterTextString.equals(FilteredTree.this.initialText) ? FilteredTree.this.initialText : NLS.bind((String)WorkbenchMessages.FilteredTree_AccessibleListenerFiltered, (Object[])new String[]{filterTextString, String.valueOf(this.getFilteredItemsCount())});
            }

            private int getFilteredItemsCount() {
                TreeItem[] items;
                int total = 0;
                TreeItem[] treeItemArray = items = FilteredTree.this.getViewer().getTree().getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    total += this.itemCount(item);
                    ++n2;
                }
                return total;
            }

            private int itemCount(TreeItem treeItem) {
                TreeItem[] children;
                int count = 1;
                TreeItem[] treeItemArray = children = treeItem.getItems();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem element = treeItemArray[n2];
                    count += this.itemCount(element);
                    ++n2;
                }
                return count;
            }
        });
        this.filterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Display display = FilteredTree.this.filterText.getDisplay();
                display.asyncExec(() -> {
                    if (!FilteredTree.this.filterText.isDisposed() && FilteredTree.this.getInitialText().equals(FilteredTree.this.filterText.getText().trim())) {
                        FilteredTree.this.filterText.selectAll();
                    }
                });
            }

            public void focusLost(FocusEvent e) {
                if (FilteredTree.this.filterText.getText().equals(FilteredTree.this.initialText)) {
                    FilteredTree.this.setFilterText("");
                    FilteredTree.this.textChanged();
                }
            }
        });
        this.filterText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (FilteredTree.this.filterText.getText().equals(FilteredTree.this.initialText)) {
                    FilteredTree.this.setFilterText("");
                    FilteredTree.this.textChanged();
                }
            }
        });
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean hasItems;
                boolean bl = hasItems = FilteredTree.this.getViewer().getTree().getItemCount() > 0;
                if (hasItems && e.keyCode == 0x1000002) {
                    FilteredTree.this.treeViewer.getTree().setFocus();
                    return;
                }
            }
        });
        this.filterText.addTraverseListener(e -> {
            if (this.quickSelectionMode) {
                return;
            }
            if (e.detail == 4) {
                e.doit = false;
                this.updateTreeSelection(true);
            }
        });
        this.filterText.addModifyListener(e -> this.textChanged());
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.filterText.setLayoutData((Object)gridData);
    }

    protected void updateTreeSelection(boolean setFocus) {
        Tree tree = this.getViewer().getTree();
        if (tree.getItemCount() == 0) {
            if (setFocus) {
                Display.getCurrent().beep();
            }
        } else {
            TreeItem item;
            boolean textChanged;
            boolean hasFocus = setFocus ? tree.setFocus() : true;
            boolean bl = textChanged = !this.getInitialText().equals(this.filterText.getText().trim());
            if (hasFocus && textChanged && this.filterText.getText().trim().length() > 0 && (item = tree.getSelectionCount() > 0 ? this.getFirstMatchingItem(tree.getSelection()) : this.getFirstMatchingItem(tree.getItems())) != null) {
                tree.setSelection(new TreeItem[]{item});
                ISelection sel = this.getViewer().getSelection();
                this.getViewer().setSelection(sel, true);
            }
        }
    }

    protected Text doCreateFilterText(Composite parent) {
        return new Text(parent, 2436);
    }

    protected void textChanged() {
        this.narrowingDown = this.previousFilterText == null || this.previousFilterText.equals(WorkbenchMessages.FilteredTree_FilterMessage) || this.getFilterString().startsWith(this.previousFilterText);
        this.previousFilterText = this.getFilterString();
        this.refreshJob.cancel();
        this.refreshJob.schedule(this.getRefreshJobDelay());
    }

    protected long getRefreshJobDelay() {
        return 200L;
    }

    public void setBackground(Color background) {
        super.setBackground(background);
    }

    protected void clearText() {
        this.setFilterText("");
        this.textChanged();
    }

    protected void setFilterText(String string) {
        if (this.filterText != null) {
            this.filterText.setText(string);
            this.selectAll();
        }
    }

    public final PatternFilter getPatternFilter() {
        return this.patternFilter;
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public Text getFilterControl() {
        return this.filterText;
    }

    protected String getFilterString() {
        return this.filterText != null ? this.filterText.getText() : null;
    }

    public void setInitialText(String text) {
        this.initialText = text;
        if (this.filterText != null) {
            this.filterText.setMessage(text);
            if (this.filterText.isFocusControl()) {
                this.setFilterText(this.initialText);
                this.textChanged();
            } else {
                this.getDisplay().asyncExec(() -> {
                    if (!this.filterText.isDisposed() && this.filterText.isFocusControl()) {
                        this.setFilterText(this.initialText);
                        this.textChanged();
                    }
                });
            }
        } else {
            this.setFilterText(this.initialText);
            this.textChanged();
        }
    }

    public void setQuickSelectionMode(boolean enabled) {
        this.quickSelectionMode = enabled;
    }

    protected void selectAll() {
        if (this.filterText != null) {
            this.filterText.selectAll();
        }
    }

    protected String getInitialText() {
        return this.initialText;
    }

    public static Font getBoldFont(Object element, FilteredTree tree, PatternFilter filter) {
        String filterText = tree.getFilterString();
        if (filterText == null) {
            return null;
        }
        String initialText = tree.getInitialText();
        if (!filterText.isEmpty() && !filterText.equals(initialText)) {
            if (tree.getPatternFilter() != filter) {
                boolean initial;
                boolean bl = initial = initialText != null && initialText.equals(filterText);
                if (initial) {
                    filter.setPattern(null);
                } else if (filterText != null) {
                    filter.setPattern(filterText);
                }
            }
            if (filter.isElementVisible((Viewer)tree.getViewer(), element) && filter.isLeafMatch((Viewer)tree.getViewer(), element)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
        }
        return null;
    }

    class NotifyingTreeViewer
    extends TreeViewer {
        public NotifyingTreeViewer(Composite parent, int style) {
            super(parent, style);
        }

        public void add(Object parentElementOrTreePath, Object childElement) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.add(parentElementOrTreePath, childElement);
        }

        public void add(Object parentElementOrTreePath, Object ... childElements) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.add(parentElementOrTreePath, childElements);
        }

        protected void inputChanged(Object input, Object oldInput) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.inputChanged(input, oldInput);
        }

        public void insert(Object parentElementOrTreePath, Object element, int position) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.insert(parentElementOrTreePath, element, position);
        }

        public void refresh() {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.refresh();
        }

        public void refresh(boolean updateLabels) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.refresh(updateLabels);
        }

        public void refresh(Object element) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.refresh(element);
        }

        public void refresh(Object element, boolean updateLabels) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.refresh(element, updateLabels);
        }

        public void remove(Object elementsOrTreePaths) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.remove(elementsOrTreePaths);
        }

        public void remove(Object parent, Object ... elements) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.remove(parent, elements);
        }

        public void remove(Object ... elementsOrTreePaths) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.remove(elementsOrTreePaths);
        }

        public void replace(Object parentElementOrTreePath, int index, Object element) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.replace(parentElementOrTreePath, index, element);
        }

        public void setChildCount(Object elementOrTreePath, int count) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.setChildCount(elementOrTreePath, count);
        }

        public void setContentProvider(IContentProvider provider) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.setContentProvider(provider);
        }

        public void setHasChildren(Object elementOrTreePath, boolean hasChildren) {
            FilteredTree.this.getPatternFilter().clearCaches();
            super.setHasChildren(elementOrTreePath, hasChildren);
        }
    }
}

