/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.core.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.tmdmaker.core.model.AbstractConnectionModel;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.AbstractSubsetType;
import org.tmdmaker.core.model.ConnectableElement;
import org.tmdmaker.core.model.IVisitor;
import org.tmdmaker.core.model.ReusedIdentifier;
import org.tmdmaker.core.model.VirtualSuperset;

public class VirtualSupersetType
extends AbstractSubsetType<VirtualSuperset> {
    public static final String PROPERTY_SUPERSET_TYPE = "_property_superset_type";
    protected Map<AbstractEntityModel, ReusedIdentifier> reusedIdentifiers = new LinkedHashMap<AbstractEntityModel, ReusedIdentifier>();
    private boolean applyAttribute = false;

    public VirtualSupersetType() {
        this.setApplyAttribute(true);
    }

    public boolean isApplyAttribute() {
        return this.applyAttribute;
    }

    public void setApplyAttribute(boolean applyAttribute) {
        boolean oldValue = this.applyAttribute;
        this.applyAttribute = applyAttribute;
        this.firePropertyChange(PROPERTY_SUPERSET_TYPE, oldValue, this.applyAttribute);
    }

    public void addReusedIdentifier(AbstractEntityModel source) {
        this.addReusedIdentifier(source, source.createReusedIdentifier());
    }

    protected void addReusedIdentifier(AbstractEntityModel source, ReusedIdentifier reused) {
        this.reusedIdentifiers.put(source, reused);
        this.notifyRelationshipChanged();
    }

    public ReusedIdentifier removeReusedIdentifier(AbstractEntityModel source) {
        ReusedIdentifier removed = this.reusedIdentifiers.remove(source);
        this.notifyRelationshipChanged();
        return removed;
    }

    private void notifyRelationshipChanged() {
        ((AbstractEntityModel)this.getModelSourceConnections().get(0).getTarget()).fireIdentifierChanged();
    }

    public Map<AbstractEntityModel, ReusedIdentifier> getReusedIdentifiers() {
        return this.reusedIdentifiers;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public VirtualSuperset getSuperset() {
        if (!this.getModelSourceConnections().isEmpty()) {
            AbstractConnectionModel r = this.getModelSourceConnections().get(0);
            return (VirtualSuperset)r.getTarget();
        }
        return null;
    }

    @Override
    public List<AbstractEntityModel> getSubsetList() {
        ArrayList<AbstractEntityModel> list = new ArrayList<AbstractEntityModel>();
        for (AbstractConnectionModel c : this.getModelTargetConnections()) {
            ConnectableElement m = c.getSource();
            if (!(m instanceof AbstractEntityModel)) continue;
            list.add((AbstractEntityModel)m);
        }
        return list;
    }
}

