/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.core.model;

import java.util.ArrayList;
import java.util.List;
import org.tmdmaker.core.model.AbstractConnectionModel;
import org.tmdmaker.core.model.AbstractEntityModel;
import org.tmdmaker.core.model.ConnectableElement;
import org.tmdmaker.core.model.Diagram;
import org.tmdmaker.core.model.Entity2VirtualSupersetTypeRelationship;
import org.tmdmaker.core.model.IVisitor;
import org.tmdmaker.core.model.VirtualSuperset;
import org.tmdmaker.core.model.VirtualSupersetType;
import org.tmdmaker.core.model.parts.ModelName;

public class VirtualSupersetType2VirtualSupersetRelationship
extends AbstractConnectionModel {
    @Deprecated
    private VirtualSuperset superset;
    @Deprecated
    private VirtualSupersetType type;
    private List<Entity2VirtualSupersetTypeRelationship> subset2typeRelationshipList;

    @Deprecated
    public VirtualSupersetType2VirtualSupersetRelationship() {
    }

    public VirtualSupersetType2VirtualSupersetRelationship(VirtualSuperset superset) {
        this.setSource(new VirtualSupersetType());
        this.setTarget(superset);
    }

    public VirtualSupersetType2VirtualSupersetRelationship(VirtualSuperset superset, List<AbstractEntityModel> subsets) {
        this.setSource(new VirtualSupersetType());
        this.setTarget(superset);
        this.setSubsetList(subsets);
    }

    public VirtualSupersetType2VirtualSupersetRelationship(String virtualSupersetName, List<AbstractEntityModel> subsets) {
        this.setSource(new VirtualSupersetType());
        this.setTarget(VirtualSuperset.of(new ModelName(virtualSupersetName)));
        this.setSubsetList(subsets);
    }

    public void setSubsetList(List<AbstractEntityModel> subsets) {
        this.subset2typeRelationshipList = new ArrayList<Entity2VirtualSupersetTypeRelationship>();
        for (AbstractEntityModel s : subsets) {
            Entity2VirtualSupersetTypeRelationship r = new Entity2VirtualSupersetTypeRelationship(s, (ConnectableElement)this.getVirtualSupersetType());
            this.subset2typeRelationshipList.add(r);
        }
    }

    @Override
    public void connect() {
        super.connect();
        this.connectSubsetList();
        Diagram diagram = this.getDiagram();
        if (diagram != null) {
            diagram.addChild(this.getVirtualSuperset());
            diagram.addChild(this.getVirtualSupersetType());
        }
    }

    private Diagram getDiagram() {
        return ((AbstractEntityModel)this.subset2typeRelationshipList.get(0).getSource()).getDiagram();
    }

    private void connectSubsetList() {
        for (Entity2VirtualSupersetTypeRelationship r : this.subset2typeRelationshipList) {
            r.connect();
        }
    }

    @Override
    public void disconnect() {
        Diagram diagram = this.getDiagram();
        if (diagram != null) {
            diagram.removeChild(this.getVirtualSupersetType());
            diagram.removeChild(this.getVirtualSuperset());
        }
        this.disconnectSubsetList();
        super.disconnect();
    }

    private void disconnectSubsetList() {
        for (Entity2VirtualSupersetTypeRelationship r : this.subset2typeRelationshipList) {
            r.disconnect();
        }
    }

    @Override
    public boolean isDeletable() {
        return true;
    }

    @Override
    public String getSourceName() {
        return this.getTarget().getName();
    }

    @Override
    public String getTargetName() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        VirtualSupersetType vsType = this.getVirtualSupersetType();
        for (AbstractEntityModel m : vsType.getSubsetList()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(m.getName());
        }
        return builder.toString();
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visit(this);
    }

    private List<AbstractEntityModel> getSubsetList() {
        ArrayList<AbstractEntityModel> list = new ArrayList<AbstractEntityModel>();
        for (Entity2VirtualSupersetTypeRelationship r : this.subset2typeRelationshipList) {
            list.add((AbstractEntityModel)r.getSource());
        }
        return list;
    }

    public void reconnect(List<AbstractEntityModel> subsets) {
        List<AbstractEntityModel> currentSubsetList = this.getSubsetList();
        ArrayList<Entity2VirtualSupersetTypeRelationship> newSubsetList = new ArrayList<Entity2VirtualSupersetTypeRelationship>();
        for (AbstractEntityModel s : subsets) {
            if (currentSubsetList.contains(s)) {
                int index = currentSubsetList.indexOf(s);
                newSubsetList.add(this.subset2typeRelationshipList.get(index));
                continue;
            }
            newSubsetList.add(new Entity2VirtualSupersetTypeRelationship(s, (ConnectableElement)this.getVirtualSupersetType()));
        }
        this.disconnectSubsetList();
        this.subset2typeRelationshipList = newSubsetList;
        this.connectSubsetList();
    }

    public List<Entity2VirtualSupersetTypeRelationship> getSubset2typeRelationshipList() {
        return this.subset2typeRelationshipList;
    }

    public void setSubset2typeRelationshipList(List<Entity2VirtualSupersetTypeRelationship> subset2typeRelationshipList) {
        this.subset2typeRelationshipList = subset2typeRelationshipList;
    }

    public VirtualSuperset getVirtualSuperset() {
        return (VirtualSuperset)this.getTarget();
    }

    public VirtualSupersetType getVirtualSupersetType() {
        return (VirtualSupersetType)this.getSource();
    }
}

