/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.dialogs.components;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tmdmaker.core.model.EntityType;
import org.tmdmaker.core.model.parts.ModelName;
import org.tmdmaker.ui.Messages;
import org.tmdmaker.ui.dialogs.AttributeDialog;
import org.tmdmaker.ui.dialogs.model.EditAttribute;
import org.tmdmaker.ui.dialogs.model.EntityCreationModel;

public class EntityNameAndTypeSettingPanel
extends Composite {
    private Label identifierLabel = null;
    private Text identifierText = null;
    private Label typeLabel = null;
    private Button nameAutoCreateCheckBox = null;
    private Label nameLabel = null;
    private Text nameText = null;
    private Button descButton = null;
    private Button btnRadioButton_0;
    private Button btnRadioButton_1;
    private Button btnRadioButton_2;
    private EntityCreationModel entity;

    public EntityNameAndTypeSettingPanel(Composite parent, int style) {
        this(parent, style, new EntityCreationModel());
    }

    public EntityNameAndTypeSettingPanel(Composite parent, int style, EntityCreationModel _entity) {
        super(parent, style);
        this.entity = _entity;
        this.initialize();
        this.initializeEntityTypeRadio();
    }

    private void initializeEntityTypeRadio() {
        this.btnRadioButton_0.setSelection(EntityType.RESOURCE.equals((Object)this.entity.getEntityType()));
        this.btnRadioButton_1.setSelection(EntityType.EVENT.equals((Object)this.entity.getEntityType()));
        this.btnRadioButton_2.setSelection(EntityType.LAPUTA.equals((Object)this.entity.getEntityType()));
    }

    private void initialize() {
        this.identifierLabel = new Label((Composite)this, 0);
        this.identifierLabel.setText(Messages.Identifier);
        GridData gridData11 = new GridData();
        gridData11.grabExcessHorizontalSpace = true;
        gridData11.horizontalAlignment = 4;
        gridData11.verticalAlignment = 2;
        GridData gridData9 = new GridData();
        gridData9.horizontalSpan = 2;
        GridData gridData1 = new GridData();
        gridData1.grabExcessHorizontalSpace = false;
        gridData1.verticalAlignment = 2;
        gridData1.horizontalAlignment = 4;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = -1;
        gridData.verticalAlignment = 2;
        this.identifierText = new Text((Composite)this, 2048);
        this.identifierText.setLayoutData((Object)gridData);
        this.descButton = new Button((Composite)this, 0);
        this.descButton.setText(Messages.DescriptionButton);
        this.descButton.setLayoutData((Object)gridData11);
        this.nameAutoCreateCheckBox = new Button((Composite)this, 32);
        this.nameAutoCreateCheckBox.setText(Messages.AutomaticGenerateEntityName);
        this.nameAutoCreateCheckBox.setLayoutData((Object)gridData9);
        new Label((Composite)this, 0);
        this.nameLabel = new Label((Composite)this, 0);
        this.nameLabel.setText(Messages.EntityName);
        this.nameText = new Text((Composite)this, 2048);
        this.nameText.setLayoutData((Object)gridData1);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.widget;
                EntityNameAndTypeSettingPanel.this.entity.setEntityName(new ModelName(t.getText()));
            }
        });
        this.nameAutoCreateCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.widget;
                EntityNameAndTypeSettingPanel.this.entity.setEntityNameAutoGeneration(b.getSelection());
                if (b.getSelection()) {
                    EntityNameAndTypeSettingPanel.this.nameText.setEnabled(false);
                    EntityNameAndTypeSettingPanel.this.nameText.setText(EntityNameAndTypeSettingPanel.this.entity.getEntityName().getValue());
                } else {
                    EntityNameAndTypeSettingPanel.this.nameText.setEnabled(true);
                }
            }
        });
        this.identifierText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.widget;
                EntityNameAndTypeSettingPanel.this.entity.setIdentifierName(t.getText());
                if (EntityNameAndTypeSettingPanel.this.nameAutoCreateCheckBox.getSelection()) {
                    EntityNameAndTypeSettingPanel.this.nameText.setText(EntityNameAndTypeSettingPanel.this.entity.getEntityName().getValue());
                }
            }
        });
        this.descButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditAttribute edited;
                AttributeDialog dialog = new AttributeDialog(EntityNameAndTypeSettingPanel.this.getShell(), EntityNameAndTypeSettingPanel.this.entity.getIdentifier());
                if (dialog.open() == 0 && (edited = dialog.getEditedValue()).isEdited()) {
                    EntityNameAndTypeSettingPanel.this.identifierText.setText(edited.getName());
                }
            }
        });
        this.nameAutoCreateCheckBox.setSelection(true);
        this.nameText.setEnabled(false);
        new Label((Composite)this, 0);
        GridData gridData10 = new GridData();
        gridData10.horizontalAlignment = 2;
        gridData10.verticalAlignment = 2;
        this.typeLabel = new Label((Composite)this, 0);
        this.typeLabel.setText(Messages.EntityType);
        this.typeLabel.setLayoutData((Object)gridData10);
        Composite composite = new Composite((Composite)this, 0);
        RowLayout rl_composite = new RowLayout(256);
        rl_composite.justify = true;
        composite.setLayout((Layout)rl_composite);
        composite.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        this.btnRadioButton_0 = new Button(composite, 16);
        this.btnRadioButton_0.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EntityNameAndTypeSettingPanel.this.entity.setEntityType(EntityType.RESOURCE);
            }
        });
        this.btnRadioButton_0.setText(Messages.Resource);
        this.btnRadioButton_1 = new Button(composite, 16);
        this.btnRadioButton_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EntityNameAndTypeSettingPanel.this.entity.setEntityType(EntityType.EVENT);
            }
        });
        this.btnRadioButton_1.setText(Messages.Event);
        this.btnRadioButton_2 = new Button(composite, 16);
        this.btnRadioButton_2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EntityNameAndTypeSettingPanel.this.entity.setEntityType(EntityType.LAPUTA);
            }
        });
        this.btnRadioButton_2.setText(Messages.Laputa);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.horizontalSpacing = 5;
        this.setLayout((Layout)gridLayout);
        this.setSize(new Point(350, 115));
    }
}

