/*
 * Decompiled with CFR 0.152.
 */
package org.tmdmaker.ui.editor.gef3.editparts.relationship;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tmdmaker.core.model.AbstractConnectionModel;
import org.tmdmaker.core.model.ConnectableElement;
import org.tmdmaker.core.model.ModelElement;
import org.tmdmaker.ui.editor.draw2d.AnchorConstraintManager;
import org.tmdmaker.ui.editor.draw2d.anchors.XYChopboxAnchor;

public abstract class AbstractRelationshipEditPart
extends AbstractConnectionEditPart
implements NodeEditPart,
PropertyChangeListener {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConnectionAnchor anchor;

    private ConnectionAnchor getConnectionAnchor() {
        if (this.anchor == null) {
            this.anchor = new PolylineConnectionAnchor((PolylineConnection)this.getFigure());
        }
        return this.anchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getConnectionAnchor();
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getConnectionAnchor();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("_property_constraint")) {
            this.logger.debug("Connection AbstractEntityModel.P_CONSTRAINT");
            this.refreshVisuals();
        } else if (evt.getPropertyName().equals("p_source_connection")) {
            this.logger.debug("Connection AbstractEntityModel.P_SOURCE_CONNECTION");
            this.refreshSourceConnections();
        } else if (evt.getPropertyName().equals("p_target_connection")) {
            this.logger.debug("Connection AbstractEntityModel.P_TARGET_CONNECTION");
            this.refreshTargetConnections();
        }
    }

    public void activate() {
        super.activate();
        ((ModelElement)this.getModel()).addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void deactivate() {
        super.deactivate();
        ((ModelElement)this.getModel()).removePropertyChangeListener((PropertyChangeListener)this);
    }

    protected List<AbstractConnectionModel> getModelSourceConnections() {
        return ((ConnectableElement)this.getModel()).getModelSourceConnections();
    }

    protected List<AbstractConnectionModel> getModelTargetConnections() {
        return ((ConnectableElement)this.getModel()).getModelTargetConnections();
    }

    protected void calculateAnchorLocation() {
        ConnectionAnchor targetAnchor;
        AbstractConnectionModel relationship = (AbstractConnectionModel)this.getModel();
        ConnectionAnchor sourceAnchor = this.getConnectionFigure().getSourceAnchor();
        if (sourceAnchor instanceof XYChopboxAnchor) {
            ((XYChopboxAnchor)sourceAnchor).setLocation(AnchorConstraintManager.getSourceAnchorConstraint(relationship));
        }
        if ((targetAnchor = this.getConnectionFigure().getTargetAnchor()) instanceof XYChopboxAnchor) {
            ((XYChopboxAnchor)targetAnchor).setLocation(AnchorConstraintManager.getTargetAnchorConstraint(relationship));
        }
    }

    protected static class PolylineConnectionAnchor
    extends AbstractConnectionAnchor {
        private PolylineConnection owner;

        public PolylineConnectionAnchor(PolylineConnection owner) {
            this.owner = owner;
        }

        public Point getLocation(Point reference) {
            Point midpoint = this.owner.getPoints().getMidpoint();
            this.owner.translateToAbsolute((Translatable)midpoint);
            return midpoint;
        }

        public IFigure getOwner() {
            return this.owner;
        }

        public Point getReferencePoint() {
            if (this.owner == null) {
                return null;
            }
            return this.getLocation(null);
        }
    }
}

