
/* tnetio_fwd.c - TCP/IP ѥåžץ */

/* $Id: tnetio_fwd.c,v 1.3 2003/05/19 05:36:38 tosihisa Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/time.h>

#include <signal.h>

#include <sys/wait.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include <time.h>

#include "tnetio.h"

#ifdef	DYN_LOAD
/* ܥ饤֥꤬ɤ줿˸ƤӽФ */
void _init(void)
{
}

/* ܥ饤֥꤬ɤ줿˸ƤӽФ */
void _fini(void)
{
}
#endif

/* tnetsrv ϡδؿƤӽФ */
int tnetio_run(int in_fd,int out_fd,int argc,char **argv)
{
	struct _local_vars {
		struct sockaddr_in server_addr;
		int sockfd;
		int maxfd;
		fd_set rfds;
		unsigned char buffer[8192];
		int bufsize;
		char *name;
		char *port;
		char *proto;
	} INIT_LOCAL(l);

	l.name = argv[1];
	l.port = argv[2];
	l.proto = argv[3];

	if((l.name != NULL) && (l.port != NULL))
	{
		if(l.proto == NULL)
			l.proto = "tcp";

		if(tnetio_sockaddr_in_byname(1,l.name,l.port,l.proto,&(l.server_addr)) >= 0)
		{
			if((l.sockfd = tnetio_socket(AF_INET,SOCK_STREAM,0)) >= 0)
			{
				if(tnetio_connect(l.sockfd,(struct sockaddr *)&(l.server_addr),sizeof(l.server_addr)) == 0)
				{
					while(1)
					{
						FD_ZERO(&(l.rfds));
						FD_SET(in_fd,&(l.rfds));
						FD_SET(l.sockfd,&(l.rfds));

						l.maxfd = l.sockfd;
						if(in_fd > l.maxfd)
							l.maxfd = in_fd;

						if(select(l.maxfd + 1,&(l.rfds),NULL,NULL,NULL) < 0)
							break;

						if(FD_ISSET(in_fd,&(l.rfds)))
						{
							l.bufsize = read(in_fd,l.buffer,sizeof(l.buffer));
							if(l.bufsize <= 0)
								break;

							if(write(l.sockfd,l.buffer,l.bufsize) != l.bufsize)
								break;
						}

						if(FD_ISSET(l.sockfd,&(l.rfds)))
						{
							l.bufsize = read(l.sockfd,l.buffer,sizeof(l.buffer));
							if(l.bufsize <= 0)
								break;

							if(write(out_fd,l.buffer,l.bufsize) != l.bufsize)
								break;
						}
					}
				}

				close(l.sockfd);
			}
		}
	}

	return 0;
}

