
/* log_write() åν */

/* $Id: log_write.c,v 1.3 2003/05/20 09:59:57 tosihisa Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>

#ifdef HAVE_SYSLOG
#include <syslog.h>
#endif

#include "tnetio.h"

struct _tnetio_log_write_param_vars {	/* ѥ᡼Хѿ */
	int syslog_write;	/* (0) = syslog ˽񤯡(0) = ɸϤ˽񤯡 */
	char *syslog_ident;	/* syslog ͳȤ̾ */
	int syslog_option;	/* syslog ͳȤΥץ */
	int syslog_facility;	/* syslog ͳȤΥեƥ */
	int syslog_priority;	/* syslog ͳȤΥץ饤ƥ */
	int stdout_date;	/* (0) ʤСɸϤ˥ǡ񤭽Фˡդղä */
	int stdout_fd;		/* եǥץ */
	int stdout_pid;		/* ʤС"syslog_ident[getpid()]" Ϥ */
};

static struct _tnetio_log_write_param_vars P_log_write = {
	0,
	"tnetio",
#ifdef HAVE_SYSLOG
	(LOG_PID | LOG_NDELAY),
	LOG_DAEMON,
	LOG_INFO,
#else
	0,
	0,
	0,
#endif
	1,
	1,
	1,
};

void tnetio_log_init(char *myname)
{
	P_log_write.syslog_write = 0;	/* ɸϤ˽Ф */
	P_log_write.syslog_ident = myname;
	if(rindex(myname,'/') != NULL)
		P_log_write.syslog_ident = rindex(myname,'/') + 1;
}

void tnetio_log_date(int flag)
{
	P_log_write.stdout_date = flag;
}

void tnetio_log_fd(int fd)
{
	P_log_write.stdout_fd = fd;
}

void tnetio_log_pid(int flag)
{
	P_log_write.stdout_pid = flag;
}

void tnetio_log_open(void)
{
#ifdef HAVE_SYSLOG
	P_log_write.syslog_write = 1;

	openlog(P_log_write.syslog_ident,P_log_write.syslog_option,P_log_write.syslog_facility);
#else
	tnetio_log_write(" WARNING : Not supported : syslog() functions. (LOGGING is stdout only)\n");
#endif
}

void tnetio_log_close(void)
{
#ifdef HAVE_SYSLOG
	if(P_log_write.syslog_write)
		closelog();
#endif
}

int tnetio_log_write(const char *fmt,...)
{
	time_t tim;
	char logbuf[1024];
	int  logbuf_remain = 0;
	struct tm *pst_localtime;
	static const char *time_fmt = "%x %X : ";
	va_list args;	/* Ĺ */


	va_start(args,fmt);	/* Ĺѳ */

	if(P_log_write.syslog_write)
	{
#ifdef HAVE_SYSLOG
		/* syslog ͳ */
		vsyslog(P_log_write.syslog_priority,fmt,args);
#endif
	}
	else
	{
		/* ɸ */

		logbuf_remain = sizeof(logbuf) - 1;

		if(P_log_write.stdout_date)
		{
			/* ֥ǡꤹ */
			if(logbuf_remain > 0)
			{
				tim = time(NULL);
				pst_localtime = localtime(&tim);
				strftime(logbuf,logbuf_remain ,time_fmt,pst_localtime);
				logbuf_remain = sizeof(logbuf) - strlen(logbuf) - 1;
			}
		}

		if(P_log_write.stdout_pid)
		{
			/* ץ̾pid  */
			if(logbuf_remain > 0)
			{
				snprintf(logbuf + strlen(logbuf),logbuf_remain,"%s[%d]:",P_log_write.syslog_ident,getpid());
				logbuf_remain = sizeof(logbuf) - strlen(logbuf) - 1;
			}
		}

		/* 񤭹ߥǡκ */
		if(logbuf_remain > 0)
		{
			vsnprintf(logbuf + strlen(logbuf),logbuf_remain,fmt,args);
			write(P_log_write.stdout_fd,logbuf,strlen(logbuf));
		}
	}

	va_end(args);

	return 0;
}

