
/* tnetcvs - cvs pserver ǧڤ~/.passwd_cvs ǧڤǤ褦ˤ뤿Υåѡ */

/* $Id: tnetcvs.c,v 1.7 2003/05/22 09:11:14 tosihisa Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <stdarg.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <errno.h>

#include <pwd.h>
#include <grp.h>

#include <limits.h>

#include "tnetio.h"

#ifndef	CVSPASS_NAME
#	define CVSPASS_NAME	".passwd_cvs"	/* ɤ߼ѥɥե̾ */
#endif

/* ʤǲ */
#define	TNETCVS_PASS_OK		 0
#define	TNETCVS_PASS_NG		11
#define	TNETCVS_NO_USER		21
#define	TNETCVS_PROTO_ERR	31
#define	TNETCVS_EXEC_ERR	41

/* scramble() ȡdescramble() ϡCVS Υˤޤ */
extern char *scramble(char *str);
extern char *descramble(char *str);

static const char *G_reqbegin[] =
{
	"BEGIN VERIFICATION REQUEST",
	"BEGIN AUTH REQUEST",
	NULL
};

static const char *G_reqend[] =
{
	"END VERIFICATION REQUEST",
	"END AUTH REQUEST",
	NULL
};

static const char *G_reqlog[] =
{
	" CVS VERIFICATION(CVS login) : %s : %s\n",
	" CVS AUTH(CVS operation) : %s : %s\n",
	NULL
};

static char *G_exec_argv[] = { "cvs" , "server", NULL };

static int Gi_scramble_error = 0;

static const char *CVS_AUTH_ANS[] = 
{
	"I LOVE YOU\n",
	"I HATE YOU\n",
	NULL
};

static char *G_CVS_TrueUser = NULL;	/* Υ桼¤ưޤ */
static char *G_CVS_AuthUser = NULL;	/* Υ桼ǧڤޤ */

int tnetio_error(int a,int b,const char *fmt,...)
{
	va_list args;	/* Ĺ */


	va_start(args,fmt);	/* Ĺѳ */

	Gi_scramble_error = 1;

	va_end(args);

	return 0;
}

int tnetio_check_CVSpassword(char *pass_client,char *pass_server)
{
	char *pass_dsc = NULL;
	int i_retval = 0;


	i_retval = TNETCVS_PASS_NG;	/* ѥ԰ */

	if((pass_dsc = descramble(pass_client)) != NULL)
	{
		if(Gi_scramble_error == 0)
		{
			if(!strcmp(pass_dsc,pass_server))
			{
				/* ѥɰ */
				i_retval = TNETCVS_PASS_OK;
			}
		}

		tnetio_freebuf(&pass_dsc);
	}

	return i_retval;
}

int tnetio_validate_user(char *USERNAME,char *PASSWORD)
{
	struct passwd *pst_pwd = NULL;
	char CVSPASS_FULL[PATH_MAX + 1 + sizeof(CVSPASS_NAME) + 2];
	int cvs_fd = 0;
	char read_pass[128];
	int i_retval = 0;
	struct stat passwd_file;
	struct stat home_dir;
	int length = 0;


	i_retval = TNETCVS_NO_USER;	/* 桼¸ߤʤ~/.passwd_cvs ¸ߤʤ */

	/* 桼ϼºߤ */
	if((pst_pwd = getpwnam(USERNAME)) != NULL)
	{
		/* ۡǥ쥯ȥΥơ˹Ԥ뤳 */
		if(stat(pst_pwd->pw_dir,&home_dir) == 0)
		{
			/* ۡǥ쥯ȥΥ¤ˡ롼ס¾桼ɤ߼ꡢ񤭹߸¤̵ */
			if((home_dir.st_mode & (S_IRGRP | S_IWGRP | S_IROTH | S_IWOTH)) == 0)
			{
				strncpy(CVSPASS_FULL,pst_pwd->pw_dir,PATH_MAX);
				strcat(CVSPASS_FULL,"/");
				strcat(CVSPASS_FULL,CVSPASS_NAME);

				/* ե뤬ɤ߼ǽǥץǤ */
				if((cvs_fd = open(CVSPASS_FULL,O_RDONLY)) >= 0)
				{
					/* եΥơ˹Ԥ */
					if(fstat(cvs_fd,&passwd_file) == 0)
					{
						/* ̾եǤ */
						if(S_ISREG(passwd_file.st_mode))
						{
							/* 롼ס¾Υѡߥå 0 Ǥ */
							if(((passwd_file.st_mode & (S_IRWXG | S_IRWXO)) == 0))
							{
								/* ɤ߼롣λä˥顼Ϲͤʤ */
								if(tnetio_getline_raw(read_pass,sizeof(read_pass) - 2,cvs_fd,&length))
								{
									/* ʸ򸡽ФƤʤ饫åȤ */
									length--;
									read_pass[length] = 0x00;
								}

								/* ʸʾɤ߹Ǥ */
								if(
#ifdef	ALLOW_NULLOK	/* NULL ѥɤ */
									1
#else
									(length > 0)
#endif
								  )
								{
									i_retval = tnetio_check_CVSpassword(PASSWORD,read_pass);
								}
								else tnetio_log_write(" ERROR : (%s) : [%s]\n",CVSPASS_FULL,"NULL password (anyway reject)");
							}
							else tnetio_log_write(" ERROR : (%s) : [%s]\n",CVSPASS_FULL,"Illegal permission (Any user can read or write??)");
						}
						else tnetio_log_write(" ERROR : stat(%s) : [%s]\n",CVSPASS_FULL,"Not a regular file");
					}
					else tnetio_log_write(" ERROR : stat(%s) : [%s]\n",CVSPASS_FULL,strerror(errno));

					close(cvs_fd);
				}
				else tnetio_log_write(" ERROR : open(%s) : [%s]\n",CVSPASS_FULL,strerror(errno));
			}
			else  tnetio_log_write(" ERROR : (%s) : [%s]\n",pst_pwd->pw_dir,"Illegal permission (Any user can read or write??)");
		}
		else  tnetio_log_write(" ERROR : stat(%s) : [%s]\n",pst_pwd->pw_dir,strerror(errno));
	}
	else tnetio_log_write(" ERROR : getpwnam(%s) : [%s]\n",USERNAME,strerror(errno));

	return i_retval;	/* */
}

int tnetio_exec_cvs(void)
{
	struct passwd *pst_pwd;
	int i_retval = TNETCVS_EXEC_ERR;


	if(G_CVS_TrueUser == NULL)
		G_CVS_TrueUser = G_CVS_AuthUser;

	if((pst_pwd = getpwnam(G_CVS_TrueUser)) != NULL)
	{
		if(chdir(pst_pwd->pw_dir) == 0)
		{
			if(initgroups(pst_pwd->pw_name, pst_pwd->pw_gid) == 0)
			{
				if(setgid(pst_pwd->pw_gid) == 0)
				{
					if(setuid(pst_pwd->pw_uid) == 0)
					{
						umask(0);
						setenv("HOME",pst_pwd->pw_dir,1);
						setenv("LOGNAME",G_CVS_TrueUser,1);
						setenv("USER",G_CVS_TrueUser,1);
						setenv("CVS_USER",G_CVS_AuthUser,1);

						execvp( G_exec_argv[0], G_exec_argv );
					}
				}
			}
		}
	}

	return i_retval;
}

/* tnetsrv ϡδؿƤӽФ */
int tnetio_run(int in_fd,int out_fd,int argc,char **argv)
{
	int auth_type = 0;
	int i_retval = 0;
	char *PASSWORD = NULL;


	tnetio_initbuf(in_fd);

	G_CVS_TrueUser = argv[1];

	i_retval = TNETCVS_PROTO_ERR;	/* 桼ǧڥץȥ륨顼 */

	if(tnetio_getline())	/* ǧڳϥåɤ߼ */
	{
		tnetio_chop();

		if((auth_type = tnetio_selectbuf(G_reqbegin)) >= 0)
		{
			if(tnetio_getline())	/* ݥȥɤ߼ */
			{
				if(tnetio_getline())	/* 桼̾ɤ߼ */
				{
					tnetio_chop();

					if((G_CVS_AuthUser = tnetio_copybuf()) != NULL)
					{
						if(tnetio_getline())	/* ѥɤɤ߼ */
						{
							tnetio_chop();

							if((PASSWORD = tnetio_copybuf()) != NULL)
							{
								if(tnetio_getline())	/* ǧڽλåɤ߼ */
								{
									tnetio_chop();

									if(tnetio_selectbuf(G_reqend) == auth_type)
									{
										i_retval = tnetio_validate_user(G_CVS_AuthUser,PASSWORD);

										tnetio_log_write(G_reqlog[auth_type],G_CVS_AuthUser,(i_retval == 0) ? "OK" : "NG");
									}
								}
							}
						}
					}
				}
			}
		}
	}

	write(out_fd,CVS_AUTH_ANS[(i_retval & 1)],strlen(CVS_AUTH_ANS[(i_retval & 1)]));

	if((i_retval == TNETCVS_PASS_OK) && (auth_type == 1))
	{
		i_retval = tnetio_exec_cvs();
	}

	tnetio_freebuf(&G_CVS_AuthUser);

	return i_retval;
}

int main(int argc,char *argv[])
{
	tnetio_log_init(argv[0]);
	tnetio_log_fd(2);

	return tnetio_run(0,1,argc,argv);
}

