
/* tnetio.h - tnetio ̥إå */

/* $Id: tnetio.h,v 1.11 2003/05/21 11:42:44 tosihisa Exp $ */

#ifndef	__TNETIO_H_INCLUDED
#define	__TNETIO_H_INCLUDED

#include <netdb.h>

#define	TNETIO_VERSION	0x0010	/* 8bit ᥸㡼С󡣲8bit ޥʡС */

#define	INIT_LOCAL(l)	l ; memset(&l,0x00,sizeof(l))

#define	EXIT_NORMAL	0
#define	EXIT_EPERM	10
#define	EXIT_REFUSED	20
#define	EXIT_NOEXEC	30
#define	EXIT_BINDERR	40
#define	EXIT_SOLOAD	50

void tnetio_log_init(char *myname);
void tnetio_log_date(int flag);
void tnetio_log_fd(int fd);
void tnetio_log_pid(int flag);
void tnetio_log_open(void);
void tnetio_log_close(void);
int  tnetio_log_write(const char *fmt,...);

int tnetio_r_eval(char *funcname,int errcode);

int tnetio_socket(int domain, int type, int protocol);
int tnetio_bind(int sockfd, struct sockaddr *my_addr, socklen_t addrlen);
int tnetio_listen(int s, int backlog);
int tnetio_accept(int s, struct sockaddr *addr, socklen_t *addrlen);
int tnetio_getpeername(int s, struct sockaddr *name, socklen_t *namelen);
int tnetio_connect(int sockfd,struct sockaddr *serv_addr, socklen_t addrlen);

int tnetio_drop_ip_options(int fd);
int tnetio_set_tcp_nodelay(int fd);
int tnetio_set_keepalive(int fd);
int tnetio_set_linger(int fd,int t_tim);
int tnetio_set_reuse(int fd);

int tnetio_sockaddr_in_byname(int hostnamelookup,char *name,char *port,char *proto,struct sockaddr_in *addr);

int tnetio_libwrap_use(void);
int tnetio_test_client_connect(char *reject_file,int wrap_flag,char *wrap_name,int fd);

int   tnetio_dluse(void);
void *tnetio_dlopen(char *libname);
void *tnetio_dlsym(void *handler,char *funcname);
int   tnetio_dlclose(void *handler);
const char *tnetio_dlerror(void);

int tnetio_run(int in_fd,int out_fd,int argc,char **argv);
int tnetio_run_default(int in_fd,int out_fd,int argc,char **argv);

typedef struct _tnetio_buffer {
	int in_fd;
	char buf[8192];
	int len;
	int term;
} tnetio_buffer_t;

int tnetio_getline_raw(char *buffer,int limit,int fd,int *length);
int tnetio_getline(void);
int tnetio_chop(void);
void tnetio_initbuf(int fd);
char *tnetio_copybuf(void);
void tnetio_freebuf(char **ptr);
int tnetio_selectbuf(const char *buffers[]);
extern tnetio_buffer_t G_recvstr;

#endif	/* __TNETIO_H_INCLUDED */

