
/* tnetio_PAM - PAM ͳǤΥ桼ǧڥ饤֥ */

/* $Id: tnetio_PAM.c,v 1.2 2003/05/20 09:59:57 tosihisa Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "tnetio.h"

#include <security/pam_appl.h>

struct _pam_userinfo {
	char *username;
	char *password;
};

static char *my_strdup(char *s)
{
	return (s != NULL) ? strdup(s) : NULL;
}

static struct _pam_userinfo G_auth_pam_app_info;

static int tnetio_auth_pam_conv_func(int num_msg,const struct pam_message **msg,struct pam_response **resp,void *appdata_ptr)
{
	struct pam_response *response = NULL;
	struct _pam_userinfo *pst_userinfo;
	char *dup_target;
	int i_retval = PAM_CONV_ERR;
	int i;


	pst_userinfo = (struct _pam_userinfo *)appdata_ptr;

	if((response = (struct pam_response *)calloc(num_msg, sizeof(struct pam_response))) != NULL)
	{
		for (i = 0; i < num_msg; i++)
		{
			response[i].resp_retcode = 0;
			response[i].resp = NULL;

			dup_target = NULL;

			switch(msg[i]->msg_style)
			{
				case PAM_PROMPT_ECHO_ON:
					dup_target = pst_userinfo->username;
					break;
				case PAM_PROMPT_ECHO_OFF:
					dup_target = pst_userinfo->password;
					break;
			}

			if((response[i].resp = my_strdup(dup_target)) == NULL)
			{
				dup_target = NULL;
				break;
			}
		}

		if(dup_target != NULL)
		{
			*resp = response;
			i_retval = PAM_SUCCESS;
		}
		else
		{
			free(response);
		}
	}

	return i_retval;
}

static const struct pam_conv G_PAM_conv = { tnetio_auth_pam_conv_func , &G_auth_pam_app_info };

int tnetio_PAM_auth(char *pam_name,char *username,char *password)
{
	pam_handle_t *pamh = NULL;
	int pam_stat = PAM_OPEN_ERR;
	int i_retval = -1;


	G_auth_pam_app_info.username = username;
	G_auth_pam_app_info.password = password;

	/* PAM ǧڤϳϤǤޤ */
	if((pam_stat = pam_start(pam_name,username,&G_PAM_conv,&pamh)) == PAM_SUCCESS)
	{
		/* Υ桼¸ߤޤ */
		if((pam_stat = pam_authenticate(pamh,0)) == PAM_SUCCESS)
		{
			/* Υ桼ΥȤͭǤ */
			if((pam_stat = pam_acct_mgmt(pamh,0)) == PAM_SUCCESS)
			{
				/* Υ桼¸ߤȤͭǤ */
				i_retval = 0;
			}
		}
	}

	if(pam_stat != PAM_SUCCESS)
	{
		printf("%d(%s)\n",pam_stat,pam_strerror(pamh,pam_stat));
	}

	pam_end(pamh,pam_stat);

	return i_retval;
}

int main(int argc,char *argv[])
{
	if(tnetio_PAM_auth(argv[1],argv[2],argv[3]) >= 0)
		printf("PAM-auth OK!!!\n");
	return 0;
}

