
/* tnetio_getline.c - ƥɤ߼ؿ */

/* $Id: tnetio_getline.c,v 1.3 2003/05/21 11:42:44 tosihisa Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "tnetio.h"

/* 0֤ȡʸ򸡽ФǤ˽λ򼨤 */
int tnetio_getline_raw(char *buffer,int limit,int fd,int *length)
{
	int limit_idx = 0;
	char work = 0;
	int readsts = 0;
	int find_term = 0;


	/* ¡0x0a,0x00 ȤʤΤǡ㣲Хʬοͤɬ */
	if((limit >= 2) && (buffer != NULL))
	{
		do {
			if((readsts = read(fd,&work,sizeof(work))) == sizeof(work))
			{
				*(buffer + limit_idx) = work;
				limit_idx++;
				*(buffer + limit_idx) = 0x00;

				/* MS-DOS λͤơ0x0d Ԥȹͤ */
				if( (work == 0x0a)
				    || (work == 0x0d)
				    || (work == 0x00)
				  )
				{
					find_term = 1;
				}
			}
		} while ((find_term == 0) && (readsts == sizeof(work)) && (limit_idx < (limit - 1)));
	}

	if(length != NULL)
		*length = limit_idx;

	return find_term;
}

tnetio_buffer_t G_recvstr;

int tnetio_getline(void)
{
	return (G_recvstr.term = tnetio_getline_raw(G_recvstr.buf,sizeof(G_recvstr.buf) - 2,G_recvstr.in_fd,&(G_recvstr.len)));
}

int tnetio_chop(void)
{
	if(G_recvstr.len > 0)
	{
		G_recvstr.len--;
		G_recvstr.buf[G_recvstr.len] = 0x00;
	}

	return G_recvstr.len;
}

void tnetio_initbuf(int fd)
{
	memset(&G_recvstr,0x00,sizeof(G_recvstr));
	G_recvstr.in_fd = fd;
}

char *tnetio_copybuf(void)
{
	char *ptr_retval = NULL;

	if(G_recvstr.len > 0)
	{
		ptr_retval = malloc(G_recvstr.len + 1);
		if(ptr_retval != NULL)
		{
			memcpy(ptr_retval,G_recvstr.buf,G_recvstr.len + 1);
		}
	}

	return ptr_retval;
}

void tnetio_freebuf(char **ptr)
{
	if(*ptr != NULL)
	{
		free(*ptr);
		*ptr = NULL;
	}
}

int tnetio_selectbuf(const char *buffers[])
{
	int i;
	int i_retval = -1;


	for(i = 0;buffers[i] != NULL;i++)
	{
		if(!strcmp(G_recvstr.buf,buffers[i]))
		{
			i_retval = i;
			break;
		}
	}

	return i_retval;
}

#ifdef __SELFTEST__

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

int main(int argc,char *argv[])
{
	int fd = 0;
	char *buffer = NULL;
	int sts = 0;
	FILE *fp;
	int length;


	buffer = malloc(40);

	if((fd = open(argv[1],O_RDONLY)) >= 0)
	{
		do {
			/* sts = tnetio_getline(fd,&buffer,40,NULL); */
			sts = tnetio_getline_read(buffer,40,fd,&length);
			if(length > 0)
			{
				printf("[%3d][%d]:[%s]\n",length,sts,buffer);
			}
		} while(length > 0);
		close(fd);
	}

	puts("-----");

	if((fp = fopen(argv[1],"rb")) != NULL)
	{
		do {
			if(fgets(buffer,40,fp) != NULL)
			{
				printf("[%3d]:[%s]\n",strlen(buffer),buffer);
			}
			else
				break;
		} while(1);

		fclose(fp);
	}

	tnetio_memfree(&buffer);

	return 0;
}
#endif

