
/* tnetio_socket.c - å饤֥ */

/* $Id: tnetio_socket.c,v 1.1 2003/05/19 05:37:49 tosihisa Exp $ */

#include <stdio.h>
#include <string.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/socket.h>

#include "tnetio.h"

int tnetio_socket(int domain, int type, int protocol)
{
	return tnetio_r_eval("socket",socket(domain,type,protocol));
}

int tnetio_bind(int sockfd, struct sockaddr *my_addr, socklen_t addrlen)
{
	return tnetio_r_eval("bind",bind(sockfd,my_addr,addrlen));
}

int tnetio_listen(int s, int backlog)
{
	return tnetio_r_eval("listen",listen(s,backlog));
}

int tnetio_accept(int s, struct sockaddr *addr, socklen_t *addrlen)
{
	return tnetio_r_eval("accept",accept(s,addr,addrlen));
}

int tnetio_getpeername(int s, struct sockaddr *name, socklen_t *namelen)
{
	return tnetio_r_eval("getpeername",getpeername(s,name,namelen));
}

int tnetio_connect(int sockfd,struct sockaddr *serv_addr, socklen_t addrlen)
{
	return tnetio_r_eval("connect",connect(sockfd,serv_addr,addrlen));
}

