
/* tnetio_socket.c - å饤֥ */

/* $Id: tnetio_sockopt.c,v 1.1 2003/05/19 05:37:49 tosihisa Exp $ */

#include <stdio.h>
#include <string.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/socket.h>

#include "tnetio.h"

int tnetio_drop_ip_options(int fd)
{
	struct _local_vars {
		unsigned char optbuf[1024];
		unsigned char *optptr;
		int optsize;
		char logbuf[1024];
		int logbuf_remain;
	} INIT_LOCAL(l);


	/* ⤷꤬ IP_OPTIONS ꤷƤʤ顢λݥ˵Ͽ */

	l.optsize = sizeof(l.optbuf);
	if(getsockopt(fd,IPPROTO_IP,IP_OPTIONS,(char *)l.optbuf,&l.optsize) == 0)
	{
		if(l.optsize > 0)
		{
			/* ϡIP_OPTIONS ͭˤƤ롣λΥǡ˻Ĥ*/

			l.logbuf[0] = (char)('\0');
			l.logbuf_remain = sizeof(l.logbuf) - strlen(l.logbuf) - 1;

			l.optptr = l.optbuf;
			for(;l.optsize > 1;l.optsize--,l.optptr++)
			{
				snprintf(l.logbuf + strlen(l.logbuf),l.logbuf_remain,"%02X:",*l.optptr);
				l.logbuf_remain = sizeof(l.logbuf) - strlen(l.logbuf) - 1;
				if(l.logbuf_remain <= 20)
					break;	/* ǰΤ */
			}
			snprintf(l.logbuf + strlen(l.logbuf),l.logbuf_remain,"%02X",*l.optptr);	/* Ǹ */

			tnetio_log_write(" WARNING : IP_OPTION : [%s]\n",l.logbuf);	/* ؽ񤭽Ф */
		}
	}

	/* IP_OPTIONS ̵ѤȤIP 롼ƥ󥰤̵ˤʤ(Ϥ) */
	return setsockopt(fd,IPPROTO_IP,IP_OPTIONS,NULL,0);
}

int tnetio_set_tcp_nodelay(int fd)
{
	int optval = 1;


	return setsockopt(fd,IPPROTO_TCP,1 /* TCP_NODELAY */,&optval,sizeof(optval));
}

int tnetio_set_keepalive(int fd)
{
	int optval = 1;


	return setsockopt(fd,SOL_SOCKET,SO_KEEPALIVE,&optval,sizeof(optval));
}

int tnetio_set_linger(int fd,int t_tim)
{
	struct linger st_linger;


	/* ̤ѥåȤ֤ǡҥץƥλ
	   (close())ϡꤵ줿Ԥä close() 褦˻Ÿ롣  */
	st_linger.l_onoff = 1;
	st_linger.l_linger = t_tim;	/* Linux  man setsockopt ˤȡ 1/100  ñ̤餷 */
	return setsockopt(fd,SOL_SOCKET,SO_LINGER,&(st_linger),sizeof(st_linger));
}

int tnetio_set_reuse(int fd)
{
	int optval = 1;

	return setsockopt(fd,SOL_SOCKET,SO_REUSEADDR,&optval,sizeof(optval));
}

