
/* tnetsrv - TCP/IP Хץ */

/* tnetsrv [options] port-num program [program-arg(s)] */

/* $Id: tnetsrv.c,v 1.6 2003/05/20 09:59:57 tosihisa Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <sys/time.h>

#include <signal.h>

#include <sys/wait.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>

#include <time.h>

#include <errno.h>

#include <sys/stat.h>
#include <fcntl.h>

#include "tnetio.h"

static const char *log_msg[] = {
	/*      ɤʡ  ܤ */
	" accept  : %s (%s) : (%d/%d)\n",
	" refused : %s (%s) : (%d/%d)\n",
	" closed  : %d (0x%08X) : (%d/%d)\n",
	" wait    : : (%d/%d)\n",
	" bind    : %s %d %s : %s\n",
	" signal  : %d : (%d/%d)\n",
	NULL,
	" ERROR   : exec(%s) : [%s]\n",
	" ERROR   : fork() : [%s]\n",
	" ABORT   : dynamic-link (%s) : [%s]\n",
	NULL
};

#define	LOG_MSG_ACCEPT	0
#define	LOG_MSG_REFUSED	1
#define	LOG_MSG_CLOSED	2
#define	LOG_MSG_WAIT	3
#define	LOG_MSG_BIND	4
#define	LOG_MSG_SIGNAL	5
#define	LOG_MSG_W_IPOPT	6
#define	LOG_MSG_E_EXEC	7
#define	LOG_MSG_E_FORK	8
#define	LOG_MSG_E_DLOAD	9

struct _client_info {	/* 饤(ҥץ) */
	struct sockaddr_in addr;
	int len;
	char *hostname;
};

struct _server_info {
	struct sockaddr_in addr;
	int type;
};

struct _total_info {
	int now_connect;		/* ߤƱ³ϿƤ */
	int all_connect;		/* ³(reject ޤ)     */
	int max_connect;		/* ³߷(reject ޤ) */
	int overflow;			/* ³¤ۤäˣ */
};

struct _global_vars {	/* Хѿ */
	int progrun;				/* 0:ϽλʤФʤʤ0:Ϸ³ */
	struct _total_info total;		/* ߷׾ */
	struct _server_info server;		/* о */
	struct _client_info client;		/* ľ³饤Ⱦ */
	int (*tnetio_run)(int,int,int,char **);	/* ͥΩ³ĤƤνؿ */
	void *dl_handler;			/* ͭ饤֥ɤ߹ߥϥɥ */
} G;

#define	PROTO_TCP	0
#define	PROTO_UDP	1

struct _proto_tbl {
	const char *name;
	int type;
};

const struct _proto_tbl G_proto_tbl[3] =
{
	{ "tcp",SOCK_STREAM },
	{ "udp",SOCK_DGRAM  },
	{ NULL , 0 }
};

struct _param_vars {			/* Хѿ(ѥ᡼)¤ */
	int max_connect;
	char *bind_addr;
	int hostnamelookup;
	char *port;
	int  proto_num;
	char *env_prefix;
	int tcp_nodelay;
	int keepalive;
	int chg_uid;
	int chg_gid;
	int dl_flag;
	char *reject_file;
	char *status_file;
	int wrap_flag;
	char *wrap_name;
} P;

const struct _param_vars P_init = {	/* Хѿ(ѥ᡼) */
	25,		/* max_connect */
	"0.0.0.0",	/* bind_addr */
	0,		/* hostnamelookup */
	NULL,		/* port */
	PROTO_TCP,	/* proto_num */
	"NETSRV_",	/* env_prefix */
	0,		/* tcp_nodelay */
	0,		/* keepalive */
	-1,		/* chg_uid */
	-1,		/* chg_gid */
	0,		/* dl_flag */
	NULL,		/* reject_file */
	NULL,		/* status_file */
	0,		/* wrap_flag */
	"netsrv"	/* wrap_name */
};

static void signal_handler(int signum)
{
	tnetio_log_write(log_msg[LOG_MSG_SIGNAL],signum,G.total.now_connect,P.max_connect);
	G.progrun = 0;
}

static void signal_alarm(int signum)
{
	/* ä˲⤷ޤ */
}

static void signal_child(int signum)
{
	pid_t child_pid = 0;
	int status = 0;

	while((child_pid = waitpid(-1,&status,WNOHANG)) > 0)
	{
		G.total.now_connect--;

		tnetio_log_write(log_msg[LOG_MSG_CLOSED],child_pid,status,G.total.now_connect,P.max_connect);
	}
}

static void signal_wait(void)
{
	sigset_t sig_set;


	/* ʥ뽸ˤ롣פˡä˥ޥΤ̵ȸǤ */
	sigemptyset(&sig_set);

	/* ʥ뤬ǤޤԤޤ
	   ޥƤޤ󤫤顢餫Υʥ뤬
	   Ǥ饵ڥɤϲޤ           */
	sigsuspend(&sig_set);
}

static int signal_block(int signum)
{
	sigset_t sig_set;


	/* ʥ뽸ˤ롣פˡä˥ޥΤ̵ȸǤ */
	sigemptyset(&sig_set);

	/* ꤵ줿ʥä(ޥ) */
	sigaddset(&sig_set,signum);

	/* ꤵ줿ʥԤäƤ餦(֥å) */
	return sigprocmask(SIG_BLOCK,&sig_set,NULL);
}

static int signal_unblock(int signum)
{
	sigset_t sig_set;


	/* ʥ뽸ˤ롣פˡä˥ޥΤ̵ȸǤ */
	sigemptyset(&sig_set);

	/* ꤵ줿ʥä(ޥ) */
	sigaddset(&sig_set,signum);

	/* ꤵ줿ʥȯޤ(֥åޤ) */
	return sigprocmask(SIG_UNBLOCK,&sig_set,NULL);
}

static void set_signals(void)
{
	signal(SIGINT,signal_handler);
	signal(SIGTERM,signal_handler);
	signal(SIGALRM,signal_alarm);
	signal(SIGCHLD,signal_child);
}

/* set_signals() ǥåȤʥϡƤδؿǸ᤹ */
static void default_signals(void)
{
	signal(SIGINT,SIG_DFL);
	signal(SIGTERM,SIG_DFL);
	signal(SIGALRM,SIG_DFL);
	signal(SIGCHLD,SIG_DFL);
}

static int wait_new_connect(int fd,struct sockaddr *addr, socklen_t *addrlen)
{
	struct _local_vars {
		fd_set rfds;
		struct timeval tv;
		int newfd;
	} INIT_LOCAL(l);


	l.newfd = -1;

	while(G.progrun)
	{
		if( G.total.now_connect >= P.max_connect )
		{
			/* ³ޤãƤʤԤޤ */
			/* ͽۤ륷ʥϡ
			   (1) SIGTERM (G.progrun = 0)
			   (2) SIGINT  (G.progrun = 0)
			   (3) SIGCHLD (G.total.now_connect--)
			   (4) SIGALARM (1÷в)
			   ΥʥǤ                       */
			G.total.overflow = 1;	/* Сեȯ */
			alarm(1);	/* ॢ */
			signal_wait();	/* ʥԤ */
		}
		else
		{
			/* ³ãƤʤʤ顢ϤԤޤ */
			FD_ZERO(&(l.rfds));
			FD_SET(fd, &(l.rfds));
			l.tv.tv_sec = 1;	/* ॢ */
			l.tv.tv_usec = 0;

			if(select(fd + 1, &(l.rfds), NULL, NULL, &(l.tv) ) > 0)
			{
				if(FD_ISSET(fd, &(l.rfds)))
				{
					if((l.newfd = tnetio_accept(fd,addr,addrlen)) >= 0)
						break;	/* ǽλ */
					else
						G.progrun = 0;	/* ̿Ū꤬롣ץλ */
				}
			}
		}
	}

	return l.newfd;
}

static int logging_connect(int acs)
{
	char *fmt = NULL;


	fmt = (char *)log_msg[LOG_MSG_REFUSED];
	if(acs)
		fmt = (char *)log_msg[LOG_MSG_ACCEPT];

	tnetio_log_write(fmt,inet_ntoa(G.client.addr.sin_addr),G.client.hostname,G.total.now_connect,P.max_connect);

	return acs;
}

static int setup_client_info(int fd,struct _client_info *pst_client)
{
	struct hostent *client_ent = NULL;


	memset(pst_client,0x00,sizeof(struct _client_info));
	pst_client->len = sizeof(pst_client->addr);

	pst_client->hostname = "";

	if(tnetio_getpeername(fd,(struct sockaddr *)&(pst_client->addr),&(pst_client->len)) >= 0)
	{
		if(P.hostnamelookup)
		{
			pst_client->hostname = "UNKNOWN";
			client_ent = gethostbyaddr(&(pst_client->addr.sin_addr),4,AF_INET);
			if(client_ent != NULL)
			{
				pst_client->hostname = client_ent->h_name;
			}
		}
	}

	return 0;
}

static void tnetio_set_uidgid(int i_uid,int i_gid)
{
	if(i_gid >= 0)
		setgid(i_gid);

	if(i_uid >= 0)
		setuid(i_uid);
}

static int tnetio_set_my_env(void)
{
	char env_name[1024];
	char env_val[1024];

	snprintf(env_name,sizeof(env_name)-1,"%sPROTO",P.env_prefix);
	snprintf(env_val ,sizeof(env_val)-1 ,"%s",G_proto_tbl[P.proto_num].name);
	setenv(env_name,env_val,1);

	snprintf(env_name,sizeof(env_name)-1,"%sLOCALIP",P.env_prefix);
	snprintf(env_val ,sizeof(env_val)-1 ,"%s",inet_ntoa(G.server.addr.sin_addr));
	setenv(env_name,env_val,1);

	snprintf(env_name,sizeof(env_name)-1,"%sLOCALPORT",P.env_prefix);
	snprintf(env_val ,sizeof(env_val)-1 ,"%d",ntohs(G.server.addr.sin_port));
	setenv(env_name,env_val,1);

	/* ʲδĶѿϡTCP Լλ */
	if(P.proto_num == PROTO_TCP)
	{
		snprintf(env_name,sizeof(env_name)-1,"%sREMOTEIP",P.env_prefix);
		snprintf(env_val ,sizeof(env_val)-1 ,"%s",inet_ntoa(G.client.addr.sin_addr));
		setenv(env_name,env_val,1);

		snprintf(env_name,sizeof(env_name)-1,"%sREMOTEPORT",P.env_prefix);
		snprintf(env_val ,sizeof(env_val)-1 ,"%d",ntohs(G.client.addr.sin_port));
		setenv(env_name,env_val,1);

		if(G.client.hostname != NULL)
		{
			snprintf(env_name,sizeof(env_name)-1,"%sREMOTEHOST",P.env_prefix);
			snprintf(env_val ,sizeof(env_val)-1 ,"%s",G.client.hostname);
			setenv(env_name,env_val,1);
		}
	}

	return 0;
}

static int calc_argv(char **run_child_name)
{
	int i;

	for(i = 0;*(run_child_name + i) != NULL;i++);

	return i;
}

static void fork_child(int srvfd,int newfd,char **run_child_name)
{
	int i_retval = EXIT_REFUSED;


	close(srvfd);	/* ΥåȤĤޤ */

	default_signals();	/* ʥϰöᤷޤ */

	/* IP_OPTIONS ϡ̵Ȥ롣
	   ꤬ IP 롼ƥ󥰺ΤԤäƤǽ뤫*/
	tnetio_drop_ip_options(newfd);

	/* 饤Ⱦμ(ȴĶѿ) */
	setup_client_info(newfd,&(G.client));

	/* tnetio_test_client_connect() ƤӽФꤵ줿 IP ³ľ֤Ĵ٤ */

	/* ꤵ줿 IP ɥ쥹³϶ؤƤ(Ȳꤹ) */
	i_retval = EXIT_REFUSED;

	if(logging_connect(tnetio_test_client_connect(P.reject_file,P.wrap_flag,P.wrap_name,newfd)))
	{
		/* ꤵ줿 IP ɥ쥹³ϵĤƤޤ */
		/* åȤγƼ */
		if(P.tcp_nodelay)
			tnetio_set_tcp_nodelay(newfd);

		if(P.keepalive)
			tnetio_set_keepalive(newfd);

		tnetio_set_linger(newfd,60*100);

		/* ³δĶѿ */
		tnetio_set_my_env();

		/* ؿƤӽФޤ */
		i_retval = (*G.tnetio_run)(newfd,newfd,calc_argv(run_child_name),run_child_name);
	}

	close(newfd);	/* åȤƤʤĤޤ */

	exit(i_retval);	/* ǽޤ*/
}

static int parse_args(int argc,char *argv[])
{
	struct _local_vars {
		int c;
		int log_fd;
	} INIT_LOCAL(l);

	do {

		l.c = getopt(argc,argv,"b:D:E:lM:NSUW:X:u:g:ka:svP:");

		if(l.c != EOF)
		{
			switch(l.c)
			{
				case 'b':	/* bind  IP ɥ쥹ꤹ */
					P.bind_addr = optarg;
					break;
				case 'D':	/* ɸϤ˥񤭽Фˡդղäʤ*/
					tnetio_log_date(0);
					break;
				case 'E':	/* ץ¹ԻꤹĶѿƬ optarg ˤ(TCPΤͭ) */
					P.env_prefix = optarg;
					break;
				case 'l':	/* ³줿 IP ɥ쥹顢ۥ̾θԤ(TCPΤͭ) */
					P.hostnamelookup = 1;
					break;
				case 'M':	/* Ʊ³(TCPΤͭ) */
					P.max_connect = atoi(optarg);
					if(P.max_connect <= 0)
						P.max_connect = 1;
					break;
				case 'N':	/* TCP_NODELAY ͭˤ(TCPΤͭ) */
					P.tcp_nodelay = 1;
					break;
				case 'S':	/* ǡ syslog ˽񤭹 */
					tnetio_log_open();	/* System log open */
					break;
				case 'U':	/* UDP Ԥ */
					P.proto_num = PROTO_UDP;
					break;
				case 'W':	/* tcpwrapper(libwrap) εǽѤ롣ǡץ̾ optarg ˤ(TCPΤͭ) */
					if(tnetio_libwrap_use())
					{
						/* TCP Wrapper 饤֥꤬ѤǤ */
						P.wrap_flag = 1;
						P.wrap_name = optarg;
					}
					break;
				case 'X':	/* ͥΩoptarg Ǽե뤬ɤ߽Фǽ¸ߤƤϤǤ(TCPΤͭ) */
					P.reject_file = optarg;
					break;
				case 'u':	/* ꤷ桼IDڤؤư */
					P.chg_uid = atoi(optarg);
					break;
				case 'g':	/* ꤷ롼IDڤؤư */
					P.chg_gid = atoi(optarg);
					break;
				case 'k':	/* KEEPALIVE ͭˤ(TCPΤͭ) */
					P.keepalive = 1;
					break;
				case 'a':	/* ϤɸϤǤϤʤoptarg եɲä */
					l.log_fd = open(optarg,(O_CREAT | O_APPEND),(S_IRUSR | S_IWUSR | S_IRGRP | S_IWGRP | S_IROTH));
					if(l.log_fd < 0)
					{
						tnetio_log_write(" ABORT : log-file : %s\n",strerror(errno));
						exit(EXIT_EPERM);
					}
					dup2(l.log_fd,1);	/* ɸϤϡƤΥե˸ */
					close(l.log_fd);
					break;
				case 's':	/* Ϳץ̾ϡץ̾ǤϤʤͭ饤֥ */
					if(!tnetio_dluse())
					{
						exit(EXIT_EPERM); /* ͭ饤֥굡ǽϻѤǤޤ */
					}
					P.dl_flag = 1;
					break;
				case 'v':	/* Сϸ塢exit(0) */
					tnetio_log_pid(0);
					tnetio_log_date(0);
					tnetio_log_write("%s : Version %x.%02x (BUILD DATE:%s %s)\n",
						argv[0],
						(unsigned)(TNETIO_VERSION >> 8),
						(unsigned)(TNETIO_VERSION & 0x00ff),
						__DATE__,
						__TIME__);
					exit(0);
					break;
				case 'P':	/* ơեˡ߾񤭹褦ˤ(TCPΤͭ) */
					P.status_file = optarg;
					break;
				default:
					exit(EXIT_EPERM);
					break;
			}
		}

	} while (l.c != EOF);

	return optind;
}

static void *tnetio_dynamic_load(char *libname)
{
	void *ptr_retval;


	/* ɸǼ¹Ԥؿؿ */
	ptr_retval = tnetio_run_default;

	if(P.dl_flag)
	{
		ptr_retval = NULL;
		if( (G.dl_handler = tnetio_dlopen(libname)) != NULL)
		{
			ptr_retval = tnetio_dlsym(G.dl_handler,"tnetio_run");
		}
	}

	if(ptr_retval == NULL)
	{
		tnetio_log_write(log_msg[LOG_MSG_E_DLOAD],libname,tnetio_dlerror());
	}

	return ptr_retval;
}

static void tnetio_dynamic_unload(void)
{
	if(G.dl_handler != NULL)
		tnetio_dlclose(G.dl_handler);
}

static pid_t count_new_connect(pid_t c_pid)
{
	switch(c_pid)
	{
		case 0:		/* ҥץξ */
			/* ҥץ¦ϡҥץƤʤΤǡ
			   G.total.now_connect ͤϡ˽롣                */
			G.total.now_connect++;	/* ҥץܣ */
			break;
		case -1:	/* ʬȤνѤ˼ԤߤǤ㥯餬­ʤäʡ */
			tnetio_log_write(log_msg[LOG_MSG_E_FORK],strerror(errno));
			break;
		default:	/* ƥץξ */
			/* 衢ҥץοѲ(G.total.now_connect ͤѤ)
			   ΤǡSIGCHLD ʥ뤬ȯȡG.total.now_connect ζ礬롣 
			   򿩤ߤ뤿ˡSIGCHLD ʥȯϡԤäƤ餦 */
			if(signal_block(SIGCHLD) == 0)
			{
				/*  ϡSIGCLHD γߤʤϤ  */

				G.total.now_connect++;	/* ҥץܣ */

				/* SIGCHLD ʥĤޤ */
				signal_unblock(SIGCHLD);
				/*  ϡSIGCHLD γߤݥݥǤϤ  */
			}

			/* ³߷פη׻ */
			G.total.all_connect++;		/* ³סܣ */
			if(G.total.now_connect > G.total.max_connect)
				G.total.max_connect = G.total.now_connect;	/* Ʊ³߷סܣ */

			break;
	}

	return c_pid;
}

static int job_tcp(int sockfd,char **run_child_name)
{
	int newsockfd = -1;
	int i_retval = EXIT_BINDERR;


	/* åȥ塼 */
	if(tnetio_listen(sockfd,5) >= 0)
	{
		/* λ */

		i_retval = EXIT_NORMAL;

		/* ᥤ롼 */
		while((newsockfd = wait_new_connect(sockfd,NULL,NULL)) >= 0)
		{
			/* 줫Ĥʤޤ*/

			/* ץʣ(fork())³򥫥Ȥ */
			if(count_new_connect(fork()) == 0)
			{
				/* ҥץξ硢ҥץν */
				fork_child(sockfd,newsockfd,run_child_name);
			}

			close(newsockfd);
			newsockfd = -1;
		}
	}

	return i_retval;
}

static int job_udp(int sockfd,char **run_child_name)
{
	int i_retval = 0;

	/* UDP Լξ硢TCP ¦ǹԤۤȤɤΥӥѤǤʤ*/

	default_signals();	/* ʥϰöᤷޤ */

	/* ³δĶѿ */
	tnetio_set_my_env();

	while(i_retval >= 0)
	{
		/* ؿ򤤤ʤƤӽФޤ֤ʤСλޤ */
		i_retval = (*G.tnetio_run)(sockfd,sockfd,calc_argv(run_child_name),run_child_name);
	}

	return i_retval;
}

static int job_main(int sockfd,char **run_child_name)
{
	int i_retval = 0;


	if(P.proto_num == PROTO_TCP)
		i_retval = job_tcp(sockfd,run_child_name);
	else
		i_retval = job_udp(sockfd,run_child_name);

	return i_retval;
}

static int init_param(char *myname)
{
	/* Хѿ(ѥ᡼)ν */
	memcpy(&P,&P_init,sizeof(P));

	/* طν */
	tnetio_log_init(myname);

	return 0;
}

int main(int argc,char *argv[])
{
	struct _local_vars {
		int start_arg;
		char **run_child_name;
		int sockfd;
		int i_retval;
	} INIT_LOCAL(l);

	/* Хѿν */
	memset(&G,0x00,sizeof(G));
	G.progrun  = 1;

	/* ѥ᡼ѿν */
	init_param(argv[0]);

	/* ץβ */
	l.start_arg = parse_args(argc,argv);

	if(l.start_arg < argc)
	{
		P.port = argv[l.start_arg];
		l.start_arg++;
	}

	/* λǡbind  IPݡֹ桢ץȥ뤬Ƥ
	   Τǡbind 뤿ξ󤬹ۤǤ뤫Ĵ٤롣                */
	switch(tnetio_sockaddr_in_byname(P.hostnamelookup,P.bind_addr,P.port,(char *)(G_proto_tbl[P.proto_num].name),&(G.server.addr)))
	{
		case 0:		/*  */
			G.server.type = G_proto_tbl[P.proto_num].type;
			break;
		case -1:	/* bind ۥ̾ */
			tnetio_log_write(" ABORT : Invalid bind-addr %s\n",
				(P.bind_addr != NULL) ? P.bind_addr : "(none)"
				);
			return EXIT_EPERM;
			break;
		case -2:	/* bind ݡֹ椬 */
			tnetio_log_write(" ABORT : Invalid bind-port %s\n",
				(P.port != NULL) ? P.port : "(none)"
				);
			return EXIT_EPERM;
			break;
		default:	/* ???? */
			return EXIT_EPERM;
			break;
	}

	/* ¹Ԥҥץξ */

	if(l.start_arg < argc)
	{
		l.run_child_name = &(argv[l.start_arg]);
		l.start_arg++;
	}

	if( (l.run_child_name == NULL ) || (strlen(*(l.run_child_name + 0)) <= 0) )
	{
		tnetio_log_write(" ABORT : no child-program\n");
		return EXIT_EPERM;
	}

	set_signals();

	l.i_retval = EXIT_BINDERR;

	/* åȤ򳫤 */
	if((l.sockfd = tnetio_socket(G.server.addr.sin_family,G.server.type,0)) >= 0)
	{
		tnetio_set_reuse(l.sockfd);	/* 륢ɥ쥹κѤǽˤƤޤ */

		/* åȤ bind  */
		if(tnetio_bind(l.sockfd,(struct sockaddr *)&(G.server.addr),sizeof(G.server.addr)) >= 0)
		{
			/* bind 褿顢桼 ID ȡ롼 ID ڤؤ롣ʹߤưϡʲθ¤ǹԤ */
			tnetio_set_uidgid(P.chg_uid,P.chg_gid);

			/* ꤵ줿ץ̾¤϶ͭ饤֥Ǥ硢ɤԤ */
			l.i_retval = EXIT_SOLOAD;
			if( (G.tnetio_run = tnetio_dynamic_load(*(l.run_child_name + 0))) != NULL )
			{
				/* ä */
				tnetio_log_write(log_msg[LOG_MSG_BIND],
					inet_ntoa(G.server.addr.sin_addr),
					ntohs(G.server.addr.sin_port),
					G_proto_tbl[P.proto_num].name,
					*(l.run_child_name + 0));

				tnetio_log_write(log_msg[LOG_MSG_WAIT],G.total.now_connect,P.max_connect);

				l.i_retval = job_main(l.sockfd,l.run_child_name);

			}

			tnetio_dynamic_unload();
		}

		close(l.sockfd);
		l.sockfd = -1;
	}

	tnetio_log_close();

	return l.i_retval;
}

