/* File: tables.c */

/* Purpose: Angband Tables */

/*
 * Copyright (c) 1989 James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research, and
 * not for profit purposes provided that this copyright and statement are
 * included in all such copies.
 */

#include "angband.h"




/*
 * Global array for looping through the "keypad directions"
 */
s16b ddd[9] =
{ 2, 8, 6, 4, 3, 1, 9, 7, 5 };

/*
 * Global arrays for converting "keypad direction" into offsets
 */
s16b ddx[10] =
{ 0, -1, 0, 1, -1, 0, 1, -1, 0, 1 };

s16b ddy[10] =
{ 0, 1, 1, 1, 0, 0, 0, -1, -1, -1 };

/*
 * Global arrays for optimizing "ddx[ddd[i]]" and "ddy[ddd[i]]"
 */
s16b ddx_ddd[9] =
{ 0, 0, 1, -1, 1, -1, 1, -1, 0 };

s16b ddy_ddd[9] =
{ 1, -1, 0, 0, 1, 1, -1, -1, 0 };


/*
 * Circular keypad direction array
 */
s16b cdd[8] =
{ 2, 3, 6, 9, 8, 7, 4, 1 };

/*
 * Global arrays for optimizing "ddx[cdd[i]]" and "ddy[cdd[i]]"
 */
s16b ddx_cdd[8] =
{ 0, 1, 1, 1, 0, -1, -1, -1 };

s16b ddy_cdd[8] =
{ 1, 1, 0, -1, -1, -1, 0, 1 };



/*
 * Global array for converting numbers to uppercase hecidecimal digit
 * This array can also be used to convert a number to an octal digit
 */
char hexsym[16] =
{
	'0', '1', '2', '3', '4', '5', '6', '7',
	'8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
};


/*
 * Global array for converting numbers to a logical list symbol
 */
char listsym[] =
{
	'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
	'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
	'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
	'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M',
	'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
	'\0'
};


/*
 * Encode the screen colors
 */
cptr color_char = "dwsorgbuDWvyRGBU";


/*
 * Stat Table (INT/WIS) -- Number of half-spells per level
 */
byte adj_mag_study[] =
{
	0	/* 3 */,
	0	/* 4 */,
	0	/* 5 */,
	0	/* 6 */,
	0	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	2	/* 12 */,
	2	/* 13 */,
	2	/* 14 */,
	2	/* 15 */,
	2	/* 16 */,
	2	/* 17 */,
	2	/* 18/00-18/09 */,
	2	/* 18/10-18/19 */,
	2	/* 18/20-18/29 */,
	2	/* 18/30-18/39 */,
	2	/* 18/40-18/49 */,
	3	/* 18/50-18/59 */,
	3	/* 18/60-18/69 */,
	3	/* 18/70-18/79 */,
	3	/* 18/80-18/89 */,
	4	/* 18/90-18/99 */,
	4	/* 18/100-18/109 */,
	4	/* 18/110-18/119 */,
	5	/* 18/120-18/129 */,
	5	/* 18/130-18/139 */,
	5	/* 18/140-18/149 */,
	5	/* 18/150-18/159 */,
	5	/* 18/160-18/169 */,
	5	/* 18/170-18/179 */,
	5	/* 18/180-18/189 */,
	5	/* 18/190-18/199 */,
	5	/* 18/200-18/209 */,
	6	/* 18/210-18/219 */,
	6	/* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- extra 1/4-mana-points per level (plus 128)
 */
byte adj_mag_mana[] =
{
	128 + -8	/* 3 */,
	128 + -6	/* 4 */,
	128 + -4	/* 5 */,
	128 + -2	/* 6 */,
	128 + -1	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 1	/* 14 */,
	128 + 1	/* 15 */,
	128 + 2	/* 16 */,
	128 + 3	/* 17 */,
	128 + 4	/* 18/00-18/09 */,
	128 + 5	/* 18/10-18/19 */,
	128 + 6	/* 18/20-18/29 */,
	128 + 7	/* 18/30-18/39 */,
	128 + 8	/* 18/40-18/49 */,
	128 + 9	/* 18/50-18/59 */,
	128 + 10	/* 18/60-18/69 */,
	128 + 11	/* 18/70-18/79 */,
	128 + 12	/* 18/80-18/89 */,
	128 + 13	/* 18/90-18/99 */,
	128 + 14	/* 18/100-18/109 */,
	128 + 15	/* 18/110-18/119 */,
	128 + 16	/* 18/120-18/129 */,
	128 + 17	/* 18/130-18/139 */,
	128 + 18	/* 18/140-18/149 */,
	128 + 19	/* 18/150-18/159 */,
	128 + 20	/* 18/160-18/169 */,
	128 + 21	/* 18/170-18/179 */,
	128 + 22	/* 18/180-18/189 */,
	128 + 23	/* 18/190-18/199 */,
	128 + 24	/* 18/200-18/209 */,
	128 + 25	/* 18/210-18/219 */,
	128 + 26	/* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- Minimum failure rate (percentage)
 */
byte adj_mag_fail[] =
{
	99      /* 3 */,
	99      /* 4 */,
	99      /* 5 */,
	99      /* 6 */,
	99      /* 7 */,
	50      /* 8 */,
	30      /* 9 */,
	20      /* 10 */,
	15      /* 11 */,
	12      /* 12 */,
	11      /* 13 */,
	10      /* 14 */,
	9       /* 15 */,
	8       /* 16 */,
	7       /* 17 */,
	6       /* 18/00-18/09 */,
	6       /* 18/10-18/19 */,
	5       /* 18/20-18/29 */,
	5       /* 18/30-18/39 */,
	5       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	4       /* 18/60-18/69 */,
	4       /* 18/70-18/79 */,
	4       /* 18/80-18/89 */,
	3       /* 18/90-18/99 */,
	3       /* 18/100-18/109 */,
	2       /* 18/110-18/119 */,
	2       /* 18/120-18/129 */,
	2       /* 18/130-18/139 */,
	2       /* 18/140-18/149 */,
	1       /* 18/150-18/159 */,
	1       /* 18/160-18/169 */,
	1       /* 18/170-18/179 */,
	1       /* 18/180-18/189 */,
	1       /* 18/190-18/199 */,
	0       /* 18/200-18/209 */,
	0       /* 18/210-18/219 */,
	0       /* 18/220+ */
};


/*
 * Stat Table (INT/WIS) -- Various things
 */
byte adj_mag_stat[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	3       /* 18/30-18/39 */,
	3       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	4       /* 18/60-18/69 */,
	5       /* 18/70-18/79 */,
	6       /* 18/80-18/89 */,
	7       /* 18/90-18/99 */,
	8       /* 18/100-18/109 */,
	9       /* 18/110-18/119 */,
	10      /* 18/120-18/129 */,
	11      /* 18/130-18/139 */,
	12      /* 18/140-18/149 */,
	13      /* 18/150-18/159 */,
	14      /* 18/160-18/169 */,
	15      /* 18/170-18/179 */,
	16      /* 18/180-18/189 */,
	17      /* 18/190-18/199 */,
	18      /* 18/200-18/209 */,
	19      /* 18/210-18/219 */,
	20      /* 18/220+ */
};


/*
 * Stat Table (CHR) -- payment percentages
 */
byte adj_chr_gold[] =
{
	130     /* 3 */,
	125     /* 4 */,
	122     /* 5 */,
	120     /* 6 */,
	118     /* 7 */,
	116     /* 8 */,
	114     /* 9 */,
	112     /* 10 */,
	110     /* 11 */,
	108     /* 12 */,
	106     /* 13 */,
	104     /* 14 */,
	103     /* 15 */,
	102     /* 16 */,
	101     /* 17 */,
	100     /* 18/00-18/09 */,
	99      /* 18/10-18/19 */,
	98      /* 18/20-18/29 */,
	97      /* 18/30-18/39 */,
	96      /* 18/40-18/49 */,
	95      /* 18/50-18/59 */,
	94      /* 18/60-18/69 */,
	93      /* 18/70-18/79 */,
	92      /* 18/80-18/89 */,
	91      /* 18/90-18/99 */,
	90      /* 18/100-18/109 */,
	89      /* 18/110-18/119 */,
	88      /* 18/120-18/129 */,
	87      /* 18/130-18/139 */,
	86      /* 18/140-18/149 */,
	85      /* 18/150-18/159 */,
	84      /* 18/160-18/169 */,
	83      /* 18/170-18/179 */,
	82      /* 18/180-18/189 */,
	81      /* 18/190-18/199 */,
	80      /* 18/200-18/209 */,
	79      /* 18/210-18/219 */,
	78      /* 18/220+ */
};


/*
 * Stat Table (INT) -- Magic devices
 */
byte adj_int_dev[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	4       /* 18/20-18/29 */,
	4       /* 18/30-18/39 */,
	5       /* 18/40-18/49 */,
	5       /* 18/50-18/59 */,
	6       /* 18/60-18/69 */,
	6       /* 18/70-18/79 */,
	7       /* 18/80-18/89 */,
	7       /* 18/90-18/99 */,
	8       /* 18/100-18/109 */,
	9       /* 18/110-18/119 */,
	10      /* 18/120-18/129 */,
	11      /* 18/130-18/139 */,
	12      /* 18/140-18/149 */,
	13      /* 18/150-18/159 */,
	14      /* 18/160-18/169 */,
	15      /* 18/170-18/179 */,
	16      /* 18/180-18/189 */,
	17      /* 18/190-18/199 */,
	18      /* 18/200-18/209 */,
	19      /* 18/210-18/219 */,
	20      /* 18/220+ */
};


/*
 * Stat Table (WIS) -- Saving throw
 */
byte adj_wis_sav[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	3       /* 18/30-18/39 */,
	3       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	4       /* 18/60-18/69 */,
	5       /* 18/70-18/79 */,
	5       /* 18/80-18/89 */,
	6       /* 18/90-18/99 */,
	7       /* 18/100-18/109 */,
	8       /* 18/110-18/119 */,
	9       /* 18/120-18/129 */,
	10      /* 18/130-18/139 */,
	11      /* 18/140-18/149 */,
	12      /* 18/150-18/159 */,
	13      /* 18/160-18/169 */,
	14      /* 18/170-18/179 */,
	15      /* 18/180-18/189 */,
	16      /* 18/190-18/199 */,
	17      /* 18/200-18/209 */,
	18      /* 18/210-18/219 */,
	19      /* 18/220+ */
};


/*
 * Stat Table (DEX) -- disarming
 */
byte adj_dex_dis[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	0       /* 8 */,
	0       /* 9 */,
	0       /* 10 */,
	0       /* 11 */,
	0       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	1       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	4       /* 18/00-18/09 */,
	4       /* 18/10-18/19 */,
	4       /* 18/20-18/29 */,
	4       /* 18/30-18/39 */,
	5       /* 18/40-18/49 */,
	5       /* 18/50-18/59 */,
	5       /* 18/60-18/69 */,
	6       /* 18/70-18/79 */,
	6       /* 18/80-18/89 */,
	7       /* 18/90-18/99 */,
	8       /* 18/100-18/109 */,
	8       /* 18/110-18/119 */,
	8       /* 18/120-18/129 */,
	8       /* 18/130-18/139 */,
	8       /* 18/140-18/149 */,
	9       /* 18/150-18/159 */,
	9       /* 18/160-18/169 */,
	9       /* 18/170-18/179 */,
	9       /* 18/180-18/189 */,
	9       /* 18/190-18/199 */,
	10      /* 18/200-18/209 */,
	10      /* 18/210-18/219 */,
	10      /* 18/220+ */
};


/*
 * Stat Table (INT) -- disarming
 */
byte adj_int_dis[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	1       /* 8 */,
	1       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	3       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	4       /* 18/30-18/39 */,
	4       /* 18/40-18/49 */,
	5       /* 18/50-18/59 */,
	6       /* 18/60-18/69 */,
	7       /* 18/70-18/79 */,
	8       /* 18/80-18/89 */,
	9       /* 18/90-18/99 */,
	10      /* 18/100-18/109 */,
	10      /* 18/110-18/119 */,
	11      /* 18/120-18/129 */,
	12      /* 18/130-18/139 */,
	13      /* 18/140-18/149 */,
	14      /* 18/150-18/159 */,
	15      /* 18/160-18/169 */,
	16      /* 18/170-18/179 */,
	17      /* 18/180-18/189 */,
	18      /* 18/190-18/199 */,
	19      /* 18/200-18/209 */,
	19      /* 18/210-18/219 */,
	20      /* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to ac (plus 128)
 */
byte adj_dex_ta[] =
{
	128 + -4    /*  3 */,
	128 + -3    /*  4 */,
	128 + -2    /*  5 */,
	128 + -1    /*  6 */,
	128 + 0     /*  7 */,
	128 + 0     /*  8 */,
	128 + 0     /*  9 */,
	128 + 0     /* 10 */,
	128 + 0     /* 11 */,
	128 + 0     /* 12 */,
	128 + 0     /* 13 */,
	128 + 0     /* 14 */,
	128 + 1     /* 15 */,
	128 + 1     /* 16 */,
	128 + 1     /* 17 */,
	128 + 2     /* 18/00-18/09 */,
	128 + 2     /* 18/10-18/19 */,
	128 + 2     /* 18/20-18/29 */,
	128 + 2     /* 18/30-18/39 */,
	128 + 2     /* 18/40-18/49 */,
	128 + 3     /* 18/50-18/59 */,
	128 + 3     /* 18/60-18/69 */,
	128 + 3     /* 18/70-18/79 */,
	128 + 4     /* 18/80-18/89 */,
	128 + 5     /* 18/90-18/99 */,
	128 + 6     /* 18/100-18/109 */,
	128 + 7     /* 18/110-18/119 */,
	128 + 8     /* 18/120-18/129 */,
	128 + 9     /* 18/130-18/139 */,
	128 + 9     /* 18/140-18/149 */,
	128 + 10    /* 18/150-18/159 */,
	128 + 11    /* 18/160-18/169 */,
	128 + 12    /* 18/170-18/179 */,
	128 + 13    /* 18/180-18/189 */,
	128 + 14    /* 18/190-18/199 */,
	128 + 15    /* 18/200-18/209 */,
	128 + 15    /* 18/210-18/219 */,
	128 + 16    /* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to dam (plus 128)
 */
byte adj_str_td[] =
{
	128 + -2    /*  3 */,
	128 + -2    /*  4 */,
	128 + -1    /*  5 */,
	128 + -1    /*  6 */,
	128 + 0     /*  7 */,
	128 + 0     /*  8 */,
	128 + 0     /*  9 */,
	128 + 0     /* 10 */,
	128 + 0     /* 11 */,
	128 + 0     /* 12 */,
	128 + 0     /* 13 */,
	128 + 0     /* 14 */,
	128 + 0     /* 15 */,
	128 + 1     /* 16 */,
	128 + 2     /* 17 */,
	128 + 2     /* 18/00-18/09 */,
	128 + 2     /* 18/10-18/19 */,
	128 + 3     /* 18/20-18/29 */,
	128 + 3     /* 18/30-18/39 */,
	128 + 3     /* 18/40-18/49 */,
	128 + 3     /* 18/50-18/59 */,
	128 + 3     /* 18/60-18/69 */,
	128 + 4     /* 18/70-18/79 */,
	128 + 5     /* 18/80-18/89 */,
	128 + 5     /* 18/90-18/99 */,
	128 + 6     /* 18/100-18/109 */,
	128 + 7     /* 18/110-18/119 */,
	128 + 8     /* 18/120-18/129 */,
	128 + 9     /* 18/130-18/139 */,
	128 + 10    /* 18/140-18/149 */,
	128 + 11    /* 18/150-18/159 */,
	128 + 12    /* 18/160-18/169 */,
	128 + 13    /* 18/170-18/179 */,
	128 + 14    /* 18/180-18/189 */,
	128 + 15    /* 18/190-18/199 */,
	128 + 16    /* 18/200-18/209 */,
	128 + 18    /* 18/210-18/219 */,
	128 + 20    /* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to hit (plus 128)
 */
byte adj_dex_th[] =
{
	128 + -3        /* 3 */,
	128 + -2        /* 4 */,
	128 + -2        /* 5 */,
	128 + -1        /* 6 */,
	128 + -1        /* 7 */,
	128 + 0 /* 8 */,
	128 + 0 /* 9 */,
	128 + 0 /* 10 */,
	128 + 0 /* 11 */,
	128 + 0 /* 12 */,
	128 + 0 /* 13 */,
	128 + 0 /* 14 */,
	128 + 0 /* 15 */,
	128 + 1 /* 16 */,
	128 + 2 /* 17 */,
	128 + 3 /* 18/00-18/09 */,
	128 + 3 /* 18/10-18/19 */,
	128 + 3 /* 18/20-18/29 */,
	128 + 3 /* 18/30-18/39 */,
	128 + 3 /* 18/40-18/49 */,
	128 + 4 /* 18/50-18/59 */,
	128 + 4 /* 18/60-18/69 */,
	128 + 4 /* 18/70-18/79 */,
	128 + 4 /* 18/80-18/89 */,
	128 + 5 /* 18/90-18/99 */,
	128 + 6 /* 18/100-18/109 */,
	128 + 7 /* 18/110-18/119 */,
	128 + 8 /* 18/120-18/129 */,
	128 + 9 /* 18/130-18/139 */,
	128 + 9 /* 18/140-18/149 */,
	128 + 10        /* 18/150-18/159 */,
	128 + 11        /* 18/160-18/169 */,
	128 + 12        /* 18/170-18/179 */,
	128 + 13        /* 18/180-18/189 */,
	128 + 14        /* 18/190-18/199 */,
	128 + 15        /* 18/200-18/209 */,
	128 + 15        /* 18/210-18/219 */,
	128 + 16        /* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to hit (plus 128)
 */
byte adj_str_th[] =
{
	128 + -3        /* 3 */,
	128 + -2        /* 4 */,
	128 + -1        /* 5 */,
	128 + -1        /* 6 */,
	128 + 0 /* 7 */,
	128 + 0 /* 8 */,
	128 + 0 /* 9 */,
	128 + 0 /* 10 */,
	128 + 0 /* 11 */,
	128 + 0 /* 12 */,
	128 + 0 /* 13 */,
	128 + 0 /* 14 */,
	128 + 0 /* 15 */,
	128 + 0 /* 16 */,
	128 + 0 /* 17 */,
	128 + 1 /* 18/00-18/09 */,
	128 + 1 /* 18/10-18/19 */,
	128 + 1 /* 18/20-18/29 */,
	128 + 1 /* 18/30-18/39 */,
	128 + 1 /* 18/40-18/49 */,
	128 + 1 /* 18/50-18/59 */,
	128 + 1 /* 18/60-18/69 */,
	128 + 2 /* 18/70-18/79 */,
	128 + 3 /* 18/80-18/89 */,
	128 + 4 /* 18/90-18/99 */,
	128 + 5 /* 18/100-18/109 */,
	128 + 6 /* 18/110-18/119 */,
	128 + 7 /* 18/120-18/129 */,
	128 + 8 /* 18/130-18/139 */,
	128 + 9 /* 18/140-18/149 */,
	128 + 10        /* 18/150-18/159 */,
	128 + 11        /* 18/160-18/169 */,
	128 + 12        /* 18/170-18/179 */,
	128 + 13        /* 18/180-18/189 */,
	128 + 14        /* 18/190-18/199 */,
	128 + 15        /* 18/200-18/209 */,
	128 + 15        /* 18/210-18/219 */,
	128 + 16        /* 18/220+ */
};


/*
 * Stat Table (STR) -- weight limit in deca-pounds
 */
byte adj_str_wgt[] =
{
	10      /* 3 */,
	11      /* 4 */,
	12      /* 5 */,
	13      /* 6 */,
	14      /* 7 */,
	15      /* 8 */,
	16      /* 9 */,
	17      /* 10 */,
	18      /* 11 */,
	19      /* 12 */,
	20      /* 13 */,
	21      /* 14 */,
	22      /* 15 */,
	23      /* 16 */,
	24      /* 17 */,
	25      /* 18/00-18/09 */,
	26      /* 18/10-18/19 */,
	27      /* 18/20-18/29 */,
	28      /* 18/30-18/39 */,
	29      /* 18/40-18/49 */,
	30      /* 18/50-18/59 */,
	31      /* 18/60-18/69 */,
	31      /* 18/70-18/79 */,
	32      /* 18/80-18/89 */,
	32      /* 18/90-18/99 */,
	33      /* 18/100-18/109 */,
	33      /* 18/110-18/119 */,
	34      /* 18/120-18/129 */,
	34      /* 18/130-18/139 */,
	35      /* 18/140-18/149 */,
	35      /* 18/150-18/159 */,
	36      /* 18/160-18/169 */,
	36      /* 18/170-18/179 */,
	37      /* 18/180-18/189 */,
	37      /* 18/190-18/199 */,
	38      /* 18/200-18/209 */,
	38      /* 18/210-18/219 */,
	39      /* 18/220+ */
};


/*
 * Stat Table (STR) -- weapon weight limit in pounds
 */
byte adj_str_hold[] =
{
	4       /* 3 */,
	5       /* 4 */,
	6       /* 5 */,
	7       /* 6 */,
	8       /* 7 */,
	9       /* 8 */,
	10      /* 9 */,
	11      /* 10 */,
	12      /* 11 */,
	13      /* 12 */,
	14      /* 13 */,
	15      /* 14 */,
	16      /* 15 */,
	17      /* 16 */,
	18      /* 17 */,
	19      /* 18/00-18/09 */,
	20      /* 18/10-18/19 */,
	21      /* 18/20-18/29 */,
	22      /* 18/30-18/39 */,
	23      /* 18/40-18/49 */,
	24      /* 18/50-18/59 */,
	25      /* 18/60-18/69 */,
	26      /* 18/70-18/79 */,
	27      /* 18/80-18/89 */,
	28      /* 18/90-18/99 */,
	30      /* 18/100-18/109 */,
	31      /* 18/110-18/119 */,
	32      /* 18/120-18/129 */,
	33      /* 18/130-18/139 */,
	34      /* 18/140-18/149 */,
	35      /* 18/150-18/159 */,
	37      /* 18/160-18/169 */,
	40      /* 18/170-18/179 */,
	44      /* 18/180-18/189 */,
	48      /* 18/190-18/199 */,
	50     /* 18/200-18/209 */,
	50     /* 18/210-18/219 */,
	50     /* 18/220+ */
};


/*
 * Stat Table (STR) -- digging value
 */
byte adj_str_dig[] =
{
	0       /* 3 */,
	0       /* 4 */,
	1       /* 5 */,
	2       /* 6 */,
	3       /* 7 */,
	4       /* 8 */,
	4       /* 9 */,
	5       /* 10 */,
	5       /* 11 */,
	6       /* 12 */,
	6       /* 13 */,
	7       /* 14 */,
	7       /* 15 */,
	8       /* 16 */,
	8       /* 17 */,
	9       /* 18/00-18/09 */,
	10      /* 18/10-18/19 */,
	12      /* 18/20-18/29 */,
	15      /* 18/30-18/39 */,
	20      /* 18/40-18/49 */,
	25      /* 18/50-18/59 */,
	30      /* 18/60-18/69 */,
	35      /* 18/70-18/79 */,
	40      /* 18/80-18/89 */,
	45      /* 18/90-18/99 */,
	50      /* 18/100-18/109 */,
	55      /* 18/110-18/119 */,
	60      /* 18/120-18/129 */,
	65      /* 18/130-18/139 */,
	70      /* 18/140-18/149 */,
	75      /* 18/150-18/159 */,
	80      /* 18/160-18/169 */,
	85      /* 18/170-18/179 */,
	90      /* 18/180-18/189 */,
	95      /* 18/190-18/199 */,
	100     /* 18/200-18/209 */,
	100     /* 18/210-18/219 */,
	100     /* 18/220+ */
};


/*
 * Stat Table (STR) -- help index into the "blow" table
 */
byte adj_str_blow[] =
{
	3       /* 3 */,
	4       /* 4 */,
	5       /* 5 */,
	6       /* 6 */,
	7       /* 7 */,
	8       /* 8 */,
	9       /* 9 */,
	10      /* 10 */,
	11      /* 11 */,
	12      /* 12 */,
	13      /* 13 */,
	14      /* 14 */,
	15      /* 15 */,
	16      /* 16 */,
	17      /* 17 */,
	20 /* 18/00-18/09 */,
	30 /* 18/10-18/19 */,
	40 /* 18/20-18/29 */,
	50 /* 18/30-18/39 */,
	60 /* 18/40-18/49 */,
	70 /* 18/50-18/59 */,
	80 /* 18/60-18/69 */,
	90 /* 18/70-18/79 */,
	100 /* 18/80-18/89 */,
	110 /* 18/90-18/99 */,
	120 /* 18/100-18/109 */,
	130 /* 18/110-18/119 */,
	140 /* 18/120-18/129 */,
	150 /* 18/130-18/139 */,
	160 /* 18/140-18/149 */,
	170 /* 18/150-18/159 */,
	180 /* 18/160-18/169 */,
	190 /* 18/170-18/179 */,
	200 /* 18/180-18/189 */,
	210 /* 18/190-18/199 */,
	220 /* 18/200-18/209 */,
	230 /* 18/210-18/219 */,
	240 /* 18/220+ */
};


/*
 * Stat Table (DEX) -- index into the "blow" table
 */
byte adj_dex_blow[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	0       /* 8 */,
	0       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	2       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	3       /* 18/30-18/39 */,
	4       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	5       /* 18/60-18/69 */,
	5       /* 18/70-18/79 */,
	6       /* 18/80-18/89 */,
	6       /* 18/90-18/99 */,
	7       /* 18/100-18/109 */,
	7       /* 18/110-18/119 */,
	8       /* 18/120-18/129 */,
	8       /* 18/130-18/139 */,
	9      /* 18/140-18/149 */,
	9      /* 18/150-18/159 */,
	10      /* 18/160-18/169 */,
	10      /* 18/170-18/179 */,
	11      /* 18/180-18/189 */,
	11      /* 18/190-18/199 */,
	12      /* 18/200-18/209 */,
	12      /* 18/210-18/219 */,
	13      /* 18/220+ */
};


/*
 * Stat Table (DEX) -- index into the "blow" table (bare hand)
 */
byte adj_dex_blow_bare_hand[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	0       /* 8 */,
	0       /* 9 */,
	1       /* 10 */,
	1       /* 11 */,
	1       /* 12 */,
	1       /* 13 */,
	1       /* 14 */,
	2       /* 15 */,
	2       /* 16 */,
	2       /* 17 */,
	2       /* 18/00-18/09 */,
	3       /* 18/10-18/19 */,
	3       /* 18/20-18/29 */,
	3       /* 18/30-18/39 */,
	4       /* 18/40-18/49 */,
	4       /* 18/50-18/59 */,
	6       /* 18/60-18/69 */,
	6       /* 18/70-18/79 */,
	8       /* 18/80-18/89 */,
	8       /* 18/90-18/99 */,
	10      /* 18/100-18/109 */,
	10      /* 18/110-18/119 */,
	14      /* 18/120-18/129 */,
	14      /* 18/130-18/139 */,
	18     /* 18/140-18/149 */,
	18     /* 18/150-18/159 */,
	24      /* 18/160-18/169 */,
	24      /* 18/170-18/179 */,
	30      /* 18/180-18/189 */,
	30      /* 18/190-18/199 */,
	36      /* 18/200-18/209 */,
	36      /* 18/210-18/219 */,
	42      /* 18/220+ */
};


/*
 * Stat Table (DEX) -- chance of avoiding "theft" and "falling"
 */
byte adj_dex_safe[] =
{
	0       /* 3 */,
	1       /* 4 */,
	2       /* 5 */,
	3       /* 6 */,
	4       /* 7 */,
	5       /* 8 */,
	5       /* 9 */,
	6       /* 10 */,
	6       /* 11 */,
	7       /* 12 */,
	7       /* 13 */,
	8       /* 14 */,
	8       /* 15 */,
	9       /* 16 */,
	9       /* 17 */,
	10      /* 18/00-18/09 */,
	10      /* 18/10-18/19 */,
	15      /* 18/20-18/29 */,
	15      /* 18/30-18/39 */,
	20      /* 18/40-18/49 */,
	25      /* 18/50-18/59 */,
	30      /* 18/60-18/69 */,
	35      /* 18/70-18/79 */,
	40      /* 18/80-18/89 */,
	45      /* 18/90-18/99 */,
	50      /* 18/100-18/109 */,
	60      /* 18/110-18/119 */,
	70      /* 18/120-18/129 */,
	80      /* 18/130-18/139 */,
	90      /* 18/140-18/149 */,
	100     /* 18/150-18/159 */,
	100     /* 18/160-18/169 */,
	100     /* 18/170-18/179 */,
	100     /* 18/180-18/189 */,
	100     /* 18/190-18/199 */,
	100     /* 18/200-18/209 */,
	100     /* 18/210-18/219 */,
	100     /* 18/220+ */
};


/*
 * Stat Table (CON) -- base regeneration rate
 */
byte adj_con_fix[] =
{
	0       /* 3 */,
	0       /* 4 */,
	0       /* 5 */,
	0       /* 6 */,
	0       /* 7 */,
	0       /* 8 */,
	0       /* 9 */,
	0       /* 10 */,
	0       /* 11 */,
	0       /* 12 */,
	0       /* 13 */,
	1       /* 14 */,
	1       /* 15 */,
	1       /* 16 */,
	1       /* 17 */,
	2       /* 18/00-18/09 */,
	2       /* 18/10-18/19 */,
	2       /* 18/20-18/29 */,
	2       /* 18/30-18/39 */,
	2       /* 18/40-18/49 */,
	3       /* 18/50-18/59 */,
	3       /* 18/60-18/69 */,
	3       /* 18/70-18/79 */,
	3       /* 18/80-18/89 */,
	3       /* 18/90-18/99 */,
	4       /* 18/100-18/109 */,
	4       /* 18/110-18/119 */,
	5       /* 18/120-18/129 */,
	6       /* 18/130-18/139 */,
	6       /* 18/140-18/149 */,
	7       /* 18/150-18/159 */,
	7       /* 18/160-18/169 */,
	8       /* 18/170-18/179 */,
	8       /* 18/180-18/189 */,
	8       /* 18/190-18/199 */,
	9       /* 18/200-18/209 */,
	9       /* 18/210-18/219 */,
	9       /* 18/220+ */
};


/*
 * Stat Table (CON) -- extra 1/4-hitpoints per level (plus 128)
 */
byte adj_con_mhp[] =
{
	128 + -8	/* 3 */,
	128 + -6	/* 4 */,
	128 + -4	/* 5 */,
	128 + -2	/* 6 */,
	128 + -1	/* 7 */,
	128 + 0	/* 8 */,
	128 + 0	/* 9 */,
	128 + 0	/* 10 */,
	128 + 0	/* 11 */,
	128 + 0	/* 12 */,
	128 + 0	/* 13 */,
	128 + 1	/* 14 */,
	128 + 1	/* 15 */,
	128 + 2	/* 16 */,
	128 + 3	/* 17 */,
	128 + 4	/* 18/00-18/09 */,
	128 + 5	/* 18/10-18/19 */,
	128 + 6	/* 18/20-18/29 */,
	128 + 7	/* 18/30-18/39 */,
	128 + 8	/* 18/40-18/49 */,
	128 + 9	/* 18/50-18/59 */,
	128 + 10	/* 18/60-18/69 */,
	128 + 11	/* 18/70-18/79 */,
	128 + 12	/* 18/80-18/89 */,
	128 + 13	/* 18/90-18/99 */,
	128 + 14	/* 18/100-18/109 */,
	128 + 15	/* 18/110-18/119 */,
	128 + 16	/* 18/120-18/129 */,
	128 + 17	/* 18/130-18/139 */,
	128 + 18	/* 18/140-18/149 */,
	128 + 19	/* 18/150-18/159 */,
	128 + 20	/* 18/160-18/169 */,
	128 + 21	/* 18/170-18/179 */,
	128 + 22	/* 18/180-18/189 */,
	128 + 23	/* 18/190-18/199 */,
	128 + 24	/* 18/200-18/209 */,
	128 + 25	/* 18/210-18/219 */,
	128 + 26	/* 18/220+ */
};


/*
 * Stat Table (CHR) -- charm
 */
byte adj_chr_chm[] =
{
	0       /* 3 */,
	0       /* 4 */,
	1       /* 5 */,
	2       /* 6 */,
	3       /* 7 */,
	4       /* 8 */,
	4       /* 9 */,
	5       /* 10 */,
	5       /* 11 */,
	6       /* 12 */,
	6       /* 13 */,
	7       /* 14 */,
	7       /* 15 */,
	8       /* 16 */,
	8       /* 17 */,
	9       /* 18/00-18/09 */,
	10      /* 18/10-18/19 */,
	12      /* 18/20-18/29 */,
	15      /* 18/30-18/39 */,
	18      /* 18/40-18/49 */,
	21      /* 18/50-18/59 */,
	24      /* 18/60-18/69 */,
	28      /* 18/70-18/79 */,
	32      /* 18/80-18/89 */,
	36      /* 18/90-18/99 */,
	39      /* 18/100-18/109 */,
	42      /* 18/110-18/119 */,
	45      /* 18/120-18/129 */,
	49      /* 18/130-18/139 */,
	53      /* 18/140-18/149 */,
	57      /* 18/150-18/159 */,
	61      /* 18/160-18/169 */,
	65      /* 18/170-18/179 */,
	69      /* 18/180-18/189 */,
	73      /* 18/190-18/199 */,
	77      /* 18/200-18/209 */,
	81      /* 18/210-18/219 */,
	85      /* 18/220+ */
};


/*
 * Stat Table (CHR) -- give money
 */
byte adj_chr_give[] =
{
	128 + -5      /* 3 */,
	128 + -4      /* 4 */,
	128 + -3      /* 5 */,
	128 + -2      /* 6 */,
	128 + -1      /* 7 */,
	128 + 0       /* 8 */,
	128 + 0       /* 9 */,
	128 + 0       /* 10 */,
	128 + 0       /* 11 */,
	128 + 0       /* 12 */,
	128 + 0       /* 13 */,
	128 + 1       /* 14 */,
	128 + 1       /* 15 */,
	128 + 2       /* 16 */,
	128 + 3       /* 17 */,
	128 + 4       /* 18/00-18/09 */,
	128 + 5       /* 18/10-18/19 */,
	128 + 6       /* 18/20-18/29 */,
	128 + 7       /* 18/30-18/39 */,
	128 + 8       /* 18/40-18/49 */,
	128 + 9       /* 18/50-18/59 */,
	128 + 10      /* 18/60-18/69 */,
	128 + 11      /* 18/70-18/79 */,
	128 + 12      /* 18/80-18/89 */,
	128 + 13      /* 18/90-18/99 */,
	128 + 14      /* 18/100-18/109 */,
	128 + 15      /* 18/110-18/119 */,
	128 + 16      /* 18/120-18/129 */,
	128 + 17      /* 18/130-18/139 */,
	128 + 18      /* 18/140-18/149 */,
	128 + 19      /* 18/150-18/159 */,
	128 + 20      /* 18/160-18/169 */,
	128 + 21      /* 18/170-18/179 */,
	128 + 22      /* 18/180-18/189 */,
	128 + 23      /* 18/190-18/199 */,
	128 + 24      /* 18/200-18/209 */,
	128 + 25      /* 18/210-18/219 */,
	128 + 26      /* 18/220+ */
};


/*
 * Stat Table (STR/DEX) -- throwing stone or grave damages and to-hit (plus 128)
 */
byte adj_throwing[] =
{
	128 + 0     /*  3 */,
	128 + 0     /*  4 */,
	128 + 0     /*  5 */,
	128 + 0     /*  6 */,
	128 + 0     /*  7 */,
	128 + 0     /*  8 */,
	128 + 0     /*  9 */,
	128 + 0     /* 10 */,
	128 + 0     /* 11 */,
	128 + 0     /* 12 */,
	128 + 0     /* 13 */,
	128 + 0     /* 14 */,
	128 + 0     /* 15 */,
	128 + 0     /* 16 */,
	128 + 0     /* 17 */,
	128 + 1     /* 18/00-18/09 */,
	128 + 1     /* 18/10-18/19 */,
	128 + 1     /* 18/20-18/29 */,
	128 + 1     /* 18/30-18/39 */,
	128 + 1     /* 18/40-18/49 */,
	128 + 2     /* 18/50-18/59 */,
	128 + 2     /* 18/60-18/69 */,
	128 + 2     /* 18/70-18/79 */,
	128 + 2     /* 18/80-18/89 */,
	128 + 2     /* 18/90-18/99 */,
	128 + 3     /* 18/100-18/109 */,
	128 + 3     /* 18/110-18/119 */,
	128 + 3     /* 18/120-18/129 */,
	128 + 3     /* 18/130-18/139 */,
	128 + 3     /* 18/140-18/149 */,
	128 + 4     /* 18/150-18/159 */,
	128 + 4     /* 18/160-18/169 */,
	128 + 4     /* 18/170-18/179 */,
	128 + 4     /* 18/180-18/189 */,
	128 + 4     /* 18/190-18/199 */,
	128 + 5     /* 18/200-18/209 */,
	128 + 5     /* 18/210-18/219 */,
	128 + 5     /* 18/220+ */
};


/*
 * This table is used to help calculate the number of blows the player can
 * make in a single round of attacks (one player turn) with a normal weapon.
 *
 * This number ranges from a single blow/round for weak players to up to six
 * blows/round for powerful warriors.
 *
 * Note that certain artifacts and ego-items give "bonus" blows/round.
 *
 * First, from the player class, we extract some values:
 *
 * Soldier       num = 5; mul = 3; div = MAX(70, weapon_weight)
 * Knight        num = 6; mul = 5; div = MAX(70, weapon_weight)
 * Berserker     num = 6; mul = 5; div = MAX(70, weapon_weight)
 * Terror-Knight num = 6; mul = 6; div = MAX(70, weapon_weight)
 * BeastTamer    num = 5; mul = 4; div = MAX(70, weapon_weight)
 * Sword-Master  num = 5; mul = 4; div = MAX(50, weapon_weight)
 * Dragoon       num = 6; mul = 5; div = MAX(70, weapon_weight)
 * Ninja         num = 4; mul = 1; div = MAX(20, weapon_weight)
 * Wizard        num = 3; mul = 2; div = MAX(100, weapon_weight)
 * Warlock       num = 4; mul = 4; div = MAX(100, weapon_weight)
 * Exorcist      num = 5; mul = 4; div = MAX(100, weapon_weight)
 * Amazoness     num = 5; mul = 3; div = MAX(70, weapon_weight)
 * Valkyrie      num = 5; mul = 4; div = MAX(70, weapon_weight)
 * Archer        num = 4; mul = 3; div = MAX(100, weapon_weight)
 * DragonTamer   num = 5; mul = 4; div = MAX(70, weapon_weight)
 * Witch         num = 4; mul = 3; div = MAX(100, weapon_weight)
 * Sirene        num = 3; mul = 2; div = MAX(100, weapon_weight)
 * Cleric        num = 5; mul = 3; div = MAX(100, weapon_weight)
 * Priest        num = 3; mul = 2; div = MAX(100, weapon_weight)
 * Lich          num = 3; mul = 2; div = MAX(100, weapon_weight)
 * Angel-Knight  num = 6; mul = 5; div = MAX(70, weapon_weight)
 * High-Witch    num = 1; mul = 1; div = MAX(1, weapon_weight)
 * Gunner        num = 3; mul = 2; div = MAX(100, weapon_weight)
 * Temple-Knight num = 5; mul = 4; div = MAX(70, weapon_weight)
 * White-Knight num = 5; mul = 4; div = MAX(70, weapon_weight)
 *
 * To get "P", we look up the relevant "adj_str_blow[]" (see above),
 * multiply it by "mul", and then divide it by "div".
 * Increase P by 1 if you wield a weapon two-handed.
 * Decrease P by 1 if you are a Ninja.
 *
 * To get "D", we look up the relevant "adj_dex_blow[]" (see above),
 *
 * The player gets "blows_table[P][D]" blows/round, as shown below,
 * up to a maximum of "num" blows/round, plus any "bonus" blows/round.
 */
byte blows_table[12][12] =
{
	/* P/D */
	/*      0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11+ */
	/*      3   10   15  /10  /40  /60  /80 /100 /120 /140 /160 /180  */
/* 0 */{	1,   1,   1,   1,   1,   2,   2,   2,   2,   3,   3,   4 },
/* 1 */{	1,   1,   1,   2,   2,   2,   3,   3,   3,   4,   4,   4 },
/* 2 */{	1,   1,   2,   2,   3,   3,   4,   4,   4,   5,   5,   5 },
/* 3 */{	1,   1,   2,   3,   3,   4,   4,   4,   5,   5,   5,   5 },
/* 4 */{	1,   1,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5 },
/* 5 */{	1,   1,   2,   3,   4,   4,   4,   5,   5,   5,   5,   6 },
/* 6 */{	1,   1,   2,   3,   4,   4,   4,   5,   5,   5,   5,   6 },
/* 7 */{	1,   2,   2,   3,   4,   4,   4,   5,   5,   5,   5,   6 },
/* 8 */{	1,   2,   3,   3,   4,   4,   4,   5,   5,   5,   6,   6 },
/* 9 */{	1,   2,   3,   4,   4,   4,   5,   5,   5,   5,   6,   6 },
/* 10*/{	2,   2,   3,   4,   4,   4,   5,   5,   5,   6,   6,   6 },
/*11+*/{	2,   2,   3,   4,   4,   4,   5,   5,   6,   6,   6,   7 },

};

s16b arena_monsters[MAX_ARENA_MONS + 4] =
{
	MON_SIMON,
	MON_SOLDIER,
	MON_AMAZONESS,
	MON_ARCHER,
	MON_KNIGHT,
	MON_PRIEST,
	MON_BEASTTAMER,
	MON_BERSERKER,
	MON_FAIRY,
	MON_HAWKMAN,
	MON_DRAGOON,
	MON_SWORDMASTER,
	MON_TERROR_KNIGHT,
	MON_PIXY,
	MON_WARLOCK,
	MON_NINJA,
	MON_BEASTMASTER,
	MON_PUMPKIN_HEAD,
	MON_LIZARDMAN,
	MON_GORGON,
	MON_GUNNER,
	MON_COCKATRICE,
	MON_VALKYRIE,
	MON_SIRENE,
	MON_DRAGONTAMER,
	MON_DARK_PRIEST,
	MON_SORCERER,
	MON_VENEFIK,
	MON_CENTAUR,
	MON_LADY_CENTAUR,
	MON_HIGH_PRIEST,
	MON_NECROMANCER,
	MON_MAD_HALLOWEEN,
	MON_GABIAR,
	MON_ANGEL_KNIGHT,
	MON_BALANCE_WYRM,
	MON_FIRE_BRASS,
	MON_MOLDOUX,
	0,
	MON_CANOPUS,
	0,
	MON_DENEB
};



byte arena_object[MAX_ARENA_MONS + 4][2] =
{
	{TV_BOOTS, SV_PAIR_OF_SANDALS},
	{TV_POTION, SV_POTION_CURE_CRITICAL},
	{TV_POTION, SV_POTION_CURE_CRITICAL},
	{TV_POTION, SV_POTION_SPEED},
	{TV_POTION, SV_POTION_HEROISM},
	{TV_POTION, SV_POTION_CURING},
	{TV_POTION, SV_POTION_CURE_CRITICAL},
	{TV_POTION, SV_POTION_HEROISM},
	{TV_POTION, SV_POTION_CURING},
	{TV_POTION, SV_POTION_HEALING},
	{TV_POTION, SV_POTION_HEROISM},
	{TV_POTION, SV_POTION_SPEED},
	{TV_POTION, SV_POTION_BERSERK_STRENGTH},
	{TV_POTION, SV_POTION_SPEED},
	{TV_POTION, SV_POTION_RESTORING},
	{TV_POTION, SV_POTION_SPEED},
	{TV_ROD, SV_ROD_STONE_TO_MUD},
	{TV_ROD, SV_ROD_MAPPING},
	{TV_SCROLL, SV_SCROLL_STAR_DESTRUCTION},
	{TV_POTION, SV_POTION_RESTORE_MANA},
	{TV_BOW, SV_ROCKET_LAUNCHER},
	{TV_POTION, SV_POTION_CURE_STONING},
	{TV_POTION, SV_POTION_STAR_HEALING},
	{TV_SCROLL, SV_SCROLL_ACQUIREMENT},
	{TV_SCROLL, SV_SCROLL_STAR_ENCHANT_WEAPON},
	{TV_POTION, SV_POTION_RESTORE_MANA},
	{TV_SCROLL, SV_SCROLL_GENOCIDE},
	{TV_POTION, SV_POTION_DEATH},
	{TV_RING, SV_RING_SHOTS},
	{TV_RING, SV_RING_DEC_MANA},
	{TV_POTION, SV_POTION_LIFE},
	{TV_SCROLL, SV_SCROLL_MASS_GENOCIDE},
	{TV_SCROLL, SV_SCROLL_STAR_ACQUIREMENT},
	{TV_ROD, SV_ROD_HEALING},
	{TV_ROD, SV_ROD_SPEED},
	{TV_ROD, SV_ROD_IDENTIFY},
	{TV_WAND, SV_WAND_DRAGON_FIRE},
	{TV_STAFF, SV_STAFF_THE_MAGI},
	{0, 0},
	{0, 0},
	{0, 0},
	{0, 0},
};



/*
 * Store owners (exactly four "possible" owners per store, chosen randomly)
 * { name, purse, max greed, min greed, haggle_per, tolerance, race, unused }
 *
 * Lifted extra shopkeepers from CthAngband (don't you just love open source
 * development? ;-)). Since this gave less than 32 unique names for some
 * shops, those have their first x names copied to reach 32.
 *
 * For the weapon and armour shops, several owners have a limit of 5k.
 *
 * I want to do 50k owners, but the purse is currently s16b. Perhaps
 * we should just store 1/10th of the purse?
 */
owner_type owners[MAX_STORES][MAX_OWNERS] =
{
	{
		/* General store - 32 unique names */
		{"Υǥ",             1000, 180, 109, 5, 15, RACE_GHOST},
		{"ᵯե",           1000, 160, 107, 4, 16, RACE_SKELETON},
		{"㤭",             1000, 150, 110, 3, 18, RACE_GORGON},
		{"ʡΥ",       1000, 170, 108, 5, 15, RACE_LIZARDMAN},
		{"դΥޥ̥",           1000, 200, 110, 6, 12, RACE_HUMAN},
		{"ʿΥե",               1000, 180, 105, 4, 12, RACE_HUMAN},
		{"Υ٥ȥ꡼",     1000, 170, 108, 6, 18, RACE_HAWKMAN},
		{"Υۥåȥޥ",       1000, 180, 108, 5, 15, RACE_LIZARDMAN},
		{"¤Υå",           1000, 160, 110, 6, 18, RACE_FAIRY},
		{"ͥ",               1000, 200, 107, 4, 12, RACE_GREMLIN},
		{"Υ󥱥ե", 1000, 170, 103, 5, 10, RACE_SKELETON},
		{"˲ԥ",               1000, 200, 104, 4, 12, RACE_GHOST},
		{"ͳοͥ륽",         1000, 180, 109, 5, 15, RACE_PUMPKINHEAD},
		{"롦ե",           1000, 190, 109, 6, 18, RACE_GORGON},
		{"ޥԥ",   1000, 170, 107, 4, 12, RACE_GOBLIN},
		{"Υȡ롼",     1000, 180, 105, 4, 12, RACE_HUMAN},
		{"ޡ㡦֥ջ", 1000, 170, 108, 6, 18, RACE_HAWKMAN},
		{"ȴΥ",               1000, 180, 108, 5, 15, RACE_LIZARDMAN},
		{"ȤΥե",       1000, 160, 110, 6, 18, RACE_FAIRY},
		{"ĤΥڥͥ",         1000, 170, 107, 4, 12, RACE_GOBLIN},
		{"ϵΥ󥻥",       1000, 170, 108, 4, 12, RACE_PUMPKINHEAD},
		{"ǴΥå",         1000, 190, 111, 4, 16, RACE_HUMAN},
		{"աͥ",               1000, 170, 109, 5, 15, RACE_HAWKMAN},
		{"Υ륹",           1000, 180, 108, 6, 12, RACE_LIZARDMAN},
		{"եɥ꡼ʥӥ",     1000, 170, 108, 5, 15, RACE_FAIRY},
		{"¼ԥ饹ȥ",         1000, 175, 108, 4, 12, RACE_GREMLIN},
		{"¼ԥ󥹥",     1000, 175, 108, 4, 12, RACE_SKELETON},
		{"ؤ㤤륿",         1000, 170, 107, 5, 15, RACE_GHOST},
		{"ϥ󥵥ʥ饤=",    1000, 165, 107, 6, 18, RACE_PUMPKINHEAD},
		{"٥쥹",         1000, 170, 108, 5, 15, RACE_GORGON},
		{"ӤΥ饷ʥ",       1000, 170, 107, 5, 15, RACE_GOBLIN},
		{"ʡ롦",     1000, 165, 107, 6, 18, RACE_HUMAN},
	},
	{
		/* Armoury - 32 unique names */
		{"Ǽԥ",             30000, 200, 114, 5, 15, RACE_HUMAN},
		{"ͤΥ磻",         30000, 220, 111, 5, 15, RACE_HAWKMAN},
		{"̾Υʥ",             30000, 190, 115, 4, 12, RACE_LIZARDMAN},
		{"¯ΥСХ",           30000, 200, 109, 5, 15, RACE_FAIRY},
		{"ƸΥޥΥե",     30000, 210, 110, 6, 12, RACE_GREMLIN},
		{"ǽΨΥƥ顼",           30000, 220, 117, 7, 10, RACE_SKELETON},
		{"ɤΥߥ",         30000, 190, 109, 5, 10, RACE_GHOST},
		{"ʥϥХ",             30000, 200, 110, 7, 14, RACE_PUMPKINHEAD},
		{"ʡΥ쥢",         30000, 170, 108, 4,  8, RACE_GORGON},
		{"ʥ",             30000, 170, 107, 4, 12, RACE_GOBLIN},
		{"ԻΥʥ",               30000, 160, 106, 4, 12, RACE_PUMPKINHEAD},
		{"˥Ĺ",                 30000, 180, 104, 4, 16, RACE_HAWKMAN},
		{"ҹĤΥ֥ϥ",       30000, 220, 119, 4, 16, RACE_LIZARDMAN},
		{"ոΥƥ٥",         30000, 200, 111, 5, 10, RACE_FAIRY},
		{"ǰΥå",         30000, 180, 108, 6, 12, RACE_GREMLIN},
		{"ʰΥޥ",         30000, 210, 112, 5, 10, RACE_SKELETON},
		{"ѸΥƥͥ",       30000, 180, 108, 4,  8, RACE_GHOST},
		{"ʢΥ",             30000, 230, 120, 5, 10, RACE_HUMAN},
		{"󳤤Υꥢ",           30000, 180, 109, 6, 12, RACE_GOBLIN},
		{"Υǥ",       30000, 200, 110, 4, 12, RACE_GORGON},
		{"ۤΥ󥰥ȥ",       30000, 200, 110, 4, 16, RACE_HUMAN},
		{"ԸΥ٥",             30000, 190, 111, 5, 10, RACE_HAWKMAN},
		{"ˢƤΥ",         30000, 200, 115, 6, 12, RACE_GREMLIN},
		{"Ʊ󥿥",           30000, 190, 110, 7, 14, RACE_SKELETON},
		{"=",            30000, 210, 115, 5,  7, RACE_GOBLIN},
		{"Ǽԥ=",        30000, 190, 111, 4,  9, RACE_HUMAN},
		{"ԥǥ",               30000, 200, 112, 4, 10, RACE_PUMPKINHEAD},
		{"결Υ",     30000, 200, 112, 4,  5, RACE_HUMAN},
		{"ɥ饴󥹥", 30000, 200, 112, 4,  5, RACE_LIZARDMAN},
		{"ǥꥫȥ",               30000, 210, 115, 5,  7, RACE_FAIRY},
		{"˥ॹ",                 30000, 200, 112, 4, 10, RACE_GORGON},
		{"ǥ",               30000, 190, 111, 4,  9, RACE_GHOST},
	},
	{
		/* Weapon Smith - 32 unique names */
		{"軰奱ӥ",         30000, 200, 114, 5, 15, RACE_PUMPKINHEAD},
		{"ҡΥꥹ",         30000, 220, 111, 5, 15, RACE_HAWKMAN},
		{"ͦԤΥߡ",       30000, 190, 115, 4, 12, RACE_LIZARDMAN},
		{"ǺΥ",             30000, 200, 109, 5, 15, RACE_FAIRY},
		{"ƤΥʥХ",             30000, 210, 110, 6, 12, RACE_GREMLIN},
		{"سΥ",             30000, 220, 117, 7, 10, RACE_SKELETON},
		{"ϤΥȥߡ",             30000, 190, 109, 5, 10, RACE_GHOST},
		{"ϺΥ奢",           30000, 200, 110, 7, 14, RACE_GORGON},
		{"ƮΥۥå֥",           30000, 170, 108, 4,  8, RACE_HUMAN},
		{"ޤΥ",             30000, 170, 107, 4, 12, RACE_GOBLIN},
		{"֤Υ顼",     30000, 160, 106, 4, 12, RACE_PUMPKINHEAD},
		{"̵ؿΥ饺",       30000, 180, 104, 4, 16, RACE_HAWKMAN},
		{"Ťʥޥå󥸡",       30000, 220, 119, 4, 16, RACE_LIZARDMAN},
		{"ƮΥߥå",           30000, 200, 111, 5, 10, RACE_FAIRY},
		{"ѥ륿Υ",         30000, 180, 108, 6, 12, RACE_GREMLIN},
		{"ۤοͥ륽",         30000, 210, 112, 5, 10, RACE_SKELETON},
		{"ͦԤʥɥߡȥꥤ",       30000, 180, 108, 4,  8, RACE_GHOST},
		{"Υå",           30000, 230, 120, 5, 10, RACE_HUMAN},
		{"Υ",           30000, 180, 109, 6, 12, RACE_GOBLIN},
		{"ԤΥ饦ǥ",       30000, 200, 110, 4, 12, RACE_GORGON},
		{"ŴΥޥꥢ",             30000, 200, 110, 4, 16, RACE_GORGON},
		{"ξͥڥ",         30000, 210, 117, 7, 21, RACE_PUMPKINHEAD},
		{"ٴߥߥ塼",   30000, 200, 114, 4,  8, RACE_HAWKMAN},
		{"Υ",             30000, 190, 109, 3,  9, RACE_FAIRY},
		{"Ǧʤ륢Υ",       30000, 210, 115, 6,  6, RACE_LIZARDMAN},
		{"ûΥ",       30000, 185, 110, 5,  9, RACE_HUMAN},
		{"ե󥰡ȥ",       30000, 190, 115, 5,  7, RACE_HAWKMAN},
		{"εΥ饤",       30000, 195, 112, 4,  8, RACE_HUMAN},
		{"Υȥ",       30000, 185, 110, 5,  9, RACE_SKELETON},
		{"ζλҥå",         30000, 185, 110, 5,  9, RACE_LIZARDMAN},
		{"ѥǥΥեꥹ",   30000, 210, 115, 6,  6, RACE_GHOST},
		{"ХΥҥ奤⥰", 30000, 195, 112, 4,  8, RACE_GOBLIN},
	},
	{
		/* Temple - 32 unique names */
		{"̾˾MEEYA",            30000, 180, 114, 5, 15, RACE_GREMLIN},
		{"̾Υ꡼",         30000, 190, 111, 5, 15, RACE_HAWKMAN},
		{"Υѡ˥",         30000, 190, 115, 4, 12, RACE_LIZARDMAN},
		{"«Υե",           30000, 180, 109, 5, 15, RACE_FAIRY},
		{"Υå",           30000, 180, 110, 6, 12, RACE_GREMLIN},
		{"ۼΥ륽",       30000, 190, 117, 7, 10, RACE_SKELETON},
		{"ؼԥեޡ",       30000, 190, 109, 5, 10, RACE_GHOST},
		{"ʶݥ奨",         30000, 200, 110, 7, 14, RACE_PUMPKINHEAD},
		{"ɥߥ",         30000, 170, 108, 4,  8, RACE_GORGON},
		{"ϺΥ饶ե", 30000, 170, 107, 4, 12, RACE_GOBLIN},
		{"ǥԥ磻륺",   30000, 160, 106, 4, 12, RACE_PUMPKINHEAD},
		{"ˤΥꥹ",         30000, 180, 104, 4, 16, RACE_HAWKMAN},
		{"ȥȥ졼",       30000, 160, 119, 4, 16, RACE_LIZARDMAN},
		{"եꥦ",             30000, 180, 111, 5, 10, RACE_FAIRY},
		{"¤ʥ硼",     30000, 180, 108, 6, 12, RACE_GREMLIN},
		{"̵ٵʥ।奭",   30000, 180, 112, 5, 10, RACE_SKELETON},
		{"ΧΥХ",           30000, 180, 108, 4,  8, RACE_GHOST},
		{"Υޥ",         30000, 160, 120, 5, 10, RACE_HUMAN},
		{"̯Υե",         30000, 180, 109, 6, 12, RACE_GOBLIN},
		{"Υ֥롼",         30000, 200, 110, 4, 12, RACE_GORGON},
		{"ʶΥ른",         30000, 200, 110, 4, 16, RACE_HUMAN},
		{"ƻꥢ",     30000, 170, 108, 4, 16, RACE_GHOST},
		{"׼祪ǥ",         30000, 180, 105, 7, 14, RACE_PUMPKINHEAD},
		{"󥸥",           30000, 160, 106, 6, 12, RACE_GORGON},
		{"ηӥ",           30000, 200, 111, 6, 18, RACE_SKELETON},
		{"޶ԥ륬롼",       30000, 180, 108, 4,  8, RACE_GREMLIN},
		{"Ǥʥ롼ɥ",     30000, 175, 109, 6, 15, RACE_FAIRY},
		{"ѥǥΥʡ",   30000, 185, 110, 5, 23, RACE_GOBLIN},
		{"Ф줷ȥ",         30000, 180, 107, 6, 20, RACE_LIZARDMAN},
		{"ʤ륵饹ȥ",     30000, 185, 109, 5, 15, RACE_HAWKMAN},
		{"ѡ붪",         30000, 180, 107, 6, 20, RACE_HUMAN},
		{"ؿ",               30000, 185, 110, 5, 23, RACE_HUMAN},
	},
	{
		/* Alchemist - 32 unique names */
		{"Եʥߥ",           30000, 200, 114, 5, 15, RACE_GORGON},
		{"®Υޥ",             30000, 220, 111, 5, 15, RACE_HAWKMAN},
		{"ϲΥ䥻",             30000, 190, 115, 4, 12, RACE_LIZARDMAN},
		{"ε֤",                 30000, 200, 109, 5, 15, RACE_HAWKMAN},
		{"ѴΥå",             30000, 210, 110, 6, 12, RACE_GREMLIN},
		{"ӭΥ參",             30000, 220, 117, 7, 10, RACE_SKELETON},
		{"ͫΥե졼",           30000, 190, 109, 5, 10, RACE_GHOST},
		{"ȶµߥ륺",         30000, 200, 110, 7, 14, RACE_PUMPKINHEAD},
		{"Υ󥸥㡼", 30000, 170, 108, 4,  8, RACE_HUMAN},
		{"åԡΥȥХ",     30000, 170, 107, 4, 12, RACE_GOBLIN},
		{"եեȤΥХ˥", 30000, 160, 106, 4, 12, RACE_PUMPKINHEAD},
		{"ˡ",             30000, 180, 104, 4, 16, RACE_HAWKMAN},
		{"Ƥʥˡ",           30000, 220, 119, 4, 16, RACE_LIZARDMAN},
		{"ڷɤΥ꡼",           30000, 200, 111, 5, 10, RACE_GORGON},
		{"ɤʥ塼",         30000, 180, 108, 6, 12, RACE_GREMLIN},
		{"Υե",         30000, 210, 112, 5, 10, RACE_SKELETON},
		{"ưΥӥ",           30000, 180, 108, 4,  8, RACE_GHOST},
		{"ϮΥ",         30000, 230, 120, 5, 10, RACE_HUMAN},
		{"ǤΥ",           30000, 180, 109, 6, 12, RACE_GOBLIN},
		{"ƮΥڥ󥵡",         30000, 200, 110, 4, 12, RACE_FAIRY},
		{"Υۥեå",     30000, 200, 110, 4, 16, RACE_HUMAN},
		{"ϣѻեå",         30000, 220, 122, 4, 24, RACE_HUMAN},
		{"ɴҤΥ桼ǥ",         30000, 180, 109, 7, 14, RACE_HUMAN},
		{"ޥ󥴡",             30000, 170, 107, 4,  8, RACE_HAWKMAN},
		{"ؼԥޥ",           30000, 190, 111, 5,  8, RACE_SKELETON},
		{"Υ",         30000, 190, 110, 6,  8, RACE_LIZARDMAN},
		{"ߥߥ",               30000, 200, 116, 6,  9, RACE_PUMPKINHEAD},
		{"եå",               30000, 220, 111, 4,  9, RACE_FAIRY},
		{"Υ󥷡",       30000, 190, 110, 6,  8, RACE_GHOST},
		{"ɸꥰʥ",             30000, 190, 110, 6,  8, RACE_GOBLIN},
		{"ˡͥ쥤",         30000, 190, 111, 5,  8, RACE_GORGON},
		{"λҥ䥡å",       30000, 220, 111, 4,  9, RACE_GREMLIN},
	},
	{
		/* Magic Shop - 32 unique names */
		{"ФΥ쥤",             30000, 200, 114, 5, 15, RACE_HUMAN},
		{"اΥꥢɥ",         30000, 220, 111, 5, 15, RACE_GORGON},
		{"ƴݤΥϥ",               30000, 190, 115, 4, 12, RACE_LIZARDMAN},
		{"äΥե",           30000, 200, 109, 5, 15, RACE_FAIRY},
		{"ǺΥȥ",         30000, 210, 110, 6, 12, RACE_GREMLIN},
		{"ƹΥϥޥ",             30000, 220, 117, 7, 10, RACE_SKELETON},
		{"Υ",               30000, 190, 109, 5, 10, RACE_GHOST},
		{"ץӥå",     30000, 200, 110, 7, 14, RACE_PUMPKINHEAD},
		{"²Υᥤ",             30000, 170, 108, 4,  8, RACE_HAWKMAN},
		{"̵¤Υȡ",         30000, 170, 107, 4, 12, RACE_GOBLIN},
		{"ݥեå",     30000, 160, 106, 4, 12, RACE_PUMPKINHEAD},
		{"Ȥʥ꡼ޥ",         30000, 180, 104, 4, 16, RACE_HAWKMAN},
		{"ѥ纴",             30000, 220, 119, 4, 16, RACE_LIZARDMAN},
		{"ؼԥ㥵",       30000, 200, 111, 5, 10, RACE_GORGON},
		{"åѤߤΥ",     30000, 180, 108, 6, 12, RACE_GREMLIN},
		{"Υ쥤",           30000, 210, 112, 5, 10, RACE_SKELETON},
		{"ԥ顼", 30000, 180, 108, 4,  8, RACE_GHOST},
		{"դΥå",       30000, 230, 120, 5, 10, RACE_HUMAN},
		{"ȥ",             30000, 180, 109, 6, 12, RACE_HUMAN},
		{";ʰΥƥڥ",         30000, 200, 110, 4, 12, RACE_FAIRY},
		{"ʰΥޥեǥ",         30000, 200, 110, 4, 16, RACE_GOBLIN},
		{"ХХ",             30000, 210, 112, 5, 15, RACE_GOBLIN},
		{"Ƴեޥ꡼ĥ",         30000, 190, 109, 5, 10, RACE_HUMAN},
		{"ͷΥ",             30000, 180, 107, 6, 12, RACE_GORGON},
		{"顼Υ=ѥ",      30000, 200, 110, 7,  8, RACE_HUMAN},
		{"ʤ֥ӥ",       30000, 215, 113, 6, 10, RACE_PUMPKINHEAD},
		{"Ȥ㥯",           30000, 175, 110, 5, 11, RACE_GREMLIN},
		{"ѻեɥˡ",       30000, 200, 110, 7,  8, RACE_HAWKMAN},
		{"ѻեꥢ",             30000, 200, 110, 7, 10, RACE_FAIRY},
		{"ѻե˥å",           30000, 175, 110, 5, 11, RACE_GHOST},
		{"ѻե٥",             30000, 200, 110, 7, 10, RACE_SKELETON},
		{"餯եȥ",         30000, 215, 113, 6, 10, RACE_LIZARDMAN},
	},
	{
		/* Black Market - 32 unique names */
		{"ԧΥإ",         30000, 250, 154,  5, 15, RACE_GORGON},
		{"ǤΥڥɥ",         30000, 250, 151,  5, 15, RACE_HUMAN},
		{"ŵΥޥƥͥ",   30000, 250, 155,  4, 12, RACE_LIZARDMAN},
		{"ؤΥߥ",           30000, 250, 159,  5, 15, RACE_FAIRY},
		{"罾ϢդΥĥ",     30000, 250, 150,  6, 12, RACE_GREMLIN},
		{"ͳΥΥ",     30000, 250, 157,  7, 10, RACE_SKELETON},
		{"ϥĹ",         30000, 250, 155,  5, 10, RACE_GHOST},
		{"òΥǥ",       30000, 250, 150,  7, 14, RACE_PUMPKINHEAD},
		{"ñΥ",         30000, 250, 158,  4,  8, RACE_HAWKMAN},
		{"쥤ɶ",         30000, 250, 157,  4, 12, RACE_GOBLIN},
		{"ήԥ᡼",   30000, 250, 156,  4, 12, RACE_PUMPKINHEAD},
		{"ʤ̤Υȥޥ",         30000, 250, 154,  4, 16, RACE_HAWKMAN},
		{"ԤΥ쥪",         30000, 250, 159,  4, 16, RACE_LIZARDMAN},
		{"른㥳",       30000, 250, 151,  5, 10, RACE_HUMAN},
		{"ʰΥ֥ƥ",     30000, 250, 158,  6, 12, RACE_GREMLIN},
		{"Υ륲",       30000, 250, 152,  5, 10, RACE_SKELETON},
		{"Ƽ¤Υҥ",         30000, 250, 158,  4,  8, RACE_GHOST},
		{"ΥС",       30000, 250, 150,  5, 10, RACE_GORGON},
		{"󤷤Υϡ",   30000, 250, 159,  6, 12, RACE_HUMAN},
		{"᤭Υѥ",     30000, 250, 150,  4, 12, RACE_FAIRY},
		{"ȤΥ",         30000, 250, 150,  4, 16, RACE_GOBLIN},
		{"ˡȤ꡼",       30000, 250, 170,  4,  8, RACE_GREMLIN},
		{"ˡ",       30000, 250, 200,  5, 20, RACE_FAIRY},
		{"̤Υӥ",       30000, 250, 150,  6, 12, RACE_LIZARDMAN},
		{"ǤⲰå",     30000, 250, 150,  4, 20, RACE_PUMPKINHEAD},
		{"Υ",       30000, 250, 150,  6, 12, RACE_GORGON},
		{"Եԥʥ",         30000, 250, 150,  6, 18, RACE_HAWKMAN},
		{"󲰥",         500, 250, 150, 10,  5, RACE_GOBLIN},
		{"֥Υҥȡ", 30000, 250, 150, 10,  5, RACE_GOBLIN},
		{"ե󥮿ͥ", 30000, 250, 150, 10,  5, RACE_GOBLIN},
		{"ͥå",         30000, 250, 150, 10,  5, RACE_GHOST},
		{"Υץƥ",   30000, 250, 150, 10,  5, RACE_SKELETON},
	},
	{
		/* Home */
#ifdef JP
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
		{ "椬", 0, 100, 100,  0, 99, 99},
#else
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
		{ "Your home", 0, 100, 100,  0, 99, 99},
#endif

	},

	{
		/* Bookstore - 32 unique names */
		{"Ҽԥꥢ",       30000, 200, 114, 5, 15, RACE_HUMAN},
		{"ۤΥ",           30000, 220, 111, 5, 15, RACE_HAWKMAN},
		{"ɤΥ饺",       30000, 190, 115, 4, 12, RACE_LIZARDMAN},
		{"Υޥå",           30000, 200, 109, 5, 15, RACE_FAIRY},
		{"꡼ȤΥߥإ륹",       30000, 210, 110, 6, 12, RACE_GREMLIN},
		{"Υޥ륯",           30000, 220, 117, 7, 10, RACE_SKELETON},
		{"ΥΥޥ",           30000, 190, 109, 5, 10, RACE_GHOST},
		{"Υߥ奨륽",     30000, 200, 110, 7, 14, RACE_PUMPKINHEAD},
		{"̤Υǥ",           30000, 170, 108, 4,  8, RACE_HUMAN},
		{"Υǥ",         30000, 170, 107, 4, 12, RACE_GOBLIN},
		{"ҸŪʥ",         30000, 160, 106, 4, 12, RACE_PUMPKINHEAD},
		{"ƫΥ륲󥷥ƥ", 30000, 180, 104, 4, 16, RACE_HAWKMAN},
		{"Υ",           30000, 220, 119, 4, 16, RACE_LIZARDMAN},
		{"ŪΤʥѥ졼",           30000, 200, 111, 5, 10, RACE_FAIRY},
		{"ꯤΥåᥦ",         30000, 180, 108, 6, 12, RACE_GREMLIN},
		{"󶵼",               30000, 210, 112, 5, 10, RACE_SKELETON},
		{"Զ¤ʥեƥ󥬡", 30000, 180, 108, 4,  8, RACE_GHOST},
		{"ԤΥ塼",       30000, 230, 120, 5, 10, RACE_HUMAN},
		{"Υҥ塼",           30000, 180, 109, 6, 12, RACE_GOBLIN},
		{"ĤΥǥ",           30000, 200, 110, 4, 12, RACE_GORGON},
		{"ûΥӥ塼ƥ",       30000, 200, 110, 4, 16, RACE_GORGON},
		{"ץ",               30000, 190, 109, 6, 18, RACE_HUMAN},
		{"Υեǥå ",      30000, 190, 110, 5, 10, RACE_LIZARDMAN},
		{"庤Υեߥͥå",     30000, 200, 112, 4, 12, RACE_HAWKMAN},
		{"ۤΥʥ",       30000, 120, 110, 7, 19, RACE_GHOST},
		{"ʪ񤭥ݡ",             30000, 175, 108, 4, 12, RACE_SKELETON},
		{"ܤ˥",           30000, 120, 105, 6, 16, RACE_HUMAN},
		{"ؼԤΥޥ꡼",           30000, 175, 108, 4, 12, RACE_FAIRY},
		{"õ奯",               30000, 120, 110, 7, 19, RACE_SKELETON},
		{"ԥإ",         30000, 120, 105, 6, 16, RACE_PUMPKINHEAD},
		{"ǥ󥽥",         30000, 120, 110, 7, 19, RACE_GORGON},
		{"ƤΥ",               30000, 120, 110, 7, 19, RACE_HUMAN},
	},

	{
		/* Museum */
#ifdef JP
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
		{ "ʪ", 0, 100, 100,  0, 99, 99},
#else
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
		{ "Museum", 0, 100, 100,  0, 99, 99},
#endif

	},

};




/*
 * This table allows quick conversion from "speed" to "energy"
 * The basic function WAS ((S>=110) ? (S-110) : (100 / (120-S)))
 * Note that table access is *much* quicker than computation.
 *
 * Note that the table has been changed at high speeds.  From
 * "Slow (-40)" to "Fast (+30)" is pretty much unchanged, but
 * at speeds above "Fast (+30)", one approaches an asymptotic
 * effective limit of 50 energy per turn.  This means that it
 * is relatively easy to reach "Fast (+30)" and get about 40
 * energy per turn, but then speed becomes very "expensive",
 * and you must get all the way to "Fast (+50)" to reach the
 * point of getting 45 energy per turn.  After that point,
 * furthur increases in speed are more or less pointless,
 * except to balance out heavy inventory.
 *
 * Note that currently the fastest monster is "Fast (+30)".
 *
 * It should be possible to lower the energy threshhold from
 * 100 units to 50 units, though this may interact badly with
 * the (compiled out) small random energy boost code.  It may
 * also tend to cause more "clumping" at high speeds.
 */
byte extract_energy[200] =
{
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* S-50 */     1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* S-40 */     2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
	/* S-30 */     2,  2,  2,  2,  2,  2,  2,  3,  3,  3,
	/* S-20 */     3,  3,  3,  3,  3,  4,  4,  4,  4,  4,
	/* S-10 */     5,  5,  5,  5,  6,  6,  7,  7,  8,  9,
	/* Norm */    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
	/* F+10 */    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
	/* F+20 */    30, 31, 32, 33, 34, 35, 36, 36, 37, 37,
	/* F+30 */    38, 38, 39, 39, 40, 40, 40, 41, 41, 41,
	/* F+40 */    42, 42, 42, 43, 43, 43, 44, 44, 44, 44,
	/* F+50 */    45, 45, 45, 45, 45, 46, 46, 46, 46, 46,
	/* F+60 */    47, 47, 47, 47, 47, 48, 48, 48, 48, 48,
	/* F+70 */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
	/* Fast */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
};




/*
 * Base experience levels
 */
s32b player_exp[PY_MAX_LEVEL] =
{
	12,
	31,
	56,
	87,
	125,
	175,
	250,
	350,
	475, /* 10 */
	625,
	812,
	1062,
	1375,
	1750,
	2250,
	2875,
	3625,
	4500,
	5500, /* 20 */
	6750,
	8500,
	10500,
	12750,
	15625,
	21875,
	31250,
	43750L,
	62500L,
	93750L, /* 30 */
	125000L,
	187500L,
	250000L,
	343750L,
	437500L,
	562500L,
	687500L,
	875000L,
	1062500L,
	1250000L, /* 40 */
	1562500L,
	1875000L,
	2250000L,
	2625000L,
	3000000L,
	3375000L,
	3750000L,
	4375000L,
	5000000L,
	5625000L, /* 50 */
	6250000L
};


/*
 * Player Sexes
 *
 *      Title,
 *      Winner
 */
player_sex sex_info[MAX_SEXES] =
{
	{
#ifdef JP
		"",
		"",
#endif
		"Female",
		"Queen"
	},
	{
#ifdef JP
		"",
		"",
#endif
		"Male",
		"King"
	}
};


/*
 * Player Races
 *
 *      Title,
 *      {STR,INT,WIS,DEX,CON,CHR},
 *      r_dis, r_dev, r_sav, r_stl, r_srh, r_fos, r_spd, r_thn, r_thb,
 *                                                rx_spd,
 *      hitdie, manadie, exp base,
 *      Age (Base, Mod),
 *      Male (Hgt, Wgt),
 *      Female (Hgt, Wgt)
 *      infra,
 *      class-choices,
 *      sex
 */
player_race race_info[MAX_RACES] =
{
	{
#ifdef JP
		"ʹ",
#endif
		"Human",

		0L,
		{  0,  0,  0,  0,  0,  0 },
		0,  0,  0,  0,  0,  10,  0,  0,  0,
		                         0,
		14, 0, 100,
		14,  6,
		70,  6, 154, 25,
		63,  5, 124, 20,
		0,
		0x7FFFFFFF,
		RACE_TYPE_NORMAL,
	},
	{
#ifdef JP
		"ۡޥ",
#endif
		"Hawkman",

		0L,
		{  1,  -1,  -1,  2,  0,  0 },
		0,  0,  0,  1,  0,  10,  0,  8,  10,
		                         3,
		14, 0, 160,
		42,  22,
		75,  7, 185, 27,
		67,  5, 134, 20,
		1,
		0x7FFFFFFF,
		RACE_TYPE_NORMAL,
	},
	{
#ifdef JP
		"ꥶɥޥ",
#endif
		"Lizardman",

		0L,
		{  2,  -1,  -1,  1,  2,  -1 },
		10,  5,  3,  0,  -1,  10,  0, 10,  5,
		                           1,
		15, 0, 145,
		95,  65,
		76,  1, 160, 5,
		72,  1, 130, 5,
		2,
		0x7FFFFFFF,
		RACE_TYPE_NORMAL,
	},
	{
#ifdef JP
		"ե꡼",
#endif
		"Fairy",

		0L,
		{ -2, 1, 1, 1, -2, 1 },
		10, 8, 6, 4, 10, 10, 0, -12, 8,
		                     5,
		12, 1, 155,
		50, 35,
		32,  2, 75,  2,
		29,  2, 65,  2,
		4,
		0x7FFFFFFF,
		RACE_TYPE_NORMAL,
	},
	{
#ifdef JP
		"",
#endif
		"Gremlin",

		0L,
		{ -2, 1, -1, 1, -1, -1 },
		4, 7, 9, 2, 5, 12,  0, -5, 15,
		                    5,
		12, 1, 170,
		65, 35,
		22,  2,  55,  2,
		19,  2,  45,  2,
		4,
		0x7FFFFFFF,
		RACE_TYPE_NORMAL,
	},
	{
#ifdef JP
		"ȥ",
#endif
		"Skeleton",

		PRF_UNDEAD | PRF_NO_DIGEST,
		{ 0, 0, -2, 0, 1, -2 },
		-5, 0, 3, -1, -1, 8, 0, 10, 0,
		                     1,
		14, 0, 135,
		120, 35,
		70,  6, 50, 5,
		66,  4, 50, 5,
		2,
		0x7FFFFFFF,
		RACE_TYPE_NORMAL,
	},
	{
#ifdef JP
		"",
#endif
		"Ghost",

		PRF_UNDEAD | PRF_NO_DIGEST,
		{ -3, 1, -1, -1, 0, -2 },
		10, 15, 12, 6, 5, 14, -1, -15, -10,
		                       0,
		10, 0, 190,
		120, 35,
		70, 6, 20, 5,
		66, 4, 20, 5,
		5,
		0x7FFFFFFF,
		RACE_TYPE_NORMAL,
	},
	{
#ifdef JP
		"ѥץإå",
#endif
		"Pumpkin-Head",

		0L,
		{ -2, -2, 3, 0, 3, 0 },
		0, 0, 10, 0, 10, 18, 0, -10, -5,
		                     0,
		13, 1, 105,
		11, 9,
		55, 5, 190, 30,
		55, 5, 190, 30,
		8,
		0x7FFFFFFF,
		RACE_TYPE_MALE,
	},
	{
#ifdef JP
		"֥",
#endif
		"Goblin",

		0L,
		{ 2, -1, 0, 0, 1, -2 },
		-3, -3, -2, -1, 0, 7, 0, 14, -5,
		                      1,
		14, 0, 120,
		11, 4,
		66, 1, 150, 5,
		62, 1, 120, 5,
		3,
		0x7FFFFFFF,
		RACE_TYPE_NORMAL,
	},
	{
#ifdef JP
		"",
#endif
		"Gorgon",

		0L,
		{ 1, 2, -2, 2, -1, 2 },
		8, 10, 8, 2, 8, 12, 0, 8, 25,
		                    3,
		14, 0, 200,
		100, 30,
		78, 10, 180, 15,
		78, 10, 180, 15,
		3,
		0x7FFFFFFF,
		RACE_TYPE_FEMALE,
	},
	{
#ifdef JP
		"ޡᥤ",
#endif
		"Mermaid",

		0L,
		{ -1, 0, 1, 1, -1, 1 },
		12, 14, 7, 1, 0, 10, -5, -5, 2,
		                      3,
		13, 0, 140,
		46, 33,
		72, 6, 156, 25,
		64, 5, 126, 20,
		2,
		0x7FFFFFFF,
		RACE_TYPE_NORMAL,
	},
};


/*
 * Player Classes
 *
 *      Title,
 *      flags,
 *      {needSTR,needINT,needWIS,needDEX,needCON,needCHR},
 *      {gainSTR,gainINT,gainWIS,gainDEX,gainCON,gainCHR},
 *      c_dis, c_dev, c_sav, c_stl, c_srh, c_fos, c_spd, c_thn, c_thb,
 *      x_dis, x_dev, x_sav, x_stl, x_srh, x_fos, x_spd, x_thn, x_thb,
 *      c_to_a, hitdie, manadie, exp base
 */
player_class class_info[MAX_CLASS] =
{
	{
#ifdef JP
		"른㡼",
#endif
		"Soldier",

		PCF_ALIGN_ANY | PCF_SEX_MALE | PCF_BIRTH,
		{0, 0, 0, 0, 0, 0},
		{03, 03, 03, 03, 03, 02},
		25, 28, 20,  3, 18, 14, 0, 60, 50,
		12,  8,  9,  2,  0,  0, 3, 18, 20,
		0, 1, 0, 60,
	},

	{
#ifdef JP
		"ʥ",
#endif
		"Knight",

		PCF_ALIGN_LAWFUL | PCF_ALIGN_NEUTRAL | PCF_SEX_MALE | PCF_BIRTH,
		{15, 0, 0, 16, 14, 0},
		{04, 02, 03, 04, 03, 02},
		17, 18, 17, -1, 14, 13, 0, 68, 52,
		 9,  7,  8,  0,  0,  0, 1, 28, 23,
		15, 2, 0, 75,
	},

	{
#ifdef JP
		"С",
#endif
		"Berserker",

		PCF_ALIGN_NEUTRAL | PCF_ALIGN_CHAOTIC | PCF_SEX_MALE | PCF_BIRTH,
		{15, 0, 0, 14, 16, 0},
		{05, 01, 02, 03, 04, 01},
		26, 11, 18,  1, 19, 15, 0, 70, 49,
		12,  6,  9,  0,  0,  0, 1, 30, 17,
		15, 3, 0, 80,
	},

	{
#ifdef JP
		"ƥ顼ʥ",
#endif
		"Terror-Knight",

		PCF_ALIGN_CHAOTIC | PCF_SEX_MALE,
		{18 + 60, 0, 0, 0, 18 + 60, 0},
		{05, 00, 00, 02, 05, 00},
		 1,  0, 2, -10, 1, 4, 0, 90, 11,
		-6, -6, 0, -10, 0, 0, 0, 38,  2,
		30, 5, 2, 115,
	},

	{
#ifdef JP
		"ӡȥƥޡ",
#endif
		"BeastTamer",

		PCF_ALIGN_ANY | PCF_SEX_MALE | PCF_BIRTH,
		{15, 0, 16, 0, 14, 0},
		{04, 01, 02, 02, 04, 03},
		28, 27, 25, 1, 12, 16, 0, 62, 56,
		10,  9,  9, 2,  0,  0, 1, 20, 19,
		10, 3, 2, 105, 
	},

	{
#ifdef JP
		"ɥޥ",
#endif
		"Sword-Master",

		PCF_ALIGN_LAWFUL | PCF_SEX_MALE,
		{18 + 40, 0, 0, 18 + 60, 0, 0},
		{03, 03, 02, 05, 02, 03},
		29, 27, 25, 4, 24, 16, 0, 70, 40,
		10,  9, 10, 4,  0,  0, 3, 23, 18,
		0, 4, 1, 115,
	},

	{
#ifdef JP
		"ɥ饰",
#endif
		"Dragoon",

		PCF_ALIGN_ANY | PCF_SEX_MALE,
		{18 + 50, 0, 0, 18 + 50, 18 + 40, 0},
		{04, 02, 01, 04, 04, 02},
		24, 14, 24, 1, 18, 16, 0, 68, 23,
		 8,  6,  9, 0,  0,  0, 0, 33, 12,
		10, 3, 1, 110,
	},

	{
#ifdef JP
		"˥󥸥",
#endif
		"Ninja",

		PCF_ALIGN_ANY | PCF_SEX_ANY | PCF_BIRTH,
		{15, 0, 0, 16, 14, 0},
		{02, 02, 01, 05, 02, 01},
		45, 24, 19, 8, 28, 22, 0, 65, 66,
		15, 10,  8, 5,  0,  0, 6, 19, 18,
		-5, 0, 0, 105,
	},

	{
#ifdef JP
		"",
#endif
		"Wizard",

		PCF_ALIGN_NEUTRAL | PCF_ALIGN_CHAOTIC | PCF_SEX_MALE | PCF_BIRTH,
		{0, 16, 14, 0, 0, 0},
		{01, 04, 03, 02, 01, 02},
		30, 36, 30, 2, 16, 20, 0, 34, 20,
		 7, 13, 13, 0,  0,  0, 1,  6,  7,
		-10, 0, 3, 100,
	},

	{
#ifdef JP
		"å",
#endif
		"Warlock",

		PCF_ALIGN_LAWFUL | PCF_ALIGN_NEUTRAL | PCF_SEX_MALE,
		{0, 18 + 70, 18 + 50, 0, 0, 0},
		{01, 04, 04, 01, 01, 04},
		32, 38, 28, 2, 18, 16, 0, 52, 21,
		14, 14, 14, 0,  0,  0, 0, 18, 11,
		-5, 0, 2, 125,
	},

	{
#ifdef JP
		"",
#endif
		"Exorcist",

		PCF_ALIGN_LAWFUL | PCF_SEX_MALE | PCF_BIRTH,
		{0, 12, 14, 0, 14, 0},
		{03, 02, 04, 02, 03, 02},
		25, 30, 32, 1, 16, 8, 0, 60, 28,
		 9,  8,  9, 0,  0, 0, 0, 21,  7,
		0, 1, 2, 95,
	},

	{
#ifdef JP
		"ޥͥ",
#endif
		"Amazoness",

		PCF_ALIGN_ANY | PCF_SEX_FEMALE | PCF_BIRTH,
		{0, 0, 0, 0, 0, 0},
		{03, 03, 03, 03, 03, 03},
		26, 26, 20, 2, 17, 12, 0, 58, 52,
		11,  9,  9, 2,  0,  0, 3, 16, 22,
		0, 1, 0, 60,
	},

	{
#ifdef JP
		"륭꡼",
#endif
		"Valkyrie",

		PCF_ALIGN_LAWFUL | PCF_ALIGN_NEUTRAL | PCF_SEX_FEMALE | PCF_BIRTH,
		{14, 0, 14, 0, 16, 0},
		{04, 02, 03, 03, 04, 01},
		30, 28, 28, -1, 18, 16, 0, 64, 48,
		10, 10,  9,  0,  0,  0, 1, 23, 14,
		15, 2, 1, 85,
	},

	{
#ifdef JP
		"㡼",
#endif
		"Archer",

		PCF_ALIGN_NEUTRAL | PCF_ALIGN_CHAOTIC | PCF_SEX_FEMALE | PCF_BIRTH,
		{0, 0, 0, 16, 14, 0},
		{03, 02, 02, 05, 03, 02},
		38, 24, 23, 3, 24, 16, 0, 56, 82,
		12, 10,  8, 1,  0,  0, 5, 13, 36,
		0, 3, 0, 110,
	},

	{
#ifdef JP
		"ɥ饴ƥޡ",
#endif
		"DragonTamer",

		PCF_ALIGN_ANY | PCF_SEX_FEMALE,
		{18 + 60, 0, 18 + 40, 0, 0, 0},
		{04, 02, 03, 03, 03, 03},
		31, 29, 26, 1, 13, 17, 0, 52, 63,
		13, 10, 10, 2,  0,  0, 2, 17, 25,
		10, 2, 1, 105,
	},

	{
#ifdef JP
		"å",
#endif
		"Witch",

		PCF_ALIGN_NEUTRAL | PCF_ALIGN_CHAOTIC | PCF_SEX_FEMALE | PCF_BIRTH,
		{0, 15, 14, 0, 0, 0},
		{01, 04, 03, 03, 01, 04},
		32, 41, 29, 2, 18, 19, 0, 45, 51,
		16, 16, 12, 1,  0,  0, 1, 13, 20,
		-5, 0, 2, 95,
	},

	{
#ifdef JP
		"졼",
#endif
		"Sirene",

		PCF_ALIGN_LAWFUL | PCF_ALIGN_NEUTRAL | PCF_SEX_FEMALE,
		{0, 18 + 20, 18, 0, 0, 0},
		{01, 05, 03, 02, 01, 02},
		28, 35, 32, 2, 13, 20, 0, 15, 17,
		 7, 13, 13, 0,  0,  0, 0,  5,  7,
		-10, 0, 3, 100,
	},

	{
#ifdef JP
		"å",
#endif
		"Cleric",

		PCF_ALIGN_LAWFUL | PCF_ALIGN_NEUTRAL | PCF_SEX_FEMALE | PCF_BIRTH,
		{0, 14, 15, 0, 0, 0},
		{02, 03, 04, 03, 02, 02},
		25, 34, 30, 2, 12, 12, 0, 40, 50,
		 8, 11,  9, 0,  0,  0, 1,  9, 18,
		-5, 1, 2, 95,
	},

	{
#ifdef JP
		"ץ꡼",
#endif
		"Priest",

		PCF_ALIGN_LAWFUL | PCF_SEX_FEMALE,
		{0, 18 + 40, 18 + 60, 0, 0, 0},
		{01, 04, 05, 02, 01, 02},
		30, 32, 33, 1, 16, 9, 0, 27, 27,
		 8,  9, 11, 0,  0, 0, 0,  6,  9,
		-10, 1, 2, 75,
	},

	{
#ifdef JP
		"å",
#endif
		"Lich",

		PCF_ALIGN_ANY | PCF_SEX_ANY | PCF_REINCARNATE | PCF_NO_CHANGE | PCF_UNDEAD | PCF_NO_DIGEST,
		{0, 18 + 100, 18 + 80, 0, 0, 0},
		{00, 05, 04, 01, 03, 00},
		29, 28, 31, 1, 4, 13, 0, 8, 10,
		 7,  8, 12, 0, 0,  0, 0, 6,  4,
		5, 2, 3, 135,
	},

	{
#ifdef JP
		"󥸥ʥ",
#endif
		"Angel-Knight",

		PCF_ALIGN_LAWFUL | PCF_SEX_FEMALE | PCF_REINCARNATE | PCF_NO_CHANGE | PCF_NO_DIGEST,
		{18 + 70, 18 + 80, 18 + 40, 18 + 60, 18 + 60, 18 + 100},
		{04, 03, 04, 03, 03, 03},
		30, 30, 28, 1, 18, 16, 0, 72, 55,
		10, 10, 12, 0,  0,  0, 2, 30, 30,
		30, 2, 2, 135,
	},

	{
#ifdef JP
		"ä",
#endif
		"High-Witch",

		PCF_ALIGN_NEUTRAL | PCF_ALIGN_CHAOTIC | PCF_SEX_FEMALE | PCF_NO_CHANGE,
		{0, 0, 0, 0, 0, 18 + 120},
		{00, 05, 04, 02, 00, 05},
		32, 49, 29, 1, 18, 19, 0, 4, 6,
		16, 16, 12, 0,  0,  0, 0, 2, 3,
		-20, 0, 4, 150,
	},

	{
#ifdef JP
		"ʡ",
#endif
		"Gunner",

		PCF_ALIGN_ANY | PCF_SEX_MALE | PCF_NO_CHANGE,
		{18 + 20, 0, 0, 18 + 40, 0, 0},
		{03, 03, 02, 04, 02, 02},
		38, 0, 10, 2, 24, 24, 0, 56, 76,
		12, 0,  2, 4,  0,  0, 1, 18, 32,
		-10, 3, 0, 145,
	},

	{
#ifdef JP
		"ƥץʥ",
#endif
		"Temple-Knight",

		PCF_ALIGN_ANY | PCF_SEX_ANY | PCF_NO_CHANGE,
		{18 + 70, 18 + 40, 18 + 60, 18 + 50, 18 + 50, 0},
		{04, 03, 03, 04, 03, 01},
		15, 23, 18, -4, 14, 4, 0, 62, 52,
		 7,  8, 10, -1,  0, 0, 0, 26, 20,
		10, 3, 0, 135,
	},

	{
#ifdef JP
		"ۥ磻ȥʥ",
#endif
		"White-Knight",

		PCF_ALIGN_ANY | PCF_SEX_ANY | PCF_NO_CHANGE,
		{18 + 70, 18 + 40, 18 + 60, 18 + 50, 18 + 50, 0},
		{04, 02, 03, 04, 03, 03},
		25, 21, 22, -2, 11, 15, 0, 70, 44,
		10,  7, 10,  0,  0,  0, 0, 27, 14,
		10, 3, 0, 120,
	},

	{
#ifdef JP
		"",
#endif
		"Lord",

		PCF_ALIGN_ANY | PCF_SEX_MALE | PCF_NO_CHANGE | PCF_SECRET,
		{0, 0, 0, 0, 0, 0},
		{05, 03, 04, 05, 05, 04},
		25, 28, 28,  5, 25, 14, 0, 80, 50,
		12,  8, 10,  4,  0,  0, 3, 35, 20,
		10, 5, 1, 120,
	},

	{
#ifdef JP
		"ͥ",
#endif
		"General",

		PCF_ALIGN_LAWFUL | PCF_SEX_MALE | PCF_NO_CHANGE | PCF_SECRET,
		{0, 0, 0, 0, 0, 0},
		{04, 03, 03, 05, 03, 04},
		29, 27, 25, 4, 24, 16, 0, 70, 40,
		10,  9, 10, 4,  0,  0, 3, 32, 18,
		30, 4, 0, 115,
	},


	{
#ifdef JP
		"˥󥸥ޥ",
#endif
		"Ninjamaster",

		PCF_ALIGN_ANY | PCF_SEX_ANY | PCF_NO_CHANGE | PCF_SECRET,
		{0, 0, 0, 0, 0, 0},
		{02, 02, 01, 05, 02, 01},
		45, 24, 19, 8, 28, 22, 0, 65, 66,
		15, 10,  8, 5,  0,  0, 6, 19, 18,
		5, 1, 0, 105,
	},

	{
#ifdef JP
		"ƥå",
#endif
		"Archmage",

		PCF_ALIGN_CHAOTIC | PCF_SEX_MALE | PCF_NO_CHANGE | PCF_SECRET,
		{0, 0, 0, 0, 0, 0},
		{01, 04, 03, 02, 01, 02},
		30, 36, 30, 2, 16, 20, 0, 34, 20,
		 7, 13, 13, 0,  0,  0, 1,  6,  7,
		-5, 0, 4, 100,
	},

	{
#ifdef JP
		"ե쥤",
#endif
		"Freya",

		PCF_ALIGN_LAWFUL | PCF_SEX_FEMALE | PCF_NO_CHANGE | PCF_SECRET,
		{0, 0, 0, 0, 0, 0},
		{04, 03, 04, 03, 04, 03},
		34, 30, 30,  1, 18, 16, 0, 70, 48,
		12, 12, 12,  0,  0,  0, 2, 23, 14,
		15, 3, 1, 95,
	},

	{
#ifdef JP
		"쥻",
#endif
		"Crescent",

		PCF_ALIGN_NEUTRAL | PCF_ALIGN_CHAOTIC | PCF_SEX_FEMALE | PCF_NO_CHANGE | PCF_SECRET,
		{0, 0, 0, 0, 0, 0},
		{04, 03, 02, 05, 04, 02},
		42, 26, 28, 4, 24, 16, 0, 60, 90,
		12, 10,  9, 2,  2,  0, 6, 16, 42,
		10, 4, 0, 140,
	},

	{
#ifdef JP
		"ѥ",
#endif
		"Vampire",

		PCF_ALIGN_CHAOTIC | PCF_SEX_MALE | PCF_REINCARNATE | PCF_NO_CHANGE | PCF_UNDEAD,
		{18 + 70, 18 + 80, 18 + 40, 18 + 60, 18 + 60, 18 + 40},
		{05, 04, 03, 05, 05, 04},
		25, 28, 28,  6, 14, 20, 0, 80, 35,
		12, 10,  8,  4,  0,  0, 3, 35, 18,
		10, 5, 1, 150,
	},

};



/*
 * Zangband uses this array instead of the spell flags table, as there
 * are 5 realms of magic, each with 4 spellbooks and 8 spells per book -- TY
 */
u32b fake_spell_flags[MAX_REALM][3] =
{
	/* Magery */
	{
		0x00001fff,
		0x03ffe000,
		0x00000000
	},
	/* Fire Magic */
	{
		0x00003fff,
		0x00000000,
		0x00000000
	},
	/* Aqua Magic */
	{
		0x00003fff,
		0x00000000,
		0x00000000
	},
	/* Earth Magic */
	{
		0x00001fff,
		0x00000000,
		0x00000000
	},
	/* Wind Magic */
	{
		0x00000fff,
		0x00000000,
		0x00000000
	},
	/* Holy Magic */
	{
		0x00000fff,
		0x00fff000,
		0x00000000
	},
	/* Death Magic */
	{
		0x00001fff,
		0x01ffe000,
		0x00000000
	},
	/* Symbiotic Magic */
	{
		0x00007fff,
		0x00000000,
		0x00000000
	},
	/* Witch Magic */
	{
		0x000003ff,
		0x000ffc00,
		0x7ff00000
	},
	/* Drakonite Magic */
	{
		0x000000ff,
		0x00000000,
		0x00000000
	},
	/* Crusade Magic */
	{
		0x00000fff,
		0x01fff000,
		0x00000000
	},
};


s32b realm_choices[] =
{
	(CH_NONE), /* Soldier */
	(CH_NONE), /* Knight */
	(CH_NONE), /* Berserker */
	(CH_NONE), /* Terror-Knight */
	(CH_SYMBIOTIC), /* BeastTamer */
	(CH_FIRE | CH_AQUA | CH_EARTH | CH_WIND), /* Sword-Master*/
	(CH_WITCH), /* Dragoon */
	(CH_FIRE | CH_AQUA | CH_EARTH | CH_WIND), /* Ninja */
	(CH_MAGERY | CH_FIRE | CH_AQUA | CH_EARTH | CH_WIND), /* Wizard */
	(CH_MAGERY | CH_WITCH | CH_DRAKONITE), /* Warlock */
	(CH_FIRE | CH_AQUA | CH_EARTH | CH_WIND | CH_CRUSADE), /* Exorcist */
	(CH_NONE), /* Amazoness */
	(CH_FIRE | CH_AQUA | CH_EARTH | CH_WIND), /* Valkyrie */
	(CH_NONE), /* Archer */
	(CH_SYMBIOTIC), /* DragonTamer */
	(CH_MAGERY | CH_WITCH | CH_DEATH), /* Witch */
	(CH_MAGERY | CH_FIRE | CH_AQUA | CH_EARTH | CH_WIND), /* Sirene */
	(CH_FIRE | CH_AQUA | CH_EARTH | CH_WIND | CH_HOLY), /* Cleric */
	(CH_FIRE | CH_AQUA | CH_EARTH | CH_WIND | CH_HOLY | CH_CRUSADE), /* Priest */
	(CH_MAGERY | CH_FIRE | CH_AQUA | CH_EARTH | CH_WIND | CH_DEATH | CH_WITCH), /* Lich */
	(CH_FIRE | CH_AQUA | CH_EARTH | CH_WIND | CH_CRUSADE), /* Angel-Knight */
	(CH_MAGERY | CH_FIRE | CH_AQUA | CH_EARTH | CH_WIND | CH_HOLY | CH_DEATH |
	 CH_SYMBIOTIC | CH_WITCH | CH_DRAKONITE | CH_CRUSADE), /* High-Witch */
	(CH_NONE), /* Gunner */
	(CH_DEATH), /* Temple-Knight */
	(CH_HOLY), /* White-Knight */
	(CH_FIRE | CH_AQUA | CH_EARTH | CH_WIND | CH_HOLY), /* Load */
	(CH_NONE), /* General */
	(CH_FIRE | CH_AQUA | CH_EARTH | CH_WIND), /* Ninjamaster */
	(CH_MAGERY | CH_FIRE | CH_AQUA | CH_EARTH | CH_WIND | CH_DEATH), /* Archmage */
	(CH_FIRE | CH_AQUA | CH_EARTH | CH_WIND | CH_CRUSADE), /* Freya */
	(CH_WIND), /* Crescent */
	(CH_DEATH), /* Vampire */
};


#ifdef JP
cptr realm_names[] =
{
	"ˡʤ",
	"ƻ",
	"б",
	"",
	"",
	"",
	"",
	"Ź",
	"",
	"å",
	"ε",
	"˼",
	"",
};
#endif

#ifdef JP
cptr E_realm_names[]
#else
cptr realm_names[]
#endif
= {
	"none",
	"Magery",
	"Fire",
	"Aqua",
	"Earth",
	"Wind",
	"Holy",
	"Death",
	"Symbiotic",
	"Witch",
	"Drakonite",
	"Crusade",
	"unknown"
};

/*
 * Names of the spells (mage spells then priest spells)
 */
cptr spell_names[MAX_REALM][32] =
{
	/*** Magery Spells ***/
	{
		"ޥåߥ",
		"󥹥",
		"硼ȥƥݡ",
		"櫤ⴶ",
		"饤ȡꥢ",
		"櫡˲",
		"ƥݡ",
		"",
		"ϲ",
		"ˡϿ",
		"",
		"",
		"Ϥ",

		"ʢ­",
		"Ԥμʸ",
		"Ĵ",
		"ϽŶ",
		"ƥݡȡ٥",
		"ƥݡȡ",
		"",
		"ˡå",
		"Τ",
		"⾤",
		"ư",
		"ζ",
		"Ϥ",

		"",
		"",
		"",
		"",
		"",
		"",
	},

	/*** Fire Spells ***/
	{
		"ѡե",
		"ǥեͥ",
		"եܥ",
		"󥹥",
		"եȡ",
		"ꥢ",
		"ҡȥݥ",
		"Ǥ",
		"ޥ",
		"ॾΡ",
		"Ȥζ",
		"ȥ饤Υ",
		"ͥβø",
		"ѡΥ",

		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	},

	/*** Aqua Spells ***/
	{
		"ǥե롼",
		"˴",
		"֥饹",
		"ꥢ֥å",
		"ࡼ",
		"",
		"ܡ",
		"ݥϥ",
		"",
		"ե",
		"ޡ쥤",
		"繿",
		"֥롼ѥ",
		"쥯",

		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	},

	/*** Earth Spells ***/
	{
		"֥",
		"ǥեС",
		"åɡܥ",
		"¤",
		"åɥ饦",
		"ץ",
		"ȩв",
		"ε",
		"Ϥܸ",
		"Ρ",
		"åץ쥹",
		"ڥȥ֥쥹",
		"",

		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	},

	/*** Wind Spells ***/
	{
		"ǥåɥå",
		"ǥեϡͥ",
		"θ",
		"ܥ",
		"ե쥢",
		"åࡼ",
		"륹ȡ",
		"ȥ͡",
		"С",
		"ϡͥ",
		"",
		"ꥢ륯饤",

		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	},

	/*** Holy Spells ***/
	{
		"ٰ¸ߴ",
		"֥쥹",
		"ξ",
		"ҡ",
		" & ⴶ",
		"ʢ­",
		"奢ݥ",
		"奢",
		"ͽ",
		"",
		"볦",
		"ҡ󥰥",

		"ꥢ",
		"мٰ볦",
		"ҡ󥰥ץ饹",
		"",
		"۶θ",
		"",
		"ʤ",
		"˥ե",
		"ŷȾ",
		"볦",
		"ѡեȥҡ",
		"ꥶ쥯",

		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	},

	/*** Death Spells ***/
	{
		"ǥåɽ°",
		"Ź",
		"Ǯ",
		"Ǥα",
		"㡼ڥ",
		"ʥȥᥢ",
		"Ķ",
		"󥹥",
		"Ծ",
		"ɥ֥ڥ",
		"˲θ",
		"",
		"ڥå",

		"۷ο",
		"Ԥ",
		"饤եե",
		"",
		"̽ؤξ",
		"",
		"Ź",
		"Ǥ˿",
		"",
		"Ϲι",
		"ѥ",
		"ǥåɥ꡼",

		"",
		"",
		"",
		"",
		"",
		"",
		"",
	},

	/*** Symbiotic Spells ***/
	{
		"󥹥",
		"ưʪ餷",
		"ͧͼ",
		"",
		"",
		"ڥåȽ",
		"­þ",
		"ͧΤ餻",
		"ԡɡ󥹥",
		"ưʪͧ",
		"˻",
		"ϥɾ",
		"ͧؤΰ",
		"ưʪ",
		"ͧͼ",

		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	},

	/*** Witch Spells ***/
	{
		"ֳ",
		"㡼",
		"β",
		"ҡʬ",
		"ǥե",
		"θ",
		"ꥢ֥å",
		"åࡼ",
		"ࡼ",
		"©μ",

		"󥹥",
		"ȯΥ롼",
		"ץ",
		"ݥ󥯥饦",
		"ߡ",
		"",
		"ޥ륦ݥ",
		"ȥݥ",
		"ץ쥤",
		"߱群",

		"**ӡ",
		"ˡγ",
		"ߥμ",
		"ɾ",
		"륹ȡ",
		"Ͼõ",
		"ޡ쥤",
		"ڥȥ饦",
		"",
		"󥸥",
		"ͩβ",

		"",
	},

	/*** Drakonite Spells ***/
	{
		"ޡƥ饤",
		"ɥߥ˥",
		"ƥڥ",
		"˥ҥ졼",
		"ƥȥ饤",
		"ۥ磻ȥߥ塼",
		"꡼󥫡ͥ",
		"ʥåץɥ饴",

		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	},

	/*** Crusade Spells ***/
	{
		"ٰ¸ߴ",
		"饤ȥ˥󥰥ܥ",
		"",
		"ξ",
		"Ʃǧ",
		"",
		"",
		"ʤ",
		"ե",
		"ۤ",
		"ܤ",
		"ޥåܥ",

		"ε",
		"",
		"ȥ󥭥饤",
		"ʤ륪",
		"ʤ",
		"㥤˥",
		"ʤ",
		"С",
		"ϥޥɥ",
		"ܤˤܤ",
		"ۡ꡼",
		"ƥ",
		"",

		"",
		"",
		"",
		"",
		"",
		"",
		"",
	}
};

/*
 * Each chest has a certain set of traps, determined by pval
 * Each chest has a "pval" from 1 to the chest level (max 55)
 * If the "pval" is negative then the trap has been disarmed
 * The "pval" of a chest determines the quality of its treasure
 * Note that disarming a trap on a chest also removes the lock.
 */
int chest_traps[64] =
{
	0,                                      /* 0 == empty */
	(CHEST_POISON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),                       /* 5 == best small wooden */
	0,
	(CHEST_ALARM),
	(CHEST_ALARM),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_POISON),
	(CHEST_SCATTER),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),                 /* 15 == best large wooden */
	0,
	(CHEST_ALARM),
	(CHEST_SCATTER),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_EXPLODE),                        /* 25 == best small iron */
	0,
	(CHEST_E_SUMMON),
	(CHEST_POISON | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_BIRD_STORM),
	(CHEST_POISON | CHEST_SUMMON),
	(CHEST_E_SUMMON | CHEST_ALARM),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON), /* 35 == best large iron */
	0,
	(CHEST_SUMMON | CHEST_ALARM),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_EXPLODE),
	(CHEST_BIRD_STORM),
	(CHEST_EXPLODE | CHEST_E_SUMMON | CHEST_ALARM),
	(CHEST_H_SUMMON),        /* 45 == best small steel */
	0,
	(CHEST_EXPLODE | CHEST_SUMMON | CHEST_ALARM),
	(CHEST_BIRD_STORM),
	(CHEST_RUNES_OF_EVIL),
	(CHEST_EXPLODE | CHEST_SUMMON | CHEST_ALARM),
	(CHEST_BIRD_STORM | CHEST_ALARM),
	(CHEST_H_SUMMON | CHEST_ALARM),
	(CHEST_RUNES_OF_EVIL),
	(CHEST_H_SUMMON | CHEST_SCATTER | CHEST_ALARM),
	(CHEST_RUNES_OF_EVIL | CHEST_EXPLODE),  /* 55 == best large steel */
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
};


/*
 * Class titles for the player.
 *
 * The player gets a new title every five levels, so each class
 * needs only ten titles total.
 */
cptr player_title[MAX_CLASS][PY_MAX_LEVEL / 5] =
{
	/* Soldier */
	{
		"ͽʼ",
		"ʼ",
		"ʼ",
		"ʼ",
		"Ĺ",
		"",
		"Ĺ",
		"",
		"",
		"",
	},
	/* Knight */
	{
		"",
		"",
		"鵳",
		"鵳",
		"鵳",
		"ƻ",
		"",
		"Ĺ",
		"Ĺ",
		"Ĺ",
	},
	/* Berserker */
	{
		"Ĥ",
		"Ԥ",
		"",
		"±",
		"޶",
		"޶Ԥ",
		"ήƮ",
		"ϤƮ",
		"ӻƮ",
		"Ʈ",
	},
	/* Terror-Knight */
	{
		"Ǥʤ",
		"Ѽ",
		"",
		"",
		"ͻ",
		"ڤ궸",
		"٤ڼ",
		"ε",
		"ΰ̴",
		"٤粦",
	},
	/* BeastTamer */
	{
		"Ļμ",
		"ǭμ",
		"Ϥμ",
		"ϵμ",
		"פμ",
		"μ",
		"Ҥμ",
		"äμ",
		"äμ",
		"ÿͧ",
	},
	/* Sword-Master */
	{
		"鿴",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
		"",
	},
	/* Dragoon */
	{
		"Ȥ",
		"ؤӻ",
		"ε",
		"ε",
		"ε",
		"ε",
		"ε",
		"ε",
		"ε",
		"ε",
	},
	/* Ninja */
	{
		"",
		"ż",
		"ã",
		"ûȤ",
		"ڤ",
		"",
		"ο",
		"Ǥΰ",
		"Ż",
		"Ĺ",
	},
	/* Wizard */
	{
		"ʻ",
		"ѻ",
		"ꤤ",
		"",
		"ۻ",
		"",
		"Žѻ",
		"ѻ",
		"ƻ",
		"ˡȤ",
	},
	/* Warlock */
	{
		"ࡼɼ",
		"",
		"",
		"ˡ",
		"ؽβ",
		"β",
		"",
		"ˡ",
		"õ",
		"Ƥ򼱤",
	},
	/* Exorcist */
	{
		"",
		"ƻ",
		"ʼ",
		"Żʼ",
		"ʼ",
		"",
		"ʧ",
		"ʧ",
		"Ƥļ",
		"ν跺",
	},
	/* Amazoness - same as Soldier */
	{
		"ͽʼ",
		"ʼ",
		"ʼ",
		"ʼ",
		"Ĺ",
		"",
		"Ĺ",
		"",
		"",
		"",
	},
	/* Valkyrie */
	{
		"",
		"",
		"ݤ",
		"Ф",
		"Ƽ",
		"Ƽ",
		"Ŵ",
		"Ŵ",
		"",
		"",
	},
	/* Archer */
	{
		"Ӥ",
		"פӤ",
		"ĤӤ",
		"ŴӤ",
		"Ӥ",
		"Ӥ",
		"ǤӤ",
		"Ӥ",
		"Ӥ",
		"Ӥ",
	},
	/* DragonTamer */
	{
		"μ",
		"εμ",
		"εμ",
		"εμ",
		"εμ",
		"εμ",
		"εμ",
		"εμ",
		"εμ",
		"εͧ",
	},
	/* Witch */
	{
		"Ⱦ",
		"",
		"Ф",
		"Ȥ",
		"ꤤ",
		"",
		"",
		"Ȥ",
		"󺰤",
		"ʤ",
	},
	/* Sirene - same as Wizard */
	{
		"ʻ",
		"ѻ",
		"ꤤ",
		"",
		"ۻ",
		"",
		"Žѻ",
		"ѻ",
		"ƻ",
		"ˡȤ",
	},
	/* Cleric */
	{
		"",
		"",
		"",
		"",
		"Ǥʺ",
		"",
		"ʺ",
		"ʶ",
		"ʶ",
		"ʶ",
	},
	/* Priest */
	{
		"",
		"",
		"",
		"η",
		"Ǥʺ",
		"ʺ",
		"ʶ",
		"ʶ",
		"",
		"",
	},
	/* Lich */
	{
		"ƥå",
		"Ǵγ",
		"Υå",
		"ϥå",
		"ŴΥå",
		"Ϋå",
		"ǥߥå",
		"å",
		"Ϋå",
		"ʱ򼱤",
	},
	/* Angel-Knight */
	{
		"",
		"ŷ",
		"ŷ",
		"ŷ",
		"ǽŷ",
		"ŷ",
		"ŷ",
		"ŷ",
		"ŷ",
		"ŷ",
	},
	/* High-Witch */
	{
		"ͤߤ",
		"ޥ",
		"",
		"Фڤ",
		"ߤޤ꤯",
		"",
		"",
		"",
		"",
		"̳",
	},
	/* Gunner */
	{
		"Կ",
		"̵",
		"ƻȤ",
		"",
		"Ż",
		"",
		"ʥѡ",
		"塼",
		"",
		"ļ",
	},
	/* Temple-Knight - same as Knight */
	{
		"",
		"",
		"鵳",
		"鵳",
		"鵳",
		"ƻ",
		"",
		"Ĺ",
		"Ĺ",
		"Ĺ",
	},
	/* White-Knight - same as Knight */
	{
		"",
		"",
		"鵳",
		"鵳",
		"鵳",
		"ƻ",
		"",
		"Ĺ",
		"Ĺ",
		"Ĺ",
	},
	/* Load - same as Soldier */
	{
		"ͽʼ",
		"ʼ",
		"ʼ",
		"ʼ",
		"Ĺ",
		"",
		"Ĺ",
		"",
		"",
		"",
	},
	/* General - same as Knight */
	{
		"",
		"",
		"鵳",
		"鵳",
		"鵳",
		"ƻ",
		"",
		"Ĺ",
		"Ĺ",
		"Ĺ",
	},
	/* Ninjamaster */
	{
		"",
		"ż",
		"ã",
		"ûȤ",
		"ڤ",
		"",
		"ο",
		"Ǥΰ",
		"Ż",
		"Ĺ",
	},
	/* Archmage */
	{
		"ʻ",
		"ѻ",
		"ꤤ",
		"",
		"ۻ",
		"",
		"Žѻ",
		"ѻ",
		"ƻ",
		"ˡȤ",
	},
	/* Freya */
	{
		"",
		"",
		"ݤ",
		"Ф",
		"Ƽ",
		"Ƽ",
		"Ŵ",
		"Ŵ",
		"",
		"ﲵ",
	},
	/* Crescent */
	{
		"Ӥ",
		"פӤ",
		"ĤӤ",
		"ŴӤ",
		"Ӥ",
		"Ӥ",
		"ǤӤ",
		"Ӥ",
		"Ӥ",
		"ƥߥ",
	},
	/* Vampire */
	{
		"۷ʪ",
		"۷ʪ",
		"۷ʪ",
		"۷ʪ",
		"",
		"",
		"벦",
		"λۼ",
		"Ǥλۼ",
		"",
	},
};


/*
 * Hack -- the "basic" color names (see "TERM_xxx")
 */
cptr color_names[16] =
{
#ifdef JP
	"",
	"",
	"ĳ",
	"",
	"",
	"",
	"",
	"ῧ",
	"",
	"ĳ",
	"",
	"",
	"뤤",
	"뤤",
	"뤤",
	"ῧ",
#else
	"Dark",
	"White",
	"Slate",
	"Orange",
	"Red",
	"Green",
	"Blue",
	"Umber",
	"Light Dark",
	"Light Slate",
	"Violet",
	"Yellow",
	"Light Red",
	"Light Green",
	"Light Blue",
	"Light Umber",
#endif

};


/*
 * Abbreviations of healthy stats
 */
cptr stat_names[A_MAX] =
{
#ifdef JP
	" :", "ǽ :", " :", " :", "ѵ :", "̥ :"
#else
	"STR : ", "INT : ", "WIS : ", "DEX : ", "CON : ", "CHR : "
#endif

};

/*
 * Abbreviations of damaged stats
 */
cptr stat_names_reduced[A_MAX] =
{
#ifdef JP
	"x:", "ǽx:", "x:", "x:", "ѵx:", "̥x:"
#else
	"Str : ", "Int : ", "Wis : ", "Dex : ", "Con : ", "Chr : "
#endif

};


/*
 * Certain "screens" always use the main screen, including News, Birth,
 * Dungeon, Tomb-stone, High-scores, Macros, Colors, Visuals, Options.
 *
 * Later, special flags may allow sub-windows to "steal" stuff from the
 * main window, including File dump (help), File dump (artifacts, uniques),
 * Character screen, Small scale map, Previous Messages, Store screen, etc.
 *
 * The "ctrl-i" (tab) command flips the "Display inven/equip" and "Display
 * equip/inven" flags for all windows.
 *
 * The "ctrl-g" command (or pseudo-command) should perhaps grab a snapshot
 * of the main screen into any interested windows.
 */
cptr window_flag_desc[32] =
{
#ifdef JP
	"ʪ/",
#else
	"Display inven/equip",
#endif

#ifdef JP
	"/ʪ",
#else
	"Display equip/inven",
#endif

#ifdef JP
	"ʸ",
#else
	"Display spell list",
#endif

#ifdef JP
	"饯",
#else
	"Display character",
#endif

	NULL,
	NULL,
#ifdef JP
	"å",
#else
	"Display messages",
#endif

#ifdef JP
	"󥸥ο",
#else
	"Display overhead view",
#endif

#ifdef JP
	"󥹥λפ",
#else
	"Display monster recall",
#endif

#ifdef JP
	"ƥξܺ",
#else
	"Display object recall",
#endif

#ifdef JP
	"ʬμϤɽ", 
#else
	"Display dungeon view",
#endif

#ifdef JP
	"ǰ",
#else
	"Display snap-shot",
#endif

	NULL,
	NULL,
#ifdef JP
	"ܡå",
#else
	"Display borg messages",
#endif

#ifdef JP
	"ܡơ",
#else
	"Display borg status",
#endif

	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};


/*
 * Available Options
 *
 */
option_type option_info[] =
{
	/*** Input Options ***/

#ifdef JP
	{ &rogue_like_commands,         FALSE, 1, 0, 0,
	"rogue_like_commands",          "֤Ѥ" },
#else
	{ &rogue_like_commands,         FALSE, 1, 0, 0,
	"rogue_like_commands",          "Rogue-like commands" },
#endif


#ifdef JP
	{ &always_pickup,               FALSE, 1, 0, 5,
	"always_pickup",                "˥ƥ򽦤" },
#else
	{ &always_pickup,               FALSE,  1, 0, 5,
	"always_pickup",                "Pick things up by default" },
#endif


#ifdef JP
	{ &carry_query_flag,            FALSE, 1, 0, 3,
	"carry_query_flag",  "ƥ򽦤˳ǧ" },
#else
	{ &carry_query_flag,            FALSE, 1, 0, 3,
	"carry_query_flag",             "Prompt before picking things up" },
#endif


#ifdef JP
	{ &quick_messages,              TRUE,  1, 0, 1,
	"quick_messages",  "ååѤ" },
#else
	{ &quick_messages,              TRUE,  1, 0, 1,
	"quick_messages",               "Activate quick messages" },
#endif


#ifdef JP
	{ &auto_more,                   FALSE, 1, 2, 6,
	"auto_more",                    "ԤʤϢ³ǥåɽ" },
#else
	{ &auto_more,                   FALSE, 1, 2, 6,
	"auto_more",                    "Automatically clear '-more-' prompts" },
#endif


#ifdef JP
	{ &command_menu,                TRUE,  1, 2, 7,
	"command_menu",                 "˥塼ˤꥳޥͭˤ" },
#else
	{ &command_menu,                TRUE,  1, 2, 7,
	"command_menu",                 "Enable command selection menu" },
#endif


#ifdef JP
	{ &other_query_flag,            FALSE, 1, 0, 2,
	"other_query_flag",             "ΥƥѤȤ˳ǧ" },
#else
	{ &other_query_flag,            FALSE, 1, 0, 2,
	"other_query_flag",             "Prompt for floor item selection" },
#endif


#ifdef JP
	{ &use_old_target,              FALSE, 1, 0, 4,
	"use_old_target",  "˰ΥåȤꤹ" },
#else
	{ &use_old_target,              FALSE, 1, 0, 4,
	"use_old_target",               "Use old target by default" },
#endif


#ifdef JP
	{ &always_repeat,               TRUE,  1, 0, 6,
	"always_repeat",                "ޥɼư֤" },
#else
	{ &always_repeat,               TRUE,  1, 0, 6,
	"always_repeat",                "Repeat obvious commands" },
#endif


#ifdef JP
	{ &confirm_destroy,             FALSE, 1, 5, 3,
	"confirm_destroy",              "̵͡פʥƥ˲ǧ" },
#else
	{ &confirm_destroy,             FALSE, 1, 5, 3,
	"confirm_destroy",              "Prompt for destruction of known worthless items" },
#endif


#ifdef JP
	{ &confirm_wear,                TRUE, 1, 5, 4,
	"confirm_wear",                 "줿ʪǧ" },
#else
	{ &confirm_wear,                TRUE, 1, 5, 4,
	"confirm_wear",                 "Confirm to wear/wield known cursed items" },
#endif


#ifdef JP
	{ &confirm_quest,               TRUE, 1, 1, 9,
	"confirm_quest",                "ȤƳʤƨ˳ǧ" },
#else
	{ &confirm_quest,               TRUE, 1, 1, 9,
	"confirm_quest",                "Prompt before exiting a quest level" },
#endif


#ifdef JP
	{ &target_pet,                  FALSE,  1, 2, 5,
	"target_pet",                   "ڥåȤ򥿡åȤˤ" },
#else
	{ &target_pet,                  FALSE,  1, 2, 5,
	"target_pet",                   "Allow targetting pets" },
#endif


#ifdef ALLOW_EASY_OPEN
#ifdef JP
	{ &easy_open,                   TRUE,  1, 5, 7,
	"easy_open",                    "ưŪ˥ɥ򳫤" },
#else
	{ &easy_open,                   TRUE,  1, 5, 7,
	"easy_open",                    "Automatically open doors" },
#endif
#endif /* ALLOW_EASY_OPEN */


#ifdef ALLOW_EASY_DISARM
#ifdef JP
	{ &easy_disarm,                 TRUE,  1, 5, 8,
	"easy_disarm",                  "ưŪ櫤" },
#else
	{ &easy_disarm,                 TRUE,  1, 5, 8,
	"easy_disarm",                  "Automatically disarm traps" },
#endif
#endif /* ALLOW_EASY_DISARM */


#ifdef ALLOW_EASY_FLOOR /* TNB */
#ifdef JP
	{ &easy_floor,                  FALSE, 1, 5, 9,
	"easy_floor",                   "ǽŤʤäƥꥹȤ" },
#else
	{ &easy_floor,                  FALSE, 1, 5, 9,
	"easy_floor",                   "Display floor stacks in a list" },
#endif
#endif /* ALLOW_EASY_FLOOR -- TNB */


#ifdef JP
	{ &use_command,                 FALSE, 1, 5, 10,
	"use_command",                  "ֻȤ(a)ץޥɤǥƥ򲿤ǤȤ" },
#else
	{ &use_command,                 FALSE, 1, 5, 10,
	"use_command",                  "Allow unified use command" },
#endif


#ifdef JP
	{ &over_exert,                  FALSE,  1, 0, 29,
	"over_exert",                   "MP­ʤƤˡĩ魯" },
#else
	{ &over_exert,                  FALSE,  1, 0, 29,
	"over_exert",                   "Allow casting spells when short of mana" },
#endif


	/*** Output Options ***/

#ifdef JP
	{ &depth_in_feet,               FALSE, 2, 0, 7,
	"depth_in_feet",                "󥸥οեȤɽ" },
#else
	{ &depth_in_feet,               FALSE, 2, 0, 7,
	"depth_in_feet",                "Show dungeon level in feet" },
#endif


#ifdef JP
	{ &show_labels,                 TRUE,  2, 0, 10,
	"show_labels",                  "ɽ" },
#else
	{ &show_labels,                 TRUE,  2, 0, 10,
	"show_labels",                  "Show labels in object listings" },
#endif


#ifdef JP
	{ &show_weights,                TRUE,  2, 0, 11,
	"show_weights",                 "ƥǽ̤ɽ" },
#else
	{ &show_weights,                TRUE,  2, 0, 11,
	"show_weights",                 "Show weights in object listings" },
#endif


#ifdef JP
	{ &show_item_graph,             TRUE,  2, 2, 0,
	"show_item_graph",              "ƥΥܥɽ" },
#else
	{ &show_item_graph,             TRUE,  2, 2, 0,
	"show_item_graph",              "Show items graphics" },
#endif


#ifdef JP
	{ &show_choices,                TRUE,  2, 0, 12,
	"show_choices",                 "ʪ/ɥ򥢥ƥɽ" },
#else
	{ &show_choices,                TRUE,  2, 0, 12,
	"show_choices",                 "Show choices in certain sub-windows" },
#endif


#ifdef JP
	{ &plain_pickup,                FALSE, 2, 6, 6,
	"plain_pickup",                 "ֽäץåά" },
#else
	{ &plain_pickup,                FALSE,99, 6, 6,
	"plain_pickup",                 "Plain pickup messages(japanese only)" },
#endif


#ifdef JP
	{ &player_symbols,              FALSE, 2, 1, 13,
	"player_symbols",               "ץ쥤䡼̤ʵɽ"},
#else
	{ &player_symbols,              FALSE, 2, 1, 13,
	"player_symbols",               "Use special symbols for the player char"},
#endif


#ifdef JP
	{ &equippy_chars,               TRUE,  2, 1, 12,
	"equippy_chars",                "ơʸɽ" },
#else
	{ &equippy_chars,               TRUE,  2, 1, 12,
	"equippy_chars",                "Display 'equippy' chars" },
#endif


#ifdef JP
	{ &display_mutations,              FALSE, 2, 5, 0,
	"display_mutations",               "'C'ޥɤѰۤɽ" },
#else
	{ &display_mutations,              FALSE, 2, 5, 0,
	"display_mutations",               "Display mutations in 'C'haracter Display" },
#endif


#ifdef JP
	{ &plain_descriptions,          TRUE, 2, 5, 1,
	"plain_descriptions",           "ƥεҤάˤ" },
#else
	{ &plain_descriptions,          TRUE, 2, 5, 1,
	"plain_descriptions",           "Plain object descriptions" },
#endif


#ifdef JP
	{ &center_player,               FALSE, 2, 5, 11,
	"center_player",                "˥ץ쥤䡼濴֤(*٤*)" },
#else
	{ &center_player,               FALSE, 2, 5, 11,
	"center_player",                "Center map while walking (*slow*)" },
#endif


#ifdef JP
	{ &center_running,              TRUE,  2, 5, 12,
	"center_running",               "äƤǤ濴֤" },
#else
	{ &center_running,              TRUE,  2, 5, 12,
	"center_running",               "Centering even while running" },
#endif


#ifdef JP
	{ &view_yellow_lite,            TRUE,  2, 1, 28,
	"view_yellow_lite",              "ϰϤ̤ʿɽ" },
#else
	{ &view_yellow_lite,            TRUE,  2, 1, 28,
	"view_yellow_lite",             "Use special colors for torch-lit grids" },
#endif


#ifdef JP
	{ &view_bright_lite,            TRUE,  2, 1, 29,
	"view_bright_lite",             "볦ϰϤ̤ʿɽ" },
#else
	{ &view_bright_lite,            TRUE,  2, 1, 29,
	"view_bright_lite",             "Use special colors for 'viewable' grids" },
#endif


#ifdef JP
	{ &view_granite_lite,           TRUE,  2, 1, 30,
	"view_granite_lite",            "ɤ̤ʿɽ(Ť)" },
#else
	{ &view_granite_lite,           TRUE,  2, 1, 30,
	"view_granite_lite",            "Use special colors for wall grids (slow)" },
#endif


#ifdef JP
	{ &view_special_lite,           TRUE,  2, 1, 31,
	"view_special_lite",            "̤ʿɽ(Ť)" },
#else
	{ &view_special_lite,           TRUE,  2, 1, 31,
	"view_special_lite",            "Use special colors for floor grids (slow)" },
#endif

#ifdef JP
	{ &new_ascii_graphics,          FALSE, 2, 2, 4,
	"new_ascii_graphics",           "ϷŤϤäɽ" },
#else
	{ &new_ascii_graphics,          FALSE, 2, 2, 4,
	"new_ascii_graphics",           "Show a clear contrast between light and dark" },
#endif

#ifdef JP
	{ &use_fake_monochrome,         FALSE, 2, 4, 2,
	"use_fake_monochrome",          "̤ʾǥΥɽˤ" },
#else
	{ &use_fake_monochrome,         FALSE, 2, 4, 2,
	"use_fake_monochrome",          "Use monochrome display on special occasion" },
#endif

#ifdef JP
	{ &display_path,                FALSE, 2, 2, 8,
	"display_path",                 "ˡεפɽ" },
#else
	{ &display_path,                FALSE, 2, 2, 8,
	"display_path",                 "Display actual path before shooting" },
#endif


#ifdef JP
	{ &always_show_list,            TRUE,  2, 4, 0,
	"always_show_list",             "ˤϾ˰ɽ" },
#else
	{ &always_show_list,            TRUE,  2, 4, 0,
	"always_show_list",             "Always show list at first when select items" },
#endif


#ifdef JP
	{ &change_numeral,              TRUE,  2, 4, 5,
	"change_numeral",               "ƥμˤäƿѤ" },
#else
	{ &change_numeral,              TRUE,  99, 4, 5,
	"change_numeral",               "Change a way to counting (japanese only)" },
#endif


	/*** Game-Play ***/

#ifdef JP
	{ &auto_scum,                   FALSE, 3, 1, 1,
	"auto_scum",                    "ʷϵư깥" },
#else
	{ &auto_scum,                   FALSE, 3, 1, 1,
	"auto_scum",                    "Auto-scum for good levels" },
#endif


#ifdef JP
	{ &stack_force_notes,           TRUE,  3, 0, 8,
	"stack_force_notes",            "ۤʤäΥƥޤȤ" },
#else
	{ &stack_force_notes,           TRUE,  3, 0, 8,
	"stack_force_notes",            "Merge inscriptions when stacking" },
#endif


#ifdef JP
	{ &stack_force_costs,           FALSE, 3, 0, 9,
	"stack_force_costs",            "ۤʤɽΥƥޤȤ" },
#else
	{ &stack_force_costs,           FALSE, 3, 0, 9,
	"stack_force_costs",            "Merge discounts when stacking" },
#endif


#ifdef JP
	{ &stack_allow_items,           TRUE,  3, 1, 2,
	"stack_allow_items",            "ƱɶޤȤ" },
#else
	{ &stack_allow_items,           TRUE,  3, 1, 2,
	"stack_allow_items",            "Allow weapons and armor to stack" },
#endif


#ifdef JP
	{ &expand_look,                 TRUE,  3, 1, 4,
	"expand_look",                  "ֲĴ٤ץޥɤĥ" },
#else
	{ &expand_look,                 TRUE,  3, 1, 4,
	"expand_look",                  "Expand the power of the look command" },
#endif


#ifdef JP
	{ &expand_list,                 TRUE,  3, 1, 5,
	"expand_list",                  "ְץޥɤĥ" },
#else
	{ &expand_list,                 TRUE,  3, 1, 5,
	"expand_list",                  "Expand the power of the list commands" },
#endif


#ifdef JP
	{ &view_perma_grids,            TRUE,  3, 1, 6,
	"view_perma_grids",             "뤤ϤΤޤޤˤ" },
#else
	{ &view_perma_grids,            TRUE,  3, 1, 6,
	"view_perma_grids",             "Map remembers all perma-lit grids" },
#endif


#ifdef JP
	{ &view_torch_grids,            FALSE, 3, 1, 7,
	"view_torch_grids",             "ǾȤ餷ϤΤޤޤˤ" },
#else
	{ &view_torch_grids,            FALSE, 3, 1, 7,
	"view_torch_grids",             "Map remembers all torch-lit grids" },
#endif


#ifdef JP
	{ &view_unsafe_grids,            FALSE, 3, 1, 8,
	"view_unsafe_grids",             "ȥå״κѤߤǤʤɽ" },
#else
	{ &view_unsafe_grids,            FALSE, 3, 1, 8,
	"view_unsafe_grids",             "Map marked by detect traps" },
#endif


#ifdef JP
	{ &show_damage,                  TRUE, 3, 4, 1,
	"show_damage",                   "/Ϳ᡼ɽ" },
#else
	{ &show_damage,                  TRUE, 3, 4, 1,
	"show_damage",                   "Show done/taken damage" },
#endif


#ifdef JP
	{ &small_levels,                TRUE,  3, 0, 30,
	"small_levels",                 "˾եǽˤ" },
#else
	{ &small_levels,                TRUE,  3, 0, 30,
	"small_levels",                 "Allow unusually small dungeon levels" },
#endif


#ifdef JP
	{ &always_small_levels,         FALSE, 3, 2, 3,
	"always_small_levels",          "˾ե" },
#else
	{ &always_small_levels,         FALSE, 3, 2, 3,
	"always_small_levels",          "Always create unusually small dungeon levels" },
#endif


#ifdef JP
	{ &empty_levels,                TRUE,  3, 0, 31,
	"empty_levels",                 "äݤΡ֥꡼ʡץ٥ǽˤ" },
#else
	{ &empty_levels,                TRUE,  3, 0, 31,
	"empty_levels",                 "Allow empty 'arena' levels" },
#endif


#ifdef JP
	{ &last_words,                  TRUE, 3, 0, 28,
	"last_words",                   "饯Τ" },
#else
	{ &last_words,                  TRUE, 3, 0, 28,
	"last_words",                   "Leave last words when your character dies" },
#endif


#ifdef JP
	{ &allow_debug_opts,            FALSE, 3, 6, 11,
	"allow_debug_opts",             "ǥХå/ץĤ" },
#else
	{ &allow_debug_opts,            FALSE, 3, 6, 11,
	"allow_debug_opts",             "Allow use of debug/cheat options" },
#endif


	/*** Disturbance ***/

#ifdef JP
	{ &find_ignore_stairs,          FALSE, 4, 0, 16,
	"find_ignore_stairs",           "ʤ̲᤹" },
#else
	{ &find_ignore_stairs,          FALSE, 4, 0, 16,
	"find_ignore_stairs",           "Run past stairs" },
#endif


#ifdef JP
	{ &find_ignore_doors,           TRUE,  4, 0, 17,
	"find_ignore_doors",            "ɥ̲᤹" },
#else
	{ &find_ignore_doors,           TRUE,  4, 0, 17,
	"find_ignore_doors",            "Run through open doors" },
#endif


#ifdef JP
	{ &find_cut,                    FALSE, 4, 0, 18,
	"find_cut",                     "ʤѤФ˺ûΥ̲᤹" },
#else
	{ &find_cut,                    FALSE, 4, 0, 18,
	"find_cut",                     "Run past known corners" },
#endif


#ifdef JP
	{ &find_examine,                TRUE,  4, 0, 19,
	"find_examine",                 "ϩŤˤʤ٤ʤѤȲꤷ̲᤹" },
#else
	{ &find_examine,                TRUE,  4, 0, 19,
	"find_examine",                 "Run into potential corners" },
#endif


#ifdef JP
	{ &disturb_move,                FALSE,  4, 0, 20,
	"disturb_move",                 "ɤΥ󥹥ưƤưߤ" },
#else
	{ &disturb_move,                FALSE,  4, 0, 20,
	"disturb_move",                 "Disturb whenever any monster moves" },
#endif


#ifdef JP
	{ &disturb_high,                FALSE,  4, 1, 3,
	"disturb_high",                 "٥ι⤤󥹥ưưߤ"},
#else
	{ &disturb_high,                FALSE,  4, 1, 3,
	"disturb_high",                 "Disturb whenever high-level monster moves" },
#endif


#ifdef JP
	{ &disturb_near,                TRUE,  4, 0, 21,
	"disturb_near",                 "볦Υ󥹥ưưߤ" },
#else
	{ &disturb_near,                TRUE,  4, 0, 21,
	"disturb_near",                 "Disturb whenever viewable monster moves" },
#endif


#ifdef JP
	{ &disturb_pets,                FALSE, 4, 5, 6,
	"disturb_pets",                 "볦ΥڥåȤưưߤ" },
#else
	{ &disturb_pets,                FALSE, 4, 5, 6,
	"disturb_pets",                 "Disturb when visible pets move" },
#endif


#ifdef JP
	{ &disturb_panel,               TRUE,  4, 0, 22,
	"disturb_panel",                "̥˹ưߤ" },
#else
	{ &disturb_panel,               TRUE,  4, 0, 22,
	"disturb_panel",                "Disturb whenever map panel changes" },
#endif


#ifdef JP
	{ &disturb_state,               TRUE,  4, 0, 23,
	"disturb_state",                "ʬΥơѲ˹ưߤ" },
#else
	{ &disturb_state,               TRUE,  4, 0, 23,
	"disturb_state",                "Disturb whenever player state changes" },
#endif


#ifdef JP
	{ &disturb_minor,               TRUE,  4, 0, 24,
	"disturb_minor",                "٤ʤȤƤưߤ" },
#else
	{ &disturb_minor,               TRUE,  4, 0, 24,
	"disturb_minor",                "Disturb whenever boring things happen" },
#endif


#ifdef JP
	{ &ring_bell,                   FALSE, 4, 0, 14,
	"ring_bell",                    "顼˥ӡײĤ餹" },
#else
	{ &ring_bell,                   FALSE, 4, 0, 14,
	"ring_bell",                    "Audible bell (on errors, etc)" },
#endif


#ifdef JP
	{ &alert_hitpoint,              TRUE, 4, 0, 26,
	"alert_hitpoint",               "ҥåȥݥȤηٹ˥ӡפĤ餹" },
#else
	{ &alert_hitpoint,              TRUE, 4, 0, 26,
	"alert_hitpoint",               "Alert user to critical hitpoints" },
#endif


#ifdef JP
	{ &disturb_trap_detect,         TRUE, 4, 0, 27,
	"disturb_trap_detect",          "ȥå״ϰϳ˽Фľ˹ưߤ" },
#else
	{ &disturb_trap_detect,         TRUE, 4, 0, 27,
	"disturb_trap_detect",          "Disturb when leaving trap detected area"},
#endif

#ifdef JP
	{ &alert_trap_detect,           FALSE, 4, 0, 25,
	"alert_trap_detect",            "ȥå״ϰϳ˽Фľ˷ٹ𤹤" },
#else
	{ &alert_trap_detect,           FALSE, 4, 0, 25,
	"alert_trap_detect",            "Alert when leaving trap detected area"},
#endif


	/*** Efficiency ***/

#ifdef JP
	{ &view_reduce_lite,            FALSE, 5, 1, 16,
	"view_reduce_lite",             "äƤȤȾ¤򸺾" },
#else
	{ &view_reduce_lite,            FALSE, 5, 1, 16,
	"view_reduce_lite",             "Reduce lite-radius when running" },
#endif


#ifdef JP
	{ &view_reduce_view,            FALSE, 5, 1, 17,
	"view_reduce_view",             "Ǥϻ򶹤" },
#else
	{ &view_reduce_view,            FALSE, 5, 1, 17,
	"view_reduce_view",             "Reduce view-radius in town" },
#endif


#ifdef JP
	{ &check_abort,                 TRUE,  5, 1, 18,
	"check_abort",                  "Ϣ³ޥɤϥϤǤ" },
#else
	{ &check_abort,                 TRUE,  5, 1, 18,
	"check_abort",                  "Check for user abort while continuous command" },
#endif


#ifdef JP
	{ &flush_failure,               TRUE,  5, 1, 20,
	"flush_failure",                "͡ʥߥȯϤ򥯥ꥢ" },
#else
	{ &flush_failure,               TRUE,  5, 1, 20,
	"flush_failure",                "Flush input on various failures" },
#endif


#ifdef JP
	{ &flush_disturb,               FALSE, 5, 1, 21,
	"flush_disturb",                "㳲ȯϤ򥯥ꥢ" },
#else
	{ &flush_disturb,               FALSE, 5, 1, 21,
	"flush_disturb",                "Flush input whenever disturbed" },
#endif


#ifdef JP
	{ &fresh_before,                TRUE,  5, 1, 23,
	"fresh_before",                 "Ϣ³ޥ˲̤褷³" },
#else
	{ &fresh_before,                TRUE,  5, 1, 23,
	"fresh_before",                 "Flush output while continuous command" },
#endif


#ifdef JP
	{ &fresh_after,                 FALSE, 5, 1, 24,
	"fresh_after",                  "ޥɸ˲̤˺褷³" },
#else
	{ &fresh_after,                 FALSE, 5, 1, 24,
	"fresh_after",                  "Flush output after monster's move" },
#endif


#ifdef JP
	{ &fresh_message,               FALSE, 5, 1, 25,
	"fresh_message",                "åθ˲̤褹" },
#else
	{ &fresh_message,               FALSE, 5, 1, 25,
	"fresh_message",                "Flush output after every message" },
#endif


#ifdef JP
	{ &compress_savefile,           FALSE, 5, 1, 26,
	"compress_savefile",            "֡եΥå򰵽̤" },
#else
	{ &compress_savefile,           FALSE, 5, 1, 26,
	"compress_savefile",            "Compress messages in savefiles" },
#endif


#ifdef JP
	{ &hilite_player,               FALSE,  5, 1, 27,
	"hilite_player",                "ץ쥤䡼˥碌" },
#else
	{ &hilite_player,               FALSE,  5, 1, 27,
	"hilite_player",                "Hilite the player with the cursor" },
#endif


	/*** Birth Options ***/

#ifdef JP
	{ &manual_haggle,               FALSE, 6, 1, 0,
	"manual_haggle",                "ŹڤĤ򤹤" },
#else
	{ &manual_haggle,               FALSE, 6, 1, 0,
	"manual_haggle",                "Manually haggle in stores" },
#endif


#ifdef JP
	{ &easy_band,                   FALSE, 6, 6, 31,
	"easy_band",                    "鿴Ѵñ⡼(*)" },
#else
	{ &easy_band,                   FALSE, 6, 6, 31,
	"easy_band",                    "Easy Mode (*)" },
#endif


#ifdef JP
	{ &smart_learn,                 TRUE,  6, 1, 14,
	"smart_learn",                  "󥹥ϼԤؽ(*)" },
#else
	{ &smart_learn,                 TRUE,  6, 1, 14,
	"smart_learn",                  "Monsters learn from their mistakes (*)" },
#endif


#ifdef JP
	{ &smart_cheat,                 FALSE, 6, 1, 15,
	"smart_cheat",                  "󥹥ϥץ쥤䡼μߤͤ(*)" },
#else
	{ &smart_cheat,                 FALSE, 6, 1, 15,
	"smart_cheat",                  "Monsters exploit players weaknesses (*)" },
#endif


#ifdef JP
	{ &ironman_rooms,                FALSE, 6, 6, 12,
	"ironman_rooms",                 "Ŵѡ˾̤Ǥʤ(*)" },
#else
	{ &ironman_rooms,               FALSE, 6, 6, 12,
	"ironman_rooms",                "Always generate very unusual rooms (*)" },
#endif


#ifdef JP
	{ &left_hander,                 FALSE, 6, 6, 13,
	"left_hander",                  "Ǥ" },
#else
	{ &left_hander,                 FALSE, 6, 6, 13,
	"left_hander",                  "Left-Hander" },
#endif


#ifdef JP
	{ &preserve_mode,               TRUE,  6, 6, 14,
	"preserve_mode",                "ΥƥƨƤ(*)" },
#else
	{ &preserve_mode,               TRUE,  6, 6, 14,
	"preserve_mode",                "Preserve artifacts (*)" },
#endif


#ifdef JP
	{ &powerup_home,                TRUE,  6, 4, 3,
	"powerup_home",                 "椬Ȥĥ(*)" },

#else
	{ &powerup_home,                TRUE,  6, 4, 3,
	"powerup_home",                 "Increase capacity of your home (*)" },
#endif


	/*** Easy Object Auto-Destroyer ***/

#ifdef JP
	{ &destroy_items,               FALSE, 7, 7, 0,
	"destroy_items",                "ƥδʰ׼ư˲Ѥ" },
#else
	{ &destroy_items,               FALSE, 7, 7, 0,
	"destroy_items",                "Use easy auto-destroyer" },
#endif

#ifdef JP
	{ &destroy_feeling,               FALSE, 7, 7, 8,
	"destroy_feeling",                "ʰ״ꤷȤư˲ŬѤ" },
#else
	{ &destroy_feeling,               FALSE, 7, 7, 8,
	"destroy_feeling",                "Apply auto-destroy as sense feeling" },
#endif

#ifdef JP
	{ &destroy_identify,               FALSE, 7, 7, 9,
	"destroy_identify",                "ꤷȤư˲ŬѤ" },
#else
	{ &destroy_identify,               FALSE, 7, 7, 9,
	"destroy_identify",                "Apply auto-destroy as identify an item" },
#endif

#ifdef JP
	{ &leave_worth,                 TRUE, 7, 7, 2,
	"leave_worth",                  "ͤ륢ƥϲʤ" },
#else
	{ &leave_worth,                 TRUE, 7, 7, 2,
	"leave_worth",                  "Auto-destroyer leaves known worthy items" },
#endif

#ifdef JP
	{ &leave_equip,                 FALSE, 7, 7, 3,
	"leave_equip",                  "/ɶϲʤ" },
#else
	{ &leave_equip,                 FALSE, 7, 7, 3,
	"leave_equip",                  "Auto-destroyer leaves weapons and armour" },
#endif

#ifdef JP
	{ &leave_chest,                 TRUE, 7, 7, 7,
	"leave_chest",                  "ƤʤȢϲʤ" },
#else
	{ &leave_chest,                 TRUE, 7, 7, 7,
	"leave_chest",                  "Auto-destroyer leaves closed chests" },
#endif

#ifdef JP
	{ &leave_wanted,                TRUE, 7, 7, 4,
	"leave_wanted",                 "޶λ/ϲʤ" },
#else
	{ &leave_wanted,                TRUE, 7, 7, 4,
	"leave_wanted",                 "Auto-destroyer leaves wanted corpses" },
#endif

#ifdef JP
	{ &leave_corpse,                FALSE, 7, 7, 5,
	"leave_corpse",                 "/ϲʤ" },
#else
	{ &leave_corpse,                FALSE, 7, 7, 5,
	"leave_corpse",                 "Auto-destroyer leaves corpses and skeletons" },
#endif

#ifdef JP
	{ &leave_junk,                  FALSE, 7, 7, 6,
	"leave_junk",                   "餯ϲʤ" },
#else
	{ &leave_junk,                  FALSE, 7, 7, 6,
	"leave_junk",                   "Auto-destroyer leaves junk" },
#endif

#ifdef JP
	{ &leave_special,               TRUE, 7, 7, 1,
	"leave_special",                "²/Ȥ̤ɬפʥƥϲʤ" },
#else
	{ &leave_special,               TRUE, 7, 7, 1,
	"leave_special",                "Auto-destroyer leaves items your race/class needs" },
#endif


	/*** Play-record Options ***/

#ifdef JP
	{ &record_fix_art,              TRUE, 10, 4, 11,
	"record_fix_art",               "ꥢƥեȤϿ" },
#else
	{ &record_fix_art,              TRUE, 10, 4, 11,
	"record_fix_art",               "Record fixed artifacts" },
#endif

#ifdef JP
	{ &record_rand_art,             TRUE, 10, 4, 12,
	"record_rand_art",              "ॢƥեȤϿ" },
#else
	{ &record_rand_art,             TRUE, 10, 4, 12,
	"record_rand_art",              "Record random artifacts" },
#endif

#ifdef JP
	{ &record_destroy_uniq,         TRUE, 10, 4, 13,
	"record_destroy_uniq",          "ˡ󥹥ݤȤϿ" },
#else
	{ &record_destroy_uniq,         TRUE, 10, 4, 13,
	"record_destroy_uniq",          "Record when destroy unique monster" },
#endif

#ifdef JP
	{ &record_fix_quest,            TRUE, 10, 4, 14,
	"record_fix_quest",             "ꥯȤãϿ" },
#else
	{ &record_fix_quest,            TRUE, 10, 4, 14,
	"record_fix_quest",             "Record fixed quests" },
#endif

#ifdef JP
	{ &record_rand_quest,           TRUE, 10, 4, 15,
	"record_rand_quest",            "९ȤãϿ" },
#else
	{ &record_rand_quest,           TRUE, 10, 4, 15,
	"record_rand_quest",            "Record random quests" },
#endif

#ifdef JP
	{ &record_maxdeapth,            TRUE, 10, 4, 16,
	"record_maxdeapth",             "ǿ򹹿Ȥ˵Ͽ" },
#else
	{ &record_maxdeapth,            TRUE, 10, 4, 16,
	"record_maxdeapth",             "Record movements to deepest level" },
#endif

#ifdef JP
	{ &record_stair,                TRUE, 10, 4, 17,
	"record_stair",                 "ΰưϿ" },
#else
	{ &record_stair,                TRUE, 10, 4, 17,
	"record_stair",                 "Record recall and stair movements" },
#endif

#ifdef JP
	{ &record_buy,                  TRUE, 10, 4, 18,
	"record_buy",                   "ƥιϿ" },
#else
	{ &record_buy,                  TRUE, 10, 4, 18,
	"record_buy",                   "Record purchased items" },
#endif

#ifdef JP
	{ &record_sell,                 FALSE, 10, 4, 19,
	"record_sell",                  "ƥѤϿ" },
#else
	{ &record_sell,                 FALSE, 10, 4, 19,
	"record_sell",                  "Record sold items" },
#endif

#ifdef JP
	{ &record_danger,               TRUE, 10, 4, 20,
	"record_danger",                "ԥˤʤäȤϿ" },
#else
	{ &record_danger,               TRUE, 10, 4, 20,
	"record_danger",                "Record hitpoint warning" },
#endif

#ifdef JP
	{ &record_arena,                TRUE, 10, 4, 21,
	"record_arena",                 "꡼ʤǤξϿ" },
#else
	{ &record_arena,                TRUE, 10, 4, 21,
	"record_arena",                 "Record arena victories" },
#endif

#ifdef JP
	{ &record_ident,                TRUE, 10, 4, 22,
	"record_ident",                 "̤ȽΥƥμ̤Ͽ" },
#else
	{ &record_ident,                TRUE, 10, 4, 22,
	"record_ident",                 "Record first identified items" },
#endif

#ifdef JP
	{ &record_named_pet,            FALSE, 10, 4, 23,
	"record_named_pet",             "̾ĤڥåȤξϿ" },
#else
	{ &record_named_pet,            FALSE, 10, 4, 23,
	"record_named_pet",             "Record informations of named pets" },
#endif


	/*** End of Table ***/

	{ NULL,                         0, 0, 0, 0,
	NULL,                           NULL }
};




martial_arts ma_blows[MAX_MA] =
{
#ifdef JP
	{ "%s򲥤ä",                 SKILL_LEVEL_BEGINNER,  0,  1,  5,  0 },
	{ "%s򽳤ä",                 SKILL_LEVEL_BEGINNER,  0,  1,  7,  0 },
	{ "%sͤ򤯤路",   SKILL_LEVEL_NOVICE,    0,  1,  9,  0 },
	{ "%sɨ򤯤路",     SKILL_LEVEL_NOVICE,    5,  2,  4, MA_KNEE },
	{ "%sɪǤ򤯤路",     SKILL_LEVEL_NOVICE,    5,  1, 12,  0 },
	{ "%sꤷ",             SKILL_LEVEL_AVERAGE,  10,  2,  6,  0 },
	{ "%s򽳤ä",                 SKILL_LEVEL_AVERAGE,  10,  3,  6, MA_SLOW },
	{ "%s˥åѡ򤯤路",   SKILL_LEVEL_AVERAGE,  12,  5,  5,  6 },
	{ "%sʽ򤯤路",   SKILL_LEVEL_SKILLED,  15,  5,  6,  8 },
	{ "%sǭ޷򤯤路",     SKILL_LEVEL_SKILLED,  20,  5,  8,  0 },
	{ "%sķӤ򤯤路",     SKILL_LEVEL_SKILLED,  25,  6,  8, 10 },
	{ "%s޽򤯤路",     SKILL_LEVEL_EXPERT,   25,  7,  9,  0 },
	{ "%s˲󤷽򤯤路",   SKILL_LEVEL_EXPERT,   30,  8, 10, 10 },
	{ "%sŴ򤯤路",     SKILL_LEVEL_EXPERT,   35,  8, 11, 10 },
	{ "%sӤ򤯤路",     SKILL_LEVEL_MASTER,   35,  8, 12, 12 },
	{ "%sȾ򤯤路",     SKILL_LEVEL_MASTER,   35,  9, 12, 16 },
	{ "%sƲήӤ򤯤路", SKILL_LEVEL_MASTER,   40, 10, 13, 18 },
#else
	{ "You punch %s.",                               SKILL_LEVEL_BEGINNER,  0,  1,  5,  0 },
	{ "You kick %s.",                                SKILL_LEVEL_BEGINNER,  0,  1,  7,  0 },
	{ "You strike %s.",                              SKILL_LEVEL_NOVICE,    0,  1,  9,  0 },
	{ "You hit %s with your knee.",                  SKILL_LEVEL_NOVICE,    5,  2,  4, MA_KNEE },
	{ "You hit %s with your elbow.",                 SKILL_LEVEL_NOVICE,    5,  1, 12,  0 },
	{ "You butt %s.",                                SKILL_LEVEL_AVERAGE,  10,  2,  6,  0 },
	{ "You kick %s.",                                SKILL_LEVEL_AVERAGE,  10,  3,  6, MA_SLOW },
	{ "You uppercut %s.",                            SKILL_LEVEL_AVERAGE,  12,  5,  5,  6 },
	{ "You double-kick %s.",                         SKILL_LEVEL_SKILLED,  15,  5,  6,  8 },
	{ "You hit %s with a Cat's Claw.",               SKILL_LEVEL_SKILLED,  20,  5,  8,  0 },
	{ "You hit %s with a jump kick.",                SKILL_LEVEL_SKILLED,  25,  6,  8, 10 },
	{ "You hit %s with an Eagle's Claw.",            SKILL_LEVEL_EXPERT,   25,  7,  9,  0 },
	{ "You hit %s with a circle kick.",              SKILL_LEVEL_EXPERT,   30,  8, 10, 10 },
	{ "You hit %s with an Iron Fist.",               SKILL_LEVEL_EXPERT,   35,  8, 11, 10 },
	{ "You hit %s with a flying kick.",              SKILL_LEVEL_MASTER,   35,  8, 12, 12 },
	{ "You hit %s with a Half-moon Kick.",           SKILL_LEVEL_MASTER,   35,  9, 12, 16 },
	{ "You hit %s with a Kingly Shooting Star Kick.",SKILL_LEVEL_MASTER,   40, 10, 13, 18 },
#endif

};

/*
 * Table of game-generated inscriptions (indexed by the defines in
 * defines.h). -- RG
 */
cptr game_inscriptions[] =
{
	NULL,            /* FEEL_NONE */
#ifdef JP
	"Ƥ",    /* FEEL_BROKEN */
	"",      /* FEEL_TERRIBLE */
	"̵",        /* FEEL_WORTHLESS */
	"Ƥ",  /* FEEL_CURSED */
	"ʾ",      /* FEEL_UNCURSED */
	"",            /* FEEL_AVERAGE */
	"",          /* FEEL_GOOD */
	"",        /* FEEL_EXCELLENT */
	"",        /* FEEL_SPECIAL */
	"̤Ƚ",        /* FEEL_TRIED */
#else
	"broken",        /* FEEL_BROKEN */
	"terrible",      /* FEEL_TERRIBLE */
	"worthless",     /* FEEL_WORTHLESS */
	"cursed",        /* FEEL_CURSED */
	"uncursed",      /* FEEL_UNCURSED */
	"average",       /* FEEL_AVERAGE */
	"good",          /* FEEL_GOOD */
	"excellent",     /* FEEL_EXCELLENT */
	"special",       /* FEEL_SPECIAL */
	"tried",         /* FEEL_TRIED */
#endif

};

cptr skill_lev_str[MAX_SKILL_LEVEL] =
#ifdef JP
{"[鿴]", "[]", "[]", "[]", "[ѡ]", "[ã]"};
#else
{"[Beginner]", "[Novice]", "[Average]", "[Skilled]", "[Expert]", "[Master]"};
#endif

s16b skill_lev_var[51] =
{
	1, /*  0 */
	2, /*  1 */
	2, /*  2 */
	2, /*  3 */
	2, /*  4 */
	2, /*  5 */
	2, /*  6 */
	2, /*  7 */
	3, /*  8 */
	3, /*  9 */
	3, /* 10 */
	3, /* 11 */
	3, /* 12 */
	3, /* 13 */
	3, /* 14 */
	3, /* 15 */
	3, /* 16 */
	3, /* 17 */
	3, /* 18 */
	3, /* 19 */
	3, /* 20 */
	4, /* 21 */
	4, /* 22 */
	4, /* 23 */
	4, /* 24 */
	4, /* 25 */
	4, /* 26 */
	4, /* 27 */
	4, /* 28 */
	5, /* 29 */
	5, /* 30 */
	5, /* 31 */
	5, /* 32 */
	5, /* 33 */
	5, /* 34 */
	5, /* 35 */
	6, /* 36 */
	6, /* 37 */
	6, /* 38 */
	6, /* 39 */
	6, /* 40 */
	6, /* 41 */
	6, /* 42 */
	6, /* 43 */
	7, /* 44 */
	7, /* 45 */
	7, /* 46 */
	7, /* 47 */
	7, /* 48 */
	7, /* 49 */
	8  /* 50 */
};

byte conv_terrain2feat[MAX_WILDERNESS] =
{
	FEAT_PERM_SOLID,
	FEAT_TOWN,
	FEAT_DEEP_WATER,
	FEAT_SHAL_WATER,
	FEAT_SWAMP,
	FEAT_DIRT,
	FEAT_GRASS,
	FEAT_TREES,
	FEAT_DIRT,
	FEAT_SHAL_LAVA,
	FEAT_DEEP_LAVA,
	FEAT_MOUNTAIN,
	FEAT_TUNDRA,
	FEAT_DEEP_SEA
};

#ifdef JP
cptr silly_attacks[MAX_SILLY_ATTACK] =
{
  "˾ؤ򤫤줿",
  "ʤβ3äƥȸä",
  "ˤФޤ蘆줿",
  "˷ʤᤵ줿",
  "˥ϥʥФ줿",
  "˥ǹ⤵줿",
  "ʤˤ«ǤФ",
  "ʤǥݡ󥰤򤷤",
  "˥١줿",
  "ˡֿιȯű줿",
  "˥áޤ줿",
  "ˤĤäߤ줿",
  "Ϥʤ٤ä",
  "˴ˤ餯񤭤򤵤줿",
  "˼ڶֺѤ򤻤ޤ줿",
  "˥Ȥ᤯줿",
  "Ϥʤμä",
  "夬줿",
  "鰦ι򤵤줿",
  "Ϥʤ500ߤǸۤä",
  "Ϥʤ100̩ˤĤǮä",
  "˥㡼Ĥ",
  "Ϥʤ˵Ĥ",
  "Ϥʤݥꥴ󲽤",
  "˾줿",
  "ϥƥޤμʸ򾧤",
  "ϤʤΥѥ֥å",
  "ϥ饤ɰư",
  "ϾζޥɤϤ˼Ԥ",
  "ϳȻưˤȯͤ",
  "ϥǥ顼ˡ򤷤",
  "˥饤åǹ⤵줿",
  "󽵴ְǥӥǥͤ˸ʤȻ̼򤫤줿",
  "ϥѥץƤ򾧤",
  "ϥѡȥ饮饯ƥޥʥä",
  "ˤ㤬߾åǥϥ줿",
  "˥åȥȥ꡼ॢå򤫤줿",
  "ϤʤĸǤ򤫤ơ123áפȶ",
  "ϡ֤ʤФФФפȤäƶФ",
  "֤󡢥롼٥󥹤γפȸäŤܤĤ",
  "ϸäTOband仿桪",
};

/* Formatted style for strfmt() */
cptr silly_attacks_other[MAX_SILLY_ATTACK] =
{
  "%s˾ؤ򤫤",
  "%sβ3äƥȸä",
  "%s򤷤Фޤ路",
  "%s˷ʤᤵ",
  "%s˥ϥʥФ",
  "%s򥸥ǹ⤷",
  "%sˤ«ǤФ",
  "%sǥݡ󥰤򤷤",
  "%s˥١",
  "%sˡֿιȯű᤿",
  "%s˥áޤ",
  "%sˤĤäߤ줿",
  "%s٤ä",
  "%sδˤ餯񤭤򤷤",
  "%s˼ڶֺѤ򤻤ޤä",
  "%sΥȤ᤯ä",
  "%sμä",
  "%s夬ä",
  "%s˰ι򤷤",
  "%s500ߤǸۤä",
  "%s100̩ˤĤǮä",
  "˥㡼Ĥ",
  "%s˵Ĥ",
  "%sݥꥴ󲽤",
  "%s򾯤ä",
  "ƥޤμʸ򾧤",
  "%sΥѥ֥å",
  "饤ɰư",
  "ζޥɤϤ˼Ԥ",
  "%s˳Ȼưˤȯͤ",
  "%s˥ǥ顼ˡ򤷤",
  "%s饤åǹ⤷",
  "%s󽵴ְǥӥǥͤ˸ʤȻ̼򤫤",
  "ѥץƤ򾧤",
  "%s˥ѡȥ饮饯ƥޥʥä",
  "%s򤷤㤬߾åǥϥ᤿",
  "%s˥åȥȥ꡼ॢå򤫤",
  "%sĸǤ򤫤ơ123áפȶ",
  "֤ʤФФФפȤäƶФ",
  "֤󡢥롼٥󥹤γפȸäŤܤĤ",
  "äTOband仿桪",
};
#else

/* Weird melee attack types when hallucinating */
cptr silly_attacks[MAX_SILLY_ATTACK] =
{
	"smothers",
	"hugs",
	"humiliates",
	"whips",
	"kisses",

	"disgusts",
	"pees all over",
	"passes the gas on",
	"makes obscene gestures at",
	"licks",

	"stomps on",
	"swallows",
	"drools on",
	"misses",
	"shrinks",

	"emasculates",
	"evaporates",
	"solidifies",
	"digitizes",
	"insta-kills",

	"massacres",
	"slaughters",
	"drugs",
	"psychoanalyzes",
	"deconstructs",

	"falsifies",
	"disbelieves",
	"molests",
	"pusupusu",
};
#endif

#ifdef JP
cptr elem_names[] =
{
	"",
	"",
	"",
	""
};
#endif

#ifdef JP
cptr E_elem_names[] =
#else
cptr elem_names[] =
#endif
{
	"Fire",
	"Aqua",
	"Earth",
	"Wind"
};

weather_type weather_table[WEATHER_TYPE_NUM][WEATHER_LEVEL_NUM] =
{
	/* Rain */
	{
		{
			"",
			{ 4, -2,  0,  0}
		},
		{
			"ŷ",
			{ 0,  0,  2,  0}
		},
		{
			"",
			{-2,  2,  2,  0}
		},
		{
			"뱫",
			{-8,  4,  0,  0}
		}
	},
	/* Wind */
	{
		{
			"",
			{-4,  0,  4, -8}
		},
		{
			"",
			{ 2,  0,  0,  1}
		},
		{
			"",
			{ 2,  0, -2,  4}
		},
		{
			"˽",
			{ 0,  0, -4,  8}
		}
	},
	/* Temparature */
	{
		{
			"",
			{ 4, -4, -2,  0}
		},
		{
			"뤤",
			{ 2, -2,  2,  0}
		},
		{
			"",
			{-2,  2,  0,  0}
		},
		{
			"˴",
			{-4,  4, -2,  0}
		}
	}
};

cptr ethnicity_names[ETHNICITY_NUM] =
{
#ifdef JP
	"륹",
	"륬",
	"Х",
	"Υӥ",
	"ǥ",
#else
	"Walstanian",
	"Gargastan",
	"Bacrum",
	"Zenobian",
	"Lodis",
#endif
};

special_blow_type special_blow_info[MAX_SB] =
{
	{
		"ӭ컶",
		"󥹥1Τ˸ߤHP򹶷ϤȤ빶Ԥʬ⸽HP1/4򼺤",
		WT_BIT_AXE | WT_BIT_CLAW,
		30, 60, 50, A_STR,
	},
	{
		"Ʋ",
		"󥹥1Τ*б*Ԥ",
		WT_BIT_AXE | WT_BIT_WHIP | WT_BIT_HAMMER,
		35, 45, 55, A_WIS,
	},
	{
		"",
		"󥹥1Τ˹Ԥ",
		WT_BIT_SMALL_SWORD | WT_BIT_SWORD | WT_BIT_KATANA,
		30, 40, 50, A_DEX,
	},
	{
		"ŷ̯",
		"󥹥1Τ**Ԥ",
		WT_BIT_SMALL_SWORD | WT_BIT_SPEAR | WT_BIT_SCYTHE,
		35, 45, 55, A_WIS,
	},
	{
		"ܹ˷",
		"󥹥1Τʬ򹶷Ԥ",
		WT_BIT_BOW,
		30, 40, 50, A_STR,
	},
	{
		"ε",
		"󥹥1Τ˹ԤƤˤäƶѤ롣",
		WT_BIT_SWORD | WT_BIT_GREAT_SWORD | WT_BIT_KATANA,
		45, 75, 70, A_STR,
	},
	{
		"",
		"󥹥1ΤвԤвʤɬв롣",
		WT_BIT_SPEAR | WT_BIT_HAMMER,
		30, 45, 70, A_STR,
	},
	{
		"ŷ˻",
		"󥹥1Τ˹ԤΥåХå롣",
		WT_BIT_KATANA | WT_BIT_STAFF | WT_BIT_HAMMER,
		30, 40, 50, A_CON,
	},
	{
		"ư",
		"󥹥1Τ̿Ϥ빶Ԥ",
		WT_BIT_AXE | WT_BIT_SPEAR | WT_BIT_CLAW,
		40, 50, 60, A_INT,
	},
	{
		"ٲ",
		"󥹥1Τ˸ߤμʬμƤ᡼Ʊ᡼Ϳ롣Ϳ᡼Ϥ롣",
		WT_BIT_GREAT_SWORD | WT_BIT_LANCE | WT_BIT_SCYTHE,
		45, 85, 75, A_INT,
	},
};

special_blow_type temple_blow_info[MAX_TEMPLE_SB] =
{
	{
		"֥åץꥺ",
		"󥹥1Τ˰ŹԤ㤵롣",
		WT_BIT_AXE | WT_BIT_CLAW | WT_BIT_WHIP,
		30, 45, 50, A_STR,
	},
	{
		"ǡ",
		"󥹥1Τ*б*Ԥ̥λ롣",
		WT_BIT_WHIP | WT_BIT_SCYTHE,
		35, 45, 55, A_CHR,
	},
	{
		"ǥ٥󥸥㡼",
		"󥹥1Τ**ԤΥåХå롣",
		WT_BIT_GREAT_SWORD | WT_BIT_AXE | WT_BIT_HAMMER,
		35, 50, 55, A_CON,
	},
	{
		"եΥ",
		"󥹥1Τ˿并Ԥ",
		WT_BIT_SWORD | WT_BIT_SPEAR,
		30, 45, 50, A_DEX,
	},
	{
		"֥쥤",
		"󥹥1Τŷ⹶Ԥ",
		WT_BIT_CLAW | WT_BIT_SPEAR,
		25, 40, 40, A_STR,
	},
	{
		"ե쥤ߥ󥰥ǥ",
		"󥹥1Τ*б*Ԥ",
		WT_BIT_KATANA | WT_BIT_SPEAR | WT_BIT_STAFF,
		30, 45, 55, A_WIS,
	},
	{
		"饤åȥС",
		"󥹥1Τʤ빶ԤˡǤʤǥåɤʤгμ¤˾Ǥ롣",
		WT_BIT_SMALL_SWORD | WT_BIT_STAFF,
		40, 65, 70, A_WIS,
	},
	{
		"ݥץ",
		"󥹥1Τ̿Ϥ빶Ԥ",
		WT_BIT_SWORD | WT_BIT_LANCE | WT_BIT_SCYTHE,
		40, 50, 60, A_INT,
	},
};

cptr wt_desc[] =
{
#ifdef JP
	"ʤ",
	"ͷ",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"ϥޡ",
	"",
	"",
	"̥㥯",
	"",
	"",
#else
	"None",
	"Small Sword",
	"Katana",
	"Sword",
	"Great Sword",
	"Axe",
	"Spear",
	"Lance",
	"Claw",
	"Scythe",
	"Whip",
	"Hammer",
	"Staff",
	"Fan",
	"Nunchaku",
	"Bow",
	"Gun",
	"Digging",
#endif
};

tarot_type tarot_info[] =
{
#ifdef JP
	{
		"",
		"ϻȤȥåȥɤϤ롣ˤϼ",
		50000,
		TRUE,
	},
	{
		"ѻա",
		"ϻȤǽκͤ夬롣",
		300000,
		FALSE,
	},
	{
		"ѻադεհ",
		"ϻȤǽκͤ롣",
		0,
		FALSE,
	},
	{
		"Խġ",
		"ϻȤϤ˲иͤơܡǡСۯ۰ڤβ˿ʹԤв",
		25000,
		TRUE,
	},
	{
		"Խġդεհ",
		"ϻȤϤȾиͤơꡢܡǡСۯ۰ڤ˿ʹԤвˤ롣",
		0,
		FALSE,
	},
	{
		"Խ",
		"ϻȤ̥Ϥκͤ夬롣",
		300000,
		FALSE,
	},
	{
		"Խդεհ",
		"ϻȤ̥Ϥκͤ롣",
		0,
		FALSE,
	},
	{
		"Թ",
		"ϻȤȰŪ˹롣",
		50000,
		TRUE,
	},
	{
		"Թդεհ",
		"ϻȤȰŪ˹롣",
		0,
		FALSE,
	},
	{
		"ˡġ",
		"ϻȤȤ̱λٻ롣",
		50000,
		FALSE,
	},
	{
		"ˡġդεհ",
		"ϻȤȤ̱λٻ򼺤",
		0,
		FALSE,
	},
	{
		"͡",
		"ϻȤȻ볦Υ󥹥Ϥ̥λ롣",
		85000,
		TRUE,
	},
	{
		"͡դεհ",
		"ϻȤȥեƤΥ󥹥ܳФᤵ롣",
		0,
		FALSE,
	},
	{
		"֡",
		"ϻȤȵǽʥ󥹥1ΤڥåȤȤƾ롣",
		50000,
		TRUE,
	},
	{
		"֡դεհ",
		"ϻȤȵǽʥ󥹥1ΤŨȤƾ롣",
		0,
		FALSE,
	},
	{
		"ϡ",
		"ϻȤϤκͤ夬롣",
		300000,
		FALSE,
	},
	{
		"ϡդεհ",
		"ϻȤϤκͤ롣",
		0,
		FALSE,
	},
	{
		"Աԡ",
		"ϻȤȸκͤ夬롣",
		300000,
		FALSE,
	},
	{
		"Աԡդεհ",
		"ϻȤȸκͤ롣",
		0,
		FALSE,
	},
	{
		"Ա̿ء",
		"ϻȤȸߤγƹ롣",
		25000,
		TRUE,
	},
	{
		"Ա̿ءդεհ",
		"ϻȤȼʬѿȤ褦Ȥ롣",
		5000,
		FALSE,
	},
	{
		"",
		"ϻȤȥ饤Ȥ˷",
		50000,
		TRUE,
	},
	{
		"դεհ",
		"ϻȤȥ饤Ȥ٤˷",
		50000,
		TRUE,
	},
	{
		"ߤ줿ˡ",
		"ϻȤŤαǰȯư롣",
		0,
		FALSE,
	},
	{
		"ߤ줿ˡդεհ",
		"ϻȤȼʬΥԡɤʵפ1롣",
		0,
		FALSE,
	},
	{
		"Ի",
		"ϻȤϤͤ20%ޤǸϤκͤȸͤκʬ᡼ȤƥեƤΥ󥹥Ϳ롣",
		25000,
		FALSE,
	},
	{
		"Իդεհ",
		"ϻȤƤǽϴ͡ϡMPǽ򤤤餫γǰѤޤ޼ʬκ٥1᤹",
		250000,
		TRUE,
	},
	{
		"",
		"ϻȤȸߤηиͤȾʬ(100000Ķʤ)ηи롣",
		25000,
		FALSE,
	},
	{
		"դεհ",
		"ϻȤȸߤηиͤȾʬ(100000Ķʤ)ηиκͤ򼺤",
		0,
		FALSE,
	},
	{
		"԰",
		"ϻȤȥǡ1ΤŨȤƾ롣˥ڥåȤˤʤ롣",
		0,
		FALSE,
	},
	{
		"԰դεհ",
		"ϻȤȻ볦Υǡ300Υ᡼Ϳ롣",
		25000,
		TRUE,
	},
	{
		"",
		"ϻȤȶˤƹϰϤ˲250Υ᡼롣",
		25000,
		FALSE,
	},
	{
		"դεհ",
		"ϻȤȼդΥƥࡢ󥹥Ϸ˲롣",
		5000,
		FALSE,
	},
	{
		"",
		"ϻȤʣιʥƥФ",
		200000,
		FALSE,
	},
	{
		"դεհ",
		"ϻȤӤ()Ѥ롣",
		0,
		FALSE,
	},
	{
		"Է",
		"ϻȤȼʬΥ줿ʣΥ󥹥򾤴롣",
		0,
		FALSE,
	},
	{
		"Էդεհ",
		"ϻȤȼʬΥ줿Υ󥹥ʣä롣ˡ󥹥ˤ̵",
		50000,
		TRUE,
	},
	{
		"ۡ",
		"ϻȤȤγϷΤ뤳ȤǤγΤʵפ˾Ȥ餵졢γƤΥ󥹥櫡⡢ʡƥƥΤ롣",
		8000,
		TRUE,
	},
	{
		"ۡդεհ",
		"ϻȤȤγΤŤ롣",
		0,
		FALSE,
	},
	{
		"ԿȽ",
		"ϻȤɤΥ󥹥ȥڥåȰʳƤΥ󥹥ä롣ˡ󥹥ˤ̵",
		300000,
		TRUE,
	},
	{
		"ԿȽդεհ",
		"ϻȤɤΥ󥹥ʣŨȤƾ롣",
		0,
		FALSE,
	},
	{
		"",
		"ϻȤȥƥ1ĴꤦȤǤ롣",
		5000000,
		TRUE,
	},
	{
		"դεհ",
		"ϻȤ1Υƥä롣",
		0,
		FALSE,
	},
	{
		"Զԡ",
		"ϻȤ⤭ʤꡢˡμΨ夬롣γˤ¤̤³",
		0,
		FALSE,
	},
	{
		"Զԡդεհ",
		"ϻȤƤΥ󥹥⤭ʤ롣γˤ¤̤³",
		100000,
		TRUE,
	},
#else
	{
		"the Blank Card",
		"",
		50000,
		TRUE,
	},
	{
		"the Magician",
		"",
		300000,
		FALSE,
	},
	{
		"reverted position of the Magician",
		"",
		0,
		FALSE,
	},
	{
		"the High Priestess",
		"",
		25000,
		TRUE,
	},
	{
		"reverted position of the High Priestess",
		"",
		0,
		FALSE,
	},
	{
		"the Empress",
		"",
		300000,
		FALSE,
	},
	{
		"reverted position of the Empress",
		"",
		0,
		FALSE,
	},
	{
		"the Emperor",
		"",
		50000,
		TRUE,
	},
	{
		"reverted position of the Emperor",
		"",
		0,
		FALSE,
	},
	{
		"the Hierophant",
		"",
		50000,
		FALSE,
	},
	{
		"reverted position of the Hierophant",
		"",
		0,
		FALSE,
	},
	{
		"the Lovers",
		"",
		85000,
		TRUE,
	},
	{
		"reverted position of the Lovers",
		"",
		0,
		FALSE,
	},
	{
		"the Chariot",
		"",
		50000,
		TRUE,
	},
	{
		"reverted position of the Chariot",
		"",
		0,
		FALSE,
	},
	{
		"the Strength",
		"",
		300000,
		FALSE,
	},
	{
		"reverted position of the Strength",
		"",
		0,
		FALSE,
	},
	{
		"the Hermit",
		"",
		300000,
		FALSE,
	},
	{
		"reverted position of the Hermit",
		"",
		0,
		FALSE,
	},
	{
		"the Wheel of Fortune",
		"",
		25000,
		TRUE,
	},
	{
		"reverted position of the Wheel of Fortune",
		"",
		5000,
		FALSE,
	},
	{
		"the Justice",
		"",
		50000,
		TRUE,
	},
	{
		"reverted position of the Justice",
		"",
		50000,
		TRUE,
	},
	{
		"the Hanged Man",
		"",
		0,
		FALSE,
	},
	{
		"reverted position of the Hanged Man",
		"",
		0,
		FALSE,
	},
	{
		"the Death",
		"",
		25000,
		FALSE,
	},
	{
		"reverted position of the Death",
		"",
		250000,
		TRUE,
	},
	{
		"the Temperance",
		"",
		25000,
		FALSE,
	},
	{
		"reverted position of the Temperance",
		"",
		0,
		FALSE,
	},
	{
		"the Devil",
		"",
		0,
		FALSE,
	},
	{
		"reverted position of the Devil",
		"",
		25000,
		TRUE,
	},
	{
		"the Tower",
		"",
		25000,
		FALSE,
	},
	{
		"reverted position of the Tower",
		"",
		5000,
		FALSE,
	},
	{
		"the Star",
		"",
		200000,
		FALSE,
	},
	{
		"reverted position of the Star",
		"",
		0,
		FALSE,
	},
	{
		"the Moon",
		"",
		0,
		FALSE,
	},
	{
		"reverted position of the Moon",
		"",
		50000,
		TRUE,
	},
	{
		"the Sun",
		"",
		8000,
		TRUE,
	},
	{
		"reverted position of the Sun",
		"",
		0,
		FALSE,
	},
	{
		"the Judgement",
		"",
		300000,
		TRUE,
	},
	{
		"reverted position of the Judgement",
		"",
		0,
		FALSE,
	},
	{
		"the World",
		"",
		5000000,
		TRUE,
	},
	{
		"reverted position of the World",
		"",
		0,
		FALSE,
	},
	{
		"the Fool",
		"",
		0,
		FALSE,
	},
	{
		"reverted position of the Fool",
		"",
		100000,
		TRUE,
	},
#endif
};

scratch_card_type scratch_card_info[] =
{
	{
		1,
		0,
		0,
		"ϥ",
	},
	{
		10000000L,
		0, /* Hack */
		0, /* Hack */
		"ʤϤä̴˰㤤ʤ",
	},
	{
		4000000L,
		TV_LITE,
		SV_LITE_MAGICAL_LAMP,
		"ޤޤ̴Τ褦ɤݤ",
	},
	{
		1000000L,
		TV_SCROLL,
		SV_SCROLL_SNAP_DRAGON,
		"äۤä",
	},
	{
		800000L,
		TV_STAFF,
		SV_STAFF_GENOCIDE,
		"ä",
	},
	{
		500000L,
		TV_SCROLL,
		SV_SCROLL_ARTIFACT,
		"ä",
	},
	{
		200000L,
		TV_ROD,
		SV_ROD_IDENTIFY,
		"ϻä",
	},
	{
		100000L,
		TV_ROD,
		SV_ROD_SPEED,
		"ä",
	},
	{
		80000L,
		TV_WAND,
		SV_WAND_DRAGON_BREATH,
		"Ȭä",
	},
	{
		40000L,
		TV_STAFF,
		SV_STAFF_HEALING,
		"ä",
	},
	{
		20000,
		TV_AMULET,
		0, /* Hack */
		"ä",
	},
	{
		10000,
		TV_AMULET,
		SV_AMULET_RESISTANCE,
		"ä",
	},
	{
		5000,
		TV_SCROLL,
		SV_SCROLL_DEADLY_BLOW_LEARNING,
		"ä",
	},
	{
		2000,
		TV_SCROLL,
		SV_SCROLL_EGO_CREATION,
		"ä",
	},
	{
		1000,
		TV_STONE,
		0,
		"ä",
	},
	{
		500,
		TV_SCROLL,
		SV_SCROLL_STAR_REMOVE_CURSE,
		"ä",
	},
	{
		200,
		TV_CLOAK,
		SV_RAINCOAT,
		"ϻä",
	},
	{
		32,
		TV_SCROLL,
		SV_SCROLL_WORD_OF_RECALL,
		"",
	},
	{
		8,
		TV_FOOD,
		SV_FOOD_PINT_OF_WINE,
		"Ȭ",
	},
	{
		4,
		TV_FOOD,
		SV_FOOD_PINT_OF_ALE,
		"",
	},
	{
		2,
		TV_FOOD,
		SV_FOOD_BISCUIT,
		"",
	},
};

int a_to_tr[A_MAX] =
{
	TR_STR,
	TR_INT,
	TR_WIS,
	TR_DEX,
	TR_CON,
	TR_CHR,
};

int ob_to_tr[OB_MAX] =
{
	TR_MAGIC_MASTERY,
	TR_STEALTH,
	TR_SEARCH,
	TR_INFRA,
	TR_TUNNEL,
	TR_SPEED,
	TR_BLOWS,
	TR_ANTI_MAGIC,
};
