<?php
	require_once('./config.inc.php');
	require_once(TODOTASK_CTRL_DIR.'/grp.class.php');
	require_once(TODOTASK_CTRL_DIR.'/email.class.php');

	// ページロード
	$page = gfPageLoad();

	$page->mode = gfIssetGET('mode',""); 
	if ($page->mode=="") {
		$page->mode = gfIssetPOST('mode',GRPMAIL_MODE_SOLICIT); 
	}
	if ($page->mode == GRPMAIL_MODE_BROADCAST) {
		$page->title = TITLE_GRPMAIL;
	} else {
		$page->title = TITLE_GRPSOLICIT;
	}
	$page->group_no = gfIssetGET('group_no',""); 

	$page->contxt = array(
		'mbody'=>gfIssetPOST('mbody',""), 
		'mto'=>gfIssetPOST('mto',""), 
		'mtoadr'=>gfIssetPOST('mtoadr',"") 
		);

	$act_flg = false;	// アクションフラグ
	$page->csrf = gfIssetPOST('csrf',""); 	 //CSRF対策
	if ($page->csrf!="") {
		$page->group_no = gfIssetPOST('group_no',""); 
		$act_flg = true;
	}

	// check page parameter
	$page->chkPage();

	// ログイン確認
	$objGrp = new Grp();
	$objMail = new EMail();
	
	$page->user_name = $objGrp->get_loginname(); 
	$page->user_id = $objGrp->get_loginid(); 

	// ログイン状態の確認
	if (!$objGrp->ChkLogin()) {
		$objGrp->ctrl_movepage("userlogin.php");
	}


	// 取得したグループが存在するか確認
	if (!$objGrp->ChkGroupMst($page->group_no)) {
		gfMsgWindow($page ,MSG_MODE_NOTE ,TASK_ART_001_1 , TASK_ART_001_2 ,$page->backurl ,MSG_NOR);
	}
	$page->group_name = $objGrp->get_group_name($page->group_no); 

	// 表示モードの取得
	$page->aryViewMode = $objGrp->GetViewMode($page->group_no);
	// 指定したグループの表示モードが取得できませんでした。
	if (!isset($page->aryViewMode['taskboxmax']) or !MAIL_GRPMAIL) {
		gfMsgWindow($page ,MSG_MODE_NOTE ,TASK_ART_003_1 , TASK_ART_003_2 ,$page->backurl ,MSG_NOR);
	// グループメールを使用可能にするか
	} else if ($page->aryViewMode['grpmail_flg']==VIEW_OFF && $page->mode != GRPMAIL_MODE_SOLICIT ) {
		gfMsgWindow($page ,MSG_MODE_NOTE ,GRPMAIL_ERR_001_1 , GRPMAIL_ERR_001_2 ,$page->backurl ,MSG_NOR);
	}

	// メンバーチェック(参照しようとしているタスクのメンバーに登録されているか)
	$page->memLv = $objGrp->ChkMember($page->group_no,$page->user_id);
	// メンバーに所属していなくてメンバーモードの場合
	if ($page->memLv < GRPAUTH_MEM) {
		gfMsgWindow($page ,MSG_MODE_NOTE ,ART_TITLE , AUTH_ERR_001 ,$page->backurl ,MSG_NOR);
	}

	// 担当者の取得
	$page->aryOptGrpMem = $objGrp->GetGrpMemberList($page->group_no,false);

	// メール送信の実行
	$sMsg = "";
	if ($act_flg) {
		// CSRFのチェック
		$objGrp->chk_csrf($page,$page->csrf,$page->group_no.$page->user_id);
		$sMsg = chkInput($page->mode,$page->contxt['mbody'],$page->contxt['mto'],$page->contxt['mtoadr'],$page->aryOptGrpMem);
		if ($sMsg=="") {
			if ($page->mode==GRPMAIL_MODE_BROADCAST) {
				// メールの処理
				foreach ($page->contxt['mto'] as $mto) {
					$mail = getUserMaiAdr($mto, $page->aryOptGrpMem);
					// メールを送信する。
					$objMail->SendGroupMail($mail,$page->contxt['mbody'],$page->group_no,$page->group_name,$page->user_name);
				}
			} else if($page->mode==GRPMAIL_MODE_SOLICIT) {
				// メールを送信する。
				$objMail->SendSolicitMail($page->contxt['mtoadr'],$page->contxt['mbody'],$page->group_no,$page->group_name,$page->user_name);
			}
			// 戻りURL
			$page->backurl = ROOT_URL."tasklist.php?group_no=".$page->group_no;
			gfMsgWindow($page ,MSG_MODE_REDIRECT ,TITLE_MAILSEND , GRPMAIL_MSG_002 ,$page->backurl ,MSG_NOR);
		}
	} 	
	$page->art_msg = $sMsg;

	// CSRFの発行
	$page->csrf = sha1($page->group_no.$page->user_id.CSRF_SEED);

	// グループメール
	$page->grpmail_flg = $page->aryViewMode['grpmail_flg'];

	$page->display('/grp/mail.php');

	// ページ終了処理
	gfPageUnLoad();


function chkInput($mode,$mbody,$mtoAry,$mtoadr,$aryOptGrpMem) {

	$sMsg = "";
	// 本文が入力されていません。
	if ($mbody=="") {
		$sMsg = GRPMAIL_ART_003;
	}
	if ($mode==GRPMAIL_MODE_BROADCAST && $sMsg == "") {
		if(!is_array($mtoAry)) {
			$sMsg = GRPMAIL_ART_004;
		} else {
			// ユーザー存在の確認
			foreach ($mtoAry as $mto) {
				if (getUserMaiAdr($mto, $aryOptGrpMem) =="") {
					$sMsg = GRPMAIL_ART_005;
				}
			}
		}
	} else if($mode==GRPMAIL_MODE_SOLICIT && $sMsg == "") {
		if(!EMail::ChkMailAdr($mtoadr)) {
			$sMsg = GRPMAIL_ART_006;
		}		
	}
	return $sMsg;
}

function getUserMaiAdr($mto, $aryOptGrpMem) {
	$mail_to = "";
	foreach ($aryOptGrpMem as $key => $val ) {
		if ($val['user_id'] == $mto ) {
			$mail_to = $val['user_mail'];
			break;
		}   
	}
	return $mail_to; 
}

?>