<?php
	require_once('./config.inc.php');
	require_once(TODOTASK_CTRL_DIR.'/grp.class.php');

	// ページロード
	$page = gfPageLoad();
	$page->title = TITLE_GRPMST;
	$page->gmode = gfIssetGET('gmode',TASK_MODE_PAGE);	// グループモードの確認 
	$page->group_no = gfIssetGET('group_no',""); 
	if ($page->group_no=="") {
		$page->group_no = gfIssetPOST('group_no',""); 
	}
	$page->mode = gfIssetPOST('mode',GRP_CLASS_1ST); 
	$page->csrf = gfIssetPOST('csrf',"");		// CSRF対策 
	$page->contxt = array(
		'delspan'=>gfIssetPOST('delspan',"") 
		);

	// 変更用
	$page->aryViewMode['assent_flg'] = gfIssetPOST('assent_flg',VIEW_ON);
	$page->aryViewMode['priority_flg'] = gfIssetPOST('priority_flg',VIEW_ON);
	$page->aryViewMode['view_flg'] = gfIssetPOST('view_flg',VIEW_ON);
	$page->aryViewMode['limit_flg'] = gfIssetPOST('limit_flg',VIEW_ON);
	$page->aryViewMode['gains_flg'] = gfIssetPOST('gains_flg',VIEW_ON);
	$page->aryViewMode['do_user_flg'] = gfIssetPOST('do_user_flg',VIEW_ON);
	$page->aryViewMode['add_user_flg'] = gfIssetPOST('add_user_flg',VIEW_ON);
	$page->aryViewMode['fintask_flg'] = gfIssetPOST('fintask_flg',VIEW_ON);
	$page->aryViewMode['staytask_flg'] = gfIssetPOST('staytask_flg',VIEW_ON);
	$page->aryViewMode['grpmail_flg'] = gfIssetPOST('grpmail_flg',VIEW_ON);
	$page->aryViewMode['grpfile_flg'] = gfIssetPOST('grpfile_flg',VIEW_ON);
	$page->aryViewMode['grpcmnt_flg'] = gfIssetPOST('grpcmnt_flg',VIEW_ON);
	$page->aryViewMode['grpcmntcnt_flg'] = gfIssetPOST('grpcmntcnt_flg',VIEW_ON);
	$page->aryViewMode['taskvolume_flg'] = gfIssetPOST('taskvolume_flg',VIEW_ON);
	$page->aryViewMode['approval_flg'] = gfIssetPOST('approval_flg',VIEW_OFF);
	$page->aryViewMode['alert_flg'] = gfIssetPOST('alert_flg',VIEW_ON);
	$page->aryViewMode['alert1_days'] = gfIssetPOST('alert1_days',3);
	$page->aryViewMode['alert2_days'] = gfIssetPOST('alert2_days',7);
	$page->aryViewMode['delauth_flg'] = gfIssetPOST('delauth_flg',1);
	$page->aryViewMode['group_msg'] = gfIssetPOST('group_msg',"");
	$page->aryViewMode['taskboxmax'] = gfIssetPOST('taskboxmax',12);
	$page->aryViewMode['pagemax'] = gfIssetPOST('pagemax',100);

	for ($i = 0; $i < MAX_TASKBOX; $i++) {
		$page->aryTaskBox[$i]['group_no'] = $page->group_no; 
		$page->aryTaskBox[$i]['taskbox_id'] = gfIssetPOST('taskbox_id('.$i.')',""); 
		$page->aryTaskBox[$i]['taskbox_name'] = gfIssetPOST('taskbox_name('.$i.')',""); 
		$page->aryTaskBox[$i]['taskbox_prio'] = gfIssetPOST('taskbox_prio('.$i.')',""); 
		$page->aryTaskBox[$i]['mailsend_flg'] = gfIssetPOST('mailsend_flg('.$i.')',""); 
	}

	$i = 0;
	while (isset($_POST['member_id('.$i.')'])) {
		$page->aryOptGrpMem[$i]['user_id'] = gfIssetPOST('member_id('.$i.')',""); 
		$page->aryOptGrpMem[$i]['user_name'] = gfIssetPOST('member_name('.$i.')',""); 
		$page->aryOptGrpMem[$i]['status'] = gfIssetPOST('member_status('.$i.')',""); 
		$i++;
	}

	$page->aryGrpInfo['group_name'] = gfIssetPOST('group_name',"");
	$page->aryGrpInfo['group_prio'] = gfIssetPOST('group_prio',"");
	$page->aryGrpInfo['group_note'] = gfIssetPOST('group_note',"");

	$page->backurl = "tasklist.php?group_no=".$page->group_no;


	// check page parameter
	$page->chkPage();

	// 数字型の確認
	gfChkNum($page->contxt['delspan'],"");
	gfChkNum($page->aryViewMode['assent_flg'],1);
	gfChkNum($page->aryViewMode['priority_flg'],"0");
	gfChkNum($page->aryViewMode['view_flg'],"0");
	gfChkNum($page->aryViewMode['gains_flg'],1);
	gfChkNum($page->aryViewMode['do_user_flg'],"0");
	gfChkNum($page->aryViewMode['limit_flg'],"0");
	gfChkNum($page->aryViewMode['add_user_fl'],1);
	gfChkNum($page->aryViewMode['add_date_fl'],"0");
	gfChkNum($page->aryViewMode['fintask_flg'],1);
	gfChkNum($page->aryViewMode['staytask_fl'],1);
	gfChkNum($page->aryViewMode['detail_flg'],1);
	gfChkNum($page->aryViewMode['grpmail_flg'],1);
	gfChkNum($page->aryViewMode['grpfile_flg'],1);
	gfChkNum($page->aryViewMode['grpcmnt_flg'],1);
	gfChkNum($page->aryViewMode['grpcmntcnt_flg'],1);
	gfChkNum($page->aryViewMode['taskvolume_flg'],1);
	gfChkNum($page->aryViewMode['approval_flg'],0);
	gfChkNum($page->aryViewMode['alert_flg'],"0");
	gfChkNum($page->aryViewMode['alert1_days'],3);
	gfChkNum($page->aryViewMode['alert2_days'],7);
	gfChkNum($page->aryViewMode['delauth_flg'],1);
	gfChkNum($page->aryViewMode['taskboxmax'],12);
	gfChkNum($page->aryViewMode['pagemaxi'],100);

	
	// ログイン確認
	$objGrp = new Grp();

	$page->user_name = $objGrp->get_loginname(); 
	$page->user_id = $objGrp->get_loginid(); 

	// 取得したグループが存在するか確認
	if (!$objGrp->ChkGroupMst($page->group_no)) {
		gfMsgWindow($page ,MSG_MODE_NOTE ,TASK_ART_001_1 , TASK_ART_001_2 ,$page->backurl ,MSG_NOR);
	}
	$page->group_name = $objGrp->get_group_name($page->group_no); 
	

	// メンバーチェック(参照しようとしているタスクのメンバーに登録されているか)
	$page->memLv = $objGrp->ChkMember($page->group_no,$page->user_id);
	// グループ管理権限確認
	if (($page->memLv != GRPAUTH_ADMIN)&&($page->memLv != GRPAUTH_MADMIN)) {
		gfMsgWindow($page ,MSG_MODE_NOTE ,ART_TITLE , AUTH_ERR_002 ,$page->backurl ,MSG_NOR);
	}

	// 入力内容の確認
	$ArtMsg = "";		// 確認関数なりを呼び出す
	
	// 期間削除処理
	if ($page->mode == GRP_CLASS_SPANDEL) {
		if ($page->contxt['delspan'] == "") {
			$ArtMsg = GRP_ART_007;
		} else {
			if (fGrpSpanDel($page,$page->csrf,$page->group_no.$page->memLv,$page->user_id,$page->group_no,$page->contxt['delspan'],$objGrp)) {
				gfMsgWindow($page ,MSG_MODE_REDIRECT ,TITLE_MSGWIND ,TASK_MSG_008 ,$page->backurl ,MSG_NOR);
			}
		}
	// 更新処理
	} else if ($page->mode == GRP_CLASS_EDIT) {
		fUpdGrp($page,$page->csrf,$page->group_no.$page->memLv,$page->group_no,$page->aryViewMode,$page->aryTaskBox,$page->aryOptGrpMem,$page->aryGrpInfo,$objGrp);
		gfMsgWindow($page ,MSG_MODE_REDIRECT ,TITLE_MSGWIND ,GRP_MSG_018 ,$page->backurl ,MSG_NOR);
	}

	$page->art_msg = $ArtMsg; 


	if ($page->mode == GRP_CLASS_1ST || $page->mode == GRP_CLASS_SPANDEL){
		// 表示モードの取得
		$page->aryViewMode = $objGrp->GetViewMode($page->group_no);
		// 指定したグループの表示モードが取得できませんでした。
		if (!isset($page->aryViewMode['taskboxmax'])) {
			gfMsgWindow($page ,MSG_MODE_NOTE ,TASK_ART_003_1 , TASK_ART_003_2 ,$page->backurl ,MSG_NOR);
		}
	
		// タスクボックスの取得
		$page->aryTaskBox = $objGrp->GetTaskbox($page->group_no);
	
		// グループメンバーの取得
		$page->aryOptGrpMem = $objGrp->GetGrpMemberList($page->group_no,false);

		// グループ基本情報
		$page->aryGrpInfo["group_name"] = $objGrp->get_group_name($page->group_no);
		$page->aryGrpInfo["group_prio"] = $objGrp->get_group_prio($page->group_no);
		$page->aryGrpInfo["group_note"] = $objGrp->get_group_note($page->group_no);
	}

	// CSRFの発行
	$page->csrf = sha1($page->group_no.$page->memLv.CSRF_SEED);

	// グループメール
	$page->grpmail_flg = $page->aryViewMode['grpmail_flg'];

	$page->title = $page->group_name.$page->title;

	$page->display('/grp/mst.php');

	// ページ終了処理
	gfPageUnLoad();


// 削除処理
function fGrpSpanDel($page,$csrf,$csrfcd,$loginid,$group_no,$delspan,$objGrp) {
	// CSRFのチェック
	$objGrp->chk_csrf($page,$csrf,$csrfcd);
	// トランザクション発行
	$retDel = $objGrp->begin_trans();

	// ユーザー情報の削除処理
	if ($retDel) {
		// ユーザ情報の削除
		$retDel = $objGrp->DelSpanTask($group_no,$delspan);
	}
	// コミット|ロールバック
	$objGrp->commit_trans($retDel);

	return $retDel;
}

// 更新処理
function fUpdGrp($page,$csrf,$csrfcd,$group_no,$aryViewMode,$aryTaskBox,$aryOptGrpMem,$aryGrpInfo,$objGrp) {
	// CSRFのチェック
	$objGrp->chk_csrf($page,$csrf,$csrfcd);
	// トランザクション発行
	$retUpd = $objGrp->begin_trans();

	// @todo オリジナルを保存して変更されてたものだけを更新する・・・

	// ユーザー情報の更新処理
	if ($retUpd) {
		foreach ($aryOptGrpMem as $key => $value) {
			$retUpd = $objGrp->UpdMemberTbl($group_no,$value['user_id'],$value['status']);
			if (!$retUpd) {
				break;
			}
		}
	}

	// グループ情報の更新
	if ($retUpd) {
		$retUpd = $objGrp->UpdGrpInfo($group_no,$aryGrpInfo);
	}

	// タスク表示状態更新処理
	if ($retUpd) {
		$retUpd = $objGrp->UpdViewMode($group_no,$aryViewMode);
	}

	// タスクボックス情報更新
	if ($retUpd) {
		$aryDelId = array();	// 削除コード
		$aryDelName = array();	// 削除ボックス名称
		for ($i = 0; $i < MAX_TASKBOX; $i++) {
			
			if($aryTaskBox[$i]['taskbox_id']!="" && $aryTaskBox[$i]['taskbox_name']=="") {
				$aryDelId[$i] = $aryTaskBox[$i]['taskbox_id'];
				$aryDelName[$i] = $aryTaskBox[$i]['taskbox_name'];
			}

			// タスクボックス更新
			if ($aryTaskBox[$i]['taskbox_name']!="" && $aryTaskBox[$i]['taskbox_id']!="") {
				$retUpd = $objGrp->UpdTaskbox($group_no,$aryTaskBox[$i]);
				if (!$retUpd) {
					break;
				}
			} else if ($aryTaskBox[$i]['taskbox_name']!="" && $aryTaskBox[$i]['taskbox_id']=="") {
				$retUpd = $objGrp->InsTaskbox($group_no,$aryTaskBox[$i]);
				if (!$retUpd) {
					break;
				}
			}
		}

		if (count($aryDelId) > 0 && $retUpd) {
			// タスクボックス削除
			$retUpd = $objGrp->DelTaskbox($group_no,$aryDelId,$aryDelName);
		}
	}

	// コミット|ロールバック
	$objGrp->commit_trans($retUpd);
	return $retUpd;
}

?>