<?php
	require_once('./config.inc.php');
	require_once(TODOTASK_CTRL_DIR.'/datafile.class.php');
	require_once(TODOTASK_CTRL_DIR.'/task.class.php');

	// ページロード
	$page = gfPageLoad();

	$data_no = gfIssetGET('data_no',""); 
	$page->task_no = gfIssetGET('task_no',""); 
	$page->group_no = gfIssetGET('group_no',""); 
	gfChkNum($data_no,"0");

	// check page parameter
	$page->chkPage();


	// 権限のチェック
	$objTask = new Task();
	$objImg = new Datafile();

	$page->user_id = $objTask->get_loginid(); 
	

	// 取得したグループが存在するか確認
	if (!$objTask->ChkGroupMst($page->group_no)) {
		exit;
	}

	// 表示モードの取得
	$aryViewMode = $objTask->GetViewMode($page->group_no);
	// 指定したグループの表示モードが取得できませんでした。
	if (!isset($aryViewMode['taskboxmax'])) {
		exit;
	}

	// メンバーチェック(参照しようとしているタスクのメンバーに登録されているか)
	$page->memLv = $objTask->ChkMember($page->group_no,$page->user_id);
	// メンバーに所属していなくてメンバーモードの場合
	if ($page->memLv < GRPAUTH_MEM && $aryViewMode["view_flg"] != GRP_VIEW_OK) {
		exit;
	}




	$aryImageData = $objImg->GetDataFile($data_no ,$page->task_no ,$page->group_no );

	// ヘッダー書き込みの確認
	$filename = "";
	$linenum = "";
	if (headers_sent($filename, $linenum)) {
		// ヘッダー送出済み
		gfMsgWindow($page ,MSG_MODE_NOTE ,ERR_TITLE , HEADER_ERR_001." file:".$filename." line:".$linenum ,$page->backurl ,MSG_NOR);
	}

	if (!isset($aryImageData["data"])) {
		exit;
	}

	// 画像表示
	header ("Content-Disposition: inline; filename=".$aryImageData["data_name"]);
	header ("Content-type: ".$objImg->GetImgMimetype($aryImageData["data_ext"]));
	header ("Content-Transfer-Encoding: binary");
	header ("Content-length: ".$aryImageData["data_size"]);

	print(base64_decode($aryImageData["data"])); 


	// ページ終了処理
	gfPageUnLoad();



?>