<?php
	require_once('./config.inc.php');
	require_once(TODOTASK_CTRL_DIR.'/datafile.class.php');
	require_once(TODOTASK_CTRL_DIR.'/task.class.php');

	// ページロード
	$page = gfPageLoad();

	$data_no = gfIssetPOST('data_no',""); 
	$page->task_no = gfIssetPOST('task_no',""); 
	$page->group_no = gfIssetPOST('group_no',""); 
	$page->csrf = gfIssetPOST('csrf',""); 
	gfChkNum($data_no,"0");

	// check page parameter
	$page->chkPage();
	$page->backurl = "taskinput.php?mode=edit&group_no=".$page->group_no."&taskno=".$page->task_no;

	// パラメーターの確認
	if ($page->csrf != sha1($page->group_no.$data_no.$page->task_no.CSRF_SEED)) {
		gfMsgWindow($page ,MSG_MODE_NOTE ,ART_TITLE , POST_ERR_001 ,$page->backurl ,MSG_NOR);
	}

	// 権限のチェック
	$objTask = new Task();
	$objImg = new Datafile();
	$page->user_id = $objTask->get_loginid(); 

	// 取得したグループが存在するか確認
	if (!$objTask->ChkGroupMst($page->group_no)) {
		gfMsgWindow($page ,MSG_MODE_NOTE ,TASK_ART_001_1 , TASK_ART_001_2 ,$page->backurl ,MSG_NOR);
	}

	// 表示モードの取得
	$aryViewMode = $objTask->GetViewMode($page->group_no);
	// 指定したグループの表示モードが取得できませんでした。
	if (!isset($aryViewMode['taskboxmax'])) {
		gfMsgWindow($page ,MSG_MODE_NOTE ,TASK_ART_003_1 , TASK_ART_003_2 ,$page->backurl ,MSG_NOR);
	}

	// メンバーチェック(参照しようとしているタスクのメンバーに登録されているか)
	$page->memLv = $objTask->ChkMember($page->group_no,$page->user_id);
	// メンバーに所属していなくてメンバーモードの場合
	if ($page->memLv < GRPAUTH_MEM && $aryViewMode["view_flg"] != GRP_VIEW_OK) {
		gfMsgWindow($page ,MSG_MODE_NOTE ,TASK_ART_002_1 , 
			TASK_ART_002_2
			.TASK_ART_002_3
			."<a href=\"grpjoin.php?group_no=".$page->group_no."\">"
			.TASK_ART_002_4
		 ,$page->backurl ,MSG_NOR);
	}

	// タスクの削除
	if ($objImg->DelDataFile($data_no ,$page->task_no ,$page->group_no ,$page->user_id)) {
		gfMsgWindow($page ,MSG_MODE_REDIRECT ,TITLE_MSGWIND ,DATA_MSG_001 ,$page->backurl ,MSG_NOR);
	}

	// ページ終了処理
	gfPageUnLoad();

?>