/**
// フォーム入力をフォローするjs
// http://espion.just-size.jp/archives/05/320195801.html
**/

function inputDefault(elm, msg) {
   this.elm     = elm;
   this.msg     = msg;
   this.color   = '#999999';
   this.bgColor = '#F9EFE9';
}

inputDefault.prototype.set = function() {
   this._cleared    = false;
   this._defColor   = this.elm.style.color;
   this._defBGColor = this.elm.style.backgroundColor;

   this.elm.value        = this.msg;
   this.elm.style.color  = this.color;
   this.elm.style.backgroundColor = this.bgColor;

   var _this = this;
   addEvent( this.elm,      'focus',  function() { _this.clear();  } );
   addEvent( this.elm.form, 'submit', function() { _this.submit(); } );
}

inputDefault.prototype.clear = function() {
   if(this._cleared) return;

   this.elm.style.color            = this._defColor;
   this.elm.style.backgroundColor  = this._defBGColor;
   this.elm.value = '';
   this._cleared  = true;
}

inputDefault.prototype.submit = function() {
   if(this._cleared) return;

   var _this = this;
   this.elm.disabled = true;
   window.setTimeout(function() { _this.elm.disabled = false; }, 1);
}


function addEvent(elm, type, event) {
   if(elm.addEventListener) {
      elm.addEventListener(type, event, false);
   } else if(elm.attachEvent) {
      elm.attachEvent('on'+type, event);
   } else {
      elm['on'+type] = event;
   }
}
