<?php
	require_once('./config.inc.php');
	require_once(TODOTASK_CTRL_DIR.'/task.class.php');
	require_once(TODOTASK_CTRL_DIR.'/datafile.class.php');
	require_once(TODOTASK_CTRL_DIR.'/email.class.php');

	// ページロード
	$page = gfPageLoad();

	$page->title = TITLE_TASKINPUT;
	$page->protype_flg = "1";
	$page->group_no = gfIssetGET('group_no',""); 
	$page->taskbox_id = gfIssetGET('taskboxid',""); 
	$page->task_no = gfIssetGET('taskno',""); 
	$page->mode = gfIssetGET('mode',TASK_CLASS_MODE_NEW); 
	$page->gmode = gfIssetGET('gmode',TASK_MODE_PAGE);	// グループモードの確認 
	$page->pageno = gfIssetGET('pageno',"1"); 
	// ファイルアップロード

	$page->up_data = gfIssetFILE('upfile',""); 

	// CSRF対策
	$page->csrf = ""; 	 

	if (isset($_POST['mode'])) {
		// パラメーターの確認
		$page->group_no = gfIssetPOST('group_no',""); 		//グループID
		$page->task_no = gfIssetPOST('taskno',""); 		//タスクNO
		$page->taskbox_id = gfIssetPOST('taskboxid',""); 	//タスクボックスID
		$page->mode = gfIssetPOST('mode',""); 	 			//追加,変更モード
		$page->csrf = gfIssetPOST('csrf',""); 	 			//CSRF対策
		$page->gmode = gfIssetPOST('gmode',""); 			//タスクボックス表示モードでアクセスしたとき1
		$page->pageno = gfIssetPOST('pageno',1);
	
		// 追加用
		$page->aryTask['newtaskbox_id'] = gfIssetPOST('newtaskboxid',""); 	 //タスクボックスID(更新処理用)
		$page->aryTask['gains'] = gfIssetPOST('gains',""); 	 	//進捗度
		$page->aryTask['volume'] = gfIssetPOST('volume',""); 	//作業ボリューム
		$page->aryTask['volunit'] = gfIssetPOST('volunit',""); 	//作業ボリューム単位
		$page->aryTask['status'] = gfIssetPOST('status',""); 	//タスクステータス
		$page->aryTask['note'] = gfIssetPOST('note',""); 	 	//タスク
		$page->aryTask['timelimit'] = gfIssetPOST('timelimit',""); 	 //タスク期日
		$page->aryTask['priority'] = gfIssetPOST('priority',""); 	 //タスク優先度
		$page->aryTask['douser'] = gfIssetPOST('douser',""); 	//タスク担当者
		$page->aryTask['detail'] = gfIssetPOST('detail',""); 	//タスク詳細
		// 承認
		$page->aryApproval['approval_no'] = gfIssetPOST('approval_no',"");	//承認コード 

		// check page parameter
		$page->chkPage();
		gfChkIDType($page->aryTask['newtaskbox_id'],"0");
		// 数値型の確認
		gfChkNum($page->aryTask['gains'],"0");
		gfChkNum($page->aryTask['volume'],"0");
		gfChkNum($page->aryTask['status'],"0");
		gfChkNum($page->aryTask['priority'],"1");
		gfChkNum($page->aryApproval['approval_no'],"1");
		gfChkMaxMin($page->aryTask['gains'],"0","100");
		gfChkMaxMin($page->aryTask['volume'],"0","999");
		gfChkMaxMin($page->aryTask['priority'],1,TASK_PRIORITY_MAX);
		// 日付型の確認
		gfChkDate($page->aryTask['timelimit'],"");

		// 戻りURL
		$page->backurl = fBackUrl($page->group_no,$page->taskbox_id,$page->gmode,$page->pageno);

		// 必須チェック
		if ($page->mode==TASK_CLASS_MODE_EDIT_ACT || $page->mode==TASK_CLASS_MODE_ADD || $page->mode==TASK_CLASS_MODE_APP) {
			// パラメーターの確認
			if ($page->csrf != sha1($page->group_no.$page->task_no.CSRF_SEED)) {
				gfMsgWindow($page ,MSG_MODE_NOTE ,ART_TITLE , POST_ERR_001 ,$page->backurl ,MSG_NOR);
			}
			// 必須項目チェック
			if ($page->group_no == "" || $page->taskbox_id == "" || $page->aryTask['newtaskbox_id'] =="" ) {
				gfMsgWindow($page ,MSG_MODE_NOTE ,TASK_ART_004_1 , TASK_ART_004_2 ,$page->backurl ,MSG_NOR);
			} 
			if ($page->aryTask['note'] == "") {
				$page->aryTask['note'] = TASK_INPUT_NOTITLE;	// タイトルが無いとリストからリンクを貼れないので
			}
		} else {
			// 更新系以外でPOSTデータが渡された。
			// ARTMSG			
		}
	}

	// check page parameter
	$page->chkPage();

	// 戻りURL
	$page->backurl = fBackUrl($page->group_no,$page->taskbox_id,$page->gmode,$page->pageno);

	// ログイン確認
	$objTask = new Task();
	$objImg = new Datafile();
	$objMail = new EMail();
	
	$page->user_name = $objTask->get_loginname(); 
	$page->user_id = $objTask->get_loginid(); 
	$page->sumsize = 0; 

	// 取得したグループが存在するか確認
	if (!$objTask->ChkGroupMst($page->group_no,$page->taskbox_id)) {
		gfMsgWindow($page ,MSG_MODE_NOTE ,TASK_ART_001_1 , TASK_ART_001_2 ,$page->backurl ,MSG_NOR);
	}
	$page->group_name = $objTask->get_group_name($page->group_no); 


	if ($page->mode!=TASK_CLASS_MODE_EDIT)  {
		// ログイン状態の確認
		if (!$objTask->ChkLogin()) {
			$objTask->ctrl_movepage("userlogin.php");
		}
	}

	// 表示モードの取得
	$page->aryViewMode = $objTask->GetViewMode($page->group_no ,$page->gmode);
	// 指定したグループの表示モードが取得できませんでした。
	if (!isset($page->aryViewMode['taskboxmax'])) {
		gfMsgWindow($page ,MSG_MODE_NOTE ,TASK_ART_003_1 , TASK_ART_003_2 ,$page->backurl ,MSG_NOR);
	}
	// グループメール
	$page->grpmail_flg = $page->aryViewMode['grpmail_flg'];

	// メンバーチェック(参照しようとしているタスクのメンバーに登録されているか)
	$page->memLv = $objTask->ChkMember($page->group_no ,$page->user_id);
	// メンバーに所属していなくてメンバーモードの場合
	if ($page->memLv < GRPAUTH_MEM && $page->aryViewMode["view_flg"] != GRP_VIEW_OK) {
		gfMsgWindow($page ,MSG_MODE_NOTE ,TASK_ART_002_1 
			, TASK_ART_002_2
				.TASK_ART_002_3
				."<a href=\"grpjoin.php?group_no=".$page->group_no."\">"
				.TASK_ART_002_4 
			,$page->backurl ,MSG_NOR);
	}

	// タスク編集の場合。
	if ($page->mode==TASK_CLASS_MODE_EDIT)  {
	// 特定タスクの呼び出し編集
		$page->aryTask = $objTask->GetTaskForEdit($page->group_no,$page->taskbox_id,$page->task_no);
		$page->aryImgList = $objTask->GetTaskDataFile($page->group_no,$page->task_no);
		$page->aryCmntList = $objTask->GetCmnt($page->group_no,$page->task_no);
		$page->aryApproval = $objTask->GetApproval($page->group_no,$page->task_no);
		$page->sumsize = $objImg->GetUserFileSize($page->user_id);
		$page->mode = TASK_CLASS_MODE_EDIT_ACT;	// 更新モードの設定
	} else if ($page->mode==TASK_CLASS_MODE_EDIT_ACT) {
	// 更新処理
		// 削除処理
		if ($page->aryTask['status'] == TASK_STATUS_DEL) {
			// トランザクション発行
			$retDel = $objTask->begin_trans();
			if ($retDel) { 
				// タスクの削除
				$retDel = $objTask->DelTask(
								$page->group_no 
								,$page->taskbox_id 
								,$page->task_no
								,$page->aryTask['status']
								,$page->aryTask['note']);
				if ($retDel) { 
					$retDel = $objImg->DelDataFile(DELL_ALL ,$page->task_no ,$page->group_no ,$page->user_id);
				}	
				// コミット|ロールバック
				$objTask->commit_trans($retDel);
			}
			gfMsgWindow($page ,MSG_MODE_REDIRECT ,TITLE_MSGWIND ,TASK_MSG_007 ,$page->backurl ,MSG_NOR);

		} else {
		// 更新処理
			// トランザクション発行
			$retIns = $objTask->begin_trans();
			if ($retIns) { 
				// タスクの更新登録
				$retIns=$objTask->UpdTask(
							$page->group_no
							,$page->aryTask['newtaskbox_id']
							,$page->taskbox_id
							,$page->task_no
							,$page->aryTask['status']
							,$page->aryTask['note']
							,$page->aryTask['priority']
							,$page->aryTask['timelimit']
							,$page->aryTask['detail']
							,$page->aryTask['gains']
							,$page->aryTask['volume']
							,$page->aryTask['volunit']
							,$page->aryTask['douser']
							,$page->user_id);
				if ($retIns && $objImg->ChkFile($page->up_data)) { 
	
					// ファイルアップロードが許可されているか？
					if ($page->aryViewMode['grpfile_flg']==VIEW_OFF) {
						// 想定外ルート
						gfHackTryLog(__FILE__.__LINE__."grpfile_up");
						gfMsgWindow($page ,MSG_MODE_NOTE ,ART_TITLE , ERR_NO_MSG ,$page->backurl ,MSG_NOR);
					}

					// 画像の登録
					if ($objImg->ChkUpFile($page->up_data,true)) {
						// 画像登録
						$retIns=$objImg->InsDataFile($page->task_no ,$page->group_no ,$page->user_id);
					} else {
						// コミット|ロールバック
						$objTask->commit_trans($retIns);
						gfMsgWindow($page ,MSG_MODE_NOTE ,ART_TITLE , $objImg->get_errmsg() ,$page->backurl ,MSG_NOR);
					}
				}
				if ($retIns) {
					// 担当者へメールを送る必要がある場合送信処理
					$aryDousers =$objTask->GetBoxDouser($page->group_no,$page->aryTask['newtaskbox_id'],$page->aryTask['douser']);
					if (isset($aryDousers["user_mail"])) {
						$objMail->SendDouser($aryDousers["user_mail"],$aryDousers["user_name"],$page->group_no,$page->group_name,$page->aryTask['note'],$page->aryTask['detail']);
					}
				}

				// コミット|ロールバック
				$objTask->commit_trans($retIns);
			}	
			// 戻りURL
			$page->backurl = fBackUrl($page->group_no,$page->aryTask['newtaskbox_id'],$page->gmode,$page->pageno);
			gfMsgWindow($page ,MSG_MODE_REDIRECT ,TITLE_MSGWIND ,TASK_MSG_006 ,$page->backurl ,MSG_NOR);
		}

	} else if ($page->mode==TASK_CLASS_MODE_ADD) {
	// 新規追加
		// トランザクション発行
		$retIns = $objTask->begin_trans();
		if ($retIns) {
			// タスクの新規登録
			$retIns = $objTask->InsTask(
							$page->group_no
							,$page->aryTask['newtaskbox_id']
							,$page->aryTask['status']
							,$page->aryTask['note']
							,$page->aryTask['priority']
							,$page->aryTask['timelimit']
							,$page->aryTask['detail']
							,$page->aryTask['gains']
							,$page->aryTask['volume']
							,$page->aryTask['volunit']
							,$page->aryTask['douser']
							,$page->user_id);
			if ($retIns && $objImg->ChkFile($page->up_data)) {	
				// ファイルアップロードが許可されているか？
				if ($page->aryViewMode['grpfile_flg']==VIEW_OFF) {
					// 想定外ルート
					gfHackTryLog(__FILE__.__LINE__."grpfile_up");
					gfMsgWindow($page ,MSG_MODE_NOTE ,ART_TITLE , ERR_NO_MSG ,$page->backurl ,MSG_NOR);
				}

				// 画像の登録
				if ($objImg->ChkUpFile($page->up_data,true)) {
					// 最後に更新したタスクNoの取得
					$page->task_no = $objTask->last_task_no;
					// 画像登録
					$retIns=$objImg->InsDataFile($page->task_no ,$page->group_no ,$page->user_id);
				} else {
					// コミット|ロールバック
					$objTask->commit_trans($retIns);
					gfMsgWindow($page ,MSG_MODE_NOTE ,ART_TITLE , $objImg->get_errmsg() ,$page->backurl ,MSG_NOR);
				}
			}	
			
			if ($retIns) {
				// 担当者へメールを送る必要がある場合送信処理
				$aryDousers =$objTask->GetBoxDouser($page->group_no,$page->aryTask['newtaskbox_id'],$page->aryTask['douser']);
				if (isset($aryDousers["user_mail"])) {
					$objMail->SendDouser($aryDousers["user_mail"],$aryDousers["user_name"],$page->group_no,$page->group_name,$page->aryTask['note'],$page->aryTask['detail']);
				}
			} else {
				// コミット|ロールバック
				$objTask->commit_trans($retIns);
				gfMsgWindow($page ,MSG_MODE_NOTE ,ART_TITLE , $objImg->get_errmsg() ,$page->backurl ,MSG_NOR);
			}
			// コミット|ロールバック
			$objTask->commit_trans($retIns);
		}
		// 戻りURL
		$page->backurl = fBackUrl($page->group_no,$page->aryTask['newtaskbox_id'],$page->gmode,$page->pageno);
		gfMsgWindow($page ,MSG_MODE_REDIRECT ,TITLE_MSGWIND ,TASK_MSG_006 ,$page->backurl ,MSG_NOR);

	} else if ($page->mode==TASK_CLASS_MODE_APP) {
	// 承認処理
		// トランザクション発行
		$retIns = $objTask->begin_trans();
		if ($retIns) {
			// タスクの新規登録
			$retIns = $objTask->InsApprovel($page->group_no, $page->task_no, $page->taskbox_id, $page->aryApproval['approval_no'],$page->user_id,$page);
			// コミット|ロールバック
			$objTask->commit_trans($retIns);
		}
		// 戻りURL
		$page->backurl = fBackUrl($page->group_no,$page->aryTask['newtaskbox_id'],$page->gmode,$page->pageno);
		gfMsgWindow($page ,MSG_MODE_REDIRECT ,TITLE_MSGWIND ,TASK_MSG_008 ,$page->backurl ,MSG_NOR);
	} else if ($page->mode==TASK_CLASS_MODE_NEW) {
	// 新規作成用ページ呼び出し
		$page->mode = TASK_CLASS_MODE_ADD;	// 作成モードの設定
	}


	// CSRFの発行
	$page->csrf = sha1($page->group_no.$page->task_no.CSRF_SEED);
	// 担当者の取得
	$page->aryOptGrpMem = $objTask->GetGrpMemberList($page->group_no);
	// タスクボックスの取得
	$page->aryOptTaskBox = $objTask->GetTaskbox($page->group_no,$page->taskbox_id,TASK_MODE_PAGE);


	if (isset($page->aryTask['note'])) {
		$page->title = "[".$page->aryTask['note']."] ".$page->group_name.$page->title;
	}

	$page->display('/task/input.php');

	// ページ終了処理
	gfPageUnLoad();


// 戻りURL
function fBackUrl($group_no,$taskboxid,$gmode,$pageno){
	return ROOT_URL."tasklist.php?group_no=".$group_no."&taskboxid=".$taskboxid."&gmode=".$gmode."&pageno=".$pageno;
}


?>