<?php
//include_once('config_auth.ini.php');	// 設定用ファイル

class AuthHatena {

    const HATENA_AUTH_PORT = 80;		// ポート
    const HATENA_AUTH_TIMEOUT  = 10;	// タイムアウト
	const HATENA_AUTHURL = "auth.hatena.ne.jp";	// はてな認証URL

	private $login_state = false;
	private $login_id = "";
	private $err_msg = "";

	private $apikey = "";
	private $secret = "";

	public function __construct($apikey, $secret) {
		$this->apikey = $apikey;
		$this->secret = $secret;
	}

	// 
	// $cert = $_GET['cert'];
    public function getAuth($cert) {
		if ($cert == "" ) {
			return;
		}
		if (!HATENA_AUTHFLG) {
			return;
		}

		$api_sig = md5($this->secret."api_key".$this->apikey."cert".$cert);

		$param  = 'api_key='  . urlencode($this->apikey);
		$param .= '&cert='    . urlencode($cert);
		$param .= '&api_sig=' . urlencode($api_sig);

		$fp = fsockopen(AuthHatena::HATENA_AUTHURL
				, AuthHatena::HATENA_AUTH_PORT
				, $errno
				, $errstr
				, AuthHatena::HATENA_AUTH_TIMEOUT);
		if (!$fp) {
			$this->err_msg = "$errstr ($errno)<br />\n";
		} else {
			$out = "GET /api/auth.xml?$param HTTP/1.1\r\n";
			$out .= "Host: auth.hatena.ne.jp\r\n";
			$out .= "Connection: Close\r\n\r\n";

			fwrite($fp, $out);
			$ret = "";
			while (!feof($fp)) {
				$ret .= fgets($fp, 2048);
			}
			fclose($fp);
		}

		// はてなの認証XMLのパターン
		$pattern = '/(\s*<name>)(.*)(<\/name>)/';
		preg_match_all($pattern,$ret,$getAry);
		$hatenauserid = $getAry[2][0];

		// ユーザーIDを取得できた場合
		if ($hatenauserid != "") {
			// ログイン成功
			$this->login_state = true;
			$this->login_id = HATENA_SERVICEID . $hatenauserid;
			return true;
		} 
	}

	public function getLoginState(){
			return $this->login_state;
	}

	public function getLoginId(){
			return $this->login_id;
	}

	public function getLoginUrl() {
		$api_sig = md5($this->secret."api_key".$this->apikey);
		$loginurl = "http://auth.hatena.ne.jp/auth?api_key=".$this->apikey."&api_sig=".$api_sig;
		return $loginurl;
	}


}
