/*
 * tomoyo_signal_test.c
 *
 * Testing program for fs/tomoyo_signal.c
 *
 * Copyright (C) 2005-2006  NTT DATA CORPORATION
 *
 * Version: 1.0.2 2006/02/13
 *
 */
#include "include.h"

static int is_enforce = 0;

static void ShowPrompt(const char *str) {
	printf("Testing %35s: (%s) ", str, is_enforce ? "must fail" : "should success");
	errno = 0;
}

static void ShowResult(int result) {
	if (is_enforce) {
		if (result == EOF) {
			if (errno == EPERM) printf("OK: Permission denied.\n");
			else printf("FAILED: %s\n", strerror(errno));
		} else {
			printf("BUG!\n");
		}
	} else {
		if (result != EOF) printf("OK\n");
		else printf("%s\n", strerror(errno));
	}
	fflush(stdout);
}

static void SetSignalEnforce(int enforce) {
	if (enforce) {
		const char *cmd = "MAC_FOR_SIGNAL=3\n"; write(status_fd, cmd, strlen(cmd));
	} else {
		const char *cmd = "MAC_FOR_SIGNAL=2\n"; write(status_fd, cmd, strlen(cmd));
	}
}
	
int main(int argc, char *argv[]) {
	static char fd_buf[32];
	char c = 0;
	memset(fd_buf, 0, sizeof(fd_buf));
	signal(SIGTERM, SIG_IGN);
	if (argc == 1) {
		int i;
		if (access("/proc/ccs/", F_OK)) {
			fprintf(stderr, "You can't use this program for this kernel.\n");
			return 1;
		}
		for (i = 0; i < 2; i++) {
			switch (fork()) {
			case 0:
				{
					static int pipe_fd[2] = { EOF, EOF };
					if (socketpair(AF_UNIX, SOCK_STREAM, 0, pipe_fd) || fcntl(pipe_fd[1], F_SETFL, 0)) {
						fprintf(stderr, "FAILED to create socketpair.\n"); fflush(stderr);
						_exit(1);
					}
					snprintf(fd_buf, sizeof(fd_buf) - 1, "%d", pipe_fd[1]);
					switch (fork()) {
					case 0:
						close(pipe_fd[0]);
						execlp(argv[0], argv[0], !i ? "--enforce" : "--permissive", fd_buf, NULL);
						fprintf(stderr, "Can't start child.\n"); fflush(stderr);
						_exit(1);
					case -1:
						fprintf(stderr, "Can't fork()\n"); fflush(stderr);
						_exit(1);
					}
					close(pipe_fd[1]);
					//fprintf(stderr, "Parent Sleeper %d\n", getpid()); fflush(stderr);
					while (read(pipe_fd[0], &c, 1));
					close(pipe_fd[0]);
					_exit(0);
				}
			case -1:
				fprintf(stderr, "Can't fork()\n"); fflush(stderr);
				exit(1);
			}
			while (wait(NULL) != EOF || errno == EINTR);
		}
		return 0;
	}
	if (argc != 3) {
		fprintf(stderr, "Invalid argument.\n");
		return 1;
	}
	if (strcmp(argv[1], "--sleeper") == 0) {
		const int parent_pipe_fd = atoi(argv[2]);
		if (write(parent_pipe_fd, &c, 1) != 1) {
			fprintf(stderr, "Can't write to pipe.\n"); fflush(stderr);
			_exit(1);
		}
		//fprintf(stderr, "Child Sleeper %d\n", getpid()); fflush(stderr);
		while (read(parent_pipe_fd, &c, 1));
		return 0;
	}
	Init();
	if (strcmp(argv[1], "--enforce") == 0) {
		printf("***** Testing signal hooks in enforce mode. *****\n"); fflush(stdout);
		is_enforce = 1;
		SetSignalEnforce(1);
	} else {
		printf("***** Testing signal hooks in permissive mode. *****\n"); fflush(stdout);
		is_enforce = 0;
		SetSignalEnforce(0);
	}
	close(status_fd);
	{
		const int parent_pipe_fd = atoi(argv[2]);
		int child_pipe_fd[2] = { EOF, EOF };
		if (socketpair(AF_UNIX, SOCK_STREAM, 0, child_pipe_fd) || fcntl(child_pipe_fd[1], F_SETFL, 0)) {
			fprintf(stderr, "Can't create socketpair.\n"); fflush(stderr);
			exit(1);
		}
		snprintf(fd_buf, sizeof(fd_buf) - 1, "%d", child_pipe_fd[1]);
		{
			const pid_t pid = fork();
			switch (pid) {
			case 0:
				close(parent_pipe_fd);
				close(child_pipe_fd[0]);
				execlp(argv[0], argv[0], "--sleeper", fd_buf, NULL);
				fprintf(stderr, "Can't start child.\n"); fflush(stderr);
				_exit(1);
			case -1:
				fprintf(stderr, "Can't fork()\n"); fflush(stderr);
				exit(1);
			}
			if (read(child_pipe_fd[0], &c, 1) != 1) {
				fprintf(stderr, "Can't find child.\n"); fflush(stderr);
				exit(1);
			}
			//fprintf(stderr, "Operator %d\n", getpid()); fflush(stderr);
			ShowPrompt("kill-parent-domain");
			ShowResult(kill(getppid(), SIGTERM));
			ShowPrompt("kill-child-domain");
			ShowResult(kill(pid, SIGTERM));
		}
		fflush(stdout);
		close(child_pipe_fd[0]);
		close(child_pipe_fd[1]);
		close(parent_pipe_fd);
	}
	ClearStatus();
	return 0;
}
