#! /bin/sh
#
# Initial exception policy generator.
#
# Copyright (C) 2005-2006  NTT DATA CORPORATION
#
# Version: 1.0.2 2006/01/24
#
# Run this script and save the output as /root/security/exception_policy .
# You MUST review the content of /root/security/exception_policy
# because there would be redundant or dangerous entries.
#

#
# Make patterns for /proc/[number]/ directory.
#
for i in `find /proc/1/ ! -type l ! -type d`
do
	echo "file_pattern "$i | sed 's@/1/@/\\$/@g'
done | sort | uniq

#
# Make patterns for /sys/ directory.
#
if [ -e /sys/block/ ]
then
	for i in /sys/*
	do
		for j in `find $i | awk -F / ' { print NF-1 }'`
		do
			echo -n "file_pattern "$i; for ((k = 2; k < $j; k = $k + 1)); do echo -n '/\*'; done; echo
		done
	done | grep -F '\' | sort | uniq
fi

#
# Make patterns for /dev/ directory.
#
echo 'file_pattern /dev/pts/\$'
echo 'file_pattern /dev/vc/\$'
echo 'file_pattern /dev/tty\$'

#
# Make patterns for policy directory.
#
echo 'file_pattern /root/security/system_policy.\$-\$-\$.\$:\$:\$.txt'
echo 'file_pattern /root/security/exception_policy.\$-\$-\$.\$:\$:\$.txt'
echo 'file_pattern /root/security/domain_policy.\$-\$-\$.\$:\$:\$.txt'

#
# Make patterns for man directory.
#
for i in `find /usr/share/man/ -type f | awk -F / ' { print NF }' | sort | uniq`
do
	echo -n "file_pattern /usr/share/man"; for ((j = 4; j < $i; j = $j + 1)); do echo -n '/\*'; done; echo
done

#
# Make patterns for spool directory. (No trailing /, or detecting symlink fails.)
#
for i in /var/spool/clientmqueue /var/spool/mail /var/spool/mqueue /var/spool/at /var/spool/exim4/msglog /var/spool/exim4/input /var/spool/cron/atjobs
do
	[ -d $i/ -a ! -L $i ] && echo 'file_pattern '$i'/\*'
done

#
# Make patterns for mail(1).
#
echo 'file_pattern /tmp/Rs\?\?\?\?\?\?'
echo 'file_pattern /tmp/Rx\?\?\?\?\?\?'
echo 'file_pattern /tmp/mail.\?\?\?\?\?\?'

#
# Make patterns for man(1).
#
echo 'file_pattern /tmp/man.\?\?\?\?\?\?'

# Make patterns for mount(8).
echo 'file_pattern /etc/mtab~\$'

#
# Make patterns for crontab(1).
#
grep -q "Red Hat Linux" /etc/issue && echo 'file_pattern /tmp/crontab.\$'                     # RHL9
grep -q "Fedora Core" /etc/issue && echo 'file_pattern /tmp/crontab.XXXX\?\?\?\?\?\?'         # FC3
grep -q "Debian" /etc/issue && echo 'file_pattern /tmp/crontab.\?\?\?\?\?\?/crontab'          # Sarge

#
# Allow reading some data files.
#
for i in /etc/ld.so.cache /proc/meminfo /proc/sys/kernel/version /etc/localtime /usr/lib/gconv/gconv-modules.cache /usr/lib/locale/locale-archive /usr/share/locale/locale.alias /usr/share/locale/ja/LC_MESSAGES/coreutils.mo /usr/share/locale/ja/LC_MESSAGES/libc.mo
do
	FILE=`readlink -f $i`
	[ -n "$FILE" -a -r "$FILE" -a ! -L "$FILE" ] && echo 'allow_read '$FILE
done

#
# Allow reading DLL files registered with ldconfig(8).
#
for i in `ldconfig -NXp | grep -F '=>' | awk ' { print $NF } ' | sort | uniq`
do
	FILE=`readlink -f $i`
	[ -n "$FILE" -a -s "$FILE" -a ! -L "$FILE" ] && echo 'allow_read '$FILE
done | sort | uniq

#
# Mark programs under /etc/init.d/ directory as initializer.
#
for FILE in `for i in /etc/init.d/*; do readlink -f $i; done | sort | uniq`
do
	[ -n "$FILE" -a -f "$FILE" -a -x "$FILE" -a ! -L "$FILE" ] && echo "initializer "$FILE
done

#
# Mark some programs that you want to assign short domainname as initializer.
#
# RHL9:  /sbin/cardmgr /sbin/klogd /sbin/mingetty /sbin/portmap /sbin/rpc.statd /sbin/syslogd /usr/bin/jserver /usr/bin/spamd /usr/sbin/anacron /usr/sbin/apmd /usr/sbin/atd /usr/sbin/crond /usr/sbin/dhcpd /usr/sbin/gpm /usr/sbin/httpd /usr/sbin/nmbd /usr/sbin/rpc.mountd /usr/sbin/rpc.rquotad /usr/sbin/sendmail.sendmail /usr/sbin/smbd /usr/sbin/sshd /usr/sbin/vsftpd /usr/sbin/xinetd
# FC3:   /sbin/cardmgr /sbin/klogd /sbin/mingetty /sbin/portmap /sbin/rpc.statd /sbin/syslogd /sbin/udevd /usr/X11R6/bin/xfs /usr/bin/dbus-daemon-1 /usr/bin/mDNSResponder /usr/bin/nifd /usr/sbin/acpid /usr/sbin/anacron /usr/sbin/atd /usr/sbin/cannaserver /usr/sbin/cpuspeed /usr/sbin/crond /usr/sbin/cupsd /usr/sbin/gpm /usr/sbin/hald /usr/sbin/htt /usr/sbin/nmbd /usr/sbin/rpc.idmapd /usr/sbin/rpc.mountd /usr/sbin/rpc.rquotad /usr/sbin/smartd /usr/sbin/smbd /usr/sbin/sshd /usr/sbin/xinetd
# Sarge: /sbin/getty /sbin/klogd /sbin/portmap /sbin/rpc.statd /sbin/syslogd /usr/sbin/afpd /usr/sbin/apache2 /usr/sbin/atalkd /usr/sbin/atd /usr/sbin/cron /usr/sbin/exim4 /usr/sbin/inetd /usr/sbin/lpd /usr/sbin/nmbd /usr/sbin/papd /usr/sbin/smbd /usr/sbin/sshd /usr/sbin/vmware-guestd
#
# You can choose from the list above or add as you like to the list below.
#
for FILE in /sbin/getty /sbin/mingetty /sbin/udevd /usr/sbin/anacron /usr/sbin/apache2 /usr/sbin/atd /usr/sbin/cron /usr/sbin/crond /usr/sbin/httpd /usr/sbin/inetd /usr/sbin/smbd /usr/sbin/sshd /usr/sbin/vsftpd /usr/sbin/xinetd
do
  FILE=`readlink -f $FILE 2> /dev/null`
  [ -n "$FILE" -a -f "$FILE" -a -x "$FILE" -a ! -L "$FILE" ] && echo 'initializer '$FILE
done | sort | uniq

#
# Mark the following programs as initializer if they are symbolic links.
#
for i in /sbin/modprobe /sbin/hotplug
do
  if [ -L "$FILE" ]; then
      FILE=`readlink -f $i`
      [ -n "$FILE" -a -f "$FILE" -a -x "$FILE" -a ! -L "$FILE" ] && echo 'initializer '$FILE
  fi
done


#
# Make patterns for emacs(1).
#
[ -d /root/.emacs.d/ ] && echo 'file_pattern /root/.emacs.d/auto-save-list/.saves-\$-\*'

#
# Make patterns for mh-rmail from emacs(1).
#
[ -d /root/Mail/inbox/ ] && echo 'file_pattern /root/Mail/inbox/\$'

#
# Make patterns for ksymoops(8).
#
[ -d /var/log/ksymoops/ ] && echo 'file_pattern /var/log/ksymoops/\*'
		
#
# Miscellaneous patterns.
#
if grep -q "Red Hat Linux" /etc/issue; then
	[ -d /etc/mrtg/ ]                 && echo 'file_pattern /etc/mrtg/mrtg.cfg_l_\$'
	[ -e /var/lib/dhcp/dhcpd.leases ] && echo 'file_pattern /var/lib/dhcp/dhcpd.leases.\$'
	[ -d /var/log/sa/ ]               && echo 'file_pattern /var/log/sa/sa\*'
	[ -d /var/log/samba/ ]            && echo 'file_pattern /var/log/samba/\*'
	[ -d /var/mailman/locks/ ]        && echo 'file_pattern /var/mailman/locks/gate_news.lock.\*'
	[ -x /usr/sbin/gpm ]              && echo 'file_pattern /var/run/gpm\?\?\?\?\?\?'
	echo 'file_pattern /tmp/autofs.\?\?\?\?\?\?'
	echo 'file_pattern /tmp/initrd.\?\?\?\?\?\?/'
	echo 'file_pattern /tmp/initrd.img.\?\?\?\?\?\?'
	echo 'file_pattern /tmp/initrd.mnt.\?\?\?\?\?\?/'
	echo 'file_pattern /tmp/logrotate.\?\?\?\?\?\?'
	echo 'file_pattern /tmp/logwatch.XX\?\?\?\?\?\?/'
	echo 'file_pattern /tmp/logwatch.XX\?\?\?\?\?\?/\*'
	echo 'file_pattern /tmp/mail.\?\?\?\?\?\?'
	echo 'file_pattern /tmp/makewhatis\?\?\?\?\?\?/'
	echo 'file_pattern /tmp/makewhatis\?\?\?\?\?\?/w'
	echo 'file_pattern /tmp/man.\?\?\?\?\?\?'
	echo 'file_pattern /tmp/spamassassin-\$'
	echo 'file_pattern /tmp/spamassassin-\$/'
	echo 'file_pattern /tmp/spamassassin-\$/.spamassassin/'
	echo 'file_pattern /tmp/spamassassin-\$/.spamassassin/auto-whitelist\*'
fi

if grep -q "Fedora Core" /etc/issue; then
	[ -f /var/lib/dhcp/dhcpd.leases ] && echo 'file_pattern /var/lib/dhcp/dhcpd.leases.\$'
	[ -d /var/lock/mrtg/ ]            && echo 'file_pattern /var/lock/mrtg/mrtg_l_\$'
	[ -f /etc/blkid.tab ]             && echo 'file_pattern /etc/blkid.tab-\?\?\?\?\?\?'
	[ -d /dev/.udev/queue/ ]          && echo 'file_pattern /dev/.udev/queue/\*'
	[ -d /var/lib/mlocate/ ]          && echo 'file_pattern /var/lib/mlocate/mlocate.db.\?\?\?\?\?\?'
	echo 'file_pattern /etc/.fstab.hal.\?'
	echo 'file_pattern /var/cache/logwatch/logwatch.\*/'
	echo 'file_pattern /var/cache/logwatch/logwatch.\*/\*'
	echo 'file_pattern /var/lock/autofs.\$'
	echo 'file_pattern /tmp/autofs.\?\?\?\?\?\?'
	echo 'file_pattern /tmp/file\?\?\?\?\?\?'
	echo 'file_pattern /tmp/logrotate.\?\?\?\?\?\?'
	echo 'file_pattern /tmp/logwatch.\*/'
	echo 'file_pattern /tmp/logwatch.\*/\*'
	echo 'file_pattern /tmp/sh-thd-\$'
	echo 'file_pattern /tmp/whatis.\?\?\?\?\?\?'
	echo 'file_pattern /tmp/auto\?\?\?\?\?\?'
	echo 'file_pattern /tmp/auto\?\?\?\?\?\?/'
	echo 'file_pattern /tmp/makewhatis.\?\?\?\?\?\?'
fi

if grep -q "Debian" /etc/issue; then
	echo 'file_pattern /tmp/ex4\?\?\?\?\?\?'
	echo 'file_pattern /tmp/logrotate.\?\?\?\?\?\?'
	echo 'file_pattern /tmp/sh-thd-\$'
	echo 'file_pattern /tmp/tmpf\?\?\?\?\?\?'
	echo 'file_pattern /tmp/zman\?\?\?\?\?\?'
	echo 'file_pattern /var/cache/man/\$'
	echo 'file_pattern /var/cache/man/\*/\$'
	[ -d /var/spool/exim4/input/ ] && echo 'file_pattern /var/spool/exim4/input/\*'
	[ -d /var/spool/exim4/msglog/ ] && echo 'file_pattern /var/spool/exim4/msglog/\*'
fi

#
# Mark domain for power-off as trusted.
#
grep -q "Red Hat Linux" /etc/issue && echo 'trust_domain <kernel> /etc/rc.d/init.d/halt /sbin/halt' # RHL9
grep -q "Fedora Core" /etc/issue   && echo 'trust_domain <kernel> /etc/rc.d/init.d/halt /sbin/halt' # FC3
grep -q "Debian" /etc/issue        && echo 'trust_domain <kernel> /etc/init.d/halt /sbin/halt'      # Sarge
grep -q "Debian" /etc/issue        && echo 'trust_domain <kernel> /etc/init.d/reboot /sbin/halt'    # Sarge
