/*
 * makelink.cpp
 *
 * Create links for the given pathnames.
 *
 * Copyright (C) 2005-2006  NTT DATA CORPORATION
 *
 * Version: 1.0 2005/11/11
 *
 * This program creates minimal symbolic links.
 * Parent directories are created with permission 0755.
 *
 */
#include <iostream>
#include <sstream>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
using namespace std;

static string decode(const string filename) {
	ostringstream buf;
	int index = 0;
	char c, d, e;
	while ((c = filename[index++]) != '\0') {
		if (c == '\\') {
			switch ((c = filename[index++])) {
			case '\\':      /* "\\" */
				buf << c;
				continue;
			case '0':       /* "\ooo" */
			case '1':
			case '2':
			case '3':
				if ((d = filename[index++]) >= '0' && d <= '7' && (e = filename[index++]) >= '0' && e <= '7') {
					const unsigned char f =
						(((unsigned char) (c - '0')) << 6) +
						(((unsigned char) (d - '0')) << 3) +
						(((unsigned char) (e - '0')));
					if (f && (f <= ' ' || f >= 127)) {
						buf << f;
						continue; /* pattern is not \000 */
					}
				}
			}
			return "";
		} else if (c <= ' ' || c >= 127) {
			return "";
		}
		buf << c;
	}
	return buf.str();
}

int main(int argc, char *argv[]) {
	string line;
	if (argc > 1 && chroot(argv[1]) || chdir("/")) {
		cerr << argv[0] << " [chroot_dir] [ < linked_filelist_file ]" << endl;
		return 0;
	}
	// Read the output of dumplink.
	while (getline(cin, line)) {
		istringstream tokenizer(line);
		string filename;
		while (tokenizer >> filename) {
			struct stat buf, buf2;
			filename = decode(filename);
			if (lstat(filename.c_str(), &buf)) continue;
			istringstream tokenizer(line);
			string filename_alias;
			while (tokenizer >> filename_alias) {
				filename_alias = decode(filename_alias);
				if (filename == filename_alias) continue;
				if (lstat(filename_alias.c_str(), &buf2) || memcmp(&buf, &buf2, sizeof(buf))) {
					// Create directories which links are created in.
					for (int i = 1; i < (int) filename.size(); i++) {
						if (filename[i] == '/') if (mkdir(filename.substr(0, i).c_str(), 0755) == 0) cout << "mkdir " << filename.substr(0, i);
					}
					for (int i = 1; i < (int) filename_alias.size(); i++) {
						if (filename_alias[i] == '/') if (mkdir(filename_alias.substr(0, i).c_str(), 0755) == 0) cout << "mkdir " << filename_alias.substr(0, i);
					}
					// Create links, after removeing old files.
					if (unlink(filename_alias.c_str()) && errno != ENOENT) {
						cerr << "Can't unlink " << filename_alias << endl;
					} else if (link(filename.c_str(), filename_alias.c_str())) {
						cerr << "Can't link " << filename << " to " << filename_alias << endl;
					} else {
						// Show what was done by this program.
						cout << "ln " << filename << " " << filename_alias << endl;
					}
				}
			}
			break;
		}
	}
	return 0;
}
