/*
 * setlevel.c
 *
 * Access Control Status Controller.
 *
 * Copyright (C) 2005-2006  NTT DATA CORPORATION
 *
 * Version: 1.0 2005/11/11
 *
 * This program controls access control status.
 * This program is almost the same as "cat".
 * Since programs that can update policies are restricted by pathnames,
 * pathnames that are called by other programs shouldn't be registered
 * as programs that can update policies.
 *
 * You may copy "cat" as other unique name (for example, "cat.exe"),
 * if you want to do "echo TOMOYO_VERBOSE=1 | cat.exe > /proc/ccs/status".
 * You shouldn't do "echo TOMOYO_VERBOSE=1 | cat > /proc/ccs/status", for
 * other programs may call "cat".
 *
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

int main(int argc, char *argv[]) {
	static const char *policy_file = "/proc/ccs/status";
	int i, fd;
	char c;
	if (access("/proc/ccs/", F_OK)) {
		fprintf(stderr, "You can't use this command for this kernel.\n");
		return 1;
	}
	if ((fd = open(policy_file, O_RDWR)) == EOF) {
		fprintf(stderr, "Can't open %s\n", policy_file);
		return 1;
	} else if (write(fd, "", 0) != 0) {
		fprintf(stderr, "You need to register this program to /root/security/manager.txt and reboot to run this program.\n");
		return 1;
	}
	if (argc > 1) {
		for (i = 1; i < argc; i++) {
			write(fd, argv[i], strlen(argv[i])); write(fd, "\n", 1);
		}
	}
	printf("<<< Access Control Status >>>\n");
	while (read(fd, &c, 1) == 1) putchar(c);
	close(fd);
	return 0;
}
