/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.base.ssh.connection;

import java.io.File;
import java.util.Observable;

import jp.sourceforge.tomoyo.base.ssh.Activator;
import jp.sourceforge.tomoyo.core.server.Connection;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;

public class SSHSession extends Observable implements Connection {

	protected SSHConnectionSettings settings = null;
	
	protected Session session = null;

	public SSHSession(SSHConnectionSettings settings) {
		this.settings = settings;
	}

	private void notifyObservers(int statusDisconnected) {
		setChanged();
		notifyObservers(settings);
	}

	//--------------------------------------------------------------------------------------------------
	// Connection related
	//--------------------------------------------------------------------------------------------------
	
	public boolean isConnected() {
		if (session == null)
			return false;
		return session.isConnected();
	}
	
	private class ConfirmDialog implements Runnable {
		private boolean connect;
		public void run() {
			connect = MessageDialog.openQuestion(
					Activator.getStandardDisplay().getActiveShell(),
					Messages.SSHSession_ConnectConfirmDialogTitle,
					Messages.SSHSession_ConnectConfirmMessage);
		}
		public boolean isConnecting() {
			return connect;
		}
	}
	
	public boolean connect() {
		try {
			if (settings.confirmConnection) {
				ConfirmDialog dialog = new ConfirmDialog();
				Display.getDefault().syncExec(dialog);
				if (!dialog.isConnecting())
					return false;
			}
			
			if (settings.isPublicKeyAuthentication) {
				connect(settings.hostname, settings.portno, settings.username, settings.knownHosts, settings.pkeyfile);
			} else {
				connect(settings.hostname, settings.portno, settings.username, settings.knownHosts, settings.password);
			}
			
			setErrorMessage(null);
			notifyObservers(STATUS_CONNECTING);
			return true;
		} catch (JSchException e) {
//			if (session != null)
//				session.disconnect();
//			disconnect();
			setErrorMessage(e.toString());
			notifyObservers(STATUS_DISCONNECTED);
			Activator.log(e);
			return false;
		}
	}

	private void connect(String host, int port, String username, File known_hosts, File private_key) throws JSchException {
		if (isConnected())
			return;
		JSch jsch = new JSch();
		SSHUserInfo ui = new SSHUserInfo();
		ui.setHoskeyCheck(known_hosts != null);
		if (known_hosts != null)
			jsch.setKnownHosts(known_hosts.getAbsolutePath());
		jsch.addIdentity(private_key.getAbsolutePath());
		session = jsch.getSession(username, host, port);
		session.setUserInfo(ui);
		session.connect();
	}

	private void connect(String host, int port, String username, File known_hosts, String password) throws JSchException {
		if (isConnected())
			return;
		JSch jsch = new JSch();
		SSHUserInfo ui = new SSHUserInfo();
		ui.setHoskeyCheck(known_hosts != null);
		ui.setPassword(password);
		if (known_hosts != null)
			jsch.setKnownHosts(known_hosts.getAbsolutePath());
		session = jsch.getSession(username, host, port);
		session.setUserInfo(ui);
		session.connect();
	}

	
	public Channel getChannel() throws JSchException {
		if (!isConnected())
			connect();
		if (session == null)
			return null;
		return session.openChannel("exec"); //$NON-NLS-1$
	}

	public void disconnect() {
		if (session != null) {
			session.disconnect();
		}
		notifyObservers(STATUS_DISCONNECTED);
	}

	private String errorMessage;

	private void setErrorMessage(String string) {
		errorMessage = string;
	}

	public String getErrorMessage() {
		return errorMessage;
	}

}

