/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.base.ssh.connection;

import jp.sourceforge.tomoyo.base.ssh.Activator;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.jcraft.jsch.UserInfo;

public class SSHUserInfo implements UserInfo {
	
	private boolean hostkeyCheck;
	
	public boolean promptYesNo(String str) {
    	return !hostkeyCheck;
    }
    
	private String passphrase;
	
	public boolean promptPassphrase(final String message) {
		Activator.getStandardDisplay().syncExec(new Runnable() {
			public void run() {
				InputDialog dialog = new PasswordInputDialog(Activator.getStandardDisplay().getActiveShell(), message);
				if (dialog.open() == Window.OK) {
					passphrase = dialog.getValue();
				} else {
					passphrase = null;
				}
			}
		});
		return true;
	}

	public String getPassphrase() {
		return passphrase;
	}

	private String password;
	
	public boolean promptPassword(final String message) {
		Activator.getStandardDisplay().syncExec(new Runnable() {
			public void run() {
				if (password == null) {
					InputDialog dialog = new PasswordInputDialog(Activator.getStandardDisplay().getActiveShell(), message);
					if (dialog.open() == Window.OK) {
						password = dialog.getValue();
					} else {
						password = null;
					}
				}
			}
		});
		return true;
    }
    
	public String getPassword() {
		return password;
	}
    
	public void setPassword(String password) {
		this.password = password;
	}
	
	public void showMessage(String message) {
    }
	
	public void setHoskeyCheck(boolean hostkeyCheck) {
		this.hostkeyCheck = hostkeyCheck;
	}

	private class PasswordInputDialog extends InputDialog {
		public PasswordInputDialog(Shell parentShell, String message) {
			super(parentShell, Messages.SSHUserInfo_InputPasswordDialogTitle, message, "", null); //$NON-NLS-2$
		}
	    /* (non-Javadoc)
	     * @see org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets.Composite)
	     */
		protected Control createDialogArea(Composite parent) {
	        Control control = super.createDialogArea(parent);
	        Text text = getText();
	        text.setEchoChar('*');
	        return control;
	    }
		class PasswordValidator implements IInputValidator {
			public String isValid(String input) {
//				String password = input.trim();
				return null;
			}
		}
	}

}

