/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.base.ssh.ui;

import java.util.Observable;
import java.util.Observer;

import jp.sourceforge.tomoyo.base.ssh.Activator;
import jp.sourceforge.tomoyo.core.PersistentPropertyManager;
import jp.sourceforge.tomoyo.core.ProjectProperty;
import jp.sourceforge.tomoyo.core.ProjectPropertyManager;
import jp.sourceforge.tomoyo.core.server.ConnectionManager;
import jp.sourceforge.tomoyo.core.server.ConnectionStatus;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class UIUtilities {

	private IProject project = null;
	
	public UIUtilities(IProject project) {
		this.project = project;
	}
	
	private static FormToolkit toolkit = null;
	
	private FormToolkit getToolkit() {
		if (toolkit == null)
			toolkit = new FormToolkit(Activator.getStandardDisplay());
		return toolkit;
	}
	
	private ProjectProperty getProjectProperty() {
		return ProjectPropertyManager.getInstance().getProperty(project);
	}
	
	public void createSettingComposite(Composite parent) {
		parent.setLayout(new GridLayout(4, false));
		GridData data = new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1);
		parent.setLayoutData(data);

//		new ConnectionComposite(parent);
		createConnectionOnOffComposites(parent);

		createAuthenticationMethodComposites(parent);
		
		createLoginUserComposites(parent);
		
		if (getProjectProperty().usePublicKeyAuthentication()) {
			createPrivateKeyComposites(parent);
		} else {
			createRememberPasswordComposites(parent);
		}

		if (getProjectProperty().useKnownHostsCheck())
			createKnownHostsComposites(parent);
		else
			createUseKnownHostsCheckComposites(parent);
	}

	private Image connecedImage = Activator.getImage("connected.gif"); //$NON-NLS-1$
	private Image notConnecedImage = new Image(Display.getCurrent(), connecedImage, SWT.IMAGE_GRAY);
	
	private void createConnectionOnOffComposites(Composite parent) {
		FormToolkit toolkit = getToolkit();

		Label title = toolkit.createLabel(parent, Messages.ProjectOverviewPage_Connect2ServerTitle + " :"); //$NON-NLS-2$ //$NON-NLS-1$ //$NON-NLS-1$ //$NON-NLS-1$ //$NON-NLS-1$
		title.setForeground(toolkit.getColors().getColor(FormColors.TITLE));
		title.setLayoutData(new GridData(GridData.BEGINNING, GridData.CENTER, true, false, 1, 1));

		final ImageHyperlink connectLink = new ImageHyperlink(parent, SWT.NULL);
		connectLink.setBackground(parent.getBackground());
		connectLink.setText(Messages.ProjectOverviewPage_Connect2ServerLinkText);
		connectLink.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, true, false));
		connectLink.setEnabled(true);
		connectLink.addHyperlinkListener(new HyperlinkAdapter() {
			@Override
			public void linkActivated(HyperlinkEvent e) {
				ConnectionManager.getInstance().connect(project);
			}
		});
		if (getProjectProperty().usePublicKeyAuthentication())
			connectLink.setForeground(JFaceColors.getActiveHyperlinkText(Activator.getStandardDisplay()));
		else
			connectLink.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_GRAY));
		
		final ImageHyperlink disConnectLink = new ImageHyperlink(parent, SWT.NULL);
		disConnectLink.setBackground(parent.getBackground());
		disConnectLink.setText(Messages.ProjectOverviewPage_DisconnectFromServerLinkText);
		disConnectLink.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false));
		disConnectLink.setEnabled(false);
		disConnectLink.addHyperlinkListener(new HyperlinkAdapter() {
			@Override
			public void linkActivated(HyperlinkEvent e) {
				boolean b = MessageDialog.openQuestion(
						Activator.getStandardDisplay().getActiveShell(),
						Messages.ProjectOverviewPage_DisconnectFromServerQuestionDialogTitle,
						Messages.ProjectOverviewPage_DisconnectFromServerQuestionDialogDescription
						);
				if (b) {
					ConnectionManager.getInstance().disConnect(project);
				}
			}
		});
		if (getProjectProperty().usePublicKeyAuthentication())
			disConnectLink.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_GRAY));
		else
			disConnectLink.setForeground(JFaceColors.getActiveHyperlinkText(Activator.getStandardDisplay()));
		
		final ImageHyperlink imageLink = new ImageHyperlink(parent, SWT.NULL);
		imageLink.setBackground(parent.getBackground());
		imageLink.setEnabled(false);
		imageLink.setImage(notConnecedImage);
		imageLink.redraw();

		ConnectionManager.getInstance().addObserver(new Observer() {
			@Override
			public void update(Observable arg0, Object arg1) {
				ConnectionStatus status = (ConnectionStatus)arg1;
				if (status.getProject().equals(project)) {
					Display.getDefault().asyncExec(new Runnable() {
						public void run() {
							if (connectLink.isDisposed())
								return;
							if (ConnectionManager.getInstance().isConnected(project)) {
								connectLink.setEnabled(false);
								disConnectLink.setEnabled(true);
								connectLink.setForeground(JFaceColors.getActiveHyperlinkText(Display.getCurrent()));
								disConnectLink.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_GRAY));
								imageLink.setImage(connecedImage);
							} else {
								connectLink.setEnabled(true);
								disConnectLink.setEnabled(false);
								connectLink.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_GRAY));
								disConnectLink.setForeground(JFaceColors.getActiveHyperlinkText(Activator.getStandardDisplay()));
								imageLink.setImage(notConnecedImage);
							}
							connectLink.redraw();
							disConnectLink.redraw();
							connectLink.redraw();
							disConnectLink.redraw();
							imageLink.redraw();
						}
					});
				}
			}
		});
	}
	/*
	private class ConnectionComposite extends Composite implements Observer, IHyperlinkListener {
		private final String TITLE = Messages.ProjectOverviewPage_Connect2ServerTitle;
		private ImageHyperlink connectLink;
		private ImageHyperlink disConnectLink;
		
		private ImageHyperlink imageLink;
		private Image connecedImage = Activator.getImage("connected.gif"); //$NON-NLS-1$
		private Image notConnecedImage = new Image(Display.getCurrent(), connecedImage, SWT.IMAGE_GRAY);
		public ConnectionComposite(Composite parent) {
			super(parent, SWT.NULL);
			createComposite();
			updateComposite();
			ConnectionManager.getInstance().addObserver(this);
		}
		private void createComposite() {
			FormToolkit toolkit = getToolkit();
			setBackground(getParent().getBackground());
			GridLayout gridLayout = new GridLayout(4, false);
			gridLayout.marginHeight = gridLayout.marginWidth = 0;
			gridLayout.marginTop = gridLayout.marginBottom = 0;
			setLayout(gridLayout);
			setLayoutData(new GridData(GridData.FILL, GridData.FILL, true, false, 1, 1));
			Label title = toolkit.createLabel(this, TITLE + " :"); //$NON-NLS-1$
			title.setForeground(toolkit.getColors().getColor(FormColors.TITLE));
			title.setLayoutData(new GridData(GridData.BEGINNING, GridData.CENTER, true, false, 1, 1));

			connectLink = new ImageHyperlink(this, SWT.NULL);
			connectLink.setBackground(getBackground());
			connectLink.setText(Messages.ProjectOverviewPage_Connect2ServerLinkText);
			connectLink.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false));
			connectLink.addHyperlinkListener(this);
			
			disConnectLink = new ImageHyperlink(this, SWT.NULL);
			disConnectLink.setBackground(getBackground());
			disConnectLink.setText(Messages.ProjectOverviewPage_DisconnectFromServerLinkText);
			disConnectLink.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false));
			disConnectLink.addHyperlinkListener(this);
			
			imageLink = new ImageHyperlink(this, SWT.NULL);
			imageLink.setBackground(getBackground());
			imageLink.setEnabled(false);
			imageLink.addHyperlinkListener(this);
		}
		private void updateComposite() {
			if (isDisposed())
				return;
			if (ConnectionManager.getInstance().isConnected(project)) {
				connectLink.setEnabled(false);
				disConnectLink.setEnabled(true);
				connectLink.setForeground(JFaceColors.getActiveHyperlinkText(getDisplay()));
				disConnectLink.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_GRAY));
				imageLink.setImage(connecedImage);
			} else {
				connectLink.setEnabled(true);
				disConnectLink.setEnabled(false);
				connectLink.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_GRAY));
				disConnectLink.setForeground(JFaceColors.getActiveHyperlinkText(Activator.getStandardDisplay()));
				imageLink.setImage(notConnecedImage);
			}
			connectLink.redraw();
			disConnectLink.redraw();
			connectLink.redraw();
			disConnectLink.redraw();
			imageLink.redraw();
		}
		public void update(Observable o, Object arg) {
			ConnectionStatus status = (ConnectionStatus)arg;
			if (status.getProject().equals(project)) {
				Display.getDefault().asyncExec(new Runnable() {
					public void run() {
						updateComposite();
					}
				});
			}
		}
		public void linkActivated(HyperlinkEvent e) {
			if (e.getSource() == connectLink) {
				ConnectionManager.getInstance().connect(project);
			}
			if (e.getSource() == disConnectLink) {
				boolean b = MessageDialog.openQuestion(
						Activator.getStandardDisplay().getActiveShell(),
						Messages.ProjectOverviewPage_DisconnectFromServerQuestionDialogTitle,
						Messages.ProjectOverviewPage_DisconnectFromServerQuestionDialogDescription
						);
				if (b) {
					ConnectionManager.getInstance().disConnect(project);
				}
			}
		}
		public void linkEntered(HyperlinkEvent e) {
		}
		public void linkExited(HyperlinkEvent e) {
		}
	}	
	*/
	private void createLoginUserComposites(Composite parent) {
		FormToolkit toolkit = getToolkit();
		Label label = toolkit.createLabel(parent, Messages.UIUtilities_LoginUserLabelTitle + " :"); //$NON-NLS-2$ //$NON-NLS-1$ //$NON-NLS-1$ //$NON-NLS-1$
		label.setForeground(toolkit.getColors().getColor(FormColors.TITLE));
		label.setLayoutData(new GridData(GridData.BEGINNING, GridData.CENTER, false, false, 1, 1));
		String property = getProjectProperty().getProperty(PersistentPropertyManager.PROPERTY_LOGIN_USERNAME);
		final Text text = toolkit.createText(parent, (property == null) ? "" : property, SWT.NULL); //$NON-NLS-1$
		text.setEditable(false);
		text.setLayoutData(new GridData(GridData.FILL, GridData.CENTER, true, false, 2, 1));
		Button button = toolkit.createButton(parent, "", SWT.NULL); //$NON-NLS-1$
		button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
			}
		});
		button.setImage(Activator.getImage("edit.gif")); //$NON-NLS-1$
		button.setLayoutData(new GridData(GridData.END, GridData.CENTER, false, false, 1, 1));
		button.setEnabled(false);
	}

	private void createAuthenticationMethodComposites(Composite parent) {
		FormToolkit toolkit = getToolkit();

		Label title = toolkit.createLabel(parent, Messages.UIUtilities_AuthenticationMethodLabelTitle + " :"); //$NON-NLS-2$ //$NON-NLS-1$ //$NON-NLS-1$ //$NON-NLS-1$ //$NON-NLS-1$
		title.setForeground(toolkit.getColors().getColor(FormColors.TITLE));
		title.setLayoutData(new GridData(GridData.BEGINNING, GridData.CENTER, true, false, 1, 1));

		ImageHyperlink link1 = new ImageHyperlink(parent, SWT.NULL);
		link1.setBackground(parent.getBackground());
		link1.setText(Messages.UIUtilities_PublicKeyLinkCaption);
		link1.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, true, false));
		link1.setEnabled(false);
		if (getProjectProperty().usePublicKeyAuthentication())
			link1.setForeground(JFaceColors.getActiveHyperlinkText(Activator.getStandardDisplay()));
		else
			link1.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_GRAY));
		
		ImageHyperlink link2 = new ImageHyperlink(parent, SWT.NULL);
		link2.setBackground(parent.getBackground());
		link2.setText(Messages.UIUtilities_PasswordLinkCaption);
		link2.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false));
		link2.setEnabled(false);
		if (getProjectProperty().usePublicKeyAuthentication())
			link2.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_GRAY));
		else
			link2.setForeground(JFaceColors.getActiveHyperlinkText(Activator.getStandardDisplay()));
		
		toolkit.createLabel(parent, ""); //$NON-NLS-1$
	}

	private void createRememberPasswordComposites(Composite parent) {
		FormToolkit toolkit = getToolkit();
		Label title = toolkit.createLabel(parent, Messages.UIUtilities_RememberPasswordLabelTitle + " :"); //$NON-NLS-2$ //$NON-NLS-1$ //$NON-NLS-1$ //$NON-NLS-1$
		title.setForeground(toolkit.getColors().getColor(FormColors.TITLE));
		title.setLayoutData(new GridData(GridData.BEGINNING, GridData.CENTER, true, false, 1, 1));
		ImageHyperlink link1 = new ImageHyperlink(parent, SWT.NULL);
		link1.setBackground(parent.getBackground());
		link1.setText(Messages.UIUtilities_Yes);
		link1.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, true, false));
		link1.setEnabled(false);
		String password = getProjectProperty().getProperty(PersistentPropertyManager.PROPERTY_LOGIN_PASSWORD);
		if (password != null)
			link1.setForeground(JFaceColors.getActiveHyperlinkText(Activator.getStandardDisplay()));
		else
			link1.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_GRAY));
		
		ImageHyperlink link2 = new ImageHyperlink(parent, SWT.NULL);
		link2.setBackground(parent.getBackground());
		link2.setText(Messages.UIUtilities_No);
		link2.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false));
		link2.setEnabled(false);
		if (password != null)
			link2.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_GRAY));
		else
			link2.setForeground(JFaceColors.getActiveHyperlinkText(Activator.getStandardDisplay()));
		
		toolkit.createLabel(parent, ""); //$NON-NLS-1$
	}
	
	private void createKnownHostsComposites(Composite parent) {
		FormToolkit toolkit = getToolkit();
		Label label = toolkit.createLabel(parent, Messages.UIUtilities_KnownHostsLabelTitle + " :");//$NON-NLS-2$ //$NON-NLS-1$ //$NON-NLS-1$ //$NON-NLS-1$
		label.setForeground(toolkit.getColors().getColor(FormColors.TITLE));
		label.setLayoutData(new GridData(GridData.BEGINNING, GridData.CENTER, false, false, 1, 1));
		String property = getProjectProperty().getProperty(PersistentPropertyManager.PROPERTY_KNOWN_HOSTS);
		final Text text = toolkit.createText(parent, (property == null) ? "" : property, SWT.NULL); //$NON-NLS-1$
		text.setEditable(false);
		text.setLayoutData(new GridData(GridData.FILL, GridData.CENTER, true, false, 2, 1));
		Button button = toolkit.createButton(parent, "", SWT.NULL); //$NON-NLS-1$
		button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
			}
		});
		button.setImage(Activator.getImage("edit.gif")); //$NON-NLS-1$
		button.setLayoutData(new GridData(GridData.END, GridData.CENTER, false, false, 1, 1));
		button.setEnabled(false);
	}
	
	private void createUseKnownHostsCheckComposites(Composite parent) {
		FormToolkit toolkit = getToolkit();
		Label title = toolkit.createLabel(parent, Messages.UIUtilities_UseKnownHostsLabelTitle + " :"); //$NON-NLS-2$ //$NON-NLS-1$ //$NON-NLS-1$ //$NON-NLS-1$ //$NON-NLS-1$
		title.setForeground(toolkit.getColors().getColor(FormColors.TITLE));
		title.setLayoutData(new GridData(GridData.BEGINNING, GridData.CENTER, true, false, 1, 1));
		ImageHyperlink link1 = new ImageHyperlink(parent, SWT.NULL);
		link1.setBackground(parent.getBackground());
		link1.setText(Messages.UIUtilities_Yes);
		link1.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, true, false));
		link1.setEnabled(false);
		if (getProjectProperty().useKnownHostsCheck())
			link1.setForeground(JFaceColors.getActiveHyperlinkText(Activator.getStandardDisplay()));
		else
			link1.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_GRAY));
		
		ImageHyperlink link2 = new ImageHyperlink(parent, SWT.NULL);
		link2.setBackground(parent.getBackground());
		link2.setText(Messages.UIUtilities_No);
		link2.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false));
		link2.setEnabled(false);
		if (getProjectProperty().useKnownHostsCheck())
			link2.setForeground(Display.getCurrent().getSystemColor(SWT.COLOR_GRAY));
		else
			link2.setForeground(JFaceColors.getActiveHyperlinkText(Activator.getStandardDisplay()));
		
		toolkit.createLabel(parent, ""); //$NON-NLS-1$
	}
	
	private void createPrivateKeyComposites(Composite parent) {
		FormToolkit toolkit = getToolkit();
		Label label = toolkit.createLabel(parent, Messages.UIUtilities_PrivateKeyFile + " :"); //$NON-NLS-2$
		label.setForeground(toolkit.getColors().getColor(FormColors.TITLE));
		label.setLayoutData(new GridData(GridData.BEGINNING, GridData.CENTER, false, false, 1, 1));
		String property = getProjectProperty().getProperty(PersistentPropertyManager.PROPERTY_PRIVATE_KEY);
		final Text text = toolkit.createText(parent, (property == null) ? "" : property, SWT.NULL); //$NON-NLS-1$
		text.setEditable(false);
		text.setLayoutData(new GridData(GridData.FILL, GridData.CENTER, true, false, 2, 1));
		Button button = toolkit.createButton(parent, "", SWT.NULL); //$NON-NLS-1$
		button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
			}
		});
		button.setImage(Activator.getImage("edit.gif")); //$NON-NLS-1$
		button.setLayoutData(new GridData(GridData.END, GridData.CENTER, false, false, 1, 1));
		button.setEnabled(false);
	}
	
}
