/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class DistributionSelectionPage extends AbstractWizardPage {

	private static final String PAGE_DESCRPTION = Messages.DistributionSelectionPage_PageDescription;

	public DistributionSelectionPage() {
		super(Messages.DistributionSelectionPage_PageName);
		setTitle(Messages.DistributionSelectionPage_PageTitle);
		setDescription(PAGE_DESCRPTION);
		setPageComplete(false);
	}
	
	protected String getHelpResourceName() {
		return "select_distribution";
	}

	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout(3, false);
		composite.setLayout(layout);
		createDistroGroup(composite);
		setControl(composite);
	}

	protected void hookFirstVisit() {
		setPreviousPage(null);
	}

	/*
	private void createDistroGroup(Composite container) {
		Label label = new Label(container, SWT.NONE);
		label.setText(Messages.DistributionSelectionPage_DistributionTitle);
		GridData griddata = new GridData();
		griddata.horizontalSpan = 2;
		griddata.widthHint = 300;
		distroCombo = new Combo(container, SWT.SINGLE | SWT.BORDER);
		distroCombo.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		distroCombo.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				inputChanged();
			}
		});
		distroCombo.setLayoutData(griddata);
		distroCombo.setText(Messages.DistributionSelectionPage_DistroComboText);
    }
	*/
	
	private Button[] checkButtons = new Button[DistributionManager.getDistributionCount()];
	
	private void createDistroGroup(Composite composite) {
		GridLayout layout = new GridLayout(1, false);
		Composite container = new Composite(composite, SWT.NONE);
		
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		container.setLayoutData(data);
		container.setLayout(layout);

		Distribution[] distros = DistributionManager.listDeistibutions();
		for (int cnt = 0; cnt < distros.length; cnt++) {
			checkButtons[cnt] = new Button(container, SWT.RADIO);
			checkButtons[cnt].setText(distros[cnt].getName());
			checkButtons[cnt].setSelection(false);
			checkButtons[cnt].addSelectionListener(new SelectionListener() {
				public void widgetDefaultSelected(SelectionEvent e) {
				}
				public void widgetSelected(SelectionEvent e) {
					inputChanged();
				}
			});
			checkButtons[cnt].setEnabled(distros[cnt].isSupported());
		}
	}
	
	private void inputChanged() {
		int selection = getSelectedVersionIndex();
		if (selection < 0) {
			setPageComplete(false);
			return;
		}
		Distribution[] distros = DistributionManager.listDeistibutions();
		Distribution distribution = distros[selection];
		if (!distribution.isSupported()) {
			setPageComplete(false);
			setErrorMessage(Messages.DistributionSelectionPage_NotSupportedErrorMessagePrefix + distribution.getName() + Messages.DistributionSelectionPage_NotSupportedErrorMessageSuffix);
			return;
		}
		setPageComplete(true);
		setMessage(Messages.DistributionSelectionPage_PageCompleteMessage, INFORMATION);
	}

	private int getSelectedVersionIndex() {
		for (int cnt = 0; cnt < checkButtons.length; cnt++) {
			if (checkButtons[cnt].getSelection()) {
				return cnt;
			}
		}
		return -1;
	}
	
	public String getVersionID() {
		int selection = getSelectedVersionIndex();
		if (selection < 0)
			return null;
		Distribution[] distros = DistributionManager.listDeistibutions();
		Distribution distribution = distros[selection];
		return distribution.getID();
	}

	protected void previousButtonPressed() {
	}

	protected void nextButtonPressed() {
		storeProperties();
	}

	private void storeProperties() {
//		ProjectProperty properties = new ProjectProperty(getProject());
//		properties.setProperty(PersistentPropertyManager.PROPERTY_DISTRIBUTION, getVersionID());
	}

}
