/*******************************************************************************
 * Copyright (c) 2007  NTT DATA CORPORATION
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Version: 1.0.0 - 2007/06/15
 *          initial API and implementation
 *******************************************************************************/
package jp.sourceforge.tomoyo.base.ssh.ui.wizards.newproject;

import jp.sourceforge.tomoyo.core.PersistentPropertyManager;
import jp.sourceforge.tomoyo.core.ProjectProperty;
import jp.sourceforge.tomoyo.core.TomoyoCorePlugin;
import jp.sourceforge.tomoyo.core.ui.preferences.ServerPreferenceConstants;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class ServerSettingsPage extends AbstractWizardPage {

	private Button useDefaultCheck;
	
	private Text ccsToolDirText = null;
	private Text ccsDataDirText = null;

//	private Text grantLogDirText = null;
//	private Text rejectLogDirText = null;

	public ServerSettingsPage() {
		super(Messages.ServerSettingsPage_PageName);
		setTitle(Messages.ServerSettingsPage_PageTitle);
		setDescription(Messages.ServerSettingsPage_PageDescription);
		setPageComplete(true);
	}

	protected String getHelpResourceName() {
		return "server_settings"; //$NON-NLS-1$
	}

	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		GridLayout layout = new GridLayout(1, false);
		composite.setLayout(layout);
		createConfigComposite(composite);
		restoreDefault();
		setControl(composite);
	}
	
	private void restoreDefault() {
		IPreferenceStore store = TomoyoCorePlugin.getDefault().getPreferenceStore();
		ccsToolDirText.setText(store.getString(ServerPreferenceConstants.P_CCS_TOOL_PATH));
		ccsDataDirText.setText(store.getString(ServerPreferenceConstants.P_CCS_DATA_PATH));
		/*
		grantLogDirText.setText(store.getString(ServerAuditPreferenceConstants.CCS_AUDITD_GRANT_LOG_PATH));
		rejectLogDirText.setText(store.getString(ServerAuditPreferenceConstants.CCS_AUDITD_REJECT_LOG_PATH));
		*/
	}
	
	private void createConfigComposite(Composite composite) {
		Composite container = new Composite(composite, SWT.NONE);
		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		container.setLayoutData(data);
		
		{
			useDefaultCheck = new Button(container, SWT.CHECK);
			useDefaultCheck.setText(Messages.ServerSettingsPage_UseDefaultLocationCheckButttonTitle);
			useDefaultCheck.setSelection(true);
			useDefaultCheck.addSelectionListener(new SelectionListener() {
				public void widgetDefaultSelected(SelectionEvent e) {
				}
				public void widgetSelected(SelectionEvent e) {
					ccsDataDirText.setEnabled(!useDefaultCheck.getSelection());
					ccsToolDirText.setEnabled(!useDefaultCheck.getSelection());
					/*
					grantLogDirText.setEnabled(!useDefaultCheck.getSelection());
					rejectLogDirText.setEnabled(!useDefaultCheck.getSelection());
					Button source = (Button)e.getSource();
					if (source.getSelection()) {
						restoreDefault();
					}
					*/
				}
			});
			GridData checkGD = new GridData(GridData.BEGINNING);
//			checkGD.horizontalSpan = 2;
			useDefaultCheck.setLayoutData(checkGD);
		}
			
		Group systemConfigGroup = new Group(container, SWT.NONE);
		systemConfigGroup.setLayout(new GridLayout(2, false));
		systemConfigGroup.setText(Messages.ServerSettingsPage_SystemGroupText);
		systemConfigGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
		
		{
			Label label = new Label(systemConfigGroup, SWT.NONE);
			label.setText(Messages.ServerSettingsPage_PolicyDirectoryLabelCaption);
			ccsDataDirText = new Text(systemConfigGroup, SWT.SINGLE | SWT.BORDER);
			ccsDataDirText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			ccsDataDirText.addModifyListener(new ModifyListener() {
				public void modifyText(ModifyEvent e) {
					inputChanged();
				}
			});
			ccsDataDirText.setEnabled(false);
		}
		{
			Label label = new Label(systemConfigGroup, SWT.NONE);
			label.setText(Messages.ServerSettingsPage_ToolDirectoryLabelCaption);
			ccsToolDirText = new Text(systemConfigGroup, SWT.SINGLE | SWT.BORDER);
			ccsToolDirText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			ccsToolDirText.addModifyListener(new ModifyListener() {
				public void modifyText(ModifyEvent e) {
					inputChanged();
				}
			});
			ccsToolDirText.setEnabled(false);
		}
		
		/*
		Group auditdConfigGroup = new Group(container, SWT.NONE);
		auditdConfigGroup.setLayout(new GridLayout(2, false));
		auditdConfigGroup.setText(Messages.ServerSettingsPage_AuditDGroupText);
		auditdConfigGroup.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));

		{
			Label label = new Label(auditdConfigGroup, SWT.NONE);
			label.setText(Messages.ServerSettingsPage_GrantLogLable);
			grantLogDirText = new Text(auditdConfigGroup, SWT.SINGLE | SWT.BORDER);
			grantLogDirText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			grantLogDirText.addModifyListener(new ModifyListener() {
				public void modifyText(ModifyEvent e) {
					inputChanged();
				}
			});
			grantLogDirText.setEnabled(false);
		}
		{
			Label label = new Label(auditdConfigGroup, SWT.NONE);
			label.setText(Messages.ServerSettingsPage_RejectLogLable);
			rejectLogDirText = new Text(auditdConfigGroup, SWT.SINGLE | SWT.BORDER);
			rejectLogDirText.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
			rejectLogDirText.addModifyListener(new ModifyListener() {
				public void modifyText(ModifyEvent e) {
					inputChanged();
				}
			});
			rejectLogDirText.setEnabled(false);
		}
		*/
	}
	
	public String getCcsToolDir() {
		if (useDefaultCheck.getSelection()) {
			IPreferenceStore store = TomoyoCorePlugin.getDefault().getPreferenceStore();
			return store.getString(ServerPreferenceConstants.P_CCS_TOOL_PATH);
		} else {
			return ccsToolDirText.getText();
		}
	}
	
	public String getCcsDataDir() {
		if (useDefaultCheck.getSelection()) {
			IPreferenceStore store = TomoyoCorePlugin.getDefault().getPreferenceStore();
			return store.getString(ServerPreferenceConstants.P_CCS_DATA_PATH);
		} else {
			return ccsDataDirText.getText();
		}
	}

	/*
	public String getGrantLogDir() {
		if (useDefaultCheck.getSelection()) {
			IPreferenceStore store = TomoyoCorePlugin.getDefault().getPreferenceStore();
			return store.getString(ServerAuditPreferenceConstants.CCS_AUDITD_GRANT_LOG_PATH);
		} else {
			return grantLogDirText.getText();
		}
	}
	
	public String getRejectLogDir() {
		if (useDefaultCheck.getSelection()) {
			IPreferenceStore store = TomoyoCorePlugin.getDefault().getPreferenceStore();
			return store.getString(ServerAuditPreferenceConstants.CCS_AUDITD_REJECT_LOG_PATH);
		} else {
			return rejectLogDirText.getText();
		}
	}
	*/
	
	private void inputChanged() {
		if (checkError(ccsToolDirText)) {
			setInputErrorMessage(Messages.ServerSettingsPage_ErrorMessageInputToolDirectory);
			return;
		}
		if (checkError(ccsDataDirText)) {
			setInputErrorMessage(Messages.ServerSettingsPage_ErrorMessageInputDataDirectory);
			return;
		}
		/*
		if (checkError(grantLogDirText) || grantLogDirText.getText().trim().endsWith("/")) {
			setInputErrorMessage(Messages.ServerSettingsPage_ErrorMessageInputGrantLogPath);
			return;
		}
		if (checkError(rejectLogDirText) || rejectLogDirText.getText().trim().endsWith("/")) {
			setInputErrorMessage(Messages.ServerSettingsPage_ErrorMessageInputRejectLogPath);
			return;
		}
		*/
		setInputErrorMessage(null);		
		setMessage(Messages.ServerSettingsPage_PageDescription, INFORMATION);
	}
	
	private boolean checkError(Text text) {
		if (text.getText().trim().length() == 0)
			return true;
		if (!text.getText().trim().startsWith("/"))
			return true;
		return false;
	}
	
	private void setInputErrorMessage(String message) {
		setErrorMessage(message);
		setPageComplete(message == null);
	}
	
	protected void previousButtonPressed() {
	}

	protected void nextButtonPressed() {
		storeProperties();
	}

	private void storeProperties() {
		ProjectProperty properties = new ProjectProperty(getProject());
		properties.setProperty(PersistentPropertyManager.PROPERTY_CCS_DATA_DIRECTORY, getCcsDataDir());
		properties.setProperty(PersistentPropertyManager.PROPERTY_CCS_TOOL_DIRECTORY, getCcsToolDir());
		/*
		properties.setProperty(PersistentPropertyManager.PROPERTY_GRANTLOG, getGrantLogDir());
		properties.setProperty(PersistentPropertyManager.PROPERTY_REJECTLOG, getRejectLogDir());
		*/
	}
	
}
